#include <ctype.h>
#include <stdio.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <stdlib.h>
#include <strings.h>
#include <string.h>
#include <errno.h>
#include <unistd.h>
#include <sys/stat.h>

#include <gtk/gtk.h>

#include "lopster.h"
#include "callbacks.h"
#include "connection.h"
#include "handler.h"
#include "global.h"
#include "search.h"
#include "transfer.h"
#include "resume.h"
#include "support.h"

GtkWidget* create_resume_popup() {
  GtkWidget *popup;
  GtkWidget *user_popup;
  GtkAccelGroup *popup_accels;
  GtkWidget *item;
  GtkWidget *separator5;
  GtkCTree* ctree;
  GtkCTreeNode* node;
  resume_t* resume;
  int flags = 0;
  int status = -1;

  ctree = GTK_CTREE(global.popup_list);
  node = gtk_ctree_node_nth(ctree, global.popup_row);
  
  if (!node) {
    flags = 0;     // no row
  } else {
    if (GTK_CTREE_ROW(node)->parent != NULL) {
      node = GTK_CTREE_NODE(GTK_CTREE_ROW(node)->parent);
      flags = 1;  // file
    } else {
      flags = 2;  // resume
    }
    resume = (resume_t*)gtk_ctree_node_get_row_data(ctree, node);
    status = resume->status;
  }

  if (flags == 0) return NULL;

  popup = gtk_menu_new ();
  gtk_object_set_data (GTK_OBJECT (popup), "popup", popup);
  popup_accels = gtk_menu_ensure_uline_accel_group (GTK_MENU (popup));

  if (flags == 2) {
    item = gtk_menu_item_new_with_label (_("Open File"));
    gtk_widget_ref (item);
    gtk_object_set_data_full (GTK_OBJECT (popup), "item", item,
			      (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (item);
    gtk_container_add (GTK_CONTAINER (popup), item);
    gtk_signal_connect (GTK_OBJECT (item), "activate",
			GTK_SIGNAL_FUNC (on_resume_play_activate),
			NULL);
    separator5 = gtk_menu_item_new ();
    gtk_widget_ref (separator5);
    gtk_object_set_data_full (GTK_OBJECT (popup), "separator5", separator5,
			      (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (separator5);
    gtk_container_add (GTK_CONTAINER (popup), separator5);
    gtk_widget_set_sensitive (separator5, FALSE);

    item = gtk_menu_item_new_with_label (_("Delete Selected"));
    gtk_widget_ref (item);
    gtk_object_set_data_full (GTK_OBJECT (popup), "item", item,
			      (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (item);
    gtk_container_add (GTK_CONTAINER (popup), item);
    gtk_signal_connect (GTK_OBJECT (item), "activate",
			GTK_SIGNAL_FUNC (on_resume_delete_activate),
			NULL);
      
    separator5 = gtk_menu_item_new ();
    gtk_widget_ref (separator5);
    gtk_object_set_data_full (GTK_OBJECT (popup), "separator5", separator5,
			      (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (separator5);
    gtk_container_add (GTK_CONTAINER (popup), separator5);
    gtk_widget_set_sensitive (separator5, FALSE);

    if (status <= R_NONE)
      item = gtk_menu_item_new_with_label (_("Search Files"));
    else
      item = gtk_menu_item_new_with_label (_("Search Again"));
    gtk_widget_ref (item);
    gtk_object_set_data_full (GTK_OBJECT (popup), "item", item,
			      (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (item);
    gtk_container_add (GTK_CONTAINER (popup), item);
    gtk_signal_connect (GTK_OBJECT (item), "activate",
			GTK_SIGNAL_FUNC (on_resume_search_activate),
			NULL);
  } else if (flags == 1) {
    item = gtk_menu_item_new_with_label (_("Download from User"));
    gtk_widget_ref (item);
    gtk_object_set_data_full (GTK_OBJECT (popup), "item", item,
			      (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (item);
    gtk_container_add (GTK_CONTAINER (popup), item);
    gtk_signal_connect(GTK_OBJECT (item), "activate",
		       GTK_SIGNAL_FUNC (on_download2_activate),
		       NULL);
    if (status >= R_QUEUED)
      gtk_widget_set_sensitive (item, FALSE);

    separator5 = gtk_menu_item_new ();
    gtk_widget_ref (separator5);
    gtk_object_set_data_full (GTK_OBJECT (popup), "separator5", separator5,
			      (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (separator5);
    gtk_container_add (GTK_CONTAINER (popup), separator5);
    gtk_widget_set_sensitive (separator5, FALSE);
    
    item = gtk_menu_item_new_with_label (_("User Menu"));
    gtk_widget_ref (item);
    gtk_widget_show (item);
    gtk_container_add (GTK_CONTAINER (popup), item);

    user_popup = create_user_popup(M_SEARCH);
    gtk_menu_item_set_submenu (GTK_MENU_ITEM (item), user_popup);
  }
  return popup;
}

resume_t* resume_find_search(search_t* search) {
  GList* dlist;
  resume_t* resume;

  for (dlist = global.incomplete; dlist; dlist = dlist->next) {
    resume = (resume_t*)(dlist->data);
    if (resume->search == search) return resume;
  }
  return NULL;
}

void resume_insert_file(resume_t* resume, file_t* file) {
  GtkCTree* ctree;
  GtkCTreeNode* node;
  GdkPixmap *pixmap = NULL;
  GdkBitmap *bitmap = NULL;

  ctree = GTK_CTREE(lookup_widget(global.win, "resume_tree"));
  node = gtk_ctree_find_by_row_data(ctree, NULL, resume);

  if (file->size != resume->size) file->status = FILE_ERROR;
  sprintf(tstr[0], "%s", file->user);
  sprintf(tstr[1], "%lu", file->size);
  sprintf(tstr[2], "%s", LineSpeed(file->linespeed));
  if (file->status == FILE_NONE)
    strcpy(tstr[3], "");
  else if (file->status == FILE_DOWNLOAD)
    strcpy(tstr[3], _("Downloading..."));
  else if (file->status == FILE_ERROR)
    strcpy(tstr[3], _("Error!"));
  else if (file->status == FILE_SUCCESS)
    strcpy(tstr[3], _("Success!"));
  else
    strcpy(tstr[3], _("Unknown file status"));

  detect_speed_pixs(file->linespeed, &pixmap, &bitmap);
  node =
    gtk_ctree_insert_node(ctree, node, NULL, list, 5,
			  pixmap, bitmap, pixmap, bitmap,
			  TRUE, FALSE);

  resume_list_update(resume);
  gtk_ctree_node_set_row_data_full(ctree, node, file, NULL);
}

void resume_list_load() {
  FILE* fd;
  resume_t* resume;
  char* fname;
  char line[2048];
  char* dir;

  fname = g_strdup_printf("%s/incomplete.list", 
			  global.lopster_home);
  if ((fd = fopen(fname, "r")) == NULL) {
    free(fname);
    return;
  }
  free(fname);

  while (fgets(line, 2048-1, fd)) {
    resume = (resume_t*)malloc(sizeof(resume_t));
    resume->filename = strdup(arg(line, 0));
    resume->size = strtoul(arg(NULL, 0), NULL, 10);
    dir = arg(NULL, 0);
    // backward compatible
    if (dir) resume->dirname = strdup(dir);
    resume->search = NULL;
    resume->status = R_NONE;
    resume->transfer = NULL;
    global.incomplete = g_list_append(global.incomplete, resume);

    resume_clist_add(resume);
  }
  fclose(fd);
}

void resume_list_save() {
  GList* dlist;
  resume_t* resume;
  char* fname;
  FILE* fd;
  
  fname = g_strdup_printf("%s/incomplete.list", 
			  global.lopster_home);
  if ((fd = fopen(fname, "w")) == NULL) {
    g_warning(_("Could not write [%s]\n"), fname);
    free(fname);
    return;
  }

  free(fname);

  for (dlist = global.incomplete; dlist; dlist = dlist->next) {
    resume = (resume_t*)(dlist->data);
    fprintf(fd, "\"%s\" %lu \"%s\"\n", resume->filename, 
	    resume->size, resume->dirname);
  }
  fclose(fd);
}

void resume_list_add(resume_t* resume) {

  global.incomplete = g_list_append(global.incomplete, resume);
  resume_list_save();
  resume_clist_add(resume);
  
}

int resume_delete_links(resume_t* resume) {
  GList* dlist;
  socket_t* socket;
  transfer_t* transfer;
  socket_t* save = NULL;

#ifdef RESUME_DEBUG
  printf("removing r:%p\n", resume);
#endif
  // first remove resume link from unactive transfers
  for (dlist = global.sockets; dlist; dlist = dlist->next) {
    socket = (socket_t*)(dlist->data);
    if (!socket) {
      printf("socket->data = NULL\n");
      continue;
    }
    if (socket->type != S_TRANSFER) continue;
    transfer = (transfer_t*)(socket->data);
    if (transfer->type != T_DOWNLOAD) continue;
    if (resume->transfer == transfer) {
#ifdef RESUME_DEBUG
      printf("not removed from  t:%p\n", transfer);
#endif
      save = socket;
    } else if (transfer->resume == resume) {
#ifdef RESUME_DEBUG
      printf("removed from  t:%p\n", transfer);
#endif
      transfer->resume = NULL;
    }
  }
  
  if (save) {
    socket_end(save, S_DELETE);
    // return 1, as socket_end(.., S_DELETE) will also call
    // resume_list_remove()
    return 1;
  } else return 0;
}

void resume_list_remove(resume_t* resume, int delete) {
  GtkCTree* ctree;
  GtkCTreeNode* node;

  if (!resume) return;
  
  if (resume_delete_links(resume)) return;

  resume_remove_search(resume);

  ctree = GTK_CTREE(lookup_widget(global.win, "resume_tree"));
  node = gtk_ctree_find_by_row_data(ctree, NULL, resume);
  if (node) gtk_ctree_remove_node(ctree, node);

  //  printf("delete = %d\n", delete);
  if (resume->filename) {
    if (delete) unlink(resume->filename);
    free(resume->filename);
  }

  global.incomplete = g_list_remove(global.incomplete, resume);
  resume_list_save();
  free(resume);
}

void resume_clist_add(resume_t* resume) {
  GtkCTree* ctree;
  char* pos;
  GtkCTreeNode* node;
  GtkCTreeNode* node2;
  file_t* file;
  GList* dlist;
  GdkPixmap *pixmap = NULL;
  GdkBitmap *bitmap = NULL;

  if (!resume) return;

  ctree = GTK_CTREE(lookup_widget(global.win, "resume_tree"));
  node = gtk_ctree_find_by_row_data(ctree, NULL, resume);
  if (node) return;

  pos = strrchr(resume->filename, '/');
  if (!pos) pos = resume->filename;
  else pos++;

  strcpy(tstr[0], pos);
  sprintf(tstr[1], "%lu", resume->size);
  
  tstr[2][0] = 0;
  tstr[3][0] = 0;

  node = gtk_ctree_insert_node(ctree, NULL, NULL, list, 5,
			       global.pix.folder, 
			       global.pix.folderb,
			       global.pix.folder_open, 
			       global.pix.folder_openb,
			       FALSE, FALSE);
  gtk_ctree_node_set_row_data_full(ctree, node, resume, NULL);

  resume_list_update(resume);
  if (!resume->search) return;

  for (dlist = resume->search->results; dlist; dlist = dlist->next) {
    file = (file_t*)(dlist->data);
    
    detect_speed_pixs(file->linespeed, &pixmap, &bitmap);

    sprintf(tstr[0], "%s", file->user);
    sprintf(tstr[1], "%lu", file->size);
    sprintf(tstr[2], "%s", LineSpeed(file->linespeed));
    if (file->status == FILE_NONE)
      strcpy(tstr[3], "");
    else if (file->status == FILE_DOWNLOAD)
      strcpy(tstr[3], _("Downloading..."));
    else if (file->status == FILE_ERROR)
      strcpy(tstr[3], _("Error!"));
    else if (file->status == FILE_SUCCESS)
      strcpy(tstr[3], _("Success!"));
    else
      strcpy(tstr[3], _("Unknown file status"));
    node2 =
      gtk_ctree_insert_node(ctree, node, NULL, list, 5,
			    pixmap, bitmap, pixmap, bitmap,
			    TRUE, FALSE);
    gtk_ctree_node_set_row_data_full(ctree, node2, file, NULL);
  }

}

void resume_list_update(resume_t* resume) {
  GtkCTree* ctree;
  GtkCTreeNode* node;
  char text[1024];
  struct stat st;

  if (!resume) return;

  ctree = GTK_CTREE(lookup_widget(global.win, "resume_tree"));
  node = gtk_ctree_find_by_row_data(ctree, NULL, resume);
  if (!node) {
    g_warning(_("Resume type not found in clist"));
    return;
  }

  if (stat(resume->filename, &st) < 0) {
    strcpy(text, _("not existent"));
  } else {
    sprintf(text, "%lu", st.st_size);
  }
  gtk_ctree_node_set_text(ctree, node, 2, text);

  if (resume->status == R_NONE)
    sprintf(text, _("Not Searched"));
  else if (resume->status == R_SEARCH)
    if (resume->search)
      sprintf(text, _("%d results"), g_list_length(resume->search->results));
    else sprintf(text, "ops");
  else if (resume->status == R_QUEUED)
    sprintf(text, _("Queued..."));
  else if (resume->status == R_DOWNLOAD)
    sprintf(text, _("Downloading..."));
  else
    sprintf(text, _("Unknown status"));

  gtk_ctree_node_set_text(ctree, node, 3, text);
}

resume_t* resume_list_search_file(file_t* file) {
  GList* dlist;
  resume_t* resume;
  char* pos;
  char* pos2;

  pos2 = extract_filename(file->longname);
#ifdef RESUME_DEBUG
  //  printf("resume: searching2 [%s]\n", pos2);
#endif
  for (dlist = global.incomplete; dlist; dlist = dlist->next) {
    resume = (resume_t*)(dlist->data);
    pos = extract_filename(resume->filename);
#ifdef RESUME_DEBUG
    //    printf("resume: target2 [%s]\n", pos);
#endif
    if (!strcmp(pos2, pos) && 
	(file->size == resume->size)) return resume;
  }
  return NULL;
}

resume_t* resume_list_search(transfer_t* transfer) {
  GList* dlist;
  resume_t* resume;
  char* pos;
  char* pos2;

  pos2 = extract_filename(transfer->longname);
  for (dlist = global.incomplete; dlist; dlist = dlist->next) {
    resume = (resume_t*)(dlist->data);
    pos = extract_filename(resume->filename);
    /*
    if (!strcmp(pos2, pos) && 
	(transfer->size == resume->size)) return resume;
    */
    if (transfer->size == resume->size) return resume;
  }
  return NULL;
}

char* get_search_string(char* str) {
  static char result[1204];
  char* pos = str;
  char* old_pos;
  char save;

  *result = 0;
  while (1) {
    old_pos = pos;
    while (isalpha(*pos)) pos++;
    if (pos > old_pos+2) {
      save = *pos;
      *pos = 0;
      if (*result) strcat(result, " ");
      strcat(result, old_pos);
      if ((save == 0) || (save == '.')) break;
    } else {
      if (*pos == '.') break;
    }
    pos++;
  }
  return result;
}

void resume_create_search(resume_t* resume) {
  search_t* search;
  search_pattern_t* pattern;
  char t2[1024];
  char* pos;

  search = search_new();
  search->resume = 1;
  search->link = resume;

  pos = strdup(extract_filename(resume->filename));
  sprintf(t2, "%d %s", search->id, pos);

  pattern = search_pattern_new(t2);
  pattern->include = strdup(get_search_string(pos));
  free(pos);
  pattern->exclude = strdup("");
  pattern->max_results = 100;
  pattern->media_type = strdup("mp3");
  pattern->destination = DEST_NAPSTER;
  if (opennap_version(0, 37)) {
    pattern->size_lo = pattern->size_hi = resume->size;
  } else {
    pattern->size_lo = pattern->size_hi = 0;
  }  

  search->pattern = pattern;
  resume->search = search;
  resume_list_update(resume);
}

void resume_search(resume_t* resume) {
  
  if (!resume) return;

  resume_remove_search(resume);

  if (global.status.searching >= 2) return;
  if (resume->status < R_QUEUED) resume->status = R_SEARCH;

  resume_create_search(resume);
  
  napster_search(resume->search->pattern, 0);
}

void resume_remove_search(resume_t* resume) {
  GtkCTreeNode* node;
  GtkCTreeNode* node2;
  file_t* file;
  GtkCTree* ctree;
  
  if (!resume->search) return;

  // remove files from window
  ctree = GTK_CTREE(lookup_widget(global.win, "resume_tree"));
  node = gtk_ctree_find_by_row_data(ctree, NULL, resume);
  while ((node2 = GTK_CTREE_ROW(node)->children) != NULL) {
    file = (file_t*)gtk_ctree_node_get_row_data(ctree, node2);
    gtk_ctree_remove_node(ctree, node2);
  }

  // remove files from resume
  if (resume->search) search_remove(resume->search);
  resume->search = NULL;

  if (resume->status < R_QUEUED) resume->status = R_NONE;
  resume_list_update(resume);
}

void resume_try_next_potential(resume_t* resume) {
  GList* dlist;
  file_t* file;
  file_t* dfile = NULL;
  
  if (!resume->search) return;

  // finding best file
  for (dlist = resume->search->results; dlist; dlist = dlist->next) {
    file = (file_t*)(dlist->data);
    if ((file->status == FILE_NONE) &&
	(!dfile || (file->linespeed > dfile->linespeed)))
      dfile = file;
  }
  
  if (dfile) download_file(dfile, 0);
}

void resume_user_flag(resume_t* resume, char* user, int flag) {
  GList* dlist;
  file_t* file;
  GtkCTree* ctree;
  char* text;
  GtkCTreeNode* node;

  if (!resume->search) return;

  ctree = GTK_CTREE(lookup_widget(global.win, "resume_tree"));
  
  for (dlist = resume->search->results; dlist; dlist = dlist->next) {
    file = (file_t*)(dlist->data);
    if (!strcmp(user, file->user)) {
      file->status = flag;
      node = gtk_ctree_find_by_row_data(ctree, NULL, file);
      if (file->status == FILE_NONE)
	text = strdup("");
      else if (file->status == FILE_DOWNLOAD)
	text = strdup(_("Downloading..."));
      else if (file->status == FILE_ERROR)
	text = strdup(_("Error!"));
      else if (file->status == FILE_SUCCESS)
	text = strdup(_("Success!"));
      else
	text = strdup(_("Unknown file status"));
      if (node) gtk_ctree_node_set_text(ctree, node, 3, text);
    }
  }
}

