// startup modes
#define L_NOT_SHARE      1
#define L_NOT_JOIN       2

// mode for user popup
#define M_ONLINE          0
#define M_SEARCH          1
#define M_HOTLIST         2
#define M_TRANSFER        3
#define M_GLOBAL          4
#define M_WHOIS           5
#define M_TEXT            6
#define M_IGNORE          7

// gtk styles for some lopster widgets
#define STYLE_NUMBER      5
#define STYLE_TAB1        0
#define STYLE_TAB2        1
#define STYLE_CHAT        2
#define STYLE_LABEL       3
#define STYLE_SEARCH      4

// user status
#define STATUS_INACTIVE   0
#define STATUS_ACTIVE     1
#define STATUS_REMOTE     2
#define STATUS_CLOAKED    3
#define STATUS_LEECHED    4
#define STATUS_MUZZLED    5
#define STATUS_UNKNOWN    6

// resume file status
#define FILE_NONE         0
#define FILE_DOWNLOAD     1
#define FILE_ERROR        2
#define FILE_SUCCESS      3

// major mime types
#define MIME_NONE         0
#define MIME_MP3          1
#define MIME_AUDIO        2
#define MIME_VIDEO        3
#define MIME_APPLICATION  4
#define MIME_IMAGE        5
#define MIME_TEXT         6
#define MIME_SIZE         7

// debugging output control
//#define SHARE_DEBUG
//#define RESUME_DEBUG
//#define BROWSE_DEBUG
//#define GLOBAL_DEBUG
//#define SEARCH_DEBUG
//#define TRANSFER_DEBUG
//#define CONNECTION_DEBUG
//#define PROTOCOL_DEBUG

// network type
#define N_UNKNOWN         0
#define N_OPENNAP         1
#define N_NAPSTER         2

// socket type
#define S_UNKNOWN         0
#define S_SHARE           1
#define S_BROWSE          2
#define S_TRANSFER        3
#define S_SERVER          4
#define S_HTTP            5
#define S_DATA            6

// exit mode
#define E_NONE            0
#define E_NORMAL          1
#define E_SAFE            2

// chat page type
#define P_FIX             0
#define P_PRIVATE         1
#define P_PUBLIC          2

// transfer status
#define S_INACTIVE      0
#define S_CONNECTING    1
#define S_INFO          2
#define S_DOWNLOADING   3
#define S_CANCELED      4
#define S_FINISHED      5
#define S_TIMEOUT       6
#define S_REJECT        7
#define S_INCOMPLETE    8
#define S_UPLOADING     9
#define S_INFO1        10
#define S_INFO2        11
#define S_INFO3        12
#define S_WAITING      13
#define S_FIREWALL     14
#define S_CONERROR     15
#define S_QUEUED       16
#define S_REMOTE       17
#define S_UNAVAILABLE  18
#define S_STOPPED      19
#define S_RESUME_ERR   20
#define S_DELETE       21
#define S_IO           22
#define S_NUMBER       23

// transfer types
#define T_UNKNOWN       0
#define T_DOWNLOAD      1
#define T_UPLOAD        2

#define TRANSFER_HISTORY_TIME         60   // 60 seconds

// transfer major types
#define T_NONE          0   // inactive
#define T_CURRENT       1   // conecting..downloading
#define T_STOPPED       2   // active, but stopped (queue)
#define T_TRANSFER      3   // transfering

// download retry flags
#define RETRY_TIMEOUT         0x01
#define RETRY_REJECT          0x02
#define RETRY_INCOMPLETE      0x04
#define RETRY_CONERROR        0x08
#define RETRY_REMOTE          0x10

// download delete flags
#define DELETE_UNSTARTED      0x01
#define DELETE_INCOMPLETE     0x02

// download remove flags
#define REMOVE_D_CANCELED    0x001
#define REMOVE_D_FINISHED    0x002
#define REMOVE_D_TIMEOUT     0x004
#define REMOVE_D_REJECT      0x008
#define REMOVE_D_INCOMPLETE  0x010
#define REMOVE_D_FIREWALL    0x020
#define REMOVE_D_CONERROR    0x040
#define REMOVE_D_REMOTE      0x080
#define REMOVE_D_UNAVAILABLE 0x100
#define REMOVE_D_RESUME_ERR  0x200
#define REMOVE_D_DELETE      0x400
#define REMOVE_D_IO          0x800

// upload remove flags
#define REMOVE_U_FINISHED    0x001
#define REMOVE_U_ABORTED     0x002

// resume status
#define R_NONE               0
#define R_SEARCH             1
#define R_QUEUED             2
#define R_DOWNLOAD           3

// destination for search
#define DEST_NAPSTER         0
#define DEST_HOTLIST         1
#define DEST_LIBRARY         2
#define DEST_SEARCH          3

// flags for files in library
#define FLAG_TO_REMOVE        1
#define FLAG_TO_SHARE         2
#define FLAG_TO_DELETE        4
#define FLAG_TO_UNSHARE       8
#define FLAG_SHARED          16

#define SERVER ((server_t*)(global.napster->data))

// user level
typedef enum {
  L_LEECH,
  L_USER,
  L_MOD,
  L_ADMIN,
  L_ELITE
} user_level_t;


typedef struct _geometry_t        geometry_t;
typedef struct _chat_page_t       chat_page_t;
typedef struct _afk_t             afk_t ;
typedef struct _clone_t           clone_t;
typedef struct _client_t          client_t;
typedef struct _suffix_t          suffix_t;
typedef struct _mime_t            mime_t;
typedef struct _user_t            user_t;
typedef struct _link_t            link_t;
typedef struct _network_t         network_t;
typedef struct _limit_t           limit_t;
typedef struct _option_t          option_t;
typedef struct _status_t          status_t;
typedef struct _file_t            file_t;
typedef struct _pix_t             pix_t;
typedef struct _bandwidth_t       bandwidth_t;
typedef struct _global_t          global_t;
typedef struct _transfer_t        transfer_t;
typedef struct _resume_t          resume_t;
typedef struct _user_info_t       user_info_t;
typedef struct _search_t          search_t;
typedef struct _search_pattern_t  search_pattern_t;
typedef struct _napster_command_t napster_command_t;
typedef struct _server_t          server_t;
typedef struct _socket_t          socket_t;
typedef struct _style_t           style_t;
typedef struct _scheme_t          scheme_t;

struct _geometry_t {
  int x;
  int y;
  int width;
  int height;
};

struct _chat_page_t {
  char* name;
  GtkWidget* window;
  int type;
};

struct _afk_t {
  char* message;
  time_t since;
};

struct _clone_t {
  GList* nicks;
  char* ip;
};

struct _client_t {
  char* info;
  int logins;
  int cnt;
};

struct _suffix_t {
  char* suffix;
  char* application;
};

struct _mime_t {
  GList* shared;
  char* download;
  GList* suffixes;
};

struct _user_t {
  char username[100];
  char password[100];
  char email[100];
  int linespeed;
  int shared;
  int unshared;
  double bytes;
  int level;
  int status;
  GList* files;
  int timeout;
};

struct _link_t {
  char* server;
  GList* links;
  char* ping;
};

struct _network_t {
  int port;
  int firewall;
  int transfer_delay;
  int transfer_timeout;
  int allow_dcc;
  int auto_resume;
  int auto_connect;
  int auto_reconnect;
  int reconnect_timer;
};

struct _limit_t {
  int max_downloads;
  int max_uploads;
  int default_uploads;
  int default_downloads;
  int cur_uploads;
  int cur_downloads;
};

struct _option_t {
  char show_joins;
  char public_ignore;
  char parse_color;
  char send_ignore;
  char logging;
  char log_expire;
  int auto_retry;
  int auto_delete;
  int dl_autoremove;
  int ul_autoremove;
  int popup_create;
  int sep_chwallop;
  int login_mode;
};

struct _status_t {
  char connection;
  char searching;
  char building;
  char whois_hide;
  char exiting;
  char rc_read;
  char geometry_read;
};

struct _file_t {
  char* longname;      // local name
  char* shortname;     // short local name
  char* winname;       // web name
  long size;
  char* user;
  unsigned long ip;    // for search response
  char* md5;
  int bitrate;
  int frequency;
  int duration;
  int linespeed;
  int flags;   // 1=in lib  2=shared
  int status;
  int local;
  int mime_type;
};

struct _pix_t {
  GdkPixmap *sgray;
  GdkBitmap *sgrayb;
  GdkPixmap *sgreen;
  GdkBitmap *sgreenb;
  GdkPixmap *syellow;
  GdkBitmap *syellowb;
  GdkPixmap *sred;
  GdkBitmap *sredb;

  GdkPixmap *folder;
  GdkBitmap *folderb;
  GdkPixmap *folder_open;
  GdkBitmap *folder_openb;
  GdkPixmap *user1;
  GdkBitmap *user1b;
  GdkPixmap *user2;
  GdkBitmap *user2b;
  GdkPixmap *ignore;
  GdkBitmap *ignoreb;
  GdkPixmap *enemy;
  GdkBitmap *enemyb;
  GdkPixmap *enemy2;
  GdkBitmap *enemy2b;
  GdkPixmap *friend;
  GdkBitmap *friendb;
  GdkPixmap *dummy;
  GdkBitmap *dummyb;
};

struct _bandwidth_t {
  long limit;
  long current;
  long maxval;
  GtkWidget* area;
  GtkWidget* label_max;
  GtkWidget* label_cur;
  long bytes;
};

struct _global_t {
  //wins
  GtkWidget* win;
  GtkWidget* connect_win;
  GtkWidget* whois_win;
  GtkWidget* options_win;
  GtkWidget* ban_win;
  GtkWidget* ignore_win;
  GtkWidget* usermode_win;
  GtkWidget* client_win;
  GtkWidget* user_win;
  GtkWidget* socket_win;
  GtkWidget* splash_win;

  socket_t* napster;            // connected server
  socket_t* upload_socket;      // listen socket file transfer
  user_t user;                  // you
  mime_t mimetype[MIME_SIZE];
  status_t status;
  server_t* last_server;
  pix_t pix;                    // pix for intern use
  
  GList* servers;               // list of servers
  GList* commands;              // the list of commands
  GList* highlight;             // the highlighted text
  GList* ignored_users;         // list of ignored users
  GList* frienduser;            // the friend users
  GList* enemyuser;             // the enemy users
  GList* chat_history;          // history of input line
  int history_pos;
  GList* hotlist;               // users in hot list
  GList* channels;              // autojoin channels
  GList* logs;                  // list of open logfiles
  GList* incomplete;            // list of incomplete downloads
  GList* client_list;
  GList* clones;
  GList* search_pattern;
  GList* searches;
  GList* usermode;
  GList* opchannel;
  GList* chat_pages;
  chat_page_t* current_page;
  GList* queue;
  GList* share_queue;
  GList* browses;
  GList* sockets;
  
  bandwidth_t down_width;
  bandwidth_t up_width;
  int popup_row;
  GtkWidget* popup_list;
  char* lopster_home;
  int timer;
  afk_t afk;
  char* reply;
  char* session_start;
  link_t* links;
  link_t* allowed_links;
  GtkStyle* style[STYLE_NUMBER];
  GdkColor color_table[16];
  char* clientinfo;
  int extra_win;
  char* incomplete_path;
  int search_width[6];
  int search_show[6];

  //options
  network_t network;            // network options
  limit_t limit;                // limit options
  option_t options;             // other options

  // some temp geometry info
  int connect_button;
  int online_width[3];
  int online_show[3];
  int paned_pos;
  int paned_pos2;
  geometry_t geometry[8];
  char* rainbow_colors;
  char* allowed_ports_str;
  GList* allowed_ports;
  scheme_t* scheme;
  char* auto_save;
  GList* execs;
};

struct _user_info_t {
  int cur;
  int max;
  int cnt;
};

struct _transfer_t {
  char* longname;
  char* shortname;
  char* winname;
  char* download_dir;
  char* md5;
  char* user;
  int linespeed;

  user_info_t* user_info;
  long progress;
  double rate;
  int timeleft;
  time_t start_time;
  time_t end_time;
  int status;
  long size;
  FILE* file;
  int type;
  int is_dcc;

  long history[TRANSFER_HISTORY_TIME];
  int hist_cnt;
  int hist_pos;

  char* resume_check;
  int check_length;
  int mime_type;

  resume_t* resume;
};

struct _resume_t {
  char* filename;
  char* dirname;
  long size;
  search_t* search;
  int status;
  transfer_t* transfer;
};

struct _search_pattern_t {
  char* name;
  char* include;
  char* exclude;
  int max_results;
  char* media_type;
  int destination;
  char* bitrate_lo;
  char* bitrate_hi;
  char* freq_lo;
  char* freq_hi;
  char* speed_lo;
  char* speed_hi;
  unsigned long size_lo;
  unsigned long size_hi;
  int duration_lo;
  int duration_hi;
};

struct _search_t {
  search_pattern_t* pattern;
  int id;
  GList* results;
  int type;
  int resume;
  void* link;
};

struct _socket_t {
  unsigned long ip_long;
  int port;
  int fd;
  int input;
  int timeout;
  int cnt;               // intern counter
  int max_cnt;           // max count for timeout
  void* data;
  int type;
};

struct _server_t {
  char* address;
  char* description;
  int port;
  char* nick;
  char* passwd;
  int meta;
  int network;
  int major;
  int minor;
};

struct _napster_command_t {
  gint16 type;
  unsigned char* data;
};

struct _scheme_t {
  char* name;
  GList* colors;                // the color scheme
  char* server_prefix;
  char* client_prefix;
};

struct _style_t {
  char* name;
  char* n_fore;
  char* n_back;
  char* n_font;
  GdkFont *font;
  GdkColor *fore;
  GdkColor *back;
};


/* 
   i:line : only allowed ips
   d:line : rejects unless in e_line
   e:line : ... 
 */
