#include <sys/types.h>
#include <ctype.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <strings.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/time.h>
#include <netdb.h>
#include <fcntl.h>
#include <errno.h>
#include <signal.h>

#include <gtk/gtk.h>

#include "lopster.h"
#include "support.h"
#include "md5.h"
#include "connection.h"
#include "commands.h"
#include "interface.h"
#include "callbacks.h"
#include "scheme.h"
#include "handler.h"
#include "log.h"
#include "global.h"
#include "chat.h"
#include "search.h"
#include "share.h"
#include "transfer.h"
#include "hotlist.h"
#include "resume.h"
#include "server.h"
#include "dialog.h"
#include "exec.h"

#include "../pixmaps/speedgreen.xpm"
#include "../pixmaps/speedyellow.xpm"
#include "../pixmaps/speedred.xpm"
#include "../pixmaps/speedgray.xpm"
#include "../pixmaps/folder.xpm"
#include "../pixmaps/folder_open.xpm"
#include "../pixmaps/user1.xpm"
#include "../pixmaps/user2.xpm"
#include "../pixmaps/ignore.xpm"
#include "../pixmaps/enemy.xpm"
#include "../pixmaps/enemy2.xpm"
#include "../pixmaps/friend.xpm"
#include "../pixmaps/d16x16.xpm"

const char Level[5][20] = {
  "Leech",
  "User",
  "Moderator",
  "Admin",
  "Elite"
};

const char LineSpeedShort[11][20] = {
  "?",
  "14.4",
  "28.8",
  "33.6",
  "56.7",
  "64K",
  "128K",
  "Cable",
  "DSL",
  "T1",
  "T3+"
};

char Network[3][20] = {
  "Unknown",
  "Opennap",
  "Napster"
};


int ColorTable(int i1, int i2) {
  static int table[10][10] = {
    {  0,  1,  2,  3,  4,  5,  6,  7,  8,  9},
    { 10, 11, 12, 13, 14, 15,  0,  1,  1,  1},
    { -2, -2, -2, -2, -2, -2, -2, -2, -2, -2},
    {  1,  4,  3,  5,  2,  6, 10, 15, -3, -3},
    {  1,  1,  1,  1,  1,  1,  1,  1, -4, -4},
    { 14,  7,  9,  8, 12, 13, 11,  0, 15,  5},
    { -6, -6, -6, -6, -6, -6, -6, -6, -6, -6},
    { -7, -7, -7, -7, -7, -7, -7, -7, -7, -7},
    { -8, -8, -8, -8, -8, -8, -8, -8, -8, -8},
    { -9, -9, -9, -9, -9, -9, -9, -9, -9, -9}
  };
  if (i1 < 0) return 0;            // white
  if (i2 < 0) return 0;            // white
  if (i1 >= 10) return 0;          // white
  if (i2 >= 10) return 0;          // white
  if (table[i1][i2] < 0) return 0; // white
  else return table[i1][i2];
}

int ColorTable2(int index) {
  static int table[8] = {
    1,  4,  3,  5,  2,  6, 10,  15
  };

  if (index < 0) return 1;   // black
  if (index >= 8) return 1;  // black
  return table[index];
};

global_t global;
char tstr[10][512];
char* list[10] = {
  tstr[0], tstr[1],
  tstr[2], tstr[3],
  tstr[4], tstr[5],
  tstr[6], tstr[7],
  tstr[8], tstr[9]
};

char rc_line[1024];

char* UserStatus(int status) {

  switch (status) {
  case STATUS_INACTIVE: return _("Inactive");
  case STATUS_ACTIVE: return _("Active");
  case STATUS_REMOTE: return _("Remote");
  case STATUS_CLOAKED: return _("Cloaked");
  case STATUS_LEECHED: return _("Leeched");
  case STATUS_MUZZLED: return _("Muzzled");
  case STATUS_UNKNOWN: return _("Unknown");
  default: return _("Unknown");
  };
  
}

char* MimeNames(int no) {
  switch (no) {
  case MIME_NONE: return _("default");
  case MIME_MP3: return _("mp3");
  case MIME_AUDIO: return _("audio");
  case MIME_VIDEO: return _("video");
  case MIME_APPLICATION: return _("application");
  case MIME_IMAGE: return _("image");
  case MIME_TEXT: return _("text");
  default: return _("default");
  };
}
char* MimeNames_(int no) {
  switch (no) {
  case MIME_NONE: return "default";
  case MIME_MP3: return "mp3";
  case MIME_AUDIO: return "audio";
  case MIME_VIDEO: return "video";
  case MIME_APPLICATION: return "application";
  case MIME_IMAGE: return "image";
  case MIME_TEXT: return "text";
  default: return "default";
  };
}

char* LineSpeed(int no) {
  switch (no) {
  case 0: return _("unknown");
  case 1: return _("14.4 kbps");
  case 2: return _("28.8 kbps");
  case 3: return _("33.6 kbps");
  case 4: return _("56.7 kbps");
  case 5: return _("64K ISDN");
  case 6: return _("128K ISDN");
  case 7: return _("Cable");
  case 8: return _("DSL");
  case 9: return _("T1");
  case 10: return _("T3+");
  default: return _("unknown");
  };
}


char* ntoa (unsigned int ip) {
  struct in_addr a;
  
  memset (&a, 0, sizeof (a));
  a.s_addr = ip;
  return (inet_ntoa (a));
}

int directory_exists(char* dir) {
  struct stat st;

  if (stat(dir, &st) < 0) return 0; 
  else return 1;
}

void create_dir(char* dir) {
  char* pos;
  char* slash;

  if (!dir) return;

  slash = dir;
  while ((pos = strchr(slash+1, '/')) != NULL) {
    pos[0] = 0;
    if (!directory_exists(dir)) {
      mkdir(dir, 7*64+5*8+5);
    }
    pos[0] = '/';
    slash = pos;
  }
  if (!directory_exists(dir)) {
    mkdir(dir, 7*64+5*8+5);
  }
}

void sigpipe_handler(int val) {
  printf("sigpipe: Broken pipe: %d\n", val);
}

void sigseg_handler(int val) {
  static int cnt = 0;

  cnt++;
  switch (cnt) {
  case 1:
    printf("sigseg: segmentation fault: %d\n", val);
    if (global.status.geometry_read) printf("sigseg: geometry was read\n");
    else printf("sigseg: geometry was *NOT* read\n");
    if (global.status.rc_read) printf("sigseg: rc-file was read\n");
    else {
      printf(_("sigseg: rc-file was *NOT* read\n"));
      printf(_("sigseg: last line read: [%s]\n"), rc_line);
      printf(_("sigseg: It seems to be a upgrade problem\n"));
      printf(_("sigseg: Please report this problem (this output and a backtrace if you know something about)\n"));
      printf(_("sigseg: Deleting (renaming) the rcfile (~/.lopster/lopsterrc) should solve the problem\n"));
    }
    printf(_("sigseg: please report the reason if you know\n"));
    printf("--------------------------------------------------\n");
    printf(_("sigseg: trying to do normal exit\n"));
    if (global.status.rc_read) {
      global_exit();
    } else {
      gtk_exit(-1);
    }
    break;
  case 2:
    printf(_("sigseg: normal exit failed\n"));
    cnt++;
    if (global.status.rc_read) {
      printf(_("sigseg: trying to save geometry\n"));
      write_geometry();
      printf(_("sigseg: geometry saved\n"));
    }
    cnt++;
    if (global.status.geometry_read) {
      printf(_("sigseg: trying to save rc-file\n"));
      write_rc();
      printf(_("sigseg: rc-file saved, exiting...\n"));
    }
    cnt++;
    gtk_exit(-2);
    break;
  case 3:
    printf(_("sigseg: saving transfers failed, force exit\n"));
    exit(-3);
    break;
  case 4:
    printf(_("sigseg: saving geometry failed, force exit\n"));
    exit(-4);
    break;
  case 5:
    printf(_("sigseg: saving rc-file failed, force exit\n"));
    exit(-5);
    break;
  case 6:
    printf(_("sigseg: exiting...\n"));
    exit(-6);
  default:
    printf(_("sigseg: forcing exit\n"));
    exit(-7);
  }
}

void sigchld_handler(int val) {
  //  printf("sigchld: %d\n", val);
}

void update_user_stats() {
  GtkWidget* temp;
  char t[1024];

  // user
  temp = lookup_widget(global.win, "label271");
  if (global.napster && SERVER && SERVER->nick)
    gtk_label_set_text(GTK_LABEL(temp), SERVER->nick);
  else
    gtk_label_set_text(GTK_LABEL(temp), global.user.username);
  temp = lookup_widget(global.win, "label272");
  gtk_label_set_text(GTK_LABEL(temp), Level[global.user.level]);
  temp = lookup_widget(global.win, "label273");
  gtk_label_set_text(GTK_LABEL(temp), UserStatus(global.user.status));
  temp = lookup_widget(global.win, "label274");
  if (global.reply)
    sprintf(t, _("Reply: %s"), global.reply);
  else
    sprintf(t, _("Reply: <None>"));
  gtk_label_set_text(GTK_LABEL(temp), t);

  // server
  if (global.napster && SERVER && (global.status.connection == 2)) {
    temp = lookup_widget(global.win, "label276");
    gtk_label_set_text(GTK_LABEL(temp), 
		       SERVER->description?SERVER->description:"???");
    temp = lookup_widget(global.win, "label277");
    sprintf(t, "%s:%d", SERVER->address, SERVER->port);
    gtk_label_set_text(GTK_LABEL(temp), t);
    temp = lookup_widget(global.win, "label278");
    gtk_label_set_text(GTK_LABEL(temp), 
		       Network[SERVER->network]);
  } else {
    temp = lookup_widget(global.win, "label276");
    gtk_label_set_text(GTK_LABEL(temp), _("Not connected"));
    temp = lookup_widget(global.win, "label277");
    gtk_label_set_text(GTK_LABEL(temp), "????");
    temp = lookup_widget(global.win, "label278");
    gtk_label_set_text(GTK_LABEL(temp), "???");
  }
}

char* strcasestr(char* str, const char* sub) {
  int len = strlen(sub);
  int max_pos = strlen(str)-len;
  int str_pos;
  int sub_pos;

  str_pos = 0;
  sub_pos = 0;
  while (str_pos <= max_pos) {
    while (toupper(str[str_pos+sub_pos]) == 
	   toupper(sub[sub_pos])) {
      sub_pos++;
      if (sub_pos == len) return &(str[str_pos]);
    }
    str_pos++;
    sub_pos = 0;
  }
  
  return NULL;
}

int speed2int(char* linespeed) {
  int i1;

  for (i1 = 0; i1 < 11; i1++) {
    if (!strcmp(linespeed, LineSpeed(i1))) return i1;
  }

  return 0;
}

int level2int(char* level) {
  int i1;

  if (level[0] == '\"') {
    level++;
    level[strlen(level)-1] = 0;
  }
  for (i1 = 0; i1 < 5; i1++) {
    if (!strcasecmp(level, Level[i1])) return i1;
  }

  return -1;
}

int mime2int(char* mime) {
  int i1;

  for (i1 = 0; i1 < MIME_SIZE; i1++) {
    if (!strcmp(mime, MimeNames(i1))) {
      return i1;
    }
  }

  return 0;
}

int mime2int_(char* mime) {
  int i1;

  for (i1 = 0; i1 < MIME_SIZE; i1++) {
    if (!strcmp(mime, MimeNames_(i1))) {
      return i1;
    }
  }

  return 0;
}

int status2int(char* status) {
  if (!strcmp("Inactive", status)) return STATUS_INACTIVE;
  else if (!strcmp("Active", status)) return STATUS_ACTIVE;
  else if (!strcmp("Active (Remote)", status)) return STATUS_REMOTE;
  else if (!strcmp("Remote", status)) return STATUS_REMOTE;
  else if (!strcmp("Cloaked", status)) return STATUS_CLOAKED;
  else if (!strcmp("Leeched", status)) return STATUS_LEECHED;
  else if (!strcmp("Muzzled", status)) return STATUS_MUZZLED;
  else if (!strcmp("Unknown", status)) return STATUS_UNKNOWN;
  else return STATUS_UNKNOWN;
}

int idle_function(gpointer data) {
  GtkWidget* temp;

  if (global.network.auto_connect) {
    on_connect_activate(NULL, NULL);
    temp = lookup_widget(global.connect_win, "combo_entry12");
    gtk_entry_set_text(GTK_ENTRY(temp), _("Last Server"));
    on_connection_ok_clicked(NULL, NULL);
  }

  return 0;
}

////////////////////////////////////////////////////
// geometry stuff
////////////////////////////////////////////////////

void geo_error(int cnt, char* line) {
  printf(_("unparsable line %d in geometry file: [%s]\n"), cnt, line);
}

char* is_clist(char* line) {
  if (!strncasecmp(line, "DOWNLOAD_COLUMN", 15)) {
    return "transfer_down";
  } else if (!strncasecmp(line, "UPLOAD_COLUMN", 13)) {
    return "transfer_up";
  } else if (!strncasecmp(line, "BROWSE_COLUMN", 13)) {
    return "ctree3";
  } else if (!strncasecmp(line, "SEARCH_COLUMN", 13)) {
    return (char*)2;
  } else if (!strncasecmp(line, "LIB_COLUMN", 10)) {
    return "lib_tree";
  } else if (!strncasecmp(line, "CHANNEL_COLUMN", 14)) {
    return "channel_list";
  } else if (!strncasecmp(line, "SERVER_COLUMN", 13)) {
    return "server_ctree";
  } else if (!strncasecmp(line, "SELECTED_COLUMN", 15)) {
    return "clist11";
  } else if (!strncasecmp(line, "HOTLIST_COLUMN", 14)) {
    return "clist16";
  } else if (!strncasecmp(line, "RESUME_COLUMN", 13)) {
    return "resume_tree";
  } else if (!strncasecmp(line, "ONLINE_COLUMN", 13)) {
    return (char*)1;
  } else {
    return NULL;
  }
}
char* is_paned(char* line) {
  if (!strncasecmp(line, "SERVER_PANED_POS", 16)) {
    return "vpaned2";
  } else if (!strncasecmp(line, "HOT_PANED_POS", 13)) {
    return "hpaned1";
  } else if (!strncasecmp(line, "ONLINE_PANED_POS", 16)) {
    return (char*)1;
  } else if (!strncasecmp(line, "WALLOP_PANED_POS", 16)) {
    return (char*)2;
  } else {
    return NULL;
  }
}

void read_geometry() {
  char File[1024];
  FILE* file;
  char line[500];
  char* pos1;
  char* pos2;
  char* pos3;
  int line_cnt;
  GtkCList* clist = NULL;
  int online;
  GtkWidget* temp = NULL;

  strcpy(File, global.lopster_home);
  strcat(File, "/geometry");

  if ((file = fopen(File, "r")) == NULL) return;
 
  line_cnt = 0;
  while (fgets(line, 400, file)) {
    line_cnt++;
    (strchr(line, '\n'))[0] = 0;
    if ((line[0] == '#') || 
	(line[0] == ' ') ||
	(line[0] == 0)) {
    } else if (!strncasecmp(line, "POSITION", 8)) {
      pos1 = strchr(line, '=');
      if (!pos1) {
	geo_error(line_cnt, line);
	continue;
      }
      pos2 = strrchr(pos1+1, ' ');
      if (!pos2) {
	geo_error(line_cnt, line);
	continue;
      }
      pos2[0] = 0;
      gtk_window_reposition(GTK_WINDOW(global.win),
			    atoi(pos1+1), atoi(pos2+1));
    } else if (!strncasecmp(line, "SIZE", 4)) {
      pos1 = strchr(line, '=');
      if (!pos1) {
	geo_error(line_cnt, line);
	continue;
      }
      pos2 = strrchr(pos1+1, ' ');
      if (!pos2) {
	geo_error(line_cnt, line);
	continue;
      }
      pos2[0] = 0;
      gtk_window_set_default_size(GTK_WINDOW (global.win),
				  atoi(pos1+1), atoi(pos2+1));
    } else if (!strncasecmp(line, "DETACHED", 8)) {
      pos1 = strchr(line, '=');
      if (!pos1) {
	geo_error(line_cnt, line);
	continue;
      }
      global.extra_win = atoi(pos1+1);
    } else if (!strncasecmp(line, "GEOMETRY", 8)) {
      pos1 = strchr(line, '=');
      if (!pos1) {
	geo_error(line_cnt, line);
	continue;
      }
      pos2 = strchr(pos1+1, ',');
      if (!pos2) {
	geo_error(line_cnt, line);
	continue;
      }
      global.geometry[atoi(pos1+1)].x = atoi(pos2+1);
      pos2 = strchr(pos2+1, ',');
      if (!pos2) {
	geo_error(line_cnt, line);
	continue;
      }
      global.geometry[atoi(pos1+1)].y = atoi(pos2+1);
      pos2 = strchr(pos2+1, ',');
      if (!pos2) {
	geo_error(line_cnt, line);
	continue;
      }
      global.geometry[atoi(pos1+1)].width = atoi(pos2+1);
      pos2 = strchr(pos2+1, ',');
      if (!pos2) {
	geo_error(line_cnt, line);
	continue;
      }
      global.geometry[atoi(pos1+1)].height = atoi(pos2+1);
    } else if ((pos1 = is_paned(line)) != NULL) {
      if (pos1 == (char*)1) online = 1;
      else if (pos1 == (char*)2) online = 2;
      else {
	online = 0;
	temp = lookup_widget(global.win, pos1);
      }
      pos1 = strchr(line, '=');
      if (!pos1) {
	geo_error(line_cnt, line);
	continue;
      }
      if (online == 1) global.paned_pos = atoi(pos1+1);
      else if (online == 2) global.paned_pos2 = atoi(pos1+1);
      else gtk_paned_set_position (GTK_PANED(temp), atoi(pos1+1));
    } else if ((pos1 = is_clist(line)) != NULL) {
      if (pos1 == (char*)1) online = 1;
      else if (pos1 == (char*)2) online = 2;
      else {
	online = 0;
	clist = GTK_CLIST(lookup_widget(global.win, pos1));
      }
      pos1 = strchr(line, '=');
      if (!pos1) {
	geo_error(line_cnt, line);
	continue;
      }
      pos2 = strchr(pos1+1, ',');
      if (!pos2) {
	geo_error(line_cnt, line);
	continue;
      }
      if (online == 1)
	global.online_width[atoi(pos1+1)] = atoi(pos2+1);
      else if (online == 2)
	global.search_width[atoi(pos1+1)] = atoi(pos2+1);
      else
	gtk_clist_set_column_width (clist, atoi(pos1+1), atoi(pos2+1));
      pos3 = strchr(pos2+1, ',');
      if (pos3) {
	if (online == 1) {
	  global.online_show[atoi(pos1+1)] = atoi(pos3+1);
	} else if (online == 2) {
	  global.search_show[atoi(pos1+1)] = atoi(pos3+1);
	} else {
	  gtk_clist_set_column_visibility(clist, atoi(pos1+1), atoi(pos3+1));
	}
      }
    } else {
      geo_error(line_cnt, line);
    }
  }
  global.status.geometry_read = 1;
}

void write_geometry() {
  char filename[1024];
  FILE* fd;
  GtkCList* clist;
  GtkPaned* paned;
  int i1;
  int x = 0;
  int y = 0;

  sprintf(filename, "%s/geometry", global.lopster_home);

  if ((fd = fopen(filename, "w")) == NULL) {
    g_warning(_("could not save geometry"));
    return;
  }
  
  if (global.win->window) {
    gdk_window_get_origin (global.win->window, &x, &y);
    fprintf(fd, "POSITION=%d %d\n", x, y);
  } else {
    g_warning("write_geometry: global.win->window == NULL");
  }

  fprintf(fd, "SIZE=%d %d\n", global.win->allocation.width, 
	  global.win->allocation.height);
  fprintf(fd, "DETACHED=%d\n", global.extra_win);
  clist = GTK_CLIST(lookup_widget(global.win, "transfer_down"));

  for (i1 = 0; i1 < 8; i1++) {
    fprintf(fd, "GEOMETRY=%d,%d,%d,%d,%d\n", i1, 
	    global.geometry[i1].x, global.geometry[i1].y,
	    global.geometry[i1].width, global.geometry[i1].height);
  }

  for (i1 = 0; i1 < clist->columns; i1++) {
    fprintf(fd, "DOWNLOAD_COLUMN=%d,%d,%d\n", i1, 
	    clist->column[i1].width, clist->column[i1].visible);
  }
  clist = GTK_CLIST(lookup_widget(global.win, "transfer_up"));
  for (i1 = 0; i1 < clist->columns; i1++) {
    fprintf(fd, "UPLOAD_COLUMN=%d,%d,%d\n", i1, 
	    clist->column[i1].width, clist->column[i1].visible);
  }
  clist = GTK_CLIST(lookup_widget(global.win, "ctree3"));
  for (i1 = 0; i1 < clist->columns; i1++) {
    fprintf(fd, "BROWSE_COLUMN=%d,%d,%d\n", i1, 
	    clist->column[i1].width, clist->column[i1].visible);
  }
  clist = GTK_CLIST(lookup_widget(global.win, "clist16"));
  for (i1 = 0; i1 < clist->columns; i1++) {
    fprintf(fd, "HOTLIST_COLUMN=%d,%d,%d\n", i1, 
	    clist->column[i1].width, clist->column[i1].visible);
  }
  clist = GTK_CLIST(lookup_widget(global.win, "lib_tree"));
  for (i1 = 0; i1 < clist->columns; i1++) {
    fprintf(fd, "LIB_COLUMN=%d,%d,%d\n", i1, 
	    clist->column[i1].width, clist->column[i1].visible);
  }
  clist = GTK_CLIST(lookup_widget(global.win, "channel_list"));
  for (i1 = 0; i1 < clist->columns; i1++) {
    fprintf(fd, "CHANNEL_COLUMN=%d,%d,%d\n", i1, 
	    clist->column[i1].width, clist->column[i1].visible);
  }
  clist = GTK_CLIST(lookup_widget(global.win, "server_ctree"));
  for (i1 = 0; i1 < clist->columns; i1++) {
    fprintf(fd, "SERVER_COLUMN=%d,%d,%d\n", i1, 
	    clist->column[i1].width, clist->column[i1].visible);
  }
  clist = GTK_CLIST(lookup_widget(global.win, "clist11"));
  for (i1 = 0; i1 < clist->columns; i1++) {
    fprintf(fd, "SELECTED_COLUMN=%d,%d,%d\n", i1, 
	    clist->column[i1].width, clist->column[i1].visible);
  }
  for (i1 = 0; i1 < 3; i1++) {
    fprintf(fd, "ONLINE_COLUMN=%d,%d,%d\n", i1, 
	    global.online_width[i1], global.online_show[i1]);
  }
  for (i1 = 0; i1 < 6; i1++) {
    fprintf(fd, "SEARCH_COLUMN=%d,%d,%d\n", i1, 
	    global.search_width[i1], global.search_show[i1]);
  }
  clist = GTK_CLIST(lookup_widget(global.win, "resume_tree"));
  for (i1 = 0; i1 < clist->columns; i1++) {
    fprintf(fd, "RESUME_COLUMN=%d,%d,%d\n", i1, 
	    clist->column[i1].width, clist->column[i1].visible);
  }

  fprintf(fd, "ONLINE_PANED_POS=%d\n", global.paned_pos);
  fprintf(fd, "WALLOP_PANED_POS=%d\n", global.paned_pos2);

  paned = GTK_PANED(lookup_widget(global.win, "vpaned2"));
  fprintf(fd, "SERVER_PANED_POS=%d\n", paned->child1_size);

  paned = GTK_PANED(lookup_widget(global.win, "hpaned1"));
  fprintf(fd, "HOT_PANED_POS=%d\n", paned->child1_size);
  
  fclose(fd);
}

////////////////////////////////////////////////////
// rcfile stuff
////////////////////////////////////////////////////

void read_rc() {
  char RCFile[1024];
  FILE* file;
  char* pos1;
  char* pos2;
  int section = 0;
  server_t* server;
  GtkWidget* temp;
  int changes = 1;
  int server_changes = 0;
  int usermode_set = 0;
  char scheme[1024] = "";

  strcpy(RCFile, global.lopster_home);
  strcat(RCFile, "/lopsterrc");

  if ((file = fopen(RCFile, "r")) == NULL) {
    suffix_t* suffix;

    g_warning(_("could not load rc-file"));
    global.channels = 
      g_list_append(global.channels, strdup("Lopster"));

    server = server_new();
    server_set_address(server, "bitchx.dimension6.com");
    server->port = 8888;
    server_set_description(server, "Bitchx");
    server_set_nick(server, "");
    server_set_passwd(server, "");
    add_server_to_list(server);

    server = server_new();
    server_set_address(server, "mp3.chemlab.org");
    server->port = 8888;
    server_set_description(server, "Chemlab");
    server_set_nick(server, "");
    server_set_passwd(server, "");
    add_server_to_list(server);

    server = server_new();
    server_set_address(server, "server.napster.com");
    server->port = 8875;
    server_set_description(server, "Official Meta Server");
    server->meta = 1;
    server_set_nick(server, "");
    server_set_passwd(server, "");
    add_server_to_list(server);

    command_make_alias("whisper", "msg");
    command_make_alias("join", "j");
    command_make_alias("emote", "me");
    
    suffix = (suffix_t*)malloc(sizeof(suffix_t));
    suffix->suffix = strdup("mp3");
    suffix->application = strdup("");
    global.mimetype[MIME_MP3].suffixes =
      g_list_append(global.mimetype[MIME_MP3].suffixes, suffix);

    on_preferences_activate(NULL, NULL);
  } else {
    while (fgets(rc_line, 400, file)) {
      (strchr(rc_line, '\n'))[0] = 0;
      if ((rc_line[0] == '#') || 
	  (rc_line[0] == ' ') ||
	  (rc_line[0] == 0)) {
      } else if (!strncasecmp(rc_line, "Section", 7)) {
	pos1 = strchr(rc_line, '[')+1;
	pos2 = strrchr(rc_line, ']');
	pos2[0] = 0;
	if (!strcasecmp(pos1, "User"))
	  section = 1;
	else if (!strcasecmp(pos1, "Path"))
	  section = 2;
	else if (!strcasecmp(pos1, "Network"))
	  section = 3;
	else if (!strcasecmp(pos1, "Hotlist"))
	  section = 4;
	else if (!strcasecmp(pos1, "Server"))
	  section = 5;
	else if (!strcasecmp(pos1, "Chat"))
	  section = 6;
	else if (!strcasecmp(pos1, "Buttons"))
	  section = 7;
	else if (!strcasecmp(pos1, "Global"))
	  section = 8;
	else if (!strcasecmp(pos1, "Library"))
	  section = 9;
	else {
	  g_warning("unknown section in rc-file [%s]", pos1);
	}
      } else if (section == 1) {
	if (!strncasecmp(rc_line, "NAME", 4)) {
	  strcpy(global.user.username, &rc_line[5]);
	} else if (!strncasecmp(rc_line, "PASSWORD", 8)) {
	  strcpy(global.user.password, &rc_line[9]);
	} else if (!strncasecmp(rc_line, "EMAIL", 5)) {
	  strcpy(global.user.email, &rc_line[6]);
	} else if (!strncasecmp(rc_line, "MODE", 4)) {
	  make_list_from_string(&global.usermode, rc_line+5, " ");
	  usermode_set = 1;
	} else {
	  g_warning(_("unknown tag in section USER [%s]"), rc_line);
	}
      } else if (section == 2) {
	if (!strncasecmp(rc_line, "DOWNLOAD", 8)) {
	  int i1;
	  pos1 = strchr(rc_line, '=')+1;
	  if (!isdigit(*pos1)) {   // backward compatible
	    i1 = MIME_MP3;
	    pos2 = pos1;
	  } else {
	    pos2 = strchr(pos1, ':');
	    *pos2 = 0;
	    pos2++;
	    i1 = atoi(pos1);
	  }
	  global.mimetype[i1].download = strdup(pos2);
	} else if (!strncasecmp(rc_line, "INCOMPLETE", 10)) {
	  global.incomplete_path = strdup(&rc_line[11]);
	} else if (!strncasecmp(rc_line, "SUFFIX", 6)) {
	  int i1;
	  suffix_t* suffix;

	  pos1 = strchr(rc_line, '=')+1;
	  pos2 = strchr(pos1, ':');
	  *pos2 = 0;
	  pos2++;
	  i1 = atoi(pos1);
	  pos1 = strchr(pos2, ':');
	  *pos1 = 0;
	  pos1++;
	  suffix = (suffix_t*)malloc(sizeof(suffix_t));
	  suffix->suffix = strdup(pos2);
	  suffix->application = strdup(pos1);
	  global.mimetype[i1].suffixes =
	    g_list_append(global.mimetype[i1].suffixes, suffix);
	} else if (!strncasecmp(rc_line, "SHARED", 6)) {
	  int i1;
	  pos1 = strchr(rc_line, '=')+1;
	  if (!isdigit(*pos1)) {   // backward compatible
	    i1 = MIME_MP3;
	    pos2 = pos1;
	  } else {
	    pos2 = strchr(pos1, ':');
	    *pos2 = 0;
	    pos2++;
	    i1 = atoi(pos1);
	  }
	  global.mimetype[i1].shared = 
	    g_list_append(global.mimetype[i1].shared, strdup(pos2));
	} else {
	  g_warning(_("unknown tag in section PATH [%s]"), rc_line);
	}
      } else if (section == 3) {
	if (!strncasecmp(rc_line, "LINESPEED", 9)) {
	  sscanf(rc_line+10, "%d", &(global.user.linespeed));
	} else if (!strncasecmp(rc_line, "PORT", 4)) {
	  sscanf(rc_line+5, "%d", &(global.network.port));
	} else if (!strncasecmp(rc_line, "ALLOWEDPORTS", 12)) {
	  pos1 = strchr(rc_line, '=')+1;
	  global.allowed_ports_str = strdup(pos1);
	  global.allowed_ports = 
	    create_ports_from_string(global.allowed_ports_str);
	} else if (!strncasecmp(rc_line, "MAX_DOWNLOADS", 13)) {
	  sscanf(rc_line+14, "%d", &(global.limit.max_downloads));
	} else if (!strncasecmp(rc_line, "MAX_UPLOADS", 11)) {
	  sscanf(rc_line+12, "%d", &(global.limit.max_uploads));
	} else if (!strncasecmp(rc_line, "DEFAULT_DOWNLOADS", 17)) {
	  sscanf(rc_line+18, "%d", &(global.limit.default_downloads));
	} else if (!strncasecmp(rc_line, "DEFAULT_UPLOADS", 15)) {
	  sscanf(rc_line+16, "%d", &(global.limit.default_uploads));
	} else if (!strncasecmp(rc_line, "AutoRetry", 9)) {
	  pos1 = strchr(rc_line, '=')+1;
	  global.options.auto_retry = atoi(pos1);
	} else if (!strncasecmp(rc_line, "AutoDelete", 9)) {
	  pos1 = strchr(rc_line, '=')+1;
	  global.options.auto_delete = atoi(pos1);
	} else if (!strncasecmp(rc_line, "FIREWALL", 8)) {
	  sscanf(rc_line+9, "%d", &(global.network.firewall));
	} else if (!strncasecmp(rc_line, "AutoConnect", 11)) {
	  sscanf(rc_line+12, "%d", &(global.network.auto_connect));
	} else if (!strncasecmp(rc_line, "TransferTimeout", 15)) {
	  sscanf(rc_line+16, "%d", &(global.network.transfer_timeout));
	} else if (!strncasecmp(rc_line, "DLAutoremove", 12)) {
	  pos1 = strchr(rc_line, '=')+1;
	  global.options.dl_autoremove = atoi(pos1);
	} else if (!strncasecmp(rc_line, "ULAutoremove", 12)) {
	  pos1 = strchr(rc_line, '=')+1;
	  global.options.ul_autoremove = atoi(pos1);
	} else if (!strncasecmp(rc_line, "TransferUpdate", 14)) {
	  sscanf(rc_line+15, "%d", &(global.network.transfer_delay));
	  if (global.network.transfer_delay <= 0)
	    global.network.transfer_delay = 1;
	} else if (!strncasecmp(rc_line, "AllowDCC", 8)) {
	  sscanf(rc_line+9, "%d", &(global.network.allow_dcc));
	} else if (!strncasecmp(rc_line, "DownloadBandwidth", 17)) {
	  pos1 = strchr(rc_line, '=')+1;
	  pos2 = strchr(pos1, ':'); *pos2 = 0;
	  pos2++;
	  global.down_width.limit = atoi(pos1);
	  global.down_width.maxval = atoi(pos2);
	} else if (!strncasecmp(rc_line, "UploadBandwidth", 15)) {
	  pos1 = strchr(rc_line, '=')+1;
	  pos2 = strchr(pos1, ':'); *pos2 = 0;
	  pos2++;
	  global.up_width.limit = atoi(pos1);
	  global.up_width.maxval = atoi(pos2);
	} else {
	  g_warning(_("unknown tag in section NETWORK [%s]"), rc_line);
	}
      } else if (section == 4) {
	if (!strncasecmp(rc_line, "USER", 4)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  add_to_hotlist(pos1);
	} else if (!strncasecmp(rc_line, "ShortNames", 10)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  temp = lookup_widget(global.win, "checkbutton18");
	  if (atoi(pos1))
	    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), TRUE);
	  else
	    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), FALSE);
	} else {
	  g_warning(_("unknown tag in section HOTLIST [%s]"), rc_line);
	}
      } else if (section == 5) {
	if (!strncasecmp(rc_line, "Server", 6)) {
	  server = server_new();
	  pos1 = strchr(rc_line, '=')+1;
	  pos2 = strchr(pos1, ':'); *pos2 = 0;
	  server_set_address(server, pos1);
	  pos1 = pos2+1;
	  pos2 = strchr(pos1, ':'); *pos2 = 0;
	  sscanf(pos1, "%d", &(server->port));
	  pos1 = pos2+1;
	  pos2 = strchr(pos1, ':'); *pos2 = 0;
	  server_set_description(server, pos1);
	  pos1 = pos2+1;
	  pos2 = strchr(pos1, ':');
	  sscanf(pos1, "%d", &(server->meta));
	  if (!pos2) {
	    server_changes = 1;
	    server->meta = 0;
	    if (global.user.username)
	      server->nick = strdup(global.user.username);
	    else server->nick = strdup("");
	    if (global.user.password)
	      server->passwd = strdup(global.user.password);
	    else server->passwd = strdup("");
	  } else {
	    *pos2 = 0;
	    pos1 = pos2+1;
	    pos2 = strchr(pos1, ':'); *pos2 = 0;
	    server->nick = strdup(pos1);
	    pos1 = pos2+1;
	    pos2 = strchr(pos1, ':');
	    if (pos1) server->passwd = strdup(pos1);
	    else server->passwd = strdup(global.user.password);
	  }
	  add_server_to_list(server);
	} else if (!strncasecmp(rc_line, "Last", 4)) {
	  server = server_new();
	  pos1 = strchr(rc_line, '=')+1;
	  pos2 = strchr(pos1, ':'); *pos2 = 0;
	  server->address = strdup(pos1);
	  pos1 = pos2+1;
	  pos2 = strchr(pos1, ':'); *pos2 = 0;
	  sscanf(pos1, "%d", &(server->port));
	  pos1 = pos2+1;
	  pos2 = strchr(pos1, ':'); *pos2 = 0;
	  server->description = strdup(pos1);
	  pos1 = pos2+1;
	  pos2 = strchr(pos1, ':');
	  sscanf(pos1, "%d", &(server->meta));
	  if (!pos2) {
	    server_destroy(server);
	  } else {
	    *pos2 = 0;
	    pos1 = pos2+1;
	    pos2 = strchr(pos1, ':'); *pos2 = 0;
	    server->nick = strdup(pos1);
	    pos1 = pos2+1;
	    pos2 = strchr(pos1, ':');
	    if (pos1) server->passwd = strdup(pos1);
	    else server->passwd = strdup(global.user.password);
	    global.last_server = server;
	  }
	} else {
	  g_warning(_("unknown tag in section SERVER [%s]"), rc_line);
	}
      } else if (section == 6) {
	if (!strncasecmp(rc_line, "Alias", 5)) {
	  pos1 = strchr(rc_line, '=')+1;
	  pos2 = strchr(rc_line, ':');
	  pos2[0] = 0;
	  pos2++;
	  command_make_alias(pos2, pos1);
	} else if (!strncasecmp(rc_line, "Highlight", 9)) {
	  pos1 = strchr(rc_line, '=')+1;
	  global.highlight = 
	    g_list_append(global.highlight, strdup(pos1));
	} else if (!strncasecmp(rc_line, "Friend", 6)) {
	  pos1 = strchr(rc_line, '=')+1;
	  global.frienduser = 
	    g_list_append(global.frienduser, strdup(pos1));
	} else if (!strncasecmp(rc_line, "Enemy", 5)) {
	  pos1 = strchr(rc_line, '=')+1;
	  global.enemyuser = 
	    g_list_append(global.enemyuser, strdup(pos1));
	} else if (!strncasecmp(rc_line, "Scheme", 6)) {
	  pos1 = strchr(rc_line, '=')+1;
	  strcpy(scheme, pos1);
	} else if (!strncasecmp(rc_line, "ShowJoins", 9)) {
	  pos1 = strchr(rc_line, '=')+1;
	  global.options.show_joins = atoi(pos1);
	} else if (!strncasecmp(rc_line, "PublicIgnore", 12)) {
	  pos1 = strchr(rc_line, '=')+1;
	  global.options.public_ignore = atoi(pos1);
	} else if (!strncasecmp(rc_line, "SendIgnore", 10)) {
	  pos1 = strchr(rc_line, '=')+1;
	  global.options.send_ignore = atoi(pos1);
	} else if (!strncasecmp(rc_line, "Channel", 7)) {
	  pos1 = strchr(rc_line, '=')+1;
	  global.channels = 
	    g_list_append(global.channels, strdup(pos1));
	} else if (!strncasecmp(rc_line, "Logging", 7)) {
	  pos1 = strchr(rc_line, '=')+1;
	  global.options.logging = atoi(pos1);
	} else if (!strncasecmp(rc_line, "LogExpire", 9)) {
	  pos1 = strchr(rc_line, '=')+1;
	  global.options.log_expire = atoi(pos1);
	} else if (!strncasecmp(rc_line, "ColorParse", 10)) {
	  pos1 = strchr(rc_line, '=')+1;
	  global.options.parse_color = atoi(pos1);
	} else if (!strncasecmp(rc_line, "SeparateWallop", 14)) {
	  pos1 = strchr(rc_line, '=')+1;
	  global.options.sep_chwallop = atoi(pos1);
	} else {
	  g_warning(_("unknown tag in section CHAT [%s]"), rc_line);
	}
      } else if (section == 7) {
	if (!strncasecmp(rc_line, "Chat", 4)) {
	  pos1 = strchr(rc_line, '=')+1;
	  temp = lookup_widget(global.win, "button114");
	  set_button_state(temp, atoi(pos1));
	} else if (!strncasecmp(rc_line, "Connect", 7)) {
	  pos1 = strchr(rc_line, '=')+1;
	  global.connect_button = atoi(pos1);
	} else if (!strncasecmp(rc_line, "Search", 6)) {
	  pos1 = strchr(rc_line, '=')+1;
	  temp = lookup_widget(global.win, "button115");
	  set_button_state(temp, atoi(pos1));
	} else {
	  g_warning(_("unknown tag in section BUTTONS [%s]"), rc_line);
	}
      } else if (section == 8) {
	if (!strncasecmp(rc_line, "Player", 6)) {  //backward 
	  suffix_t* suffix;

	  pos1 = strchr(rc_line, '=') + 1;
	  suffix = (suffix_t*)malloc(sizeof(suffix_t));
	  suffix->suffix = strdup("mp3");
	  suffix->application = strdup(pos1);
	  global.mimetype[MIME_MP3].suffixes =
	    g_list_append(global.mimetype[MIME_MP3].suffixes, suffix);
	} else if (!strncasecmp(rc_line, "Version", 7)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  if (!strcmp(pos1, VERSION)) changes = 0;
	} else if (!strncasecmp(rc_line, "PopupCreate", 11)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  global.options.popup_create = atoi(pos1);
	} else if (!strncasecmp(rc_line, "ClientInfo", 10)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  if (global.clientinfo) free(global.clientinfo);
	  global.clientinfo = strdup(pos1);
	} else if (!strncasecmp(rc_line, "Afk", 3)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  temp = lookup_widget(global.win, "entry50");
	  gtk_entry_set_text(GTK_ENTRY(temp), pos1);
	  temp = lookup_widget(global.win, "button125");
	  gtk_widget_set_sensitive(temp, FALSE);
	} else if (!strncasecmp(rc_line, "AutoReconnect", 13)) {
	  pos1 = strchr(rc_line, '=')+1;
	  global.network.auto_reconnect = atoi(pos1);
	} else if (!strncasecmp(rc_line, "AutoResume", 10)) {
	  pos1 = strchr(rc_line, '=')+1;
	  global.network.auto_resume = atoi(pos1);
	} else {
	  g_warning(_("unknown tag in section GLOBAL [%s]"), rc_line);
	}
      } else if (section == 9) {
	if (!strncasecmp(rc_line, "ShortNames", 10)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  temp = lookup_widget(global.win, "checkbutton19");
	  if (atoi(pos1))
	    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), TRUE);
	  else
	    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), FALSE);
	} else if (!strncasecmp(rc_line, "AutoSave", 8)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  global.auto_save = strdup(pos1);
	} else {
	  g_warning(_("unknown tag in section LIBRARY [%s]"), rc_line);
	}
      } else {
	g_warning(_("unparsable rc_line [%s]"), rc_line);
      }
    }
    fclose(file);
  }

  if (!usermode_set) {
    strcpy(rc_line, "ERROR CHANGE SERVER MUZZLE WALLOP CLOAK FLOOD WHOIS MSG LEVEL PING BAN KILL PORT");
    make_list_from_string(&global.usermode, rc_line, " ");
  }

  scheme_load_global(scheme, 1);

  if (changes == 1)
    changes_dialog("Changes since Version 0.9.7");
  if (server_changes == 1) {
    server_dialog(_("Changes (Server)"));
  }
  global.status.rc_read = 1;
}

void write_rc() {
  char RCFile[1024];
  FILE* file;
  GList* dlist;
  server_t* server;
  command_t* comm;
  int i1;
  char* str;
  GtkWidget* temp;
  suffix_t* suffix;

  strcpy(RCFile, global.lopster_home);
  strcat(RCFile, "/lopsterrc");

  if ((file = fopen(RCFile, "w")) != NULL) {
    fprintf(file, "# DANGER! Only edit if you know what you are doing\n");
    fprintf(file, "###################################\n");
    fprintf(file, "\nSection [USER]\n");
    fprintf(file, "Name=%s\n", global.user.username);
    fprintf(file, "Password=%s\n", global.user.password);
    fprintf(file, "EMail=%s\n", global.user.email);
    if (global.usermode) {
      fprintf(file, "Mode=%s\n", 
	      make_string_from_list(global.usermode, " "));
    }

    fprintf(file, "\nSection [PATH]\n");
    for (i1 = 0; i1 < MIME_SIZE; i1++) {
      if (global.mimetype[i1].download)
	fprintf(file, "Download=%d:%s\n", i1,
		global.mimetype[i1].download);
    }
    for (i1 = 1; i1 < MIME_SIZE; i1++) {
      for (dlist = global.mimetype[i1].shared; dlist; dlist=dlist->next) {
	fprintf(file, "Shared=%d:%s\n", i1, (char*)(dlist->data));
      }
    }
    if (global.incomplete_path)
      fprintf(file, "Incomplete=%s\n", global.incomplete_path);
    for (i1 = 1; i1 < MIME_SIZE; i1++) {
      for (dlist = global.mimetype[i1].suffixes; dlist; dlist = dlist->next) {
	suffix = (suffix_t*)(dlist->data);
	fprintf(file, "Suffix=%d:%s:%s\n", i1,
		suffix->suffix, suffix->application);
      }
    }

    fprintf(file, "\nSection [GLOBAL]\n");
    fprintf(file, "Version=%s\n", VERSION);
    fprintf(file, "PopupCreate=%d\n", global.options.popup_create);
    if (global.clientinfo)
      fprintf(file, "ClientInfo=%s\n", global.clientinfo);
    fprintf(file, "AutoReconnect=%d\n", global.network.auto_reconnect);
    fprintf(file, "AutoResume=%d\n", global.network.auto_resume);

    temp = lookup_widget(global.win, "entry50");
    str = gtk_entry_get_text(GTK_ENTRY(temp));
    fprintf(file, "AFK=%s\n", str);
    
    fprintf(file, "\nSection [Network]\n");
    fprintf(file, "Linespeed=%d\n", global.user.linespeed);
    fprintf(file, "Port=%d\n", global.network.port);
    fprintf(file, "AllowedPorts=%s\n", global.allowed_ports_str);
    fprintf(file, "Firewall=%d\n", global.network.firewall);
    fprintf(file, "Max_Downloads=%d\n", global.limit.max_downloads);
    fprintf(file, "Max_Uploads=%d\n", global.limit.max_uploads);
    fprintf(file, "Default_Downloads=%d\n", global.limit.default_downloads);
    fprintf(file, "Default_Uploads=%d\n", global.limit.default_uploads);
    fprintf(file, "AutoRetry=%d\n", global.options.auto_retry);
    fprintf(file, "AutoDelete=%d\n", global.options.auto_delete);
    fprintf(file, "AutoConnect=%d\n", global.network.auto_connect);
    fprintf(file, "TransferTimeout=%d\n", global.network.transfer_timeout);
    fprintf(file, "TransferUpdate=%d\n", global.network.transfer_delay);
    fprintf(file, "DLAutoremove=%d\n", global.options.dl_autoremove);
    fprintf(file, "ULAutoremove=%d\n", global.options.ul_autoremove);
    fprintf(file, "AllowDCC=%d\n", global.network.allow_dcc);
    fprintf(file, "DownloadBandwidth=%ld:%ld\n", 
	    global.down_width.limit,
	    global.down_width.maxval);
    fprintf(file, "UploadBandwidth=%ld:%ld\n", 
	    global.up_width.limit,
	    global.up_width.maxval);
	    
    fprintf(file, "\nSection [Hotlist]\n");
    
    if (global.hotlist) {
      dlist = g_list_first(global.hotlist);
      while (dlist) {
	str = (char*)(dlist->data);
	fprintf(file, "User=%s\n", str);
	dlist = g_list_next(dlist);
      }
    }
    temp = lookup_widget(global.win, "checkbutton18");
    if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
      fprintf(file, "ShortNames=1\n");
    } else {
      fprintf(file, "ShortNames=0\n");
    }

    fprintf(file, "\nSection [Server]\n");
    
    temp = lookup_widget(global.win, "clist11");
    i1 = 0;
    for (dlist = global.servers; dlist; dlist = dlist->next) {
      server = (server_t*)(dlist->data);
      fprintf(file, "Server=%s:%d:%s:%d:%s:%s\n", server->address, 
	      server->port, server->description, server->meta, 
	      server->nick?server->nick:"",
	      server->passwd?server->passwd:"");
    }

    if (global.last_server) {
      fprintf(file, "Last=%s:%d:%s:%d:%s:%s\n", 
	      global.last_server->address, 
	      global.last_server->port, 
	      global.last_server->description, 
	      global.last_server->meta, 
	      global.last_server->nick?global.last_server->nick:"",
	      global.last_server->passwd?global.last_server->passwd:"");
    }

    // chat
    fprintf(file, "\nSection [Chat]\n");
    for (i1 = 0; i1 < g_list_length(global.commands); i1++) {
      comm = 
	(command_t*)(g_list_nth(global.commands, i1)->data);
      if (comm->is_alias) {
	fprintf(file, "Alias=%s:%s\n", comm->name, &(comm->syntax[4]));
      }
    }
    if (global.highlight) {
      for (i1 = 0; i1 < g_list_length(global.highlight); i1++) {
	str = (char*)(g_list_nth(global.highlight, i1)->data);
	fprintf(file, "Highlight=%s\n", str);
      }
    }
    if (global.frienduser) {
      for (i1 = 0; i1 < g_list_length(global.frienduser); i1++) {
	str = (char*)(g_list_nth(global.frienduser, i1)->data);
	fprintf(file, "Friend=%s\n", str);
      }
    }
    if (global.enemyuser) {
      for (i1 = 0; i1 < g_list_length(global.enemyuser); i1++) {
	str = (char*)(g_list_nth(global.enemyuser, i1)->data);
	fprintf(file, "Enemy=%s\n", str);
      }
    }
    if (global.scheme)
      fprintf(file, "Scheme=%s\n", global.scheme->name);
    fprintf(file, "ShowJoins=%d\n", global.options.show_joins);
    fprintf(file, "PublicIgnore=%d\n", global.options.public_ignore);
    fprintf(file, "SendIgnore=%d\n", global.options.send_ignore);
    fprintf(file, "Logging=%d\n", global.options.logging);
    fprintf(file, "LogExpire=%d\n", global.options.log_expire);

    if (global.channels) {
      for (i1 = 0; i1 < g_list_length(global.channels); i1++) {
	str = (char*)(g_list_nth(global.channels, i1)->data);
	fprintf(file, "Channel=%s\n", str);
      }
    }
    fprintf(file, "ColorParse=%d\n", global.options.parse_color);
    fprintf(file, "SeparateWallop=%d\n", global.options.sep_chwallop);

    // buttons
    fprintf(file, "\nSection [Buttons]\n");
    temp = lookup_widget(global.win, "pix2");
    fprintf(file, "Chat=%d\n", GTK_WIDGET_VISIBLE(temp));
    temp = lookup_widget(global.win, "pix4");
    fprintf(file, "Search=%d\n", GTK_WIDGET_VISIBLE(temp));
    fprintf(file, "Connect=%d\n", global.connect_button);

    fprintf(file, "\nSection [Library]\n");
    temp = lookup_widget(global.win, "checkbutton19");
    if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
      fprintf(file, "ShortNames=1\n");
    } else {
      fprintf(file, "ShortNames=0\n");
    }
    if (global.auto_save)
      fprintf(file, "AutoSave=%s\n", global.auto_save);
    fclose(file);
  } else {
    g_warning(_("could not write rc-file %s"), RCFile);
  }

}

void setup_sensitive(int section) { // 0=opennap 1=destination
  int opennap;                      // 2=mediatype
  int search;
  int mp3;
  int advanced;
  char* text;
  GtkWidget* temp;
  GtkWidget* but1;
  server_t* server = NULL;

  if (global.napster)
    server = (server_t*)(global.napster->data);
  if (server && (server->network == N_OPENNAP)) opennap = TRUE;
  else opennap = FALSE;

  temp = lookup_widget(global.win, "combo_entry19");
  text = gtk_entry_get_text(GTK_ENTRY(temp));

  search = destination2int(text);

  temp = lookup_widget(global.win, "combo_entry17");
  text = gtk_entry_get_text(GTK_ENTRY(temp));
  if ((!strcmp(_("mp3"), text)) ||
      (!strcmp(_("any"), text))) mp3 = 1;
  else mp3 = 0;
  
  but1 = lookup_widget(global.win, "button73");
  temp = GTK_BIN(but1)->child;
  if (search == DEST_LIBRARY)
    gtk_label_set_text(GTK_LABEL(temp), _("Search in Library"));
  else if (search == DEST_HOTLIST)
    gtk_label_set_text(GTK_LABEL(temp), _("Search in Hotlist"));
  else if (search == DEST_SEARCH)
    gtk_label_set_text(GTK_LABEL(temp), _("Search in Results"));
  else
    gtk_label_set_text(GTK_LABEL(temp), _("Search on Network"));
  
  advanced = opennap|(search!=DEST_NAPSTER);
  if (!advanced) mp3 = 1;

  // menues
  if (section == 0) {
    temp = lookup_widget(global.win, "banned_users");
    gtk_widget_set_sensitive(temp, opennap);
    temp = lookup_widget(global.win, "linked_servers");
    gtk_widget_set_sensitive(temp, opennap);
    temp = lookup_widget(global.win, "client_statistic");
    gtk_widget_set_sensitive(temp, opennap);
  }

  //  temp = lookup_widget(global.win, "entry69");
  //  gtk_widget_set_sensitive(temp, advanced);
  temp = lookup_widget(global.win, "combo9");
  gtk_widget_set_sensitive(temp, advanced);
  temp = lookup_widget(global.win, "spinbutton24");
  gtk_widget_set_sensitive(temp, mp3&advanced);
  temp = lookup_widget(global.win, "spinbutton25");
  gtk_widget_set_sensitive(temp, mp3&advanced);
  temp = lookup_widget(global.win, "spinbutton26");
  gtk_widget_set_sensitive(temp, mp3&advanced);
  temp = lookup_widget(global.win, "spinbutton27");
  gtk_widget_set_sensitive(temp, mp3&advanced);
  temp = lookup_widget(global.win, "spinbutton28");
  gtk_widget_set_sensitive(temp, advanced);
  temp = lookup_widget(global.win, "spinbutton29");
  gtk_widget_set_sensitive(temp, advanced);
  temp = lookup_widget(global.win, "spinbutton30");
  gtk_widget_set_sensitive(temp, advanced);
  temp = lookup_widget(global.win, "spinbutton31");
  gtk_widget_set_sensitive(temp, advanced);
  temp = lookup_widget(global.win, "button146");
  gtk_widget_set_sensitive(temp, (search==2));
  
  temp = lookup_widget(global.win, "combo13");
  gtk_widget_set_sensitive(temp, search!=DEST_LIBRARY);
  temp = lookup_widget(global.win, "search_line2");
  gtk_widget_set_sensitive(temp, search!=DEST_LIBRARY);
  
  temp = lookup_widget(global.win, "combo11");
  gtk_widget_set_sensitive(temp, mp3);
  temp = lookup_widget(global.win, "search_bitrate2");
  gtk_widget_set_sensitive(temp, mp3);
  temp = lookup_widget(global.win, "combo12");
  gtk_widget_set_sensitive(temp, mp3);
  temp = lookup_widget(global.win, "search_frequency2");
  gtk_widget_set_sensitive(temp, mp3);
}

void setup_commands() {
  command_new(C_WHISPER, "whisper", 
	      "/whipser <user> <text>",
	      _("Send a private message <text> to the User <user>"),
	      L_USER, F_CHAT, lopster_whisper);
  command_new(C_EMOTE, "emote", 
	      "/emote <text>",
	      _("Send action description <text> on the current channel."),
	      L_USER, F_CHAT, lopster_emote);
  command_new(C_JOIN, "join", 
	      "/join <channel>",
	      _("Join channel <channel>."),
	      L_USER, F_CHAT, lopster_join);

  command_new(C_EMAIL, "email",
	      "/email <address>",
	      _("Change e-mail address to <address>."),
	      L_USER, F_UMOD, lopster_email);
  command_new(C_SPEED, "speed",
	      "/speed [<user>] [<speed>]",
	      _("It will change the link speed for <user>. If no user is given your own link speed is modified"),
	      L_USER, F_UMOD, lopster_speed);
  command_new(C_DATAPORT, "dataport",
	      "dataport [<user>] <port>",
	      _("Changes the dataport of <user> to <port>. If no user is specified it changes your own port"),
	      L_USER, F_UMOD, lopster_dataport);
  command_new(C_PASSWORD, "password",
	      "/password [<user>] <password>",
	      _("It will change the password for <user>. If no user is given your own password is modified"),
	      L_USER, F_UMOD, lopster_password);
  command_new(C_LEVEL, "level",
	      "/level <user> <level>",
	      _("Change level of <user> with a lower level than yours."),
	      L_USER, F_UMOD, lopster_level);
  command_new(C_USERMODE, "usermode",
	      "/usermode [[-]args <...>]",
	      _("Show or set current usermode (ERROR BAN CHANGE KILL LEVEL SERVER MUZZLE PORT WALLOP CLOAK FLOOD PING MSG WHOIS)"),
	      L_USER, F_UMOD, lopster_usermode);
  command_new(C_WHOIS, "whois", 
	      "/whois [<user>]",
	      _("Show whois info for <user>."),
	      L_USER, F_INFO, lopster_whois);
  command_new(C_HELP, "help", 
	      "/help [<command>]",
	      _("Type /help for a list of commands, type /help <command> for a description of command <command>"),
	      L_USER, F_INFO, lopster_help);
  command_new(C_DISC, "disc",
	      "/disc",
	      _("Disconnect from server."),
	      L_USER, F_MISC, lopster_disc);
  command_new(C_RAW, "raw", 
	      "/raw <type> [<arg>....]",
	      "?",
	      L_MOD, F_MOD, lopster_raw);
  command_new(C_BAN, "ban", 
	      "/ban <user|ip> [<reason>]",
	      _("Ban user or ip from server"),
	      L_MOD, F_MOD, lopster_ban);
  command_new(C_UNBAN, "unban",
	      "/unban <user|ip>",
	      _("Remove the ban on a user or ip."),
	      L_MOD, F_MOD, lopster_unban);
  command_new(C_CLOAK, "cloak", 
	      "/cloak",
	      _("Toggle your invisible state."),
	      L_MOD, F_MOD, lopster_cloak);
  command_new(C_CHCLEAR, "chclear", 
	      "/chclear",
	      _("Clear the current channel from users with a lower level than yours."),
	      L_USER, F_OP, lopster_chclear);
  command_new(C_KILL, "kill",
	      "/kill <user>",
	      _("Kill (disconnect) <user> with a lower lower level than yours."),
	      L_USER, F_MOD, lopster_kill);
  command_new(C_LINKS , "links",
	      "/links [GET|PRINT]",
	      _("Show links between servers and request linked lint from server if GET is given or list is empty."),
	      L_USER, F_INFO, lopster_links);
  command_new(C_CHLIST, "chlist",
	      "/chlist",
	      _("List all channels in channel list"),
	      L_USER, F_CLIENT, lopster_chlist);
  command_new(C_PART, "part",
	      "/part",
	      _("Part the current channel."),
	      L_USER, F_CHAT, lopster_part);
  command_new(C_WALLOP, "wallop",
	      "/wallop <text>",
	      _("Send a message to all users with level moderator or higher."),
	      L_MOD, F_MOD, lopster_wallop);
  command_new(C_STATS, "stats",
	      "/stats",
	      _("Show server statistics."),
	      L_USER, F_INFO, lopster_stats);
  command_new(C_SCHEME, "scheme",
	      "/scheme <name>",
	      _("Loading Color scheme <name>."),
	      L_USER, F_CLIENT, lopster_scheme);
  command_new(C_ALIAS, "alias",
	      "/alias <alias> <command>",
	      _("Making new <alias> for <command>."),
	      L_USER, F_CLIENT, lopster_alias);
  command_new(C_AFK, "afk",
	      "/afk [<text>]",
	      _("If argument text is given, your status is set to AFK. Users sending you private messages will receive <text> as a private message. If no argument is given AFK is deactivated."),
	      L_USER, F_CLIENT, lopster_afk);
  command_new(C_PUBLIC, "public",
	      "/public <text>",
	      _("Force to send public message"),
	      L_USER, F_CHAT, lopster_public);
  command_new(C_REPLY, "reply",
	      "/reply <text>",
	      _("Reply to the user who sent the last private message"),
	      L_USER, F_CHAT, lopster_reply);
  command_new(C_PRIVATE, "private",
	      "/private <user>",
	      _("Create new page for private messaging to <user>"),
	      L_USER, F_CHAT, lopster_private);
  command_new(C_CONN, "conn",
	      "/conn",
	      _("Connect to the last server used."),
	      L_USER, F_MISC, lopster_conn);
  command_new(C_MOTD, "motd",
	      "/motd",
	      _("Show server's \"Message Of The Day\"."),
	      L_USER, F_INFO, lopster_motd);
  command_new(C_QUIT, "quit",
	      "/quit",
	      _("Exit program."),
	      L_USER, F_MISC, lopster_quit);
  command_new(C_IGNORE, "ignore",
	      "/ignore [<user>]",
	      _("ignore user <user>. If User is not given, ignore list is shown"),
	      L_USER, F_CHAT, lopster_ignore);
  command_new(C_UNIGNORE, "unignore",
	      "/unignore <user>",
	      _("Unignores <user>"),
	      L_USER, F_CHAT, lopster_unignore);
  command_new(C_MUZZLE, "muzzle",
	      "/muzzle <user> [<reason>]",
	      _("Muzzle <user> with a lower level than yours."),
	      L_MOD, F_MOD, lopster_muzzle);
  command_new(C_UNMUZZLE, "unmuzzle",
	      "/unmuzzle <user>",
	      _("Unmuzzle <user> with a lower level than yours."),
	      L_MOD, F_MOD, lopster_unmuzzle);
  command_new(C_CHBAN, "chban",
	      "/chban <channel> <user|ip> [<reason>]",
	      _("Ban <user|ip> from <channel>"),
	      L_USER, F_OP, lopster_chban);
  command_new(C_CHUNBAN, "chunban",
	      "/chunban <channel> [<user|ip> [<reason>]]",
	      _("Unban <user|ip> from <channel>. If no user is specified, the ban list is cleared"),
	      L_USER, F_OP, lopster_chunban);
  command_new(C_TOPIC, "topic",
	      "/topic <chn> <topic>",
	      _("Set the topic of channel <chn> to <topic>."),
	      L_USER, F_OP, lopster_topic);
  command_new(C_VERSION, "version",
	      "/version",
	      _("Show server version."),
	      L_MOD, F_MOD, lopster_version);
  command_new(C_CLEAR, "clear",
	      "/clear [BOTTOM|TOP]",
	      _("Clears to current channel window"),
	      L_USER, F_CLIENT, lopster_clear);
  command_new(C_NUKE, "nuke",
	      "/nuke <user>",
	      _("Nuke a <user> (delete account)"),
	      L_ELITE, F_ADMIN, lopster_nuke);
  command_new(C_UNNUKE, "unnuke",
	      "/unnuke <user>",
	      _("Nuke a <user> (delete accout)"),
	      L_MOD, F_MOD, lopster_unnuke);
  command_new(C_GLOBAL, "global",
	      "/global <text>",
	      _("Send global message to all users."),
	      L_ADMIN, F_ADMIN, lopster_global);
  command_new(C_KICK, "kick",
	      "/kick <channel> <user> [<reason>]",
	      _("Kick <user> with a lower level than yours from the <channel>."),
	      L_USER, F_OP, lopster_kick);
  command_new(C_CVERSION, "cversion",
	      "/cversion",
	      _("Prints out the client version, if in a channel via public message"),
	      L_USER, F_INFO, lopster_cversion);
  command_new(C_PING, "ping",
	      "/ping <user>",
	      _("Ping <user>."),
	      L_USER, F_MISC, lopster_ping);
  command_new(C_SPING, "sping",
	      "/sping <server>",
	      _("Ping <server>."),
	      L_USER, F_MISC, lopster_sping);
  command_new(C_ECHO, "echo",
	      "/echo <text>",
	      _("Echo <text> to current window. What's this command good for?"),
	      L_USER, F_CLIENT, lopster_echo);
  command_new(C_CHLIMIT, "chlimit",
	      "/chlimit [<channel>] [<limit>]",
	      _("Change max. user limit of <channel> to <limit>. If no limit is specified the current limit is shown. If no channel is specified the current channel is used."),
	      L_USER, F_OP, lopster_chlimit);
  command_new(C_CHLEVEL, "chlevel", 
	      "/chlevel [<channel>] [<level>]",
	      _("Set the minimum level required to join <channel>. If no level is given the current level is shown.If no channel is given the current channel is used."),
	      L_USER, F_OP, lopster_chlevel);
  command_new(C_SSTATS, "sstats", 
	      "/sstats",
	      _("Show the server stats (moderator or higher)"),
	      L_USER, F_INFO, lopster_sstats);
  command_new(C_CHMODE, "chmode",
	      "/chmode [<channel>] [<+|-><mode>]",
	      _("Set mode for <channel>. If no mode is given the current mode is displayed. If no channel is given the current channel is used. Mode may be one of PRIVATE, MODERATED, INVITE, TOPIC, REGISTERED."),
	      L_USER, F_OP, lopster_chmode);
  command_new(C_CHWALLOP, "chwallop",
	      "/chwallop <message>",
	      _("Send message to all channel operators"),
	      L_USER, F_OP, lopster_chwallop);
  command_new(C_OP, "op",
	      "/op [<channel>] [<user>]",
	      _("Set <user> as operator on the current channel. If no channel is given the current channel is used, if no user is given the operator list is shown"),
	      L_USER, F_OP, lopster_op);
  command_new(C_DEOP, "deop",
	      "/deop  [<channel>] <user>",
	      _("Remove <user> as operator on the current channel or the specified channel."),
	      L_USER, F_OP, lopster_deop);
  command_new(C_KILLGHOST, "killghost",
	      "/killghost <ghost> [<passwd>]",
	      _("kill your <ghost>. if no password is given, the current password is used"),
	      L_USER, F_MISC, lopster_killghost);
  command_new(C_FRIEND, "friend",
	      "/friend <user>",
	      _("Add/remove a user to/from the friend list"),
	      L_USER, F_CLIENT, lopster_friend);
  command_new(C_ENEMY, "enemy",
	      "/enemy <user>",
	      _("Add/remove a user to/from the enemy list"),
	      L_USER, F_CLIENT, lopster_enemy);
  command_new(C_HOTADD, "hotadd",
	      "/hotadd <user>",
	      _("Add a user to the hot list"),
	      L_USER, F_CLIENT, lopster_hotadd);
  command_new(C_HOTREM, "hotrem",
	      "/hotrem <user>",
	      _("Remove a user from the hot list"),
	      L_USER, F_CLIENT, lopster_hotrem);
  command_new(C_LOCATE, "locate",
	      "/locate <user>",
	      _("Display on which server <user> is"),
	      L_USER, F_INFO, lopster_locate);
  command_new(C_CLIENTS, "clients",
	      "/clients",
	      _("Display clients versions if server has enabled logs"),
	      L_USER, F_INFO, lopster_clients);
  command_new(C_INVITE, "invite",
	      "/invite [<channel>] <user>",
	      _("Invite <user> to <channel> or the current channel"),
	      L_USER, F_CHAT, lopster_invite);
  command_new(C_CHMUZZLE, "chmuzzle",
	      "/chmuzzle [<user> [<reason>]]",
	      _("Muzzle <user>. If no user is specified the muzzle list is shown"),
	      L_USER, F_OP, lopster_chmuzzle);
  command_new(C_CHUNMUZZLE, "chunmuzzle",
	      "/chunmuzzle [<channel>] <user> [\"reason\"]",
	      _("Unmuzzle <user> with a lower level than yours."),
	      L_USER, F_OP, lopster_chunmuzzle);
  command_new(C_CHVOICE, "chvoice",
	      "/chvoice [<channel>] [<user>]",
	      _("Give <user> voice to speak in channel If no channel is given the current channel is used. If no user is specified the voice list is shown"),
	      L_USER, F_OP, lopster_chvoice);
  command_new(C_CHUNVOICE, "chunvoice",
	      "/chunvoice [<channel>] <user>",
	      _("Remove voice from <user> to speak in channel."),
	      L_USER, F_OP, lopster_chunvoice);
  command_new(C_CLIENTINFO, "clientinfo",
	      "/clientinfo [<info>]",
	      _("Set yout client info to <info>"),
	      L_USER, F_CLIENT, lopster_clientinfo);
  command_new(C_GUSER, "guser",
	      "/guser [<server> [<flags>]]",
	      _("List all users. Flags may be a list of the characters: e=ELITE, a=ADMIN, m=MODERATOR, l=LEECH, z=MUZZLED, c=CLOAKED"),
	      L_MOD, F_MOD, lopster_guser);
  command_new(C_SCONFIG, "sconfig",
	      "/sconfig",
	      _("Request server config"),
	      L_MOD, F_MOD, lopster_sconfig);
  command_new(C_CLONES, "clones",
	      "/clones <all|<channel>|<IP>> [<num>]",
	      _("Show all clones or for specified IP or channel. Only available if global user list was received."),
	      L_MOD, F_MOD, lopster_clones);
  command_new(C_EXEC, "exec",
	      "/exec [-out|-msg|-wallop|-chop|-quiet|-global|-kill] [<who>] [<command>]",
	      _("Executes <command>"),
	      L_USER, F_CLIENT, lopster_exec);
  command_new(C_WHOWAS, "whowas",
	      "/whowas <user>",
	      _("Query information about <user>. Moderator or higher."),
	      L_MOD, F_MOD, lopster_whowas);
  command_new(C_RAINBOW, "rainbow",
	      "/rainbow [sep] <size> <text>",
	      _("Send the <text> with rainbow colors as a public message. Color is changed after <size> letters. <sep> is a not colored text, that is inserted between the color changes."),
	      L_USER, F_CLIENT, lopster_rainbow);
  command_new(C_RCOLORS, "rcolors",
	      "/rcolor [<-reset|color_codes>]",
	      _("Setup the colors for command /rainbow"),
	      L_USER, F_CLIENT, lopster_rcolors);
  command_new(C_BROWSE, "browse",
	      "/browse [<user> [<max>]] ",
	      _("Browse at most <max> files from <user>"),
	      L_USER, F_CLIENT, lopster_browse);
  command_new(C_SEND, "send", 
	      "/send <user> <file>",
	      _("Send a file to user."),
	      L_USER, F_CLIENT, lopster_send);
  command_new(C_SLINK, "slink", 
	      "/slink <server> [<remote server>]",
	      _("Attempts to link the current server to <server>. If <remote_server> is given, then that server attempts to make the link instead of the local server."),
	      L_ADMIN, F_ADMIN, lopster_slink); // admin
  command_new(C_SDELINK, "sdelink", 
	      "/sdelink <server> [<reason>]",
	      _("delink current server from <server>."),
	      L_ADMIN, F_ADMIN, lopster_sdelink); // admin
  command_new(C_SREMOVE, "sremove", 
	      "/sremove <server> [<reason>]",
	      _("requests that <server> be removed from the table of allowed links."),
	      L_ELITE, F_ADMIN, lopster_sremove); // elite
  command_new(C_SKILL, "skill", 
	      "/skill <server> [<reason>]",  
	      _("cause the server to shutdown."),
	      L_ELITE, F_ADMIN, lopster_skill); // elite
  command_new(C_SRELOAD, "sreload",
	      "/skill [<server>]",
	      _("Reload the (local) server configuration."),
	      L_ADMIN, F_ADMIN, lopster_sreload); // admin
  command_new(C_MASSKILL, "masskill",
	      "/masskill <ip> [<reason>]",
	      _("Kill all users with <ip>."),
	      L_MOD, F_MOD, lopster_masskill);
  command_new(C_TEST, "test",
	      "/test",
	      _("Internal test function"),
	      L_MOD, F_MOD, lopster_test);
}

void create_pixmaps() {
  GtkStyle *style;

  style = gtk_widget_get_style(global.win);
  global.pix.sgreen = 
    gdk_pixmap_create_from_xpm_d(global.win->window,
				 &(global.pix.sgreenb),
				 &style->bg[GTK_STATE_NORMAL],
				 speedgreen_xpm);
  global.pix.sred = 
    gdk_pixmap_create_from_xpm_d(global.win->window,
				 &(global.pix.sredb),
				 &style->bg[GTK_STATE_NORMAL],
				 speedred_xpm);
  global.pix.syellow = 
    gdk_pixmap_create_from_xpm_d(global.win->window,
				 &(global.pix.syellowb),
				 &style->bg[GTK_STATE_NORMAL],
				 speedyellow_xpm);
  global.pix.sgray = 
    gdk_pixmap_create_from_xpm_d(global.win->window,
				 &(global.pix.sgrayb),
				 &style->bg[GTK_STATE_NORMAL],
				 speedgray_xpm);

  global.pix.folder = 
    gdk_pixmap_create_from_xpm_d(global.win->window,
				 &(global.pix.folderb),
				 &style->bg[GTK_STATE_NORMAL],
				 folder);
  global.pix.folder_open = 
    gdk_pixmap_create_from_xpm_d(global.win->window,
				 &(global.pix.folder_openb),
				 &style->bg[GTK_STATE_NORMAL],
				 folder_open);
  global.pix.user1 = 
    gdk_pixmap_create_from_xpm_d(global.win->window,
				 &(global.pix.user1b),
				 &style->bg[GTK_STATE_NORMAL],
				 user_on);
  global.pix.user2 = 
    gdk_pixmap_create_from_xpm_d(global.win->window,
				 &(global.pix.user2b),
				 &style->bg[GTK_STATE_NORMAL],
				 user_off);
  global.pix.ignore = 
    gdk_pixmap_create_from_xpm_d(global.win->window,
				 &(global.pix.ignoreb),
				 &style->bg[GTK_STATE_NORMAL],
				 ignore_xpm);
  global.pix.enemy = 
    gdk_pixmap_create_from_xpm_d(global.win->window,
				 &(global.pix.enemyb),
				 &style->bg[GTK_STATE_NORMAL],
				 enemy_xpm);
  global.pix.enemy2 = 
    gdk_pixmap_create_from_xpm_d(global.win->window,
				 &(global.pix.enemy2b),
				 &style->bg[GTK_STATE_NORMAL],
				 enemy2_xpm);
  global.pix.friend = 
    gdk_pixmap_create_from_xpm_d(global.win->window,
				 &(global.pix.friendb),
				 &style->bg[GTK_STATE_NORMAL],
				 friend_xpm);
  global.pix.dummy = 
    gdk_pixmap_create_from_xpm_d(global.win->window,
				 &(global.pix.dummyb),
				 &style->bg[GTK_STATE_NORMAL],
				 dummy_xpm);
}

void setup_widgets() {
  GtkWidget* temp;
  char* pos;
  char text[1024];
  int i1;

  sprintf(text, "Lopster %s", VERSION);
  gtk_window_set_title (GTK_WINDOW(global.win), text);

  temp = lookup_widget(global.win, "notebook3");
  gtk_notebook_popup_enable(GTK_NOTEBOOK(temp));

  temp = lookup_widget(global.win, "lib_tree");
  gtk_clist_set_compare_func(GTK_CLIST(temp), lib_compare);

  temp = lookup_widget(global.win, "server_ctree");
  gtk_clist_set_compare_func(GTK_CLIST(temp), server_compare);

  temp = lookup_widget(global.win, "Console_text");
  gtk_text_set_word_wrap(GTK_TEXT(temp), 1);

  temp = lookup_widget(global.win, "entry45");
  pos = make_string_from_list(global.highlight, " ");
  gtk_entry_set_text(GTK_ENTRY(temp), pos);

  temp = lookup_widget(global.win, "entry46");
  pos = make_string_from_list(global.frienduser, " ");
  gtk_entry_set_text(GTK_ENTRY(temp), pos);

  temp = lookup_widget(global.win, "entry51");
  pos = make_string_from_list(global.enemyuser, " ");
  gtk_entry_set_text(GTK_ENTRY(temp), pos);


  temp = lookup_widget(global.win, "checkbutton7");
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp),
			       global.options.show_joins);

  temp = lookup_widget(global.win, "checkbutton14");
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp),
			       global.options.send_ignore);

  temp = lookup_widget(global.win, "checkbutton10");
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp),
			       global.options.public_ignore);

  temp = lookup_widget(global.win, "checkbutton21");
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp),
			       global.options.parse_color);

  temp = lookup_widget(global.win, "spinbutton5");
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp),
			    global.limit.max_downloads);
  temp = lookup_widget(global.win, "spinbutton35");
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp),
			    global.limit.default_downloads);
  temp = lookup_widget(global.win, "spinbutton6");
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp),
			    global.limit.max_uploads);
  temp = lookup_widget(global.win, "spinbutton36");
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp),
			    global.limit.default_uploads);

  temp = lookup_widget(global.win, "button122");
  gtk_widget_set_sensitive(temp, FALSE);
  temp = lookup_widget(global.win, "button123");
  gtk_widget_set_sensitive(temp, FALSE);
  temp = lookup_widget(global.win, "button124");
  gtk_widget_set_sensitive(temp, FALSE);

  temp = lookup_widget(global.win, "channel_list");
  gtk_clist_set_sort_column(GTK_CLIST(temp), 0);
  gtk_clist_set_auto_sort(GTK_CLIST(temp), TRUE);
  gtk_clist_set_compare_func(GTK_CLIST(temp), channel_compare);

  temp = lookup_widget(global.win, "global_users");
  gtk_widget_set_sensitive(temp, FALSE);

  temp = lookup_widget(global.win, "transfer_down");
  gtk_clist_set_reorderable (GTK_CLIST(temp), TRUE);
  gtk_clist_set_use_drag_icons (GTK_CLIST(temp), TRUE);

  temp = lookup_widget(global.win, "clist11");
  gtk_clist_set_reorderable (GTK_CLIST(temp), TRUE);
  gtk_clist_set_use_drag_icons (GTK_CLIST(temp), TRUE);

  temp = lookup_widget(global.win, "checkbutton35");
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp),
			       global.network.auto_resume);


  temp = lookup_widget(global.win, "frame195");
  gtk_widget_set_style(temp, global.style[3]);
  temp = lookup_widget(global.win, "frame143");
  gtk_widget_set_style(temp, global.style[3]);
  temp = lookup_widget(global.win, "frame142");
  gtk_widget_set_style(temp, global.style[3]);
  temp = lookup_widget(global.win, "frame141");
  gtk_widget_set_style(temp, global.style[3]);
  temp = lookup_widget(global.win, "frame3");
  gtk_widget_set_style(temp, global.style[3]);
  temp = lookup_widget(global.win, "label463");
  gtk_widget_set_style(temp, global.style[3]);
  temp = lookup_widget(global.win, "label467");
  gtk_widget_set_style(temp, global.style[3]);
  temp = lookup_widget(global.win, "search_artist");
  gtk_widget_set_style(temp, global.style[4]);
  temp = lookup_widget(global.win, "entry69");
  gtk_widget_set_style(temp, global.style[4]);

  global.down_width.area = lookup_widget(global.win, "drawingarea1");
  global.down_width.label_max = lookup_widget(global.win, "label536");
  global.down_width.label_cur = lookup_widget(global.win, "label538");
  global.up_width.area = lookup_widget(global.win, "drawingarea2");
  global.up_width.label_max = lookup_widget(global.win, "label541");
  global.up_width.label_cur = lookup_widget(global.win, "label542");
  
  for (i1 = 0; i1 < 7; i1++) {
    if (global.extra_win & (1<<i1)) {
      global.extra_win ^= (1<<i1);
      temp = main_tab_detach(i1);
      while(gtk_events_pending()) gtk_main_iteration();
    }
  }
  if (global.extra_win & (1<<7)) {
    temp = search_fields_detach();
    while(gtk_events_pending()) gtk_main_iteration();
  }
}

void setup_buttons() {
  GtkWidget* temp;

  temp = lookup_widget(global.win, "button114");  //chat
  set_up_button(temp, "pix1",  "pix2",  "frame98");
  temp = lookup_widget(global.win, "button115");  //search
  set_up_button(temp, "pix3",  "pix4",  "frame3");
}

void setup_mime() {
  int i1;

  for (i1 = 0; i1 < MIME_SIZE; i1++) {
    global.mimetype[i1].shared = NULL;
    global.mimetype[i1].download = strdup("");;
    global.mimetype[i1].suffixes = NULL;
  }
}

void global_init() {
  GtkWidget* temp;
  time_t tim;
  char str[1024];
  user_t* user;
  int i1;

  global.user.username[0] = 0;
  global.user.password[0] = 0;
  global.user.email[0] = 0;
  global.user.level = L_USER;
  global.user.status = STATUS_INACTIVE;
  global.user.linespeed = 0;
  global.user.shared = 0;
  global.user.bytes = 0;
  global.user.level = L_USER;
  global.user.status = STATUS_INACTIVE;
  global.user.files = NULL;

  global.timer = -1;

  global.connect_win = NULL;
  global.ban_win = NULL;
  global.user_win = NULL;
  global.ignore_win = NULL;
  global.whois_win = NULL;
  global.usermode_win = NULL;
  global.socket_win = NULL;
  
  global.status.searching = 0;
  global.status.building = 0;
  global.status.connection = 0;
  global.status.whois_hide = 0;
  global.status.exiting = 0;
  global.status.rc_read = 0;
  global.status.geometry_read = 0;

  global.limit.cur_uploads = 0;
  global.limit.cur_downloads = 0;
  global.limit.max_uploads = 3;
  global.limit.max_downloads = 5;
  global.limit.default_uploads = 2;
  global.limit.default_downloads = 3;

  global.network.firewall = 0;
  global.network.transfer_timeout = 500;
  global.network.transfer_delay = 1;
  global.network.port = 6699;
  global.network.auto_connect = 0;
  global.network.reconnect_timer = -1;
  global.network.auto_reconnect = 1;
  global.network.auto_resume = 0;
  global.network.allow_dcc = 0;

  global.options.show_joins = 1;
  global.options.public_ignore = 0;
  global.options.send_ignore = 0;
  global.options.logging = 0;
  global.options.parse_color = 1;
  global.options.popup_create = 3;
  global.options.log_expire = 5;        // 5 hours
  global.options.sep_chwallop = 0;
  global.options.auto_retry = RETRY_REMOTE;
  global.options.auto_delete = DELETE_UNSTARTED;
  global.options.dl_autoremove = 0;
  global.options.ul_autoremove = 0;
  
  global.servers = NULL;
  global.ignored_users = NULL;
  global.commands = NULL;
  global.scheme = NULL;
  global.highlight = NULL;
  global.frienduser = NULL;
  global.enemyuser = NULL;
  global.chat_history = NULL;
  global.afk.message = NULL;
  global.reply = NULL;
  global.last_server = NULL;
  global.incomplete_path = NULL;
  global.connect_button = 0;
  global.usermode = NULL;
  global.incomplete = NULL;
  global.queue = NULL;
  global.share_queue = NULL;
  global.clientinfo = NULL;
  global.online_width[0] = 100;
  global.online_width[1] = 30;
  global.online_width[2] = 60;
  global.online_show[0] = 1;
  global.online_show[1] = 1;
  global.online_show[2] = 1;
  global.paned_pos = 730;
  global.paned_pos2 = 0;
  global.clones = NULL;
  global.client_list = NULL;
  global.links = NULL;
  global.allowed_links = NULL;
  global.sockets = NULL;
  global.opchannel = NULL;
  global.extra_win = 0;
  global.chat_pages = NULL;
  global.searches = NULL;

  global.down_width.limit = 1024*1024;
  global.down_width.current = 0;
  global.down_width.maxval = 1024*1024;
  global.up_width.limit = 1024*1024;
  global.up_width.current = 0;
  global.up_width.maxval = 1024*1024;

  global.search_width[0] = 462;
  global.search_width[1] = 80;
  global.search_width[2] = 80;
  global.search_width[3] = 80;
  global.search_width[4] = 80;
  global.search_width[5] = 80;

  global.rainbow_colors = strdup("RrpPBbcCgGYy");
  global.allowed_ports_str = NULL;
  global.allowed_ports = NULL;

  global.options.login_mode = 0;
  global.auto_save = NULL;
  global.execs = NULL;

  for (i1 = 0; i1 < 6; i1++) 
    global.search_show[i1] = 1;

  for (i1 = 0; i1 < 8; i1++) 
    global.geometry[i1].x = global.geometry[i1].y = 
      global.geometry[i1].width = global.geometry[i1].height = -1;

  global.style[0] = gtk_widget_get_style(global.win);

  advance_progress(_("Setting up lopster styles..."), 0.15);
  global.style[1] = gtk_style_new();
  global.style[1]->font = global.style[0]->font;
  global.style[1]->fg[GTK_STATE_NORMAL].pixel = 
    global.style[0]->fg[GTK_STATE_SELECTED].pixel;
  global.style[1]->fg[GTK_STATE_NORMAL].red = 65535;
  global.style[1]->fg[GTK_STATE_NORMAL].green = 0;
  global.style[1]->fg[GTK_STATE_NORMAL].blue = 0;

  global.style[2] = gtk_style_new();
  global.style[2]->font = global.style[0]->font;
  global.style[2]->base[GTK_STATE_NORMAL].pixel = 
    global.style[0]->base[GTK_STATE_NORMAL].pixel;
  global.style[2]->base[GTK_STATE_NORMAL].red = 0;
  global.style[2]->base[GTK_STATE_NORMAL].green = 0;
  global.style[2]->base[GTK_STATE_NORMAL].blue = 0;

  global.style[2]->text[GTK_STATE_NORMAL].pixel = 
    global.style[0]->text[GTK_STATE_NORMAL].pixel;
  global.style[2]->text[GTK_STATE_NORMAL].red = 65535;
  global.style[2]->text[GTK_STATE_NORMAL].green = 65535;
  global.style[2]->text[GTK_STATE_NORMAL].blue = 65535;

  global.style[3] = gtk_style_new();
  global.style[3]->font = gdk_font_load("-adobe-helvetica-bold-r-normal-*-*-120-*-*-p-*-iso8859-1");

  global.style[4] = gtk_style_new();
  global.style[3]->font = gdk_font_load("-adobe-helvetica-bold-r-normal-*-*-120-*-*-p-*-iso8859-1");

  temp = lookup_widget(global.win, "Console_text");
  gtk_widget_set_style(temp, global.style[2]);  

  sprintf(str, "%s/.lopster", getenv("HOME"));
  global.lopster_home = strdup(str);
  create_dir(str);
  sprintf(str, "%s/log", global.lopster_home);
  create_dir(str);
  sprintf(str, "%s/schemes", global.lopster_home);
  create_dir(str);
  sprintf(str, "%s/share", global.lopster_home);
  create_dir(str);

  time(&tim);
  global.session_start = strdup(ctime(&tim));
  global.session_start[strlen(global.session_start)-1] = 0;

  printf(_("Lopster started at %s\n"), global.session_start);

  temp = lookup_widget(global.win, "clist16");
  user = (user_t*)malloc(sizeof(user_t));
  user->shared = 0;
  user->bytes = 0; 
  user->files = NULL;      // unused
  gtk_object_set_data(GTK_OBJECT(temp), "userinfo", user);

  gdk_color_parse("#ffffff", &global.color_table[0]);  // W
  gdk_color_parse("#000000", &global.color_table[1]);  // Bl
  gdk_color_parse("#0000aa", &global.color_table[2]);  // b_
  gdk_color_parse("#00aa00", &global.color_table[3]);  // g_
  gdk_color_parse("#aa0000", &global.color_table[4]);  // r_
  gdk_color_parse("#aa5500", &global.color_table[5]);  // y_
  gdk_color_parse("#aa00aa", &global.color_table[6]);  // p_
  gdk_color_parse("#ff5555", &global.color_table[7]);  // R_
  gdk_color_parse("#ffff55", &global.color_table[8]);  // Y_
  gdk_color_parse("#55ff55", &global.color_table[9]);  // G
  gdk_color_parse("#00aaaa", &global.color_table[10]); // c
  gdk_color_parse("#55ffff", &global.color_table[11]); // C
  gdk_color_parse("#5555ff", &global.color_table[12]); // B_
  gdk_color_parse("#ff55ff", &global.color_table[13]); // P_
  gdk_color_parse("#555555", &global.color_table[14]); //dG
  gdk_color_parse("#aaaaaa", &global.color_table[15]); // w_

  global.current_page = chat_page_new("Console", P_FIX);
  chat_page_new("Channels", P_FIX);

  advance_progress(_("Reading geometry..."), 0.20);
  read_geometry();

  // setting up
  advance_progress(_("Reading link-file..."), 0.25);
  read_allowed_links();

  // setting up signal handlers
  advance_progress(_("Setting up signal handlers..."), 0.30);
  signal(SIGPIPE, sigpipe_handler);
  signal(SIGSEGV, sigseg_handler);
  signal(SIGCHLD, sigchld_handler);

  // setting up commands
  advance_progress(_("Setting up commands..."), 0.35);
  setup_commands();

  // setting up show/hide buttons
  advance_progress(_("Setting buttons..."), 0.40);
  setup_buttons();

  // creating pixmaps
  advance_progress(_("Creating pixmaps..."), 0.45);
  create_pixmaps();

  //
  advance_progress(_("Setting up mimetypes..."), 0.50);
  setup_mime();

  if (!global.allowed_ports) {
    global.allowed_ports_str = strdup("1025-9999");
    global.allowed_ports = 
      create_ports_from_string(global.allowed_ports_str);
  }

  // reading rc file
  advance_progress(_("Reading rc-file..."), 0.55);
  read_rc();
  
  // always insert the mp3 suffix
  advance_progress(_("Checking for mimetype mp3..."), 0.60);
  if (!check_suffix(".mp3", MIME_MP3)) {
    suffix_t* suffix;

    suffix = (suffix_t*)malloc(sizeof(suffix_t));
    suffix->suffix = strdup("mp3");
    suffix->application = strdup("");
    global.mimetype[MIME_MP3].suffixes =
      g_list_append(global.mimetype[MIME_MP3].suffixes, suffix);
  }
  
  // setting up some GtkWidgets
  advance_progress(_("Setting up widgets..."), 0.70);
  setup_widgets();

  // creating  listening port
  advance_progress(_("Creating dataport..."), 0.75);
  create_upload_port(global.network.port, TRUE);
  
  // loading resume list
  advance_progress(_("Loading incomplete files..."), 0.80);
  resume_list_load();

  // loading saved searches
  advance_progress(_("Loading search patterns..."), 0.85);
  search_pattern_load();
  
  update_user_stats();

  advance_progress(_("Adding startup idle and timer..."), 0.90);
  gtk_idle_add(idle_function, NULL);
  global.timer = gtk_timeout_add(1000, global_timer, NULL);

  // setting up shared files
  advance_progress(_("Starting shared list builder..."), 0.95);
  if (!global.auto_save || !lib_load(global.auto_save))
    lib_refresh();

}

void global_exit() {
  
  napster_disconnect(NULL);
  extra_win_get_geometry();

  if (global.timer >= 0)
    gtk_timeout_remove(global.timer);

  // destroying all sockets
  
  exec_kill_all();

  write_rc();

  write_geometry();

  write_allowed_links();

  // deleting commands
  command_delete_all();
  
  // and delete the global file list
  
  gtk_main_quit();
}


char* extract_short_name(char* longname) {
  char dir_sep;
  char* pos1;
  char* pos2;

  // extracting short name
  dir_sep = '/';   // ext file system

  pos1 = strchr(longname, dir_sep);
  pos2 = strrchr(longname, dir_sep);
  if (pos1 == pos2) {  // none or only one sep found
    return longname;
  } else {
    pos2[0] = 'Q';
    pos1 = strrchr(longname, dir_sep);
    pos2[0] = dir_sep;
    pos1++;
    return pos1;
  }
}

char* convert_to_win(char* name) {
  char* ptr;
   
  ptr = name;
  if (!ptr || !*ptr) return NULL;

  while(*ptr) {
    if (*ptr == '/') *ptr = '\\';
    ptr++;
  }

  return ptr;
}

char* convert_to_unix(char* name) {
  char* ptr;
   
  convert_file(name);
  ptr = name;
  if (!ptr || !*ptr) return NULL;

  while(*ptr) {
    if (*ptr == '\\') *ptr = '/';
    if (*ptr == '|') *ptr = '_';
    ptr++;
  }

  return ptr;
}

void destroy_file_row(gpointer data) {
  file_t* file;

  file = (file_t*)data;
  
  if (file->longname) free(file->longname);
  if (file->shortname) free(file->shortname);
  if (file->winname) free(file->winname);
  if (file->user) free(file->user);
  if (file->md5) free(file->md5);
  free(file);
}

gint
channel_compare (GtkCList      *clist,
		 gconstpointer  ptr1,
		 gconstpointer  ptr2) {

  char *text1 = NULL;
  char *text2 = NULL;
  int u1, u2;

  GtkCListRow *row1 = (GtkCListRow *) ptr1;
  GtkCListRow *row2 = (GtkCListRow *) ptr2;

  text1 = GTK_CELL_TEXT (row1->cell[clist->sort_column])->text;
  text2 = GTK_CELL_TEXT (row2->cell[clist->sort_column])->text;

  if (!text2)
    return (text1 != NULL);

  if (!text1)
    return -1;

  if ((clist->sort_column == 4) || (clist->sort_column == 0)) {
    return strcasecmp (text1, text2);
  } else if ((clist->sort_column == 1) || 
	     (clist->sort_column == 2) || 
	     (clist->sort_column == 3)) {
    sscanf(text1, "%d", &u1);
    sscanf(text2, "%d", &u2);
    if (u1 < u2) return -1;
    if (u1 > u2) return 1;
    return 0;
  } else {
    return 0;
  }
}

gint
client_compare (GtkCList      *clist,
		gconstpointer  ptr1,
		gconstpointer  ptr2) {

  char *text1 = NULL;
  char *text2 = NULL;
  int u1, u2;

  GtkCListRow *row1 = (GtkCListRow *) ptr1;
  GtkCListRow *row2 = (GtkCListRow *) ptr2;

  text1 = GTK_CELL_TEXT (row1->cell[clist->sort_column])->text;
  text2 = GTK_CELL_TEXT (row2->cell[clist->sort_column])->text;

  if (!text2)
    return (text1 != NULL);

  if (!text1)
    return -1;

  if (clist->sort_column == 1) {
    return strcasecmp (text1, text2);
  } else if (clist->sort_column == 0) {
    sscanf(text1, "%d", &u1);
    sscanf(text2, "%d", &u2);
    if (u1 < u2) return -1;
    if (u1 > u2) return 1;
    return 0;
  } else {
    return 0;
  }
}

void make_list_from_string(GList** glist, char* text, char* sep) {
  char* pos2;
  GList* dlist;

  for (dlist = *glist; dlist; dlist = dlist->next) {
    free(dlist->data);
  }
  if (*glist) g_list_free(*glist);
  *glist = NULL;

  pos2 = strtok(text, sep);
  while (pos2) {
    if (strlen(pos2) > 0) {
      *glist = g_list_append(*glist, strdup(pos2));
    }
    pos2 = strtok(NULL, sep);
  }
}

char* make_string_from_list(GList* glist, char* sep) {
  static char result[1024];
  char* text;
  GList* dlist;

  result[0] = 0;
  if (glist == NULL) {
    return result;
  }
  
  for (dlist = glist; dlist; dlist = dlist->next) {
    text = (char*)(dlist->data);
    if (strlen(result) > 0) strcat(result, sep);
    strcat(result, text);
  }
  
  return result;
}

void clones_clear() {
  GList* dlist;
  GList* dlist2;
  clone_t* clone;

  for (dlist = global.clones; dlist; dlist = dlist->next) {
    clone = (clone_t*)(dlist->data);
    for (dlist2 = clone->nicks; dlist2; dlist2 = dlist2->next) {
      free(dlist2->data);
    }
    g_list_free(clone->nicks);
    free(clone->ip);
    free(clone);
  }
  g_list_free(global.clones);
  global.clones = NULL;
}

client_t* is_client_in_list(GList* glist, char* t) {
  GList* dlist;
  client_t* client;

  dlist = g_list_first(glist);
  while (dlist) {
    client = (client_t*)(dlist->data);
    if (!strcmp(t, client->info) && (client->cnt > 0))
      return client;
    dlist = g_list_next(dlist);
  }
  return NULL;
}

char* is_string_in_list(GList* glist, char* t) {
  GList* dlist;
  char* text;

  dlist = g_list_first(glist);
  
  while (dlist) {
    text = (char*)(dlist->data);
    if (!strcasecmp(t, text)) {
      return text;
    }
    dlist = g_list_next(dlist);
  }
  return NULL;
}

char* is_prefix_in_list(GList* glist, char* t) {
  GList* dlist;
  char* text;

  dlist = g_list_first(glist);
  
  //  printf("user: %s\n", t);
  while (dlist) {
    text = (char*)(dlist->data);
    //    printf("%s\n", text);
    if (t == NULL) return text;
    if (!strncasecmp(t, text, strlen(t))) {
      return text;
    }
    dlist = g_list_next(dlist);
  }
  return NULL;
}

int cmp_str(char* s1, char* s2) {
  int i1, len;
  
  i1 = strlen(s1);
  len = strlen(s2);

  if (i1 < len) len = i1;

  for (i1 = 0; i1 < len; i1++) {
    if (toupper(s1[i1]) != toupper(s2[i1]))
      break;
  }
  return i1;
}

int calc_list_prefix(GList* glist) {
  int res;
  int i1;
  int temp;
  char* text;

  if (g_list_length(glist) < 1) return 0;
  
  text = g_list_nth(glist, 0)->data;
  res = strlen(text);

  for (i1 = 0; i1 < g_list_length(glist); i1++) {
    temp = cmp_str(g_list_nth(glist, i1)->data, text);
    if (temp < res) res = temp;
  }
  return res;
}

int calc_command_prefix(GList* glist) {
  int res;
  int i1;
  int temp;
  char* text;
  command_t* command;

  if (g_list_length(glist) < 1) return 0;
  
  command = g_list_nth(glist, 0)->data;
  text = command->name;
  res = strlen(text);

  for (i1 = 0; i1 < g_list_length(glist); i1++) {
    command = g_list_nth(glist, i1)->data;
    temp = cmp_str(command->name, text);
    if (temp < res) res = temp;
  }
  return res;
}

void play_file(char* filename) {
  char command[1024];
  suffix_t* suffix;
  struct stat st;

  if (stat(filename, &st) < 0) return;
  
  suffix = get_suffix(filename);
  if (!suffix) {
    client_message(_("Error"), _("Cannot open file: Unknown Suffix [%s]"),
		   filename);
    return;
  }
  if (!suffix->application) {
    client_message(_("Error"), _("Cannot open file: Unknown Suffix [%s]"),
		   suffix->suffix);
    return;
  }
  if (strlen(suffix->application) == 0) {
    client_message(_("Error"), _("Cannot open file: No application specified for suffix [%s]"),
		   suffix->suffix);
    return;
  }

  sprintf(command, "-quiet %s \"%s\"", suffix->application, filename);
  lopster_exec(command);
}

void play_file_old(char* filename) {
  char command[1024];
  int i;
  gchar *argv[4];
  gint pid;
  suffix_t* suffix;
  struct stat st;

  if (stat(filename, &st) < 0) return;
  
  suffix = get_suffix(filename);
  if (!suffix) {
    client_message(_("Error"), _("Cannot open file: Unknown Suffix [%s]"),
		   filename);
    return;
  }
  if (!suffix->application) {
    client_message(_("Error"), _("Cannot open file: Unknown Suffix [%s]"),
		   suffix->suffix);
    return;
  }
  if (strlen(suffix->application) == 0) {
    client_message(_("Error"), _("Cannot open file: No application specified for suffix [%s]"),
		   suffix->suffix);
    return;
  }

  sprintf(command, "%s \"%s\"", suffix->application, filename);
  
#ifdef GLOBAL_DEBUG
  printf("%s\n", command);
#endif
  pid = fork();
  if(pid == 0) {
    argv[0] = "sh";
    argv[1] = "-c";
    argv[2] = command;
    argv[3] = 0;
    for (i = 3; i < 256; i++) close(i);
    setsid();
    execve("/bin/sh", argv, environ);
    exit(-1);
  }
}

void set_last_server(server_t* server) {
  if (global.last_server) {
    server_destroy(global.last_server);
  }
  global.last_server = server_copy(server);;
}

void set_button_state(GtkWidget* button, int open) {
  GtkWidget* temp;
  
  if (open) {
    temp = GTK_WIDGET(gtk_object_get_data(GTK_OBJECT(button), "pix_open"));
    gtk_widget_hide(temp);
    temp = GTK_WIDGET(gtk_object_get_data(GTK_OBJECT(button), "pix_closed"));
    gtk_widget_show(temp);
    temp = GTK_WIDGET(gtk_object_get_data(GTK_OBJECT(button), "con_widget"));
    gtk_widget_show(temp);
  } else {
    temp = GTK_WIDGET(gtk_object_get_data(GTK_OBJECT(button), "pix_open"));
    gtk_widget_show(temp);
    temp = GTK_WIDGET(gtk_object_get_data(GTK_OBJECT(button), "pix_closed"));
    gtk_widget_hide(temp);
    temp = GTK_WIDGET(gtk_object_get_data(GTK_OBJECT(button), "con_widget"));
    gtk_widget_hide(temp);
  }
}

int toggle_button_state(GtkWidget* button) {
  GtkWidget* temp;
  
  temp = GTK_WIDGET(gtk_object_get_data(GTK_OBJECT(button), "con_widget"));

  if (GTK_WIDGET_VISIBLE(temp)) {
    set_button_state(button, 0);
    return 0;
  } else {
    set_button_state(button, 1);
    return 1;
  }
}

void set_up_button(GtkWidget* button, 
		   char* pix1, char* pix2, char *wid) {
  GtkObject* obj;
  GtkWidget* temp;

  obj = GTK_OBJECT(button);
  temp = lookup_widget(button, pix1);
  gtk_object_set_data(obj, "pix_open", temp);
  temp = lookup_widget(button, pix2);
  gtk_object_set_data(obj, "pix_closed", temp);
  temp = lookup_widget(button, wid);
  gtk_object_set_data(obj, "con_widget", temp);
}

void show_bans(char* channel) {
  GtkWidget* temp;
  char str[1024];
  char* data;

  if (global.ban_win) {
    temp = lookup_widget(global.ban_win, "clist3");
    gtk_clist_clear(GTK_CLIST(temp));
  } else {
    global.ban_win = create_ban_win();
    gtk_widget_show(global.ban_win);
  }

  data = gtk_object_get_user_data(GTK_OBJECT(global.ban_win));
  if (data) free(data);
  if (channel) {
    sprintf(str, _("Banned Users for Channel %s"), channel);
    send_command(CMD_CLIENT_CHANNEL_BAN_LIST, channel);
    gtk_object_set_user_data(GTK_OBJECT(global.ban_win), 
			     strdup(channel));
  } else {
    sprintf(str, _("Global banned Users"));
    send_command(CMD_CLIENT_BANLIST, "");
    gtk_object_set_user_data(GTK_OBJECT(global.ban_win), NULL);
    temp = lookup_widget(global.ban_win, "button186");
    if (global.user.level > L_USER) {
      gtk_widget_set_sensitive(temp, TRUE);
    } else {
      gtk_widget_set_sensitive(temp, FALSE);
    }
  }
  gtk_window_set_title(GTK_WINDOW(global.ban_win), str);
}

/////////////////////////////////////////////////////////////
// the code of the cparse() is almost copied from TekNap
/////////////////////////////////////////////////////////////
char* cparse(char *input) {
  int read;
  int write;
  int noappend = 1;
  static char output[2048];

  read = write = 0;

  while (input[read]) {
    if (input[read] == '%') {
      read++;
      switch (input[read]) {
      case 'k':
	output[write++] = '\003';
	output[write++] = '3';
	output[write++] = '0';
	break;
      case 'r':
	output[write++] = '\003';
	output[write++] = '3';
	output[write++] = '1';
	break;
      case 'g':
	output[write++] = '\003';
	output[write++] = '3';
	output[write++] = '2';
	break;
      case 'y':
	output[write++] = '\003';
	output[write++] = '3';
	output[write++] = '3';
	break;
      case 'b':
	output[write++] = '\003';
	output[write++] = '3';
	output[write++]   = '4';
	break;
      case 'm':
      case 'p':
	output[write++] = '\003';
	output[write++] = '3';
	output[write++]   = '5';
	break;
      case 'c':
	output[write++] = '\003';
	output[write++] = '3';
	output[write++]   = '6';
	break;
      case 'w':
	output[write++] = '\003';
	output[write++] = '3';
	output[write++]   = '7';
	break;
	
      case 'K':
	output[write++] = '\003';
	output[write++] = '5';
	output[write++]   = '0';
	break;
      case 'R':
	output[write++] = '\003';
	output[write++] = '5';
	output[write++]   = '1';
	break;
      case 'G':
	output[write++] = '\003';
	output[write++] = '5';
	output[write++]   = '2';
	break;
      case 'Y':
	output[write++] = '\003';
	output[write++] = '5';
	output[write++]   = '3';
	break;
      case 'B':
	output[write++] = '\003';
	output[write++] = '5';
	output[write++]   = '4';
	break;
      case 'M':
      case 'P':
	output[write++] = '\003';
	output[write++] = '5';
	output[write++]   = '5';
	break;
      case 'C':
	output[write++] = '\003';
	output[write++] = '5';
	output[write++]   = '6';
	break;
      case 'W':
	output[write++] = '\003';
	output[write++] = '5';
	output[write++]   = '7';
	break;
	
      case '0': case '1': case '2': case '3': 
      case '4': case '5': case '6': case '7':
	output[write++] = '\003';
	output[write++] = ',';
	output[write++] = '4';
	output[write++]   = input[read];
	break;
	
      case 'F':
	output[write++] = '\006';
	break;
      case 'n':
	output[write++] = '\003';
	output[write++] = '\017';
	break;
      case 'N':
	noappend = 1;
	break;
      case '%':
	output[write++] = input[read];
	break;
      default:
	output[write++] = '%';
	output[write++] = input[read];
	break;
      }
      read++;
    } else {
      output[write++] = input[read++];
    }
  }
  if (noappend == 0) {
    output[write++] = '\003';
    output[write++] = '-';
    output[write++] = '1';
  }
  output[write] = 0;

  return output;
}

void client_message(char* text, const char *fmt, ...) {
  va_list ap;
  char text2[1024];
  char* prefix;

  va_start (ap, fmt);
  vsprintf (text2, fmt, ap);
  va_end (ap);
  
  if (global.scheme) {
    prefix = cparse(global.scheme->client_prefix);
    chat_print("message", prefix);
  }
  if (text) {
    prefix = cparse("%W[");
    chat_print("message", prefix);
    chat_print("message", text);
    prefix = cparse("%W] ");
    chat_print("message", prefix);
  }
  chat_print_ln("message", text2);
}

void server_message(char* text, const char *fmt, ...) {
  va_list ap;
  char text2[1024];
  char* prefix;

  va_start (ap, fmt);
  vsprintf (text2, fmt, ap);
  va_end (ap);

  prefix = cparse(global.scheme->server_prefix);
  chat_print("error", prefix);
  if (text) {
    prefix = cparse("%W[");
    chat_print("error", prefix);
    chat_print("error", text);
    prefix = cparse("%W] ");
    chat_print("error", prefix);
  }
  chat_print_ln("error", text2);
}

void toggle_friend(char* user) {
  char *text;
  char t2[1024];
  GtkWidget* temp;

  if ((text=is_string_in_list(global.frienduser, user)) == NULL) {
    global.frienduser = g_list_append(global.frienduser, strdup(user));
    sprintf(t2, "is now a friend to %s", user);
  } else {
    global.frienduser = g_list_remove(global.frienduser, text);
    sprintf(t2, "is no longer a friend to %s", user);
  }
  if (global.options.send_ignore) send_emote(t2);
  update_user(user);

  temp = lookup_widget(global.win, "entry46");
  text = make_string_from_list(global.frienduser, " ");
  gtk_entry_set_text(GTK_ENTRY(temp), text);
  if (global.options_win) {
    temp = lookup_widget(global.options_win, "entry44");
    gtk_entry_set_text(GTK_ENTRY(temp), text);
  }
  temp = lookup_widget(global.win, "button123");
  gtk_widget_set_sensitive(temp, FALSE);
}

void toggle_enemy(char* user) {
  char *text;
  char t2[1024];
  GtkWidget* temp;

  if ((text=is_string_in_list(global.enemyuser, user)) == NULL) {
    global.enemyuser = g_list_append(global.enemyuser, strdup(user));
    sprintf(t2, "has a new enemy: %s", user);
  } else {
    global.enemyuser = g_list_remove(global.enemyuser, text);
    sprintf(t2, "is no longer an enemy to %s", user);
  }
  if (global.options.send_ignore) send_emote(t2);
  update_user(user);

  temp = lookup_widget(global.win, "entry51");
  text = make_string_from_list(global.enemyuser, " ");
  gtk_entry_set_text(GTK_ENTRY(temp), text);
  if (global.options_win) {
    temp = lookup_widget(global.options_win, "entry52");
    gtk_entry_set_text(GTK_ENTRY(temp), text);
  }
  temp = lookup_widget(global.win, "button124");
  gtk_widget_set_sensitive(temp, FALSE);
}

void opennap_notify() {
  client_message(_("Message"), _("Opennap commands are not allowed on this server"));
}

int opennap_version(int major, int minor) {
  if (!global.napster) return 1;
  if (SERVER->network != N_OPENNAP) return 0;
  
  return ((SERVER->major > major) ||
	  ((SERVER->major == major) &&
	   (SERVER->minor >= minor)));
}

char* arg(char* data, int last) {
  static char* string;
  char* pos;
  char* pos2;

  if (data) string = data;
  if (!string) return NULL;
  
  if (!last) while (isspace(*string)) string++;

  if (last) {
    pos = string;
    string = NULL;
    if (*pos == 0) return NULL;
    else return pos;
  }
  if (*string == '\"') {
    pos = ++string;
    pos2 = strchr(string, '\"');
    if (pos2) {
      *pos2 = 0;
      string = pos2+1;
      if (*string == ' ') string++;
      return pos;
    } else {
      string = NULL;
      return NULL;
    }
  } else {
    pos = string;
    pos2 = strchr(string, ' ');
    if (pos2) {
      *pos2 = 0;
      string = pos2+1;
    } else {
      string = NULL;
    }
    if (*pos == 0) return NULL;
    else return pos;
  }

  return NULL;
}

void convert_chars(char* text, char from, char to) {
  char* pos;

  while ((pos = strchr(text, from)) != NULL) pos[0] = to;
}

GtkWidget* create_customize_win(GtkCList* clist) {
  GtkWidget *customize_win;
  GtkWidget *frame138;
  GtkWidget *vbox84;
  GtkWidget *vbox85;
  GtkWidget *checkbutton;
  GtkWidget *hseparator19;
  GtkWidget *frame139;
  GtkWidget *hbox213;
  GtkWidget *button151;
  GtkWidget *button152;
  int i1;
  char wname[1024];
  GtkWidget* title;

  customize_win = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_object_set_data (GTK_OBJECT (customize_win), "customize_win", customize_win);
  gtk_window_set_title (GTK_WINDOW (customize_win), _("Customize List"));
  gtk_window_set_modal (GTK_WINDOW (customize_win), TRUE);
  gtk_window_set_policy (GTK_WINDOW (customize_win), FALSE, TRUE, TRUE);

  frame138 = gtk_frame_new (NULL);
  gtk_widget_ref (frame138);
  gtk_object_set_data_full (GTK_OBJECT (customize_win), "frame138", frame138,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (frame138);
  gtk_container_add (GTK_CONTAINER (customize_win), frame138);
  gtk_container_set_border_width (GTK_CONTAINER (frame138), 5);

  vbox84 = gtk_vbox_new (FALSE, 5);
  gtk_widget_ref (vbox84);
  gtk_object_set_data_full (GTK_OBJECT (customize_win), "vbox84", vbox84,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox84);
  gtk_container_add (GTK_CONTAINER (frame138), vbox84);
  gtk_container_set_border_width (GTK_CONTAINER (vbox84), 5);

  vbox85 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox85);
  gtk_object_set_data_full (GTK_OBJECT (customize_win), "vbox85", vbox85,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox85);
  gtk_box_pack_start (GTK_BOX (vbox84), vbox85, TRUE, TRUE, 0);

  for (i1 = 0; i1 < clist->columns; i1++) {
    title = gtk_clist_get_column_widget(clist, i1);
    sprintf(wname, _("Show column \"%s\""), GTK_LABEL(title)->label);
    checkbutton = gtk_check_button_new_with_label(wname);
    gtk_widget_ref (checkbutton);
    sprintf(wname, "check%d", i1);
    gtk_object_set_data_full (GTK_OBJECT (customize_win), wname, checkbutton,
			      (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (checkbutton);
    gtk_box_pack_start (GTK_BOX (vbox85), checkbutton, FALSE, FALSE, 0);
    if (clist->column[i1].visible)
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkbutton), TRUE);
    else
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkbutton), FALSE);
  }

  hseparator19 = gtk_hseparator_new ();
  gtk_widget_ref (hseparator19);
  gtk_object_set_data_full (GTK_OBJECT (customize_win), "hseparator19", hseparator19,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hseparator19);
  gtk_box_pack_start (GTK_BOX (vbox84), hseparator19, FALSE, FALSE, 0);

  frame139 = gtk_frame_new (NULL);
  gtk_widget_ref (frame139);
  gtk_object_set_data_full (GTK_OBJECT (customize_win), "frame139", frame139,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (frame139);
  gtk_box_pack_start (GTK_BOX (vbox84), frame139, FALSE, FALSE, 0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame139), GTK_SHADOW_IN);

  hbox213 = gtk_hbox_new (TRUE, 5);
  gtk_widget_ref (hbox213);
  gtk_object_set_data_full (GTK_OBJECT (customize_win), "hbox213", hbox213,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox213);
  gtk_container_add (GTK_CONTAINER (frame139), hbox213);
  gtk_widget_set_usize (hbox213, -2, 37);
  gtk_container_set_border_width (GTK_CONTAINER (hbox213), 5);

  button151 = gtk_button_new_with_label (_("Apply"));
  gtk_widget_ref (button151);
  gtk_object_set_data_full (GTK_OBJECT (customize_win), "button151", button151,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button151);
  gtk_box_pack_start (GTK_BOX (hbox213), button151, TRUE, TRUE, 0);

  button152 = gtk_button_new_with_label (_("Close"));
  gtk_widget_ref (button152);
  gtk_object_set_data_full (GTK_OBJECT (customize_win), "button152", button152,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button152);
  gtk_box_pack_start (GTK_BOX (hbox213), button152, TRUE, TRUE, 0);

  gtk_signal_connect (GTK_OBJECT (customize_win), "destroy",
                      GTK_SIGNAL_FUNC (on_customize_win_destroy),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (button151), "clicked",
                      GTK_SIGNAL_FUNC (on_button1x_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (button152), "clicked",
                      GTK_SIGNAL_FUNC (on_button2x_clicked),
                      NULL);
  gtk_object_set_data(GTK_OBJECT(customize_win), "ref_clist", clist);
  
  return customize_win;
}

void show_clients() {
  GtkWidget* temp;

  if (!global.client_win) {
    global.client_win = create_client_win();
    temp = lookup_widget(global.client_win, "clist8");
    gtk_clist_set_sort_column(GTK_CLIST(temp), 0);
    gtk_clist_set_auto_sort(GTK_CLIST(temp), TRUE);
    gtk_clist_set_compare_func(GTK_CLIST(temp), client_compare);

    cmd_version_stats("");
  }
  gtk_widget_show(global.client_win);

  if (!global.client_list) on_button149_clicked(NULL, NULL);
}

gint
user2_compare (GtkCList      *clist,
	       gconstpointer  ptr1,
	       gconstpointer  ptr2) {

  char *text1 = NULL;
  char *text2 = NULL;
  unsigned long l1, l2;
  GdkColor color = { 0, 0xff00, 0xbf00, 0xbf00 };

  GtkCListRow *row1 = (GtkCListRow *) ptr1;
  GtkCListRow *row2 = (GtkCListRow *) ptr2;

  text1 = GTK_CELL_TEXT (row1->cell[clist->sort_column])->text;
  text2 = GTK_CELL_TEXT (row2->cell[clist->sort_column])->text;

  if (!text2)
    return (text1 != NULL);

  if (!text1)
    return -1;

  if (clist->sort_column == 0) {
    return strcasecmp (text1, text2);
  } else if (clist->sort_column == 1) {
    l1 = inet_network(text1);
    l2 = inet_network(text2);
    if (l1 < l2) return -1;
    else if (l1 > l2) return 1;
    else {
      row1->background = color;
      row1->bg_set = TRUE;
      if (GTK_WIDGET_REALIZED (clist))
        gdk_color_alloc (gtk_widget_get_colormap (GTK_WIDGET (clist)),
                         &row1->background);
      row2->background = color;
      row2->bg_set = TRUE;
      if (GTK_WIDGET_REALIZED (clist))
        gdk_color_alloc (gtk_widget_get_colormap (GTK_WIDGET (clist)),
                         &row2->background);
      
      return 0;
    }
  }
  return 0;
}

void show_global_users(char* args, int clear) {
  GtkWidget* temp;

  if (global.user_win) {
    temp = lookup_widget(global.user_win, "clist12");
  } else {
    global.user_win = create_user_win();
    on_entry74_changed(NULL, NULL);
    temp = lookup_widget(global.user_win, "clist12");
    gtk_clist_set_compare_func(GTK_CLIST(temp), 
			       (GtkCListCompareFunc)user2_compare);
  }
  if (clear) {
    clones_clear();
    gtk_clist_clear(GTK_CLIST(temp));
  }
  gtk_widget_show(global.user_win);

  if (args) {
    send_command(CMD_CLIENT_GLOBAL_USER_LIST, args);
    temp = lookup_widget(global.user_win, "button164");
    gtk_widget_set_sensitive(temp, FALSE);
  }
}

void convert_file(char* name) {
  char* pos;
  char* pos2;
  
  if (strncmp(name, "|||", 3)) return;
  
  pos2 = name;
  pos = strrchr(name, '.');
  if (!pos) return;
  while (pos2+3 < pos) {
    pos2[0] = pos2[3];
    pos2++;
  }
  pos2[0] = 0;
  pos2 = strrchr(name, '|');
  if (!pos2) return;
  pos2[0] = '.';

  return;
}

void detect_speed_pixs(int speed,
		       GdkPixmap** pixmap, GdkBitmap** bitmap) {
  if (speed > 10 || speed < 1) {
    *pixmap = global.pix.sgray;
    *bitmap = global.pix.sgrayb;
  } else if (speed <= 3) {
    *pixmap = global.pix.sred;
    *bitmap = global.pix.sredb;
  } else if (speed <= 6) {
    *pixmap = global.pix.syellow;
    *bitmap = global.pix.syellowb;
  } else if (speed <= 10) {
    *pixmap = global.pix.sgreen;
    *bitmap = global.pix.sgreenb;
  } else {
    *pixmap = global.pix.sgray;
    *bitmap = global.pix.sgrayb;
  }
}

file_t* file_dup(file_t* file) {
  file_t* dest;

  dest = (file_t*)malloc(sizeof(file_t));
  if (file->longname) dest->longname = strdup(file->longname);
  if (file->winname) dest->winname = strdup(file->winname);
  if (file->shortname) dest->shortname = strdup(file->shortname);
  if (file->user) dest->user = strdup(file->user);
  if (file->md5) dest->md5 = strdup(file->md5);
  dest->size = file->size;
  dest->ip = file->ip;
  dest->bitrate = file->bitrate;
  dest->frequency = file->frequency;
  dest->duration = file->duration;
  dest->linespeed = file->linespeed;
  dest->flags = file->flags;
  dest->status = file->status;
  dest->local = file->local;
  dest->mime_type = file->mime_type;

  return dest;
}

int get_mimetype(char* name) {
  GList* dlist;
  char* suf;
  suffix_t* suffix;
  int i1;

  suf = strrchr(name, '.');
  if (!suf) return 0;
  else suf++;
  
  for (i1 = 1; i1 < MIME_SIZE; i1++) {
    for (dlist = global.mimetype[i1].suffixes; dlist; dlist=dlist->next) {
      suffix = (suffix_t*)(dlist->data);
      if (!strcasecmp(suf, suffix->suffix)) return i1;
    }
  }
  return 0;
}

suffix_t* get_suffix(char* name) {
  GList* dlist;
  char* suf;
  suffix_t* suffix;
  int i1;
  
  suf = strrchr(name, '.');
  if (!suf) return NULL;
  else suf++;
  
  for (i1 = 1; i1 < MIME_SIZE; i1++) {
    for (dlist = global.mimetype[i1].suffixes; dlist; dlist=dlist->next) {
      suffix = (suffix_t*)(dlist->data);
      if (!strcasecmp(suf, suffix->suffix)) return suffix;
    }
  }
  return NULL;
}
 
void
on_safe_exit_cancel (GtkMenuItem     *menuitem,
		     gpointer         user_data) {
  global.status.exiting = E_NONE;
}

GtkWidget* create_mode_popup (void) {
  GtkWidget *mode_popup;
  GtkWidget *separator;
  GtkAccelGroup *mode_popup_accels;
  GtkWidget *mode;
  
  mode_popup = gtk_menu_new ();
  gtk_object_set_data (GTK_OBJECT (mode_popup), "mode_popup", mode_popup);
  mode_popup_accels = gtk_menu_ensure_uline_accel_group (GTK_MENU (mode_popup));

  if (global.status.connection < 2) {
    mode = gtk_menu_item_new_with_label (_("Not connected"));
    gtk_widget_show (mode);
    gtk_container_add (GTK_CONTAINER (mode_popup), mode);
    gtk_widget_set_sensitive(mode, FALSE);
    return mode_popup;
  } else if (!opennap_version(0, 0)) {
    mode = gtk_menu_item_new_with_label (_("Opennap only"));
    gtk_widget_ref (mode);
    gtk_widget_show (mode);
    gtk_container_add (GTK_CONTAINER (mode_popup), mode);
    gtk_widget_set_sensitive(mode, FALSE);
    return mode_popup;
  }

  if (global.status.exiting == E_SAFE) {
    mode = gtk_menu_item_new_with_label (_("Cancel safe exit"));
    gtk_widget_show (mode);
    gtk_container_add (GTK_CONTAINER (mode_popup), mode);
    gtk_signal_connect (GTK_OBJECT (mode), "activate",
			GTK_SIGNAL_FUNC (on_safe_exit_cancel),
			NULL);
    separator = gtk_menu_item_new ();
    gtk_widget_show (separator);
    gtk_container_add (GTK_CONTAINER (mode_popup), separator);
    gtk_widget_set_sensitive (separator, FALSE);
  }

  mode = gtk_check_menu_item_new_with_label (_("Show server error messages"));
  gtk_widget_show (mode);
  gtk_container_add (GTK_CONTAINER (mode_popup), mode);
  if (is_string_in_list(global.usermode, "ERROR"))
    gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (mode), TRUE);
  gtk_signal_connect (GTK_OBJECT (mode), "activate",
                      GTK_SIGNAL_FUNC (on_mode_activate),
                      (void*)0);

  mode = gtk_check_menu_item_new_with_label (_("Show bans messages"));
  gtk_widget_ref (mode);
  gtk_widget_show (mode);
  gtk_container_add (GTK_CONTAINER (mode_popup), mode);
  if (is_string_in_list(global.usermode, "BAN"))
    gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (mode), TRUE);
  gtk_signal_connect (GTK_OBJECT (mode), "activate",
                      GTK_SIGNAL_FUNC (on_mode_activate),
                      (void*)1);

  mode = gtk_check_menu_item_new_with_label (_("Show configuration changed"));
  gtk_widget_ref (mode);
  gtk_widget_show (mode);
  gtk_container_add (GTK_CONTAINER (mode_popup), mode);
  if (is_string_in_list(global.usermode, "CHANGE"))
    gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (mode), TRUE);
  gtk_signal_connect (GTK_OBJECT (mode), "activate",
                      GTK_SIGNAL_FUNC (on_mode_activate),
                      (void*)2);

  mode = gtk_check_menu_item_new_with_label (_("Show kill messages"));
  gtk_widget_ref (mode);
  gtk_widget_show (mode);
  gtk_container_add (GTK_CONTAINER (mode_popup), mode);
  if (is_string_in_list(global.usermode, "KILL"))
    gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (mode), TRUE);
  gtk_signal_connect (GTK_OBJECT (mode), "activate",
                      GTK_SIGNAL_FUNC (on_mode_activate),
                      (void*)3);

  mode = gtk_check_menu_item_new_with_label (_("Show level changes"));
  gtk_widget_ref (mode);
  gtk_widget_show (mode);
  gtk_container_add (GTK_CONTAINER (mode_popup), mode);
  if (is_string_in_list(global.usermode, "LEVEL"))
    gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (mode), TRUE);
  gtk_signal_connect (GTK_OBJECT (mode), "activate",
                      GTK_SIGNAL_FUNC (on_mode_activate),
                      (void*)4);

  mode = gtk_check_menu_item_new_with_label (_("Show server messages"));
  gtk_widget_ref (mode);
  gtk_widget_show (mode);
  gtk_container_add (GTK_CONTAINER (mode_popup), mode);
  if (is_string_in_list(global.usermode, "SERVER"))
    gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (mode), TRUE);
  gtk_signal_connect (GTK_OBJECT (mode), "activate",
                      GTK_SIGNAL_FUNC (on_mode_activate),
                      (void*)5);

  mode = gtk_check_menu_item_new_with_label (_("Show muzzle messages"));
  gtk_widget_ref (mode);
  gtk_widget_show (mode);
  gtk_container_add (GTK_CONTAINER (mode_popup), mode);
  if (is_string_in_list(global.usermode, "MUZZLE"))
    gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (mode), TRUE);
  gtk_signal_connect (GTK_OBJECT (mode), "activate",
                      GTK_SIGNAL_FUNC (on_mode_activate),
                      (void*)6);

  mode = gtk_check_menu_item_new_with_label (_("Show dataport changes"));
  gtk_widget_ref (mode);
  gtk_widget_show (mode);
  gtk_container_add (GTK_CONTAINER (mode_popup), mode);
  if (is_string_in_list(global.usermode, "PORT"))
    gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (mode), TRUE);
  gtk_signal_connect (GTK_OBJECT (mode), "activate",
                      GTK_SIGNAL_FUNC (on_mode_activate),
                      (void*)7);

  mode = gtk_check_menu_item_new_with_label (_("Show wallops"));
  gtk_widget_ref (mode);
  gtk_widget_show (mode);
  gtk_container_add (GTK_CONTAINER (mode_popup), mode);
  if (is_string_in_list(global.usermode, "WALLOP"))
    gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (mode), TRUE);
  gtk_signal_connect (GTK_OBJECT (mode), "activate",
                      GTK_SIGNAL_FUNC (on_mode_activate),
                      (void*)8);

  mode = gtk_check_menu_item_new_with_label (_("Show cloaks"));
  gtk_widget_ref (mode);
  gtk_widget_show (mode);
  gtk_container_add (GTK_CONTAINER (mode_popup), mode);
  if (is_string_in_list(global.usermode, "CLOAK"))
    gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (mode), TRUE);
  gtk_signal_connect (GTK_OBJECT (mode), "activate",
                      GTK_SIGNAL_FUNC (on_mode_activate),
                      (void*)9);

  mode = gtk_check_menu_item_new_with_label (_("Show floods"));
  gtk_widget_ref (mode);
  gtk_widget_show (mode);
  gtk_container_add (GTK_CONTAINER (mode_popup), mode);
  if (is_string_in_list(global.usermode, "FLOOD"))
    gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (mode), TRUE);
  gtk_signal_connect (GTK_OBJECT (mode), "activate",
                      GTK_SIGNAL_FUNC (on_mode_activate),
                      (void*)10);

  mode = gtk_check_menu_item_new_with_label (_("Show pings"));
  gtk_widget_ref (mode);
  gtk_widget_show (mode);
  gtk_container_add (GTK_CONTAINER (mode_popup), mode);
  if (is_string_in_list(global.usermode, "PING"))
    gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (mode), TRUE);
  gtk_signal_connect (GTK_OBJECT (mode), "activate",
                      GTK_SIGNAL_FUNC (on_mode_activate),
                      (void*)11);

  if (opennap_version(0,38)) {
    mode = gtk_check_menu_item_new_with_label (_("Allow private message"));
    gtk_widget_ref (mode);
    gtk_widget_show (mode);
    gtk_container_add (GTK_CONTAINER (mode_popup), mode);
    if (is_string_in_list(global.usermode, "MSG"))
      gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (mode), TRUE);
    gtk_signal_connect (GTK_OBJECT (mode), "activate",
			GTK_SIGNAL_FUNC (on_mode_activate),
			(void*)12);
    
    mode = gtk_check_menu_item_new_with_label (_("Show whois requests"));
    gtk_widget_ref (mode);
    gtk_widget_show (mode);
    gtk_container_add (GTK_CONTAINER (mode_popup), mode);
    if (is_string_in_list(global.usermode, "WHOIS"))
      gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (mode), TRUE);
    gtk_signal_connect (GTK_OBJECT (mode), "activate",
			GTK_SIGNAL_FUNC (on_mode_activate),
			(void*)13);
  }

  return mode_popup;
}

GtkWidget* create_user_popup(int mode) {
  GtkWidget *popup;
  GtkWidget *popup2;
  GtkAccelGroup *popup_accels;
  GtkWidget *item;
  GtkWidget *item2;
  GtkWidget *separator;
  char* user;
  
  user = get_popup_user(mode);

  popup = gtk_menu_new ();
  gtk_object_set_data (GTK_OBJECT (popup), "popup", popup);
  popup_accels = gtk_menu_ensure_uline_accel_group (GTK_MENU (popup));

  if (mode == M_TEXT) {
    item = gtk_menu_item_new_with_label (user);
    gtk_widget_ref (item);
    gtk_widget_show (item);
    gtk_container_add (GTK_CONTAINER (popup), item);
    
    separator = gtk_menu_item_new ();
    gtk_widget_ref (separator);
    gtk_widget_show (separator);
    gtk_container_add (GTK_CONTAINER (popup), separator);
    gtk_widget_set_sensitive (separator, FALSE);
    separator = gtk_menu_item_new ();
    gtk_widget_ref (separator);
    gtk_widget_show (separator);
    gtk_container_add (GTK_CONTAINER (popup), separator);
    gtk_widget_set_sensitive (separator, FALSE);
  }
  item = gtk_menu_item_new_with_label (_("Private Mode"));
  gtk_widget_ref (item);
  gtk_widget_show (item);
  gtk_container_add (GTK_CONTAINER (popup), item);
  gtk_signal_connect (GTK_OBJECT (item), "activate",
                      GTK_SIGNAL_FUNC (on_private_mode_activate),
                      (gpointer)mode);
  
  separator = gtk_menu_item_new ();
  gtk_widget_ref (separator);
  gtk_widget_show (separator);
  gtk_container_add (GTK_CONTAINER (popup), separator);
  gtk_widget_set_sensitive (separator, FALSE);
    
  if (mode == M_WHOIS)
    item = gtk_menu_item_new_with_label (_("Refresh Whois"));
  else
    item = gtk_menu_item_new_with_label (_("Whois User"));
  gtk_widget_ref (item);
  gtk_widget_show (item);
  gtk_container_add (GTK_CONTAINER (popup), item);
  gtk_signal_connect (GTK_OBJECT (item), "activate",
                      GTK_SIGNAL_FUNC (on_whois_user_activate),
                      (gpointer)mode);
  if (mode != M_HOTLIST) {
    item = gtk_menu_item_new_with_label (_("Add to Hotlist"));
    gtk_widget_ref (item);
    gtk_widget_show (item);
    gtk_container_add (GTK_CONTAINER (popup), item);
    gtk_signal_connect (GTK_OBJECT (item), "activate",
			GTK_SIGNAL_FUNC (on_add_to_hotlist_activate),
			(gpointer)mode);
    item = gtk_menu_item_new_with_label (_("Browse Files"));
    gtk_widget_ref (item);
    gtk_widget_show (item);
    gtk_container_add (GTK_CONTAINER (popup), item);
    gtk_signal_connect (GTK_OBJECT (item), "activate",
			GTK_SIGNAL_FUNC (on_browse_files_activate),
			(gpointer)mode);
  }
  item = gtk_menu_item_new_with_label (_("Locate User"));
  gtk_widget_ref (item);
  gtk_widget_show (item);
  gtk_container_add (GTK_CONTAINER (popup), item);
  gtk_signal_connect (GTK_OBJECT (item), "activate",
		      GTK_SIGNAL_FUNC (on_locate_activate),
		      (gpointer)mode);

  separator = gtk_menu_item_new ();
  gtk_widget_ref (separator);
  gtk_widget_show (separator);
  gtk_container_add (GTK_CONTAINER (popup), separator);
  gtk_widget_set_sensitive (separator, FALSE);
    
  item = gtk_menu_item_new_with_label (_("Status"));
  gtk_widget_ref (item);
  gtk_widget_show (item);
  gtk_container_add (GTK_CONTAINER (popup), item);

  popup2 = gtk_menu_new();
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (item), popup2);
  item2 = gtk_check_menu_item_new_with_label (_("Friend"));
  gtk_widget_ref (item2);
  gtk_widget_show (item2);
  gtk_container_add (GTK_CONTAINER (popup2), item2);
  if (is_string_in_list(global.frienduser, user)) {
    gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (item2),
				    TRUE);
  }
  gtk_signal_connect (GTK_OBJECT (item2), "activate",
		      GTK_SIGNAL_FUNC (on_friend_activate),
		      (gpointer)mode);
  item2 = gtk_check_menu_item_new_with_label (_("Enemy"));
  gtk_widget_ref (item2);
  gtk_widget_show (item2);
  gtk_container_add (GTK_CONTAINER (popup2), item2);
  if (is_string_in_list(global.enemyuser, user)) {
    gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (item2),
				    TRUE);
  }
  gtk_signal_connect (GTK_OBJECT (item2), "activate",
		      GTK_SIGNAL_FUNC (on_enemy_activate),
		      (gpointer)mode);
  item2 = gtk_check_menu_item_new_with_label (_("Ignored"));
  gtk_widget_ref (item2);
  gtk_widget_show (item2);
  gtk_container_add (GTK_CONTAINER (popup2), item2);
  if (is_string_in_list(global.ignored_users, user)) {
    gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (item2),
				    TRUE);
  }
  gtk_signal_connect (GTK_OBJECT (item2), "activate",
		      GTK_SIGNAL_FUNC (on_ignore_activate),
		      (gpointer)mode);
  
  if (((mode == M_ONLINE) || (mode == M_TEXT)) && 
      ((global.user.level > L_USER) || 
       is_string_in_list(global.opchannel, global.current_page->name))) {
    separator = gtk_menu_item_new ();
    gtk_widget_ref (separator);
    gtk_widget_show (separator);
    gtk_container_add (GTK_CONTAINER (popup), separator);
    gtk_widget_set_sensitive (separator, FALSE);
  
    if (opennap_version(0, 0)) {
      item = gtk_menu_item_new_with_label (_("Muzzle in channel"));
      gtk_widget_ref (item);
      gtk_widget_show (item);
      gtk_container_add (GTK_CONTAINER (popup), item);
      gtk_signal_connect (GTK_OBJECT (item), "activate",
			  GTK_SIGNAL_FUNC (on_chmuzzle_activate),
			  (gpointer)mode);
    }
    item = gtk_menu_item_new_with_label (_("Kick from channel"));
    gtk_widget_ref (item);
    gtk_widget_show (item);
    gtk_container_add (GTK_CONTAINER (popup), item);
    gtk_signal_connect (GTK_OBJECT (item), "activate",
			GTK_SIGNAL_FUNC (on_kick_activate),
			(gpointer)mode);
    item = gtk_menu_item_new_with_label (_("Ban from channel"));
    gtk_widget_ref (item);
    gtk_widget_show (item);
    gtk_container_add (GTK_CONTAINER (popup), item);
    gtk_signal_connect (GTK_OBJECT (item), "activate",
			GTK_SIGNAL_FUNC (on_chban_activate),
			(gpointer)mode);
  }

  if (global.user.level > L_USER) {
    separator = gtk_menu_item_new ();
    gtk_widget_ref (separator);
    gtk_widget_show (separator);
    gtk_container_add (GTK_CONTAINER (popup), separator);
    gtk_widget_set_sensitive (separator, FALSE);
    
    item = gtk_menu_item_new_with_label (_("Muzzle User"));
    gtk_widget_ref (item);
    gtk_widget_show (item);
    gtk_container_add (GTK_CONTAINER (popup), item);
    gtk_signal_connect (GTK_OBJECT (item), "activate",
			GTK_SIGNAL_FUNC (on_muzzle_activate),
			(gpointer)mode);
    item = gtk_menu_item_new_with_label (_("Kill User"));
    gtk_widget_ref (item);
    gtk_widget_show (item);
    gtk_container_add (GTK_CONTAINER (popup), item);
    gtk_signal_connect (GTK_OBJECT (item), "activate",
			GTK_SIGNAL_FUNC (on_kill_activate),
			(gpointer)mode);
    item = gtk_menu_item_new_with_label (_("Ban User"));
    gtk_widget_ref (item);
    gtk_widget_show (item);
    gtk_container_add (GTK_CONTAINER (popup), item);
    gtk_signal_connect (GTK_OBJECT (item), "activate",
			GTK_SIGNAL_FUNC (on_ban_activate),
			(gpointer)mode);
    item = gtk_menu_item_new_with_label (_("Nuke User"));
    gtk_widget_ref (item);
    gtk_widget_show (item);
    gtk_container_add (GTK_CONTAINER (popup), item);
    gtk_signal_connect (GTK_OBJECT (item), "activate",
			GTK_SIGNAL_FUNC (on_nuke_activate),
			(gpointer)mode);
  }

  return popup;
}

int cnt_pot(long num) {
  int cnt = 0;

  while ((1<<cnt) < num) cnt++;
  
  return cnt;
}

int calc_x(long val, long max, int width) {
  if (val > max) return width;
  else return (int)(((double)val/(double)max)*(double)width);
}

void print_speed(char* str, long bytes, int withdot) {
  if (withdot) {
    if (bytes < 1024) sprintf(str, "%ld B/s", bytes);
    else if (bytes < 1024*128)
      sprintf(str, "%.2f KB/s", (double)bytes/1024.0);
    else if (bytes < 1024*1024)
      sprintf(str, "%.1f KB/s", (double)bytes/1024.0);
    else
      sprintf(str, "%.1f MB/s", (double)bytes/1024.0/1024.0);
  } else {
    if (bytes < 1024) sprintf(str, "%ld B/s", bytes);
    else if (bytes < 1024*8)
      sprintf(str, "%.1f KB/s", (double)bytes/1024.0);
    else if (bytes < 1024*1024)
      sprintf(str, "%ld KB/s", bytes/1024);
    else if (bytes < 1024*1024*8)
      sprintf(str, "%.1f MB/s", (double)bytes/1024.0/1024.0);
    else
      sprintf(str, "%ld MB/s", bytes/1024/1024);
  }
}

void draw_band_width(bandwidth_t* bandwidth, int full) {
  char str[1024];
  int height;
  int width;
  GtkWidget* area = bandwidth->area;
  long x1, x2;
  int i1;
  int overrun;

  if (full) {
    print_speed(str, bandwidth->limit, 1);
    gtk_label_set_text(GTK_LABEL(bandwidth->label_max), str);
  }
  print_speed(str, bandwidth->current, 1);
  gtk_label_set_text(GTK_LABEL(bandwidth->label_cur), str);
  
  width = bandwidth->area->allocation.width;
  height = bandwidth->area->allocation.height;
  
  if (!area->window) return;
  
  if (full) {
    // background
    gtk_paint_box(area->style, area->window,
		  GTK_STATE_NORMAL, GTK_SHADOW_OUT,
		  NULL, area, "frame",
		  0, 0, width, height);

    x2 = cnt_pot(bandwidth->maxval)-3;
    x1 = 1<<x2;
    for (i1 = 0; i1 < 9; i1++) {
      x2 = calc_x(x1*i1, bandwidth->maxval, width-11-2*area->style->klass->xthickness)+
	5+area->style->klass->xthickness;
      if (i1 < 8) {
	print_speed(str, x1*i1, 0);
	gtk_paint_string(area->style, area->window,
			 GTK_STATE_NORMAL,
			 NULL, area, "label",
			 x2+5, 12, str);
      }
      gdk_draw_line(area->window,
		    area->style->fg_gc[GTK_STATE_NORMAL],
		    x2, 0, x2, height);
    }
    gtk_paint_box(area->style, area->window,
		  GTK_STATE_NORMAL, GTK_SHADOW_IN,
		  NULL, area, "trough",
		  5, 15, width-10, height-20);
  }

  // bar
  x1 = calc_x(bandwidth->current, bandwidth->maxval, 
	      width-10-2*area->style->klass->xthickness);
  if (bandwidth->current > bandwidth->maxval) {
    overrun = 1;
    x1 -= 10;
  } else overrun = 0;

  if (x1 > 0) {
    gtk_paint_box(area->style, area->window,
		  GTK_STATE_PRELIGHT, GTK_SHADOW_OUT,
		  NULL, area, "bar",
		  5+area->style->klass->xthickness,
		  15+area->style->klass->ythickness,
		  x1,
		  height-20-2*area->style->klass->ythickness);
  }

  gtk_paint_flat_box(area->style, area->window,
		     GTK_STATE_NORMAL, GTK_SHADOW_NONE,
		     NULL, area, "entry_bg",
		     5+area->style->klass->xthickness+x1,
		     15+area->style->klass->ythickness,
		     width-10-x1-2*area->style->klass->xthickness,
		     height-20-2*area->style->klass->ythickness);

  if (overrun) {
    gtk_paint_arrow(area->style, area->window,
		    GTK_STATE_PRELIGHT, GTK_SHADOW_OUT,
		    NULL, area, "hscrollbar", GTK_ARROW_RIGHT, TRUE,
		    5+area->style->klass->xthickness+x1,
		    15+area->style->klass->ythickness,
		    width-10-x1-2*area->style->klass->xthickness,
		    height-20-2*area->style->klass->ythickness);
  }

  x1 = calc_x(bandwidth->limit, bandwidth->maxval, 
	      width-11-2*area->style->klass->xthickness)+
    5+area->style->klass->xthickness;

  if (bandwidth->limit <= bandwidth->maxval) {
    gtk_paint_arrow(area->style, area->window,
		    GTK_STATE_NORMAL, GTK_SHADOW_OUT,
		    NULL, area, "vscrollbar", GTK_ARROW_UP, TRUE,
		    x1-6,
		    15+area->style->klass->ythickness,
		    12,
		    height-15-2*area->style->klass->ythickness);
  }
}

void extra_win_get_geometry() {
  int i1;
  GtkWidget* win;
  char str[1024];

  for (i1 = 0; i1 < 7; i1++) {
    if (global.extra_win & (1<<i1)) {
      sprintf(str, "extra%d", i1);
      win = gtk_object_get_data(GTK_OBJECT(global.win), str);
      if (!win) continue;
      if (win->window) {
	gdk_window_get_origin (win->window, 
			       &global.geometry[i1].x, 
			       &global.geometry[i1].y);
      }
      global.geometry[i1].width = win->allocation.width;
      global.geometry[i1].height = win->allocation.height;
    }
  }
  if (global.extra_win & (1<<7)) {
    win = gtk_object_get_data(GTK_OBJECT(global.win), "fields");
    if (win && win->window) {
      gdk_window_get_origin (win->window, 
			     &global.geometry[7].x, 
			     &global.geometry[7].y);
    }
  }
}

void lopster_wait(int msec) {
  struct timeval start;
  struct timeval cur;

  gettimeofday(&start, NULL);
  do {
    gettimeofday(&cur, NULL);
  } while ((cur.tv_sec-start.tv_sec)*1000 + (cur.tv_usec-start.tv_usec)/1000 < msec);
}

void advance_progress(char* message, gfloat per) {
  GtkProgressBar* progress;
  GtkLabel* label;

  if (!global.splash_win) return;
  
  progress = GTK_PROGRESS_BAR(lookup_widget(global.splash_win, "progress"));
  label = GTK_LABEL(lookup_widget(global.splash_win, "label"));
  if (message) gtk_label_set_text(label, message);
  gtk_progress_bar_update(progress, per);

  if (per >= 1) return;

  while (gtk_events_pending()) gtk_main_iteration();
  //  lopster_wait(100);
}

GtkWidget*
main_tab_detach(int no) {
  char str[1024];
  char title[1024];
  GtkWidget* widget;
  GtkWidget* window;
  GtkWidget* temp;

  if (global.extra_win & (1<<no)) return NULL;

  switch (no) {
  case 0: 
    strcpy(title, _("Server"));
    strcpy(str, "vbox98");
    temp = lookup_widget(global.win, "detach_server");
    break;
  case 1: 
    strcpy(title, _("Chat"));
    strcpy(str, "vbox15");
    temp = lookup_widget(global.win, "detach_chat");
    break;
  case 2: 
    strcpy(title, _("Library"));
    strcpy(str, "vbox2");
    temp = lookup_widget(global.win, "detach_library");
    break;
  case 3: 
    strcpy(title, _("Search"));
    strcpy(str, "vbox5");
    temp = lookup_widget(global.win, "detach_search");
    break;
  case 4: 
    strcpy(title, _("Hotlist"));
    strcpy(str, "vbox124");
    temp = lookup_widget(global.win, "detach_hotlist");
    break;
  case 5: 
    strcpy(title, _("Downloads"));
    strcpy(str, "vbox8");
    temp = lookup_widget(global.win, "detach_downloads");
    break;
  case 6: 
    strcpy(title, _("Uploads"));
    strcpy(str, "vbox139");
    temp = lookup_widget(global.win, "detach_uploads");
    break;
  default:
    return NULL;
  }
  gtk_widget_set_sensitive(temp, FALSE);

  widget = lookup_widget(global.win, str);
  if (!widget) return NULL;
  
  global.extra_win |= (1<<no);

  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  sprintf(str, "extra%d", no);
  gtk_object_set_data(GTK_OBJECT(global.win), str, window);
  gtk_window_set_policy (GTK_WINDOW (window), TRUE, TRUE, FALSE);
  gtk_window_set_default_size(GTK_WINDOW (window), 
			      (global.geometry[no].width == -1)?widget->allocation.width:global.geometry[no].width,
			      (global.geometry[no].height == -1)?widget->allocation.height:global.geometry[no].height);
  gtk_window_set_title (GTK_WINDOW (window), title);
  gtk_my_widget_show(window);

  gtk_widget_ref(widget);
  gtk_container_remove(GTK_CONTAINER(widget->parent), widget);
  gtk_container_add (GTK_CONTAINER (window), widget);
  gtk_widget_unref(widget);

  gtk_signal_connect (GTK_OBJECT (window), "delete_event",
                      GTK_SIGNAL_FUNC (on_extra_win_delete),
                      (gpointer)no);

  if ((global.geometry[no].x >= 0) &&
      (global.geometry[no].y >= 0)) {
    gtk_window_reposition(GTK_WINDOW(window),
			  global.geometry[no].x,
			  global.geometry[no].y);
  }

  
  return window;
}

clone_t* is_ip_in_clones(GList* glist, char* ip) {
  GList* dlist;
  clone_t* clone;

  dlist = g_list_first(glist);
  while (dlist) {
    clone = (clone_t*)(dlist->data);
    if (!strcmp(clone->ip, ip)) return clone;
    dlist = dlist->next;
  }
  return NULL;
}

int get_version(char* data) {
  if (!strncasecmp("VERSION opennap", data, 15)) {
    SERVER->network = N_OPENNAP;
    sscanf(data+16, "%d.%d", &(SERVER->major),
	   &(SERVER->minor));
    return 1;
  } else {
    SERVER->network = N_NAPSTER;
    return 0;
  }
}

void get_server(char* data) {
  if (!strncasecmp("SERVER ", data, 7)) {
    if (global.links) free_links(global.links);
    global.links = (link_t*)malloc(sizeof(link_t));
    global.links->server = strdup(data+7);
    global.links->links = NULL;
    global.links->ping = 0;
  }
}

int port_cmp(int a, int b) {
  if (a<b) return -1;
  else if (a>b) return 1;
  else return 0;
}
GList* append_ports(GList* dlist, char* string) {
  char* sep;
  int i1;
  
  sep = strchr(string, '-');
  if (sep) {
    *sep = 0;
    for (i1 = atoi(string); i1 <= atoi(sep+1); i1++) {
      dlist = g_list_append(dlist, (gpointer)i1);
    }
  } else {
    dlist = g_list_insert_sorted(dlist, (gpointer)atoi(string),
				 (GCompareFunc)port_cmp);
  }
  return dlist;
}

GList* create_ports_from_string(char* string) {
  GList* temp_list = NULL;
  GList* dlist;
  GList* result = NULL;
  char* temp;

  temp = strdup(string);
  make_list_from_string(&temp_list, temp, ",");
  free(temp);
  for (dlist = temp_list; dlist; dlist = dlist->next) {
    result = append_ports(result, dlist->data);
  }
  return result;
}

char* create_string_from_ports(GList* ports) {
  static char result[2048] = "";
  GList* dlist;
  int port;
  int last_port = -2;
  char str[100];
  int run = 0;

  if (!ports) return "";

  *result = 0;
  for (dlist = ports; dlist; dlist = dlist->next) {
    port = (int)(dlist->data);
    if (port != last_port+1) {
      if (run) {
	sprintf(str, "%d", last_port);
	strcat(result, "-");
	strcat(result, str);
      }
      run = 0;
    } else run = 1;
    if (!run) {
      sprintf(str, "%d", port);
      if (*result != 0) strcat(result, ",");
      strcat(result, str);
    }
    last_port = port;
  }

  if (run) {
    sprintf(str, "%d", last_port);
    strcat(result, "-");
    strcat(result, str);
  }
  return result;
}

void gtk_my_widget_show(GtkWidget* widget) {
  GList* dlist;

  if (global.splash_win) {
    dlist = gtk_object_get_data(GTK_OBJECT(global.win), "hidden");
    dlist = g_list_append(dlist, widget);
    gtk_object_set_data(GTK_OBJECT(global.win), "hidden", dlist);
  } else {
    gtk_widget_show(widget);
  }
}

void gtk_my_widget_show_all() {
  GList* dlist;
  GList* hidden;

  hidden = gtk_object_get_data(GTK_OBJECT(global.win), "hidden");
  for (dlist = hidden; dlist; dlist = dlist->next) {
    gtk_widget_show(GTK_WIDGET(dlist->data));
  }
  g_list_free(hidden);
  gtk_object_set_data(GTK_OBJECT(global.win), "hidden", NULL);
}
