#include <sys/time.h>
#include <strings.h>
#include <string.h>
#include <stdio.h>
#include <gtk/gtk.h>

#include "lopster.h"
#include "support.h"
#include "md5.h"
#include "connection.h"
#include "commands.h"
#include "interface.h"
#include "callbacks.h"
#include "scheme.h"
#include "handler.h"
#include "log.h"
#include "global.h"
#include "chat.h"
#include "search.h"
#include "share.h"
#include "transfer.h"
#include "hotlist.h"
#include "resume.h"
#include "server.h"
#include "dialog.h"

int get_color(char chr) {
  switch (chr) {
  case 'r': return 4;
  case 'b': return 2;
  case 'g': return 3;
  case 'c': return 10;
  case 'y': return 8;
  case 'Y': return 5;
  case 'k': return 1;
  default: return -1;
  }
} 

void text_print_text(GtkText* widget, char* fmt, ...) {
  char* pos;
  char text2[2048];
  char* text;
  GdkColor* color = NULL;
  int temp;
  va_list ap;

  va_start (ap, fmt);
  vsprintf (text2, fmt, ap);
  va_end (ap);

  text = text2;
  while ((pos = strchr(text, '$')) != NULL) {
    gtk_text_insert(widget, NULL, color, NULL, text, pos-text);
    text = pos;
    temp = get_color(pos[1]);
    if (temp >= 0) {
      color = &global.color_table[temp];
      text += 2;
    } else {
      gtk_text_insert(widget, NULL, color, NULL, text, 1);
      text++;
    }
  }
  gtk_text_insert(widget, NULL, color, NULL, text, strlen(text));
}

void port_dialog(char* message) {
  GtkWidget* win;
  GtkText* text;

  win = create_information_win();
  gtk_widget_show(win);
  gtk_window_set_title(GTK_WINDOW(win), _("Bind Error"));
  text = GTK_TEXT(lookup_widget(win, "text15"));
  gtk_text_set_word_wrap(text, 1);
  
  text_print_text(text, _("$r-------------------------\n Information\n-------------------------\n\n"));
  text_print_text(text, _("$kCould not set up data port: $b%s.\n"), message);
  text_print_text(text, _("$kMaybe other programs use theses ports.\n"));
  text_print_text(text, _("$kAt the moment the data port was set to $b0$k, so you cannot download from users who set their port also to 0.\n"));
  text_print_text(text, _("$kIf you do not want this, choose another port at $bPreferences->General->Port for Uploading Files $k and deactivate the $bFirewall $kbutton.\n"));
}

void download_dialog(char* filename, int mime) {
  GtkWidget* win;
  GtkText* text;
  
  win = create_information_win();
  gtk_widget_show(win);
  gtk_window_set_title(GTK_WINDOW(win), _("Information"));
  text = GTK_TEXT(lookup_widget(win, "text15"));
  gtk_text_set_word_wrap(text, 1);
  
  text_print_text(text, _("$r-------------------------\n Warning\n-------------------------\n\n"));
  text_print_text(text, _("$kDownload of file $b%s $kfailed.\n"), filename);
  text_print_text(text, _("$kEither the $bincomplete $kpath was not set or\n"));
  text_print_text(text, _("$kno valid $b path $kwas specified for mime type $b%s\n"), MimeNames(mime));
  text_print_text(text, _("$kPlease select a valid directory in $bNapster->Preferences->Paths->Download$k!\n"));
}

void changes_dialog(char* title) {
  GtkWidget* win;
  GtkText* text;
  
  win = create_information_win();
  gtk_window_set_title(GTK_WINDOW(win), title);
  text = GTK_TEXT(lookup_widget(win, "text15"));
  gtk_text_set_word_wrap(text, 1);
  
  text_print_text(text, _("$r-------------------------\nChanges since version 0.9.7\n-------------------------\n\n"));
  
  text_print_text(text, _("$cRead carefully!!!\n\n"));
  text_print_text(text, _("$r* $kFirst of all: If you are upgrading from an older version check your preferences again! A few settings may now be messed, in particular the transfer settings.\n\n"));
  text_print_text(text, _("$r* $kCheck out $bHelp->News$k from time to time. If any problem appears in version 0.9.8 it will be shown there.\n\n"));
  text_print_text(text, _("$r* $kTry right clicking on a username in the chat window.\n\n"));
  text_print_text(text, _("$r* $kA lot of pages are now detachable.\n\n"));
  text_print_text(text, _("$r* $kYou are now able to connect to a server from the napigator list directly without adding it to the selected server list.\n\n"));
  text_print_text(text, _("$r* $kThe highlighted text strings are no longer quote separated but space separated.\n\n"));
  text_print_text(text, _("$r* $kThe Chat output has changed a bit. You are now able to specify a server and a client prefix in $bPreferences->Schemes $k(uses same color codes as in chat line).\n\n"));
  text_print_text(text, _("$r* $kThe Library is no longer autosaved but you can save it manually to a specific file and load it again.\n\n"));
  text_print_text(text, _("$r* $kThe Resume window has moved to the search page. Also there is the ability to search in search results.\n\n"));
  text_print_text(text, _("$r* $kYou can limit the upload and the download bandwidth\n\n"));
  text_print_text(text, _("$r* $kYou can now specify which transfers should be automatically retried, removed from transfer tab or deleted from incomplete list\n\n"));
  text_print_text(text, _("$r* $kNative language support added.\n\n"));
  text_print_text(text, _("$rHave Fun!!!  Sgop\n"));
  gtk_my_widget_show(win);
}

void server_dialog(char* title) {
  GtkWidget* win;
  GtkText* text;
  
  win = create_information_win();
  gtk_window_set_title(GTK_WINDOW(win), title);
  text = GTK_TEXT(lookup_widget(win, "text15"));
  gtk_text_set_word_wrap(text, 1);
  
  text_print_text(text, _("$r-------------------------\nServer entries have changes\n-------------------------\n\n"));
  text_print_text(text, _("$kThe server entries in the rc-file have a different format. They were converted automatically.\n"));
  text_print_text(text, _("$kNow the $bofficial Napster Meta Server $k is no longer hard coded but is also stored in the rcfile, so you have to add it $bmanually$k, if you want to use it.\n"));
  text_print_text(text, _("$kFor this do the following:\n"));
  text_print_text(text, _("$kFirst connect to the Internet. Switch to the $bServer $kpage and look at the field $bEnter server manually$k. Enter $bserver.napster.com$k as the address, $b8875$k as the port, specify a description if you want and press the button $bAdd Meta Server$k !\n\n"));
  text_print_text(text, _("$cThat's all!\n"));
  gtk_my_widget_show(win);
}

void
on_ok_clicked                     (GtkButton       *button,
				   gpointer         user_data) {
  gtk_widget_destroy(GTK_WIDGET(user_data));
}

GtkWidget*
create_info_win (char* text)
{
  GtkWidget *delete_win;
  GtkWidget *frame172;
  GtkWidget *vbox113;
  GtkWidget *hbox263;
  GtkWidget *frame214;
  GtkWidget *pixmap30;
  GtkWidget *label435;
  GtkWidget *hseparator24;
  GtkWidget *frame173;
  GtkWidget *hbox262;
  GtkWidget *button170;

  delete_win = gtk_window_new (GTK_WINDOW_DIALOG);
  gtk_window_set_title (GTK_WINDOW (delete_win), _("Information"));
  gtk_window_set_policy (GTK_WINDOW (delete_win), FALSE, FALSE, FALSE);

  frame172 = gtk_frame_new (NULL);
  gtk_widget_show (frame172);
  gtk_container_add (GTK_CONTAINER (delete_win), frame172);
  gtk_container_set_border_width (GTK_CONTAINER (frame172), 5);

  vbox113 = gtk_vbox_new (FALSE, 5);
  gtk_widget_show (vbox113);
  gtk_container_add (GTK_CONTAINER (frame172), vbox113);
  gtk_container_set_border_width (GTK_CONTAINER (vbox113), 5);

  hbox263 = gtk_hbox_new (FALSE, 10);
  gtk_widget_show (hbox263);
  gtk_box_pack_start (GTK_BOX (vbox113), hbox263, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (hbox263), 12);

  frame214 = gtk_frame_new (NULL);
  gtk_widget_show (frame214);
  gtk_box_pack_start (GTK_BOX (hbox263), frame214, FALSE, FALSE, 0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame214), GTK_SHADOW_IN);

  pixmap30 = create_pixmap (delete_win, "info.xpm");
  gtk_widget_show (pixmap30);
  gtk_container_add (GTK_CONTAINER (frame214), pixmap30);

  label435 = gtk_label_new(text);
  gtk_widget_show (label435);
  gtk_box_pack_start (GTK_BOX (hbox263), label435, FALSE, FALSE, 0);

  hseparator24 = gtk_hseparator_new ();
  gtk_widget_show (hseparator24);
  gtk_box_pack_start (GTK_BOX (vbox113), hseparator24, FALSE, FALSE, 0);

  frame173 = gtk_frame_new (NULL);
  gtk_widget_show (frame173);
  gtk_box_pack_start (GTK_BOX (vbox113), frame173, FALSE, FALSE, 0);
  gtk_widget_set_usize (frame173, -2, 41);
  gtk_frame_set_shadow_type (GTK_FRAME (frame173), GTK_SHADOW_IN);

  hbox262 = gtk_hbox_new (TRUE, 5);
  gtk_widget_show (hbox262);
  gtk_container_add (GTK_CONTAINER (frame173), hbox262);
  gtk_container_set_border_width (GTK_CONTAINER (hbox262), 5);

  button170 = gtk_button_new_with_label (_("Ok"));
  gtk_widget_show (button170);
  gtk_box_pack_start (GTK_BOX (hbox262), button170, TRUE, TRUE, 0);

  gtk_signal_connect (GTK_OBJECT (delete_win), "destroy",
                      GTK_SIGNAL_FUNC (gtk_widget_destroy),
                      delete_win);
  gtk_signal_connect (GTK_OBJECT (button170), "clicked",
                      GTK_SIGNAL_FUNC (on_ok_clicked),
                      delete_win);
  
  return delete_win;
}

