#define M_PUBLIC    0
#define M_OP        1
#define M_TOPIC     2

char* get_word(GtkText *text, int deselect);
char* get_popup_user(int mode);
GtkWidget* create_online_popup (void);
void refresh_channels();

void chat_print(char* color, char *text);
void chat_print_ln(char* color, char* text);

void chat_print_channel(chat_page_t* page, int message_type, 
			char* color, char *text);
void chat_print_channel_color(chat_page_t* page, int message_type,
			      char* color, GdkColor* fore, 
			      GdkColor* back, char *text);
void chat_print_colored(chat_page_t* page, int message_type,
			char* base_color, char *text);

void join_channel(char* name);
void create_private_page (char* name);

void cmd_public_message_no_log(char* data, int message_type);

void send_global(char* text);
void send_wallop(char* text);
void send_chwallop(char* channel, char* text);
void send_emote(char* text);
void send_private(char* nick, char* text);
void send_public(char* channel, char* text);
void send_afk(char* user, afk_t* afk);

int check_channel_wallop(char* data);
int check_server_join_quit(char* data);
int check_server_pong(char* data);
void check_op(char* data);
void check_pending_searches(char* data);
void check_share_limit(char* data);

void mark_user(char* user, GdkPixmap *pix, GdkBitmap *bit);
void update_user(char* user);
void update_users(GList* glist);
void delete_user_list(GList** glist);
int search_user_in_list(GtkCList* list, char* user);
GList* user_search(char* user);
int user_search_full(char* user);
void on_hide_show_clicked(GtkButton *button, gpointer user_data);

char* search_highlight_string(char* string, int* len);
gint user_compare (GtkCList      *clist,
		   gconstpointer  ptr1, gconstpointer  ptr2);
void highlight(chat_page_t* page, int high);

//
void set_afk(char* message);


chat_page_t* chat_page_get_current_main();
chat_page_t* chat_page_new(char* name, int type);
GtkWidget* chat_page_get_widget(chat_page_t* page);
void chat_page_destroy(chat_page_t* page);
void chat_page_attach_to_main(chat_page_t* page);
void chat_page_attach_to_new(chat_page_t* page);
void chat_page_leave(chat_page_t* page);
chat_page_t* chat_page_search(char* name, int type);
int in_private();
int in_channel();
chat_page_t* chat_page_find_unfixed();
