#include <ctype.h>
#include <strings.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>

#include <gtk/gtk.h>

#include "lopster.h"
#include "connection.h"
#include "global.h"
#include "search.h"
#include "transfer.h"
#include "support.h"
#include "callbacks.h"
#include "chat.h"
#include "server.h"
#include "scheme.h"
#include "commands.h"
#include "log.h"
#include "handler.h"

#define MAX_LINE_LENGTH  150

char* get_word(GtkText *text, int deselect) {
  gint start_pos;
  gint end_pos;
  GtkEditable *editable;
  char* str;
  static char result[1024];
  int cnt = 0;
  int cursor;

  editable = GTK_EDITABLE (text);
  
  cursor = global.popup_row;
  while (1) {
    if (cursor < 1) break;
    if (GTK_TEXT_INDEX(text, cursor-1) == '<') {
      cnt++;
      break;
    }
    if (GTK_TEXT_INDEX(text, cursor-1) == '\n')
      break;
    if (GTK_TEXT_INDEX(text, cursor-1) == ' ')
      break;
    cursor--;
  }
  start_pos = cursor;
  while (1) {
    if (cursor >= gtk_text_get_length(text)) break;
    if (GTK_TEXT_INDEX(text, cursor) == '>') {
      cnt++;
      break;
    }
    if (GTK_TEXT_INDEX(text, cursor) == '\n')
      break;
    if (GTK_TEXT_INDEX(text, cursor) == ' ')
      break;
    cursor++;
  }
  end_pos = cursor;

  if (!cnt) return NULL;

  str = gtk_editable_get_chars(GTK_EDITABLE(text),
			       start_pos, end_pos);
  /*
  if (deselect)
    gtk_editable_delete_selection(GTK_EDITABLE(text));
  else
    gtk_editable_select_region(GTK_EDITABLE(text), start_pos, end_pos);
  */
  *result = 0;
  if (str && (strlen(str) < 1024)) strcpy(result, str);
  return result;
}


char* get_popup_user(int mode) {
  char *user;
  transfer_t* transfer;
  file_t* file;
  GdkPixmap *pixmap = NULL;
  GdkBitmap *bitmap = NULL;
  guint8 space;
  static char result[1024];
  socket_t* socket;

  if ((mode == M_ONLINE) || (mode == M_HOTLIST)) {
    gtk_clist_get_pixtext (GTK_CLIST(global.popup_list), 
			   global.popup_row, 0,
			   &user, &space,
			   &pixmap, &bitmap);
  } else if (mode == M_SEARCH) {
    file = (file_t*)gtk_clist_get_row_data(GTK_CLIST(global.popup_list),
					   global.popup_row);
    if (!file) return NULL;
    user = file->user;
  } else if (mode == M_TRANSFER) {
    socket = (socket_t*)gtk_clist_get_row_data(GTK_CLIST(global.popup_list),
					       global.popup_row);
    transfer = (transfer_t*)(socket->data);
    if (!transfer) return NULL;
    user = transfer->user;
  } else if (mode == M_GLOBAL) {
    gtk_clist_get_text(GTK_CLIST(global.popup_list),
		       global.popup_row, 0, &user);
  } else if (mode == M_WHOIS) {
    user = GTK_LABEL(global.popup_list)->label;
  } else if (mode == M_TEXT) {
    user = get_word(GTK_TEXT(global.popup_list), 1);
  } else if (mode == M_IGNORE) {
    gtk_clist_get_text(GTK_CLIST(global.popup_list),
		       global.popup_row, 0, &user);
  }
  
  strcpy(result, user);
  return result;
}

GtkWidget* create_online_popup (void) {
  GtkWidget *popup;
  GtkWidget *item;
  GtkWidget *separator;
  GtkAccelGroup *popup_accels;
  
  if (global.popup_row >= 0) {
    popup = create_user_popup(M_ONLINE);

    separator = gtk_menu_item_new ();
    gtk_widget_show (separator);
    gtk_container_add (GTK_CONTAINER (popup), separator);
    gtk_widget_set_sensitive (separator, FALSE);
    separator = gtk_menu_item_new ();
    gtk_widget_show (separator);
    gtk_container_add (GTK_CONTAINER (popup), separator);
    gtk_widget_set_sensitive (separator, FALSE);
  } else {
    popup = gtk_menu_new ();
    gtk_object_set_data (GTK_OBJECT (popup), "popup", popup);
    popup_accels = gtk_menu_ensure_uline_accel_group (GTK_MENU (popup));
  }
  
  item = gtk_menu_item_new_with_label (_("Refresh List"));
  gtk_widget_show (item);
  gtk_container_add (GTK_CONTAINER (popup), item);
  gtk_signal_connect (GTK_OBJECT (item), "activate",
                      GTK_SIGNAL_FUNC (on_refresh_list_activate),
                      NULL);

  separator = gtk_menu_item_new ();
  gtk_widget_show (separator);
  gtk_container_add (GTK_CONTAINER (popup), separator);
  gtk_widget_set_sensitive (separator, FALSE);
  
  item = gtk_menu_item_new_with_label (_("Customize List"));
  gtk_widget_show (item);
  gtk_container_add (GTK_CONTAINER (popup), item);
  gtk_signal_connect (GTK_OBJECT (item), "activate",
                      GTK_SIGNAL_FUNC (on_customize_list_activate),
                      NULL);

  return popup;
}

void line_insert_lf(char* line) {
  char* last_ws = line;
  char* temp = line;
  int length;

  if (!line) return;
  length = strlen(line);
  if (length == 0) return;
  if (line[length-1] == '\n') {
    line[length-1] = 0;
    length--;
  }
  if (length <= MAX_LINE_LENGTH) return;

  while (line) {
    while (temp-line <= MAX_LINE_LENGTH) {
      last_ws = temp;
      temp = strpbrk(temp+1, " \n\t");
      if (!temp) break;
      if (*temp == '\n') {
	last_ws = temp;
	break;
      }
    }
    if ((last_ws-line > 0) && (temp)) {
      *last_ws = '\n';
      line = temp = last_ws+1;
    } else {
      break;
    }
  }
}

void refresh_channels() {
  GList* dlist;
  chat_page_t* page;

  for (dlist = global.chat_pages; dlist; dlist = dlist->next) {
    page = (chat_page_t*)(dlist->data);
    if (page->type == P_PUBLIC)
      send_command(830, page->name);
  }
}

void chat_print(char* color, char* text) {
  if (!text) return;
  chat_print_colored(global.current_page, M_PUBLIC, color, text);
  return;
}

void chat_print_ln(char* color, char* text) {
  if (text)
    chat_print_colored(global.current_page, M_PUBLIC, color, text);
  chat_print_colored(global.current_page, M_PUBLIC, color, "\n");
  return;
}


int scroll_mode(GtkWidget *text) {
  int value = GTK_ADJUSTMENT(GTK_TEXT(text)->vadj)->value;
  int page_size = GTK_ADJUSTMENT(GTK_TEXT(text)->vadj)->page_size;
  int upper = GTK_ADJUSTMENT(GTK_TEXT(text)->vadj)->upper;

  if (value + page_size < upper) return 0;
  else return 1;
}

void snap_to_bottom(GtkWidget *text) {
  GtkAdjustment* vertical_adjustment;
  
  vertical_adjustment = GTK_ADJUSTMENT(GTK_TEXT(text)->vadj);
  gtk_adjustment_set_value(vertical_adjustment,
			   vertical_adjustment->upper
			   - vertical_adjustment->lower
			   - vertical_adjustment->page_size);
}

void chat_print_channel(chat_page_t* page, int message_type,
			char* color, char* text) {
  char t[1024];
  style_t* style;
  GtkWidget* temp;
  int snap;

  if (!strcmp(page->name, "Channels"))
    page = chat_page_search("Console", P_FIX);
  if (!page) return;

  if (message_type == M_TOPIC)
    sprintf(t, "%s_topic", page->name);
  else if (message_type == M_OP)
    sprintf(t, "%s_text2", page->name);
  else sprintf(t, "%s_text", page->name);

  temp = lookup_widget(global.win, t);
  style = style_get(global.scheme, color);

  gtk_text_freeze(GTK_TEXT(temp));
  snap = scroll_mode(temp);
  gtk_text_insert(GTK_TEXT(temp), style->font, 
		  style->fore, style->back, 
		  text, strlen(text));
  gtk_text_thaw(GTK_TEXT(temp));
  if (snap) snap_to_bottom(temp);
  
  highlight(page, 1);
  
  return;
}

void chat_print_channel_color(chat_page_t* page, int message_type,
			      char* color, GdkColor* fore, 
			      GdkColor* back, char *text) {
  char t[1024];
  style_t* style;
  GtkWidget* temp;
  GdkColor* f;
  GdkColor* b;
  int snap;

  if (!strcmp(page->name, "Channels"))
    page = chat_page_search("Console", P_FIX);
  if (!page) return;
  
  if (message_type == M_TOPIC)
    sprintf(t, "%s_topic", page->name);
  else if (message_type == M_OP)
    sprintf(t, "%s_text2", page->name);
  else sprintf(t, "%s_text", page->name);

  temp = lookup_widget(global.win, t);
  style = style_get(global.scheme, color);

  if (fore) f = fore;
  else f = style->fore;
  if (back) b = back;
  else b = style->back;
  
  gtk_text_freeze(GTK_TEXT(temp));
  snap = scroll_mode(temp);
  gtk_text_insert(GTK_TEXT(temp), style->font, 
		  f, b, text, strlen(text));
  gtk_text_thaw(GTK_TEXT(temp));
  if (snap) snap_to_bottom(temp);

  highlight(page, 1);
  
  return;
}

void chat_print_colored(chat_page_t* page, int message_type,
			char* base_color, char *text) {
  GdkColor* fgcolor = NULL;
  GdkColor* bgcolor = NULL;
  char* pos2;
  int len;
  char temp_str[2048];
  int index;

  while (1) {
    pos2 = search_highlight_string(text, &len);
    if (!pos2) break;

    strncpy(temp_str, text, pos2-text);
    temp_str[pos2-text] = 0;
    chat_print_channel_color(page, message_type, base_color, 
			     fgcolor, bgcolor, temp_str);

    if ((pos2[0] == 0x03)) {
      if ((pos2[1] == 0) || (pos2[2] == 0) || (pos2[3] == 0)) return;
      if (pos2[1] == 0x0f) {
	fgcolor = NULL;
	bgcolor = NULL;
	len = 2;
      } else if (pos2[1] == ',') {
	index = ColorTable2(pos2[3]-'0');
	if (index < 0) index = -index;
	bgcolor = &global.color_table[index];
	len = 4;
      } else if (pos2[1] != '-') {
	index = ColorTable(pos2[1]-'0', pos2[2]-'0');
	if (index < 0) index = -index;
	fgcolor = &global.color_table[index];
	len = 3;
      }
    } else {
      strncpy(temp_str, pos2, len);
      temp_str[len] = 0;
      chat_print_channel(page, message_type, "highlight", temp_str);
    }
    
    text = pos2+len;
  }
  chat_print_channel_color(page, message_type, base_color, fgcolor, bgcolor, text);

  return;
}

void join_channel(char* name) {
  send_command(CMD_CLIENT_JOIN, name);
}

void on_hide_show_clicked(GtkButton *button, gpointer user_data) {
  GtkWidget* temp;
  char str[1024];
  GtkPaned* paned;
  int pos;

  temp = GTK_WIDGET(gtk_object_get_data(GTK_OBJECT(button), "con_widget"));

  sprintf(str, "%s_channel", global.current_page->name);
  paned = GTK_PANED(lookup_widget(global.win, str));

  if (GTK_WIDGET_VISIBLE(temp)) {
    pos = (int)gtk_object_get_data(GTK_OBJECT(button), "pan_pos");
    gtk_paned_set_position (paned, pos);
  } else {
    gtk_object_set_data(GTK_OBJECT(button), "pan_pos", 
			(gpointer)(paned->child1_size));
    sprintf(str, "%s_vbox", global.current_page->name);
    temp = lookup_widget(global.win, str);
    gtk_paned_set_position (paned, 
			    paned->child1_size + temp->allocation.width);
  }
}

void
create_private_page (char* name) {
  GtkWidget *scrolledwindow27;
  GtkWidget *text4;
  GtkWidget *vbox22;
  GtkWidget *tab_label;
  GtkWidget *entry19;
  GtkWidget *temp;
  GtkNotebook* notebook;
  char str[100];
  chat_page_t* page;

  temp = lookup_widget(global.win, "notebook1");
  gtk_notebook_set_page(GTK_NOTEBOOK(temp), 1);
  
  vbox22 = gtk_vbox_new (FALSE, 0);
  sprintf(str, "%s_vbox22", name);
  gtk_object_set_data (GTK_OBJECT (global.win), str, vbox22);
  gtk_widget_show (vbox22);

  entry19 = gtk_entry_new ();
  sprintf(str, "%s_topic", name);
  gtk_object_set_data (GTK_OBJECT (global.win), str, entry19);
  gtk_widget_show (entry19);
  gtk_box_pack_start (GTK_BOX (vbox22), entry19, FALSE, FALSE, 0);

  scrolledwindow27 = gtk_scrolled_window_new (NULL, NULL);
  sprintf(str, "%s_scrolled", name);
  gtk_object_set_data (GTK_OBJECT (global.win), str, scrolledwindow27);
  gtk_widget_show (scrolledwindow27);
  gtk_box_pack_start (GTK_BOX (vbox22), scrolledwindow27, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow27), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  text4 = gtk_text_new (NULL, NULL);
  sprintf(str, "%s_text", name);
  gtk_object_set_data (GTK_OBJECT (global.win), str, text4);
  gtk_signal_connect_after (GTK_OBJECT (text4), "button_press_event",
                            GTK_SIGNAL_FUNC (on_text_button_press_event),
                            NULL);

  gtk_widget_set_style(text4, global.style[2]);  

  gtk_widget_show (text4);
  gtk_text_set_word_wrap(GTK_TEXT(text4), 1);
  gtk_container_add (GTK_CONTAINER (scrolledwindow27), text4);

  tab_label = gtk_label_new(name);
  sprintf(str, "%s_tab", name);
  gtk_object_set_data (GTK_OBJECT (global.win), str, tab_label);
  gtk_widget_show(tab_label);

  notebook = GTK_NOTEBOOK(lookup_widget(global.win, "notebook3"));
  gtk_notebook_append_page(notebook, vbox22, tab_label);
  page = chat_page_new(name, P_PRIVATE);
  gtk_notebook_set_page(GTK_NOTEBOOK(notebook),
			gtk_notebook_page_num(GTK_NOTEBOOK(notebook), vbox22));
}

void cmd_public_message_no_log(char* data, int message_type) {
  char* channel;
  char* user;
  chat_page_t* page;
  char* message;

  channel = arg(data, 0);
  if (!channel) return;
  user = arg(NULL, 0);
  if (!user) return;
  message = arg(NULL, 1);

  if (global.options.public_ignore) {
    if (is_string_in_list(global.ignored_users, user)) return;
  }

  // searching any type, as this function is also used for
  // private pages
  page = chat_page_search(channel, -1);
  if (!page) return;

  chat_print_channel(page, message_type, "user", "<");
  if (!strcasecmp(SERVER->nick, user))
    chat_print_channel(page, message_type, "yourself", user);
  else if (is_string_in_list(global.frienduser, user))
    chat_print_channel(page, message_type, "friend", user);
  else
    chat_print_channel(page, message_type, "user", user);
  chat_print_channel(page, message_type, "user", ">");
  chat_print_channel(page, message_type, "NULL", " ");
    
  if (message) chat_print_colored(page, message_type, "text", message);
  chat_print_colored(page, message_type, "text", "\n");
}

void send_afk(char* user, afk_t* afk) {
  static time_t old_time = 0;
  char* message;
  time_t tim;
  int d, h,m;
  char s1[1024];
  char s2[1024];
  char s3[1024];

  // do not send AFK message to enemies
  if (is_string_in_list(global.enemyuser, user)) return;
  
  // only send one AFK message per second to avoid
  // automatic message loops
  time(&tim);
  if (tim <= old_time+1) return;
  old_time = tim;

  tim -= afk->since;    // seconds
  tim /= 60;            // minutes
  m = tim%60;           // %minutes
  tim /= 60;            // hours
  h = tim%24;           // %hours
  d = tim/24;           // days
  if (d) sprintf(s1, _("%d days "), d);
  else *s1 = 0;
  if (h || d) sprintf(s2, _("%d hours "), h);
  else *s2 = 0;
  if (m || h || d) sprintf(s3, _(" %d minutes"), m);
  else sprintf(s3, "%d minutes", 0);
  message = g_strdup_printf("AFK: %s [%s%s%s]",
			    afk->message, s1, s2, s3);
  send_private(user, message);
  g_free(message);
}

int check_channel_wallop(char* data) {
  char* pos;
  char* command;
  char* nick;
  char* message;
  char* channel;
  chat_page_t* page;

  pos = strchr(data, ' ');
  if (!pos) return 0;
  if (strncmp(pos, " [ops/", 5)) return 0;
  
  nick = arg(data, 0);
  pos = arg(NULL, 0);
  message = arg(NULL, 1);
  channel = strchr(pos, '/')+1;
  pos = strchr(channel, ']');
  *pos = 0;
  
  page = chat_page_search(channel, P_PUBLIC);
  if (!page) return 1;
  
  if (global.options.sep_chwallop) {
    command = g_strdup_printf("%s %s %s", channel, nick, message);
    cmd_public_message_no_log(command, M_OP);
    g_free(command);
  } else {
    chat_print_channel(page, M_PUBLIC, "message", _("(Channel op) "));
    command = g_strdup_printf("%s %s %s", channel, nick, message);
    cmd_public_message_no_log(command, M_PUBLIC);
    g_free(command);
  }
  log(channel, LOG_CHANNEL, "<%s> [Wallop] %s\n", nick, message);
  
  return 1;
}

int check_server_join_quit(char* data) {
  char* temp;
  char* server;
  char* str1;
  char* str2;
  int mode = 0;

  temp = strdup(data);
  str1 = arg(temp, 0);
  server = arg(NULL, 0);
  str2 = arg(NULL, 1);
  
  if (!str1) goto done_false;
  if (!server) goto done_false;
  if (!str2) goto done_false;
  
  if (strcasecmp(str1, "Server")) goto done_false;
  if (!strncmp(str2, "has quit", 8)) mode = 1;
  if (!strncmp(str2, "has joined", 10)) mode = 2;
  if (mode == 0) goto done_false;
  if (mode == 2) {
    lopster_links(NULL);
    goto done_true;
  }

  // remove the server (mode 1)
  client_message(_("Removing"), "[%s]", server);
  if (link_remove(global.links, server)) {
    client_message("Huh", _("Local server has quit?"));
  }
  
 done_true:
  free(temp);
  return 1;

 done_false:
  free(temp);
  return 0;
}

int check_server_pong(char* data) {
  char* server;
  char* temp;
  char* ping;
  link_t* link;
  
  if (strncmp(_("Pong from server"), data, 16)) return 0;
  
  temp = strdup(data+17);
  server = arg(temp, 0);
  ping = arg(NULL, 0);
  if (ping) ping++;
  else return 1;
  
  if ((link = link_search_rec(global.links, server)) == NULL) return 1;

  if (link->ping) free(link->ping);
  link->ping = strdup(ping);
  return 1;
}
 
/*
void check_get_motd(char* data) { // for macachu
  char* mode;

  if (SERVER->network == N_UNKNOWN) {
    if (get_version(data)) {
      if (global.usermode) {
	mode = make_string_from_list(global.usermode, " ");
	send_command(CMD_CLIENT_USER_MODE, "NONE");
	send_command(CMD_CLIENT_USER_MODE, mode);
      }
      lopster_links(NULL);
    }
    update_user_stats();
    setup_sensitive(0);
  }
  if (!global.links) {
    get_server(data);
  }
}
*/

// Doofus opped you on channel #Lopster
void check_op(char* data) {
  char str[1024];
  char* pos;
  GtkWidget* paned;

  pos = strchr(data, ' ');
  if (!pos) return;
  pos++;
  if (!strncmp(pos, "opped you on channel ", 21)) {
    pos += 21;
    if (is_string_in_list(global.opchannel, pos)) return;
    global.opchannel = g_list_append(global.opchannel, strdup(pos));
    
    sprintf(str, "%s_channel2", pos);
    paned = lookup_widget(global.win, str);
    if (!paned) return;
    gtk_paned_set_position (GTK_PANED(paned), global.paned_pos2);
    return;
  }
}

void check_pending_searches(char* data) {
  if (!strcmp(data, "search failed: too many pending searches")) {
    global.status.searching--;
    search_update_counter();
  }
}

void check_share_limit(char* data) {
  GList* dlist;

  if (!strncmp(data, "You may only share", 18)) {
    for (dlist = global.share_queue; dlist; dlist = dlist->next)
      free(dlist->data);
    g_list_free(global.share_queue);
    global.share_queue = NULL;
  }
}

void send_global(char* text) {
  char* text2;
  char* pos;

  line_insert_lf(text);
  while ((pos = strchr(text, '\n')) != NULL) {
    *pos = 0;
    if (global.options.parse_color) text2 = cparse(text);
    else text2 = text;
    send_command(CMD_CLIENT_ANNOUNCE, text2);
    text = pos+1;
  }
    
  if (global.options.parse_color) text2 = cparse(text);
  else text2 = text;
  send_command(CMD_CLIENT_ANNOUNCE, text2);
}

void send_wallop(char* text) {
  char* text2;
  char* pos;

  line_insert_lf(text);
  while ((pos = strchr(text, '\n')) != NULL) {
    *pos = 0;
    if (global.options.parse_color) text2 = cparse(text);
    else text2 = text;
    send_command(CMD_CLIENT_WALLOP, text2);
    text = pos+1;
  }
    
  if (global.options.parse_color) text2 = cparse(text);
  else text2 = text;
  send_command(CMD_CLIENT_WALLOP, text2);
}

void send_emote(char* text) {
  char* text2;
  char* pos;
  char* command;

  if (!in_channel()) return;

  while ((pos = strchr(text, '\n')) != NULL) {
    *pos = 0;
    if (global.options.parse_color) text2 = cparse(text);
    else text2 = text;
    command = g_strdup_printf("%s \"%s\"", 
			      global.current_page->name, text2);
    send_command(CMD_CLIENT_EMOTE, command);
    g_free(command);
    text = pos+1;
  }
    
  if (global.options.parse_color) text2 = cparse(text);
  else text2 = text;

  command = 
    g_strdup_printf("%s \"%s\"", global.current_page->name, text2);
  send_command(CMD_CLIENT_EMOTE, command);
  g_free(command);
}

void send_private(char* nick, char* text) {
  char* text2;
  char* pos;
  char* command;

  if (global.status.connection < 2) return;

  line_insert_lf(text);
  while ((pos = strchr(text, '\n')) != NULL) {
    *pos = 0;
    if (global.options.parse_color) text2 = cparse(text);
    else text2 = text;
    command = g_strdup_printf("%s %s", nick, text2);
    send_command(CMD_CLIENT_PRIVMSG, command);
    g_free(command);

    log(nick, LOG_PRIVATE, "<%s> %s\n", SERVER->nick, text2);
    if (strcasecmp(nick, global.current_page->name)) {
      chat_print("whisper", _("<to: "));
      chat_print("whisper", nick);
      chat_print("whisper", "> ");
      chat_print_ln("whisper", text2);
    } else {
      command = g_strdup_printf("%s %s %s", 
				global.current_page->name, 
				SERVER->nick, text2);
      cmd_public_message_no_log(command, M_PUBLIC);
      g_free(command);
    }
    text = pos+1;
  }
    
  if (global.options.parse_color) text2 = cparse(text);
  else text2 = text;
  command = g_strdup_printf("%s %s", nick, text2);
  send_command(CMD_CLIENT_PRIVMSG, command);
  g_free(command);

  log(nick, LOG_PRIVATE, "<%s> %s\n", SERVER->nick, text2);
  if (strcasecmp(nick, global.current_page->name)) {
    chat_print("whisper", _("<to: "));
    chat_print("whisper", nick);
    chat_print("whisper", "> ");
    chat_print_ln("whisper", text2);
  } else {
    command = 
      g_strdup_printf("%s %s %s", global.current_page->name, 
		      SERVER->nick, text2);
    cmd_public_message_no_log(command, M_PUBLIC);
    g_free(command);
  }
}

void send_public(char* channel, char* text) {
  char* text2;
  char* pos;
  char* command;
  
  line_insert_lf(text);
  while ((pos = strchr(text, '\n')) != NULL) {
    *pos = 0;
    if (global.options.parse_color) text2 = cparse(text);
    else text2 = text;
    command = g_strdup_printf("%s %s", channel, text2);
    send_command(CMD_CLIENT_PUBLIC, command);
    g_free(command);
    text = pos+1;
  }
    
  if (global.options.parse_color) text2 = cparse(text);
  else text2 = text;
  command = g_strdup_printf("%s %s", channel, text2);
  send_command(CMD_CLIENT_PUBLIC, command);
  g_free(command);
}

void send_chwallop(char* channel, char* text) {
  char* text2;
  char* pos;
  char* command;

  line_insert_lf(text);
  while ((pos = strchr(text, '\n')) != NULL) {
    *pos = 0;
    if (global.options.parse_color) text2 = cparse(text);
    else text2 = text;
    command = g_strdup_printf("%s %s", channel, text2);
    send_command(CMD_CLIENT_CHANNEL_WALLOP, command);
    g_free(command);
    text = pos+1;
  }
    
  if (global.options.parse_color) text2 = cparse(text);
  else text2 = text;
  command = g_strdup_printf("%s %s", channel, text2);
  send_command(CMD_CLIENT_CHANNEL_WALLOP, command);
  g_free(command);
}

void mark_user(char* user, GdkPixmap *pix, GdkBitmap *bit) {
  int i2;
  GdkPixmap *pixmap = NULL;
  GdkBitmap *bitmap = NULL;
  guint8 space;
  char* text;
  char t[1024];
  GList* dlist;
  chat_page_t* page;
  GtkWidget* temp;

  // mark users in online lists
  for (dlist = global.chat_pages; dlist; dlist = dlist->next) {
    page = (chat_page_t*)(dlist->data);
    if (page->type != P_PUBLIC) continue;
    sprintf(t, "%s_online", page->name);
    //    printf("searching in %s\n", t);

    temp = lookup_widget(global.win, t);
    for (i2 = 0; i2 < GTK_CLIST(temp)->rows; i2++) {
      gtk_clist_get_pixtext (GTK_CLIST(temp), i2, 0,
			     &text, &space,
			     &pixmap, &bitmap);
      strcpy(t, text);
      if (!strcasecmp(user, t)) {
	gtk_clist_set_pixtext (GTK_CLIST(temp), i2, 0, t, 
			       space, pix, bit);
      }
    }
  }  
}

void update_user(char* user) {
  if (is_string_in_list(global.frienduser, user)) {
    mark_user(user, global.pix.friend, global.pix.friendb);
  } else if (is_string_in_list(global.enemyuser, user)) {
    if (is_string_in_list(global.ignored_users, user))
      mark_user(user, global.pix.enemy2, global.pix.enemy2b);
    else
      mark_user(user, global.pix.enemy, global.pix.enemyb);
  } else if (is_string_in_list(global.ignored_users, user)) {
    mark_user(user, global.pix.ignore, global.pix.ignoreb);
  } else {
    mark_user(user, global.pix.dummy, global.pix.dummyb);
  }
}

void update_users(GList* glist) {
  int i1;
  char* pos;

  if (!glist) return;
  for (i1 = 0; i1 < g_list_length(glist); i1++) {
    pos = (char*)(g_list_nth(glist, i1)->data);
    update_user(pos);
  }
}

void delete_user_list(GList** glist) {
  char* pos;
  char* text;

  if (*glist == NULL) return;
  while (g_list_length(*glist) > 0) {
    pos = (char*)(g_list_first(*glist)->data);
    text = strdup(pos);
    *glist = g_list_remove(*glist, pos);
    update_user(text);
    free(text);
  }
  *glist = NULL;
}

int search_user_in_list(GtkCList* list, char* user) {
  char *text;
  char *t;
  int i1;
  GdkPixmap *pixmap = NULL;
  GdkBitmap *bitmap = NULL;
  guint8 space;

  if (!user) return -1;
  if (!list) return -1;

  for (i1 = 0; i1 < list->rows; i1++) {
    gtk_clist_get_pixtext (list, i1, 0,
			   &text, &space,
			   &pixmap, &bitmap);
    if (!text) {
      printf("oops\n");
      continue;
    }
    t = strdup(text);
    if (strcasecmp(user, t) == 0) {
      free(t);
      return i1;
    }
    free(t);
  }

  return -1;
}

GList* user_search(char* user) {
  GtkCList* temp;
  char *text;
  char t[500];
  int i1;
  GdkPixmap *pixmap = NULL;
  GdkBitmap *bitmap = NULL;
  guint8 space;
  int len = strlen(user);
  GList* result = NULL;

  if (!in_channel()) return NULL;

  sprintf(t, "%s_online", global.current_page->name);
  temp = GTK_CLIST(lookup_widget(global.win, t));
  if (!temp) return NULL;
  for (i1 = 0; i1 < temp->rows; i1++) {
    gtk_clist_get_pixtext (temp, i1, 0,
			   &text, &space,
			   &pixmap, &bitmap);
    strcpy(t, text);
    if (strncasecmp(user, t, len) == 0) {
      result = g_list_append(result, strdup(t));
    }
  }

  return result;
}

int user_search_full(char* user) {
  GtkCList* temp;
  char *text;
  char t[500];
  int i1;
  GdkPixmap *pixmap = NULL;
  GdkBitmap *bitmap = NULL;
  guint8 space;

  if (!in_channel()) return 0;

  sprintf(t, "%s_online", global.current_page->name);
  temp = GTK_CLIST(lookup_widget(global.win, t));
  if (!temp) return 0;
  for (i1 = 0; i1 < temp->rows; i1++) {
    gtk_clist_get_pixtext (temp, i1, 0,
			   &text, &space,
			   &pixmap, &bitmap);
    strcpy(t, text);
    if (strcasecmp(user, t) == 0) return 1;
  }
  
  return 0;
}

char* search_highlight_string(char* string, int* len) {
  char* pos;
  char* str;
  char* result = NULL;
  char* temp_str;
  GList* dlist;

  *len = 0;
  temp_str = string;

  for (dlist = global.highlight; dlist; dlist = dlist->next) {
    str = (char*)(dlist->data);
    if ((pos = strcasestr(temp_str, str)) != NULL) {
      if ((!result) || (pos < result)) {
	result = pos;
	*len = strlen(str);
      }
    }
  }
  
  pos = strchr(string, 0x03);
  if (pos) {
    if ((!result) || (pos < result)) {
      result = pos;
      *len = 3;
    }
  }
  return result;
}

// /alias c {/eval say $cparse("$*")}

gint
user_compare (GtkCList      *clist,
	      gconstpointer  ptr1,
	      gconstpointer  ptr2) {

  char *text1 = NULL;
  char *text2 = NULL;
  int u1, u2;

  GtkCListRow *row1 = (GtkCListRow *) ptr1;
  GtkCListRow *row2 = (GtkCListRow *) ptr2;

  text1 = GTK_CELL_TEXT (row1->cell[clist->sort_column])->text;
  text2 = GTK_CELL_TEXT (row2->cell[clist->sort_column])->text;

  if (!text2)
    return (text1 != NULL);

  if (!text1)
    return -1;

  if (clist->sort_column == 0) {
    return strcasecmp (text1, text2);
  } else if (clist->sort_column == 1) {
    sscanf(text1, "%d", &u1);
    sscanf(text2, "%d", &u2);
    if (u1 < u2) return -1;
    if (u1 > u2) return 1;
    return 0;
  } else if (clist->sort_column == 2) {
    u1 = speed2int(text1);
    u2 = speed2int(text2);
    if (u1 < u2) return -1;
    if (u1 > u2) return 1;
    return 0;
  } else {
    return 0;
  }
}

void highlight(chat_page_t* page, int high) {
  char t[1024];
  GtkWidget* temp;
  chat_page_t* page2;

  if (page->window) return;

  page2 = chat_page_get_current_main();
  if (page2 == page) return;

  sprintf(t, "%s_tab", page->name);
  temp = lookup_widget(global.win, t);

  gtk_widget_set_style(temp, global.style[high]);  
}

void set_afk(char* message) {
  GtkWidget* temp;

  if (!message) {
    temp = lookup_widget(global.win, "checkbutton9");
    if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), FALSE);
    } else {
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), TRUE);
    }
  } else {
    temp = lookup_widget(global.win, "checkbutton9");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), FALSE);
    temp = lookup_widget(global.win, "entry50");
    gtk_entry_set_text(GTK_ENTRY(temp), message);
    temp = lookup_widget(global.win, "checkbutton9");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), TRUE);
  }
}



chat_page_t* chat_page_get_current_main() {
  GtkNotebook* notebook;
  int page;
  GtkWidget* temp;
  char* name;

  notebook = GTK_NOTEBOOK(lookup_widget(global.win, "notebook3"));
  page = gtk_notebook_get_current_page(notebook);
  if (page < 0) return NULL;
  temp = gtk_notebook_get_nth_page(notebook, page);
  temp = gtk_notebook_get_tab_label(notebook, temp);
  name = GTK_LABEL(temp)->label;
  
  if (!strcmp(name, _("Console")))
    return chat_page_search("Console", -1);
  else if (!strcmp(name, _("Channels")))
    return chat_page_search("Channels", -1);
  else
    return chat_page_search(name, -1);
}

chat_page_t* chat_page_new(char* name, int type) {
  chat_page_t* page;

  page = (chat_page_t*)malloc(sizeof(chat_page_t));
  page->name = strdup(name);
  page->window = NULL;
  page->type = type;

  global.chat_pages = g_list_append(global.chat_pages, page);
  return page;
}

GtkWidget* chat_page_get_widget(chat_page_t* page) {
  char str[1024];
  GtkWidget* channel_widget;

  if (page->type == P_PRIVATE)
    sprintf(str, "%s_vbox22", page->name);
  else if (page->type == P_PUBLIC)
    sprintf(str, "%s_channel", page->name);
  else if (!strcmp(page->name, "Console"))
    sprintf(str, "hbox147");
  else if (!strcmp(page->name, "Channels"))
    sprintf(str, "scrolledwindow50");
  else return NULL;
  
  channel_widget = lookup_widget(global.win, str);
  return channel_widget;
}

void chat_page_destroy(chat_page_t* page) {
  GtkWidget* channel_widget;
  
  if (page->type == P_FIX) return;
  global.chat_pages = g_list_remove(global.chat_pages, page);

  channel_widget = chat_page_get_widget(page);
  if (!channel_widget) return;

  gtk_container_remove(GTK_CONTAINER(channel_widget->parent), 
		       channel_widget);

  if (page->window) {
    gtk_object_set_data(GTK_OBJECT(page->window), "channel", NULL);
    gtk_widget_destroy(page->window);
  }

  if (global.current_page == page) {
    global.current_page = chat_page_get_current_main();
  }

  if (page->name) free(page->name);
  free(page);
}

void chat_page_attach_to_main(chat_page_t* page) {
  GtkWidget* tab_label;
  GtkNotebook* notebook;
  GtkWidget* channel_widget;
  char str[1024];

  if (page->window == NULL) return;
  
  channel_widget = chat_page_get_widget(page);
  if (!channel_widget) return;

  gtk_widget_ref(channel_widget);
  gtk_container_remove(GTK_CONTAINER(channel_widget->parent), 
		       channel_widget);

  if (!strcmp(page->name, "Console"))
    tab_label = gtk_label_new(_("Console"));
  else if (!strcmp(page->name, "Channels"))
    tab_label = gtk_label_new(_("Channels"));
  else tab_label = gtk_label_new(page->name);
  gtk_widget_show(tab_label);
  sprintf(str, "%s_tab", page->name);
  gtk_object_set_data (GTK_OBJECT (global.win), str, tab_label);
  
  notebook = GTK_NOTEBOOK(lookup_widget(global.win, "notebook3"));
  gtk_notebook_append_page(notebook, channel_widget, tab_label);
  gtk_widget_unref(channel_widget);
  gtk_notebook_set_page(GTK_NOTEBOOK(notebook),
			gtk_notebook_page_num(GTK_NOTEBOOK(notebook),
					      channel_widget));
  page->window = NULL;
}

void chat_page_attach_to_new(chat_page_t* page) {
  char str[1024];
  GtkWidget* channel;
  GtkWidget* window;
  GtkWidget* vbox;
  GtkWidget* hbox;
  GtkWidget* frame;
  GtkWidget* button1;
  GtkWidget* entry;

  if (page->window) return;
  channel = chat_page_get_widget(page);
  if (!channel) return;

  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_default_size(GTK_WINDOW (window), 
			      channel->allocation.width,
			      channel->allocation.height+60);
  if (page->type == P_PRIVATE)
    sprintf(str, _("Private: %s"), page->name);
  else if (page->type == P_PUBLIC)
    sprintf(str, _("Channel: %s"), page->name);
  else strcpy(str, _(page->name));
  gtk_window_set_title (GTK_WINDOW (window), str);
  gtk_widget_show(window);
  gtk_object_set_data(GTK_OBJECT(window), "channel", page);
  gtk_widget_ref(channel);
  gtk_container_remove(GTK_CONTAINER(channel->parent), channel);

  vbox = gtk_vbox_new (FALSE, 5);
  gtk_container_set_border_width (GTK_CONTAINER (vbox), 5);
  gtk_widget_show (vbox);
  gtk_container_add (GTK_CONTAINER (window), vbox);
  gtk_box_pack_start (GTK_BOX (vbox), channel, TRUE, TRUE, 0);
  gtk_widget_unref(channel);

  hbox = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox);
  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);

  entry = gtk_entry_new ();
  gtk_widget_show (entry);
  gtk_box_pack_start (GTK_BOX (hbox), entry, TRUE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (entry), "activate",
                      GTK_SIGNAL_FUNC (on_chat_entry_activate),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (entry), "key_press_event",
                      GTK_SIGNAL_FUNC (on_chat_entry_key_press_event),
                      NULL);
  
  frame = gtk_frame_new (NULL);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_IN);
  gtk_widget_show (frame);
  gtk_box_pack_start (GTK_BOX (hbox), frame, FALSE, FALSE, 0);
  button1 = gtk_button_new_with_label (_("Leave Room"));
  gtk_widget_show (button1);
  gtk_container_add (GTK_CONTAINER (frame), button1);
  gtk_signal_connect (GTK_OBJECT (button1), "clicked",
                      GTK_SIGNAL_FUNC (on_chat_leave_clicked),
                      page);
  if (page->type == P_FIX) 
    gtk_widget_set_sensitive(button1, FALSE);
  else
    gtk_widget_set_sensitive(button1, TRUE);

  frame = gtk_frame_new (NULL);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_IN);
  gtk_widget_show (frame);
  gtk_box_pack_start (GTK_BOX (hbox), frame, FALSE, FALSE, 0);
  button1 = gtk_button_new_with_label (_("Attach to chat window"));
  gtk_widget_show (button1);
  gtk_container_add (GTK_CONTAINER (frame), button1);
  gtk_signal_connect (GTK_OBJECT (button1), "clicked",
                      GTK_SIGNAL_FUNC (on_chat_attach_clicked),
                      page);

  gtk_signal_connect (GTK_OBJECT (window), "focus_in_event",
                      GTK_SIGNAL_FUNC (on_window_focus_in_event),
                      page);
  gtk_signal_connect (GTK_OBJECT (window), "focus_out_event",
                      GTK_SIGNAL_FUNC (on_window_focus_out_event),
                      page);

  page->window = window;

  gtk_signal_connect (GTK_OBJECT (window), "destroy",
                      GTK_SIGNAL_FUNC (on_chat_destroy),
                      window);

}

void chat_page_leave(chat_page_t* page) {
  if (page->type == P_PUBLIC) {
    if (global.status.connection > 1)
      send_command(CMD_CLIENT_PART, page->name);
    else chat_page_destroy(page);
  } else if (page->type == P_PRIVATE) {
    chat_page_destroy(page);
  }
}

chat_page_t* chat_page_search(char* name, int type) {
  GList* dlist;
  chat_page_t* page;

  //  printf("searching [%s]\n", name);
  for (dlist = global.chat_pages; dlist; dlist = dlist->next) {
    page = (chat_page_t*)(dlist->data);
    //    printf("s [%s]\n", page->name);
    if (!strcasecmp(page->name, name)) {
      if ((type == -1) || (page->type == type)) return page;
    }
  }
  return NULL;
}

int in_private() {
  return (global.current_page->type == P_PRIVATE);
}

int in_channel() {
  return (global.current_page->type == P_PUBLIC);
}

chat_page_t* chat_page_find_unfixed() {
  GList* dlist;
  chat_page_t* page;
  
  for (dlist = global.chat_pages; dlist; dlist = dlist->next) {
    page = (chat_page_t*)(dlist->data);
    if (page->type != P_FIX) return page;
  }
  
  return NULL;
}
