#include <sys/socket.h>
#include <sys/types.h>
#include <stdio.h>
#include <strings.h>
#include <string.h>
#include <sys/time.h>
#include <stdlib.h>

#include <gtk/gtk.h>

#include "lopster.h"
#include "callbacks.h"
#include "connection.h"
#include "global.h"
#include "search.h"
#include "hotlist.h"
#include "share.h"
#include "support.h"
#include "chat.h"
#include "handler.h"
#include "browse.h"

socket_t* browse_search(char* nick);
gint await_conn_ack2(gpointer data, gint source, 
		     GdkInputCondition condition);
gint send_browse_send(gpointer data, gint source, 
		      GdkInputCondition condition);
gint send_browse_get(gpointer data, gint source, 
		     GdkInputCondition condition);

gint send_browse_files(gpointer data, gint source, 
		      GdkInputCondition condition) {
  char t2[2048];
  char t[1024];
  socket_t* socket = (socket_t*)data;
  file_t* file;
  GList* dlist = (GList*)(socket->data);

  if (socket->data) {
    file = (file_t*)(dlist->data);
    if ((file->flags & FLAG_SHARED) ||
	(file->flags & FLAG_TO_SHARE)) {
      strcpy(t2, "\"");
      strcat(t2, file->winname);
      strcat(t2, "\" ");
      strcat(t2, file->md5);
      sprintf(t, " %ld %d %d %d\n",
	      file->size, file->bitrate, 
	      file->frequency, file->duration);
      strcat(t2, t);
      
      send(source, t2, strlen(t2), 0);
      socket->cnt = 0;
    }
    socket->data = (void*)(dlist->next);
  } else {
    send(source, "\n", 1, 0);
    socket_destroy(socket, 1);
  }
  
  return 1;
}

gint send_browse_nick(gpointer data, gint source, 
		      GdkInputCondition condition) {
  socket_t* socket = (socket_t*)data;
  char* temp_str;
  
  if (condition != GDK_INPUT_WRITE) {
    socket_destroy(socket, 0);
    return 1;
  }

  socket->data = global.user.files;

  temp_str = g_strdup_printf("%s\n", SERVER->nick);
  send(source, temp_str, strlen(temp_str), 0);

  gdk_input_remove(socket->input);
  socket->input = 
    gdk_input_add(socket->fd, GDK_INPUT_WRITE, 
		  GTK_SIGNAL_FUNC(send_browse_files), socket);
  
  return 1;
}

////////

gint get_browse_files(gpointer data, gint source, 
		      GdkInputCondition condition) {
  int res;
  char buf[1025];
  char buf2[1025];
  char* filename;
  char* md5;
  char* size;
  char* bitrate;
  char* frequency;
  char* duration;
  socket_t* socket = (socket_t*)data;
  file_t* file;
  char* pos1;
  char* pos2;

  if (condition != GDK_INPUT_READ) {
    socket_destroy(socket, 0);
    return 1;
  }
  switch (res = recv(source, buf, 1024, MSG_PEEK)) {
  case -1:
    socket_destroy(socket, 0);
    return 1;
  case 0:
    socket_destroy(socket, 0);
    return 1;
  default:
    break;
  }

  buf[res] = 0;

  pos1 = buf;
  while ((pos2 = strchr(pos1, '\n')) != NULL) {
    res = pos2-pos1+1;
    recv(source, buf2, res, 0);
    buf2[res-1] = 0;
    
    filename = arg(buf2, 0);
    if (!filename) goto close;
    md5 = arg(NULL, 0);
    if (!md5) goto close;
    size = arg(NULL, 0);
    if (!size) goto close;
    bitrate = arg(NULL, 0);
    if (!bitrate) goto close;
    frequency = arg(NULL, 0);
    if (!frequency) goto close;
    duration = arg(NULL, 0);
    if (!duration) goto close;
    
    file = (file_t*)malloc(sizeof(file_t));
    file->user = strdup((char*)(socket->data));
    file->winname = strdup(filename);
    file->md5 = strdup(md5);
    sscanf(size, "%ld", &(file->size));
    sscanf(bitrate, "%d", &(file->bitrate));
    sscanf(frequency, "%d", &(file->frequency));
    sscanf(duration, "%d", &(file->duration));
    file->longname = strdup(file->winname);
    convert_to_unix(file->longname);
    file->shortname = strdup(extract_short_name(file->longname));
    file->mime_type = get_mimetype(file->longname);
    file->flags = 0;
    file->ip = 0;
    file->linespeed = 0;
    file->status = FILE_NONE;
    file->local = 0;            //remote file
    file_insert_browse(file);
    socket->cnt = 0;
    pos1 = pos2+1;
  }
  
  return 1;

 close:
  socket_destroy(socket, 1);
  strcpy(buf, (char*)socket->data);
  cmd_browse_end(buf);
  return 1;
}

gint get_browse_nick(gpointer data, gint source, 
		     GdkInputCondition condition) {
  unsigned char buffer[1025];
  int res;
  int cnt;
  char* pos;
  socket_t* socket = (socket_t*)data;
  socket_t* socket2;

  if (condition != GDK_INPUT_READ) {
    socket_destroy(socket, 0);
    return 1;
  }
  gdk_input_remove(socket->input);
  socket->input = -1;

  switch (res = recv(source, buffer, 1024, MSG_PEEK)) {
  case -1:
    socket_destroy(socket, 0);
    return 1;
  case 0:
    socket_destroy(socket, 0);
    return 1;
  default:
    break;
  }
  
  buffer[res] = 0;
  pos = strchr(buffer, '\n');
  if (!pos) {
    socket_destroy(socket, 0);
    return 1;
  }
  cnt = (long)pos-(long)buffer;
  recv(source, buffer, cnt+1, 0);
  buffer[cnt] = 0;
  
  socket2 = browse_search(buffer);
  if (!socket2) {
    socket_destroy(socket, 0);
    return 1;
  } else if (socket != socket2) {
    socket_destroy(socket2, 1);
    socket->data = strdup(buffer);
    socket2 = socket;
  }
  
  socket2->cnt = 0;

  socket2->input =
    gdk_input_add(socket2->fd, GDK_INPUT_READ, 
		  GTK_SIGNAL_FUNC(get_browse_files), socket2);
  
  return 1;
}

///////////////

void browse_connect_and_start(socket_t* socket) {
  
  if (!connect_socket(socket, "TCP", SOCK_STREAM)) {
    return;
  }
  
  socket->input = 
    gdk_input_add(socket->fd, GDK_INPUT_READ, 
		  GTK_SIGNAL_FUNC(await_conn_ack2), socket);
}

gint await_conn_ack3(gpointer data, gint source, 
		     GdkInputCondition condition) {
  int res;
  char c;
  socket_t* socket = (socket_t*)data;
  
  if (condition != GDK_INPUT_READ) {
    socket_destroy(socket, 0);
    return 1;
  }
  switch (res = recv(source, &c, 1, 0)) {
  case -1:
    socket_destroy(socket, 0);
    return 1;
  case 0:
    socket_destroy(socket, 0);
    return 1;
  default:
    break;
  }    

  if (c != '1') {
    socket_destroy(socket, 0);
    return 1;
  }
  
  gdk_input_remove(socket->input);
  socket->input = 
    gdk_input_add(socket->fd, GDK_INPUT_WRITE, 
		  GTK_SIGNAL_FUNC(send_browse_send), socket);

  return 1;
}
gint await_conn_ack2(gpointer data, gint source, 
		     GdkInputCondition condition) {
  int res;
  char c;
  socket_t* socket = (socket_t*)data;
  
  if (condition != GDK_INPUT_READ) {
    socket_destroy(socket, 0);
    return 1;
  }
  switch (res = recv(source, &c, 1, 0)) {
  case -1:
    socket_destroy(socket, 0);
    return 1;
  case 0:
    socket_destroy(socket, 0);
    return 1;
  default:
    break;
  }    

  if (c != '1') {
    socket_destroy(socket, 0);
    return 1;
  }
  
  gdk_input_remove(socket->input);
  socket->input = 
    gdk_input_add(socket->fd, GDK_INPUT_WRITE, 
		  GTK_SIGNAL_FUNC(send_browse_get), socket);

  return 1;
}

gint send_browse_get(gpointer data, gint source, 
		     GdkInputCondition condition) {
  socket_t* socket = (socket_t*)data;

  if (condition != GDK_INPUT_WRITE) {
    socket_destroy(socket, 0);
    return 1;
  }

  send(source, "GETLIST", 7, 0);

  gdk_input_remove(socket->input);
  socket->input = 
    gdk_input_add(socket->fd, GDK_INPUT_READ, 
		  GTK_SIGNAL_FUNC(get_browse_nick), socket);
  
  return 1;
}

gint send_browse_send(gpointer data, gint source, 
		      GdkInputCondition condition) {
  socket_t* socket = (socket_t*)data;

  if (condition != GDK_INPUT_WRITE) {
    socket_destroy(socket, 0);
    return 1;
  }
  send(source, "SENDLIST", 8, 0);
  
  gdk_input_remove(socket->input);
  socket->input = 
    gdk_input_add(socket->fd, GDK_INPUT_WRITE, 
		  GTK_SIGNAL_FUNC(send_browse_nick), socket);
  
  return 1;
}

////////////

socket_t* browse_search(char* nick) {
  GList* dlist;
  socket_t* socket;
  char* des;

  for (dlist = global.sockets; dlist; dlist = dlist->next) {
    socket = (socket_t*)(dlist->data);
    if (socket->type == S_BROWSE) {
      des = (char*)(socket->data);
      if (!strcasecmp(nick, des)) return socket;
    }
  }
  return NULL;
}

void browse_direct(char* nick) {
  socket_t* socket;
  
  socket = socket_new(S_BROWSE);
  socket->data = strdup(nick);
  send_command(CMD_CLIENT_BROWSE_DIRECT, nick);
}

GtkWidget* create_browse_popup() {
  GtkWidget *popup;
  GtkAccelGroup *popup_accels;
  GtkWidget *trennlinie20;
  GtkWidget *customize_list6;
  file_t* file;
  GtkWidget *download2;

  popup = gtk_menu_new ();
  gtk_object_set_data (GTK_OBJECT (popup), "popup", popup);
  popup_accels = gtk_menu_ensure_uline_accel_group (GTK_MENU (popup));
  if (global.popup_row != -1)
    file = (file_t*)gtk_clist_get_row_data(GTK_CLIST(global.popup_list),
					   global.popup_row);
  else file = NULL;
  
  if (global.popup_row != -1) {
    if (!file) {
      download2 = gtk_menu_item_new_with_label (_("Download Folder"));
      gtk_widget_ref (download2);
      gtk_object_set_data_full (GTK_OBJECT (popup), "download2", download2,
				(GtkDestroyNotify) gtk_widget_unref);
      gtk_widget_show (download2);
      gtk_container_add (GTK_CONTAINER (popup), download2);
      gtk_signal_connect (GTK_OBJECT (download2), "activate",
			  GTK_SIGNAL_FUNC (on_download_folder_activate),
			  (void*)0);
    } else {
      download2 = gtk_menu_item_new_with_label (_("Download Selected"));
      gtk_widget_ref (download2);
      gtk_object_set_data_full (GTK_OBJECT (popup), "download2", download2,
				(GtkDestroyNotify) gtk_widget_unref);
      gtk_widget_show (download2);
      gtk_container_add (GTK_CONTAINER (popup), download2);
      gtk_signal_connect (GTK_OBJECT (download2), "activate",
			  GTK_SIGNAL_FUNC (on_download2_activate),
			  (void*)0);
      download2 = gtk_menu_item_new_with_label (_("Download Selected with Foldername"));
      gtk_widget_ref (download2);
      gtk_object_set_data_full (GTK_OBJECT (popup), "download2", download2,
				(GtkDestroyNotify) gtk_widget_unref);
      gtk_widget_show (download2);
      gtk_container_add (GTK_CONTAINER (popup), download2);
      gtk_signal_connect (GTK_OBJECT (download2), "activate",
			  GTK_SIGNAL_FUNC (on_download2_activate),
			  (void*)1);
    }

    trennlinie20 = gtk_menu_item_new ();
    gtk_widget_ref (trennlinie20);
    gtk_object_set_data_full (GTK_OBJECT (popup), "trennlinie20", trennlinie20,
			      (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (trennlinie20);
    gtk_container_add (GTK_CONTAINER (popup), trennlinie20);
    gtk_widget_set_sensitive (trennlinie20, FALSE);
  }
  customize_list6 = gtk_menu_item_new_with_label (_("Customize List"));
  gtk_widget_ref (customize_list6);
  gtk_object_set_data_full (GTK_OBJECT (popup), "customize_list6", customize_list6,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (customize_list6);
  gtk_container_add (GTK_CONTAINER (popup), customize_list6);
  gtk_signal_connect (GTK_OBJECT (customize_list6), "activate",
                      GTK_SIGNAL_FUNC (on_customize_list_activate),
                      NULL);

  return popup;
}

file_t* file_create_from_browse_response(char* data) {
  char* pos1;
  file_t* file;

  file = (file_t*)malloc(sizeof(file_t));

  file->user = strdup(arg(data, 0));
  file->winname = strdup(arg(NULL, 0));
  file->md5 = strdup(arg(NULL, 0));

  pos1 = arg(NULL, 0);
  sscanf(pos1, "%ld", &(file->size));

  pos1 = arg(NULL, 0);
  sscanf(pos1, "%d", &(file->bitrate));

  pos1 = arg(NULL, 0);
  sscanf(pos1, "%d", &(file->frequency));

  pos1 = arg(NULL, 0);
  sscanf(pos1, "%d", &(file->duration));
  
  file->longname = strdup(file->winname);
  convert_to_unix(file->longname);
  pos1 = extract_short_name(file->longname);
  file->shortname = strdup(pos1);
  file->mime_type = get_mimetype(file->longname);
  file->flags = 0;
  file->ip = 0;
  file->linespeed = 0;
  file->status = FILE_NONE;
  file->local = 0;            //remote file

  return file;
}

void file_create_from_browse_new(char* data) {
  file_t* file;
  char* pos1;
  char* dir;
  char* name;
  char* user;

  user = arg(data, 0);
  dir = arg(NULL, 0);

  while ((name = arg(NULL, 0)) != NULL) {
    file = (file_t*)malloc(sizeof(file_t));
    
    file->user = strdup(user);

    file->md5 = strdup(arg(NULL, 0));

    pos1 = arg(NULL, 0);
    sscanf(pos1, "%ld", &(file->size));

    pos1 = arg(NULL, 0);
    sscanf(pos1, "%d", &(file->bitrate));

    pos1 = arg(NULL, 0);
    sscanf(pos1, "%d", &(file->frequency));

    pos1 = arg(NULL, 0);
    sscanf(pos1, "%d", &(file->duration));
  
    file->winname = (char*)malloc(strlen(dir)+1+strlen(name)+1);
    sprintf(file->winname, "%s\\%s", dir, name);
    file->mime_type = get_mimetype(file->winname);

    file->longname = strdup(file->winname);
    convert_to_unix(file->longname);
    pos1 = extract_short_name(file->longname);
    file->shortname = strdup(pos1);
    file->mime_type = get_mimetype(file->longname);

    file->ip = 0;
    file->flags = 0;
    file->linespeed = 0;
    file->status = FILE_NONE;
    file->local = 0;            //remote file

    file_insert_browse(file);
  }
}

void file_insert_browse_real(file_t *file) {
  GtkWidget* temp;
  char* text;
  char* filename;
  char* pos;
  GtkCTreeNode *node;
  GtkCTreeNode *node2 = NULL;
  file_t* file2;
  GtkCTree* ctree;

  ctree = GTK_CTREE(lookup_widget(global.win, "ctree3"));
  tstr[1][0] = tstr[2][0] = tstr[3][0] = tstr[4][0] = 0;
  node = NULL;

  temp = lookup_widget(global.win, "checkbutton18");
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp)))
    filename = strdup(file->shortname);
  else
    filename = strdup(file->longname);
  
  //  strcpy(t, file->shortname);

  /////////////////
  pos = strtok(filename, "/");
  while (pos) {
    if (strlen(pos) <= 0) {
      pos = strtok(NULL, "/");
      continue;
    }
    node2 = node;
    if (node) node = GTK_CTREE_ROW(node)->children;
    else node = GTK_CTREE_NODE(GTK_CLIST(ctree)->row_list);
    while (node) {
      text = GTK_CELL_PIXTEXT 
	(GTK_CTREE_ROW (node)->row.cell[ctree->tree_column])->text;
      if (strcmp(pos, text) == 0) break;
      node = GTK_CTREE_ROW(node)->sibling;
    }
    if (!node) break;
    if (GTK_CTREE_ROW (node)->is_leaf) break;
    pos = strtok(NULL, "/");
  }
  
  // do not insert identical files
  if (node && GTK_CTREE_ROW (node)->is_leaf) {
    file2 = (file_t*)gtk_ctree_node_get_row_data(ctree, node);    
    if (!strcmp(file2->longname, file->longname)) {
      //      printf("do not insert [%s]\n", file->longname);
      return;
    }
  }


  node = node2;
  do {
    strcpy(tstr[0], pos);
    pos = strtok(NULL, "/");
    if (pos) {
      node = 
	gtk_ctree_insert_node(ctree, node, NULL, list, 5,
			      global.pix.folder, 
			      global.pix.folderb,
			      global.pix.folder_open, 
			      global.pix.folder_openb,
			      FALSE, FALSE);
      gtk_ctree_node_set_row_data(ctree, node, NULL);
    } else {
      sprintf(tstr[1], "%.2f MB", (double)(file->size)/1024/1024);
      sprintf(tstr[2], "%d", file->bitrate);
      sprintf(tstr[3], "%d", file->frequency);
      sprintf(tstr[4], "%d:%s%d", file->duration/60, 
	      (file->duration%60)<10?"0":"", file->duration%60);
      
      node = gtk_ctree_insert_node(ctree,
				   node, NULL, list, 5,
				   NULL, NULL, NULL, NULL,
				   TRUE, FALSE);
      
      gtk_ctree_node_set_row_data(ctree, node, (gpointer)file);
    }
  } while (pos);
  
  free(filename);
  hotlist_update_user();
}

void file_insert_browse(file_t *file) {
  char* pos;
  
  GtkCList* clist;
  int row;
  user_t* userinfo;
  user_t* stats;
  GtkWidget* temp;

  temp = lookup_widget(global.win, "ctree3");
  stats = (user_t*)gtk_object_get_data(GTK_OBJECT(temp), "userinfo");

  if (stats && !strcmp(stats->username, file->user))
    file_insert_browse_real(file);
  
  clist = GTK_CLIST(lookup_widget(global.win, "clist16"));

  stats = (user_t*)gtk_object_get_data(GTK_OBJECT(clist), "userinfo");
  stats->shared++;
  stats->bytes += file->size;
  hotlist_update_stats();

  row = is_user_in_hotlist(file->user);
  if (row >= 0) {
    userinfo = gtk_clist_get_row_data(clist, row);
    userinfo->shared++;
    userinfo->bytes += file->size;
    userinfo->files = g_list_append(userinfo->files, file);
    pos = g_strdup_printf("%d", userinfo->shared);
    gtk_clist_set_text(clist, row, 1, pos);
    g_free(pos);
  } else if ((userinfo = browse_list_search(file->user)) != NULL) {
    userinfo->shared++;
    userinfo->bytes += file->size;
    userinfo->files = g_list_append(userinfo->files, file);
    hotlist_update_stats();
  }
}

void browse_user_files(char* nick, int max) {
  GtkCTree* ctree;
  GtkCList* clist;
  user_t* userinfo;
  int row;
  char* command;

  if (!nick || !(*nick)) return;
  
  ctree = GTK_CTREE(lookup_widget(global.win, "ctree3"));
  clist = GTK_CLIST(lookup_widget(global.win, "clist16"));
  row = is_user_in_hotlist(nick);
  if (row >= 0) {
    userinfo = gtk_clist_get_row_data(clist, row);
    hotlist_remove_user_files(userinfo);
    browse_clear(NULL);
    gtk_object_set_data(GTK_OBJECT(ctree), "userinfo", userinfo);
  } else {
    userinfo = browse_list_search(nick);
    if (userinfo) hotlist_remove_user_files(userinfo);
    else {
      userinfo = (user_t*)malloc(sizeof(user_t));
      userinfo->files = NULL;
      userinfo->timeout = 0;
      userinfo->bytes = 0;
      userinfo->shared = 0;
      strcpy(userinfo->username, nick);
      global.browses = g_list_append(global.browses, userinfo);
    }
    browse_clear(NULL);
    gtk_object_set_data(GTK_OBJECT(ctree), "userinfo", userinfo);
  }
  
  if (max > 0) command = g_strdup_printf("%s %d", nick, max);
  else command = g_strdup_printf("%s", nick);

  if (opennap_version(0, 39) || !opennap_version(0, 0)) {
    browse_direct(nick);
  } else {
    send_command(CMD_CLIENT_BROWSE, command);
  }
  g_free(command);
  hotlist_update_user();
}

user_t* browse_list_search(char* nick) {
  user_t* result;
  GList* dlist;
  
  for (dlist = global.browses; dlist; dlist = dlist->next) {
    result = (user_t*)(dlist->data);
    if (!strcasecmp(nick, result->username)) return result;
  }
  return NULL;
}

void browse_clear(user_t* userinfo) {
  GtkCTree* ctree;
  user_t* browse;

  ctree = GTK_CTREE(lookup_widget(global.win, "ctree3"));
  browse = (user_t*)gtk_object_get_data(GTK_OBJECT(ctree), "userinfo");

  if (userinfo && (userinfo != browse)) return;
  
  gtk_object_set_data(GTK_OBJECT(ctree), "userinfo", NULL);
  gtk_clist_clear(GTK_CLIST(ctree));
  
  hotlist_update_user();
}

void browse_show(user_t* userinfo) {
  GList* dlist;
  file_t* file;
  GtkCList* clist;
  user_t* browse;

  hotlist_update_user();

  clist = GTK_CLIST(lookup_widget(global.win, "ctree3"));
  browse = (user_t*)gtk_object_get_data(GTK_OBJECT(clist), "userinfo");
  if ((browse == userinfo) || (userinfo->files == NULL)) return;
  browse_clear(NULL);
  
  if (userinfo->files) {
    userinfo->timeout = 0;
    gtk_clist_freeze(clist);
    for (dlist = userinfo->files; dlist; dlist = dlist->next) {
      file = (file_t*)(dlist->data);
      file_insert_browse_real(file);
    }
    gtk_clist_thaw(clist);
  }
  gtk_object_set_data(GTK_OBJECT(clist), "userinfo", userinfo);

  gtk_ctree_sort_recursive(GTK_CTREE(clist), NULL);
  
  hotlist_update_user();
}

void on_browse_user(GtkMenuItem     *menuitem,
		    gpointer         user_data) {
  browse_show(user_data);
}

GtkWidget* create_browse_user_popup (void) {
  GtkWidget *popup;
  GtkAccelGroup *popup_accels;
  GtkWidget *mode;
  GtkCList* clist;
  int row;
  user_t* userinfo;
  char* temp_str;
  int cnt = 0;
  GList* dlist;

  popup = gtk_menu_new ();
  gtk_object_set_data (GTK_OBJECT (popup), "popup", popup);
  popup_accels = gtk_menu_ensure_uline_accel_group (GTK_MENU (popup));

  clist = GTK_CLIST(lookup_widget(global.win, "clist16"));
  for (row = 0; row < clist->rows; row++) {
    userinfo = gtk_clist_get_row_data(clist, row);
    if (!userinfo || (!userinfo->files)) continue;
    temp_str = g_strdup_printf("%s (%d)", userinfo->username,
			       userinfo->shared);
    mode = gtk_menu_item_new_with_label (temp_str);
    g_free(temp_str);
    gtk_widget_ref (mode);
    gtk_widget_show (mode);
    gtk_container_add (GTK_CONTAINER (popup), mode);
    gtk_signal_connect (GTK_OBJECT (mode), "activate",
			GTK_SIGNAL_FUNC (on_browse_user),
			userinfo);
    cnt++;
  }

  if ((cnt > 0) && global.browses) {
    mode = gtk_menu_item_new ();
    gtk_widget_set_sensitive (mode, FALSE);
    gtk_widget_ref (mode);
    gtk_widget_show (mode);
    gtk_container_add (GTK_CONTAINER (popup), mode);
  }

  for (dlist = global.browses; dlist; dlist = dlist->next) {
    userinfo = (user_t*)(dlist->data);
    if (!userinfo) continue;
    temp_str = g_strdup_printf("%s (%d)", userinfo->username,
			       userinfo->shared);
    mode = gtk_menu_item_new_with_label (temp_str);
    g_free(temp_str);
    gtk_widget_ref (mode);
    gtk_widget_show (mode);
    gtk_container_add (GTK_CONTAINER (popup), mode);
    gtk_signal_connect (GTK_OBJECT (mode), "activate",
			GTK_SIGNAL_FUNC (on_browse_user),
			userinfo);
    cnt++;
  }

  if (cnt == 0) {
    mode = gtk_menu_item_new_with_label ("empty");
    gtk_widget_set_sensitive(mode, FALSE);
    gtk_widget_ref (mode);
    gtk_widget_show (mode);
    gtk_container_add (GTK_CONTAINER (popup), mode);
    gtk_signal_connect (GTK_OBJECT (mode), "activate",
			NULL, NULL);
  }
  return popup;
}
