#include <sys/types.h>
#include <dirent.h>
#include <stdio.h>
#include <string.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/time.h>

#include <gtk/gtk.h>

#include "callbacks.h"
#include "connection.h"
#include "global.h"
#include "support.h"
#include "share.h"
#include "handler.h"

file_t* global_file;
int build_done;

void rec_build (GtkCTree *ctree, GtkCTreeNode *node,
		char* data) {
  file_t* file;
  struct stat stats;
  int size;

  if (build_done > 5) return;
  if (!GTK_CTREE_ROW (node)->is_leaf) return;
  file = gtk_ctree_node_get_row_data(ctree, node);

  if (stat(file->longname, &stats) < 0) {
    size = file->size;
  } else {
    size = stats.st_size;
  }
  if ((file->md5 == NULL) || (file->size != size)) {
    build_done++;
    file->size = size;
    file_parse_header(file);
    file_calc_md5(file);
    lib_update_file(file);
  }
}

int build_idle(gpointer data) {
  GtkCTree* ctree;

  if (global.status.exiting) {
    global.status.building = 0;
    on_exit_activate(NULL, NULL);
    return 0;
  }

  build_done = 0;
  ctree = GTK_CTREE(lookup_widget(global.win, "lib_tree"));
  gtk_ctree_post_recursive(ctree, NULL, 
			   (GtkCTreeFunc)rec_build, NULL);

  if (build_done == 0) {
    lib_commit();
    global.status.building = 0;
    return 0;
  } else return 1;
}

int add_shared_directory(char* dirname) {
  DIR* dir;
  struct dirent* entry;
  struct stat buf;
  char name[2048];
  file_t* file;

  if ((dir = opendir(dirname)) == NULL) {
#ifdef SHARE_DEBUG
    printf("could not open dir [%s] (add_shared)\n", dirname);
#endif
    return 0;
  }

  while ((entry = readdir(dir)) != NULL) {
    if (!strncmp(entry->d_name, ".", 1)) continue;
    if (!strncmp(entry->d_name, "..", 2)) continue;
    
    strcpy(name, dirname);
    strcat(name, "/");
    strcat(name, entry->d_name);
    stat(name, &buf);
    if (global.status.exiting) return 0;
    if (buf.st_mode&S_IFDIR) {
      // do not follow links!!!!!!!!!!!!!!!!!!!!
      //      printf("mode : %s:%x:%x\n", name, buf.st_mode, S_IFLNK);
      if ((buf.st_mode&S_IFLNK) == 0)
	add_shared_directory(name);
    } else {
      if (strcasecmp(&(entry->d_name[strlen(entry->d_name)-4]), ".mp3") == 0) {
	file = lib_search_file(name);
	if (!file) {
	  file = file_create_from_local(name);
	  if (file) lib_insert_file(file);
	} else {
#ifdef SHARE_DEBUG
	  printf("updating [%s]\n", file->longname);
#endif
	  file->flags |= FLAG_IN_LIB;
	}
      }
      if (gtk_events_pending()) gtk_main_iteration();
    }
  }
  closedir(dir);

  return 1;
}

void lib_refresh() {
  int i1;
  char* text;

  if (global.status.building) return;

  global.status.building = 1;

  lib_del_flag(FLAG_IN_LIB, NULL);

  if (!global.path.shared) {
    lib_commit();
    global.status.building = 0;
    return;
  }

  for (i1 = 0; i1 < g_list_length(global.path.shared); i1++) {
    text = (char*)(g_list_nth(global.path.shared, i1)->data);
    add_shared_directory(text);
  }

  gtk_idle_add(build_idle, NULL);
}

void rec_remove_unshared (GtkCTree *ctree, GtkCTreeNode *node,
			  char* data) {
  file_t* file;

  if (!GTK_CTREE_ROW (node)->is_leaf) {
    if (GTK_CTREE_ROW(node)->children == NULL) {
      gtk_ctree_remove_node(ctree, node);
    }
  } else {  
    file = gtk_ctree_node_get_row_data(ctree, node);
    if ((file->flags & FLAG_IN_LIB) == 0) {
      if (file->flags & FLAG_SHARED) {
	// unsharing
	if (global.status.connected) {
	  send_command(CMD_CLIENT_REMOVE_FILE, file->winname);
	}
      }
      if (file->flags & FLAG_DELETE) {
	unlink(file->longname);
      }
      gtk_ctree_remove_node(ctree, node);
    }
  }
}

void rec_add_shared (GtkCTree *ctree, GtkCTreeNode *node,
		     char* data) {
  file_t* file;

  if (!GTK_CTREE_ROW (node)->is_leaf) return;
  
  file = gtk_ctree_node_get_row_data(ctree, node);
  
  if ((file->flags & FLAG_SHARED) == 0) {
    send_command(CMD_CLIENT_ADD_FILE, "\"%s\" %s %ld %d %d %d",
		 file->winname, file->md5, file->size,
		 file->bitrate, file->frequency, file->length);
    file->flags |= FLAG_SHARED;
  }
}

void rec_calc_stats (GtkCTree *ctree, GtkCTreeNode *node,
		     char* data) {
  file_t* file;
  hot_t *hot;
  
  if (!GTK_CTREE_ROW (node)->is_leaf) return;
  
  file = gtk_ctree_node_get_row_data(ctree, node);

  hot = (hot_t*)data;
  hot->files++;
  hot->bytes += file->size;
}

void lib_commit() {
  GtkCTree* ctree;
  GtkWidget* temp;
  char comm[1024];
  hot_t hot;

  ctree = GTK_CTREE(lookup_widget(global.win, "lib_tree"));
  gtk_ctree_sort_recursive(ctree, NULL);

  // first removing file, not in library
  gtk_ctree_post_recursive(ctree, NULL, 
			   (GtkCTreeFunc)rec_remove_unshared, NULL);

  // now updating stats
  hot.files = 0;
  hot.bytes = 0;
  gtk_ctree_post_recursive(ctree, NULL, 
			   (GtkCTreeFunc)rec_calc_stats, &hot);
  temp = lookup_widget(global.win, "label233");
  sprintf(comm, "%d", hot.files);
  gtk_label_set_text(GTK_LABEL(temp), comm);
  temp = lookup_widget(global.win, "label235");
  sprintf(comm, "%lu", hot.bytes/1024/1024);
  gtk_label_set_text(GTK_LABEL(temp), comm);

  if (!global.status.connected) return;

  // now sharing unshared
  gtk_ctree_post_recursive(ctree, NULL, 
			   (GtkCTreeFunc)rec_add_shared, NULL);
}

file_t* file_create_from_local(char* longname) {
  struct stat buf;
  file_t* new_file;
  char* pos1;

  new_file = (file_t*)malloc(sizeof(file_t));

  new_file->longname = strdup(longname);

  pos1 = extract_short_name(new_file->longname);
  new_file->shortname = strdup(pos1);
  new_file->winname = strdup(new_file->longname);
  convert_to_win(new_file->winname);

  stat(longname, &buf);
  new_file->size = buf.st_size;
  new_file->user = strdup(global.user.username);
  
  new_file->ip = 0;
  new_file->md5 = NULL;

  new_file->bitrate = 0;
  new_file->frequency = 0;
  new_file->length = 0;
  new_file->linespeed = 0;
  new_file->ping = 0;
  new_file->flags = 0;

  return new_file;
}

int lib_load() {
  char filename[1024];
  char line[2048];
  char* pos;
  FILE* fd;
  file_t* file;

  if (global.status.building) return 1;

  sprintf(filename, "%s/shared", global.lopster_home);

  if ((fd = fopen(filename, "r")) != NULL) {
    global.status.building = 1;
    while (fgets(line, 2048-1, fd)) {
      file = (file_t*)malloc(sizeof(file_t));
      pos = strrchr(line, '\"');
      pos[0] = 0;
      file->longname = strdup(line+1);
      file->shortname = strdup(extract_short_name(file->longname));
      file->winname = strdup(file->longname);
      convert_to_win(file->winname);

      pos = strtok(pos+1, " ");
      file->md5 = strdup(pos);
      pos = strtok(NULL, " ");
      file->size = atoi(pos);
      pos = strtok(NULL, " ");
      file->bitrate = atoi(pos);
      pos = strtok(NULL, " ");
      file->frequency = atoi(pos);
      pos = strtok(NULL, " ");
      file->length = atoi(pos);

      file->user = strdup(global.user.username);
      file->ip = 0;
      file->linespeed = 0;
      file->ping = 0;
      file->flags = 0;

      lib_insert_file(file);
    }
    lib_commit();
    global.status.building = 0;
    fclose(fd);
  } else {
    return 0;
  }

  return 1;
}

void lib_insert_file(file_t *file) {
  GtkCTree* ctree;
  GtkWidget* temp;
  char* text;
  char t[500];
  char* pos;
  GtkCTreeNode *node;
  GtkCTreeNode *node2 = NULL;
  file_t* file2;

  //----------------------- new hotlist ctree -------------------------

  file->flags |= FLAG_IN_LIB;

  ctree = GTK_CTREE(lookup_widget(global.win, "lib_tree"));

  tstr[1][0] = tstr[2][0] = tstr[3][0] = tstr[4][0] = 0;

  temp = lookup_widget(global.win, "checkbutton19");
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp)))
    strcpy(t, file->shortname);
  else
    strcpy(t, file->longname);
  
  /////////////////
  pos = strtok(t, "/");
  node = NULL;
  while (pos) {
    if (strlen(pos) <= 0) {
      pos = strtok(NULL, "/");
      continue;
    }
    node2 = node;
    if (!node) node = GTK_CTREE_NODE(GTK_CLIST(ctree)->row_list);
    else node = GTK_CTREE_ROW(node)->children;
    while (node) {
      text = GTK_CELL_PIXTEXT 
	(GTK_CTREE_ROW (node)->row.cell[ctree->tree_column])->text;
      if (strcmp(pos, text) == 0) break;
      node = GTK_CTREE_ROW(node)->sibling;
    }
    if (!node) break;
    if (GTK_CTREE_ROW (node)->is_leaf) break;
    pos = strtok(NULL, "/");
  }
  
  // do not insert identical files
  if (node && GTK_CTREE_ROW (node)->is_leaf) {
    file2 = (file_t*)gtk_ctree_node_get_row_data(ctree, node);    
    if (!strcmp(file2->longname, file->longname)) return;
  }
  
  node = node2;
  do {
    strcpy(tstr[0], pos);
    pos = strtok(NULL, "/");
    if (pos) {
      node = 
	gtk_ctree_insert_node(ctree, node, NULL, list, 5,
			      global.pix.folder, 
			      global.pix.folderb,
			      global.pix.folder_open, 
			      global.pix.folder_openb,
			      FALSE, FALSE);
    } else {
      sprintf(tstr[1], "%.2f MB", (double)(file->size)/1024/1024);
      sprintf(tstr[2], "%d", file->bitrate);
      sprintf(tstr[3], "%d", file->frequency);
      sprintf(tstr[4], "%d:%s%d", file->length/60, 
	      (file->length%60)<10?"0":"", file->length%60);
      
      node = gtk_ctree_insert_node(ctree,
				   node, NULL, list, 5,
				   NULL, NULL, NULL, NULL,
				   TRUE, FALSE);
      
      gtk_ctree_node_set_row_data_full(ctree, node, (gpointer)file,
				       (GtkDestroyNotify)destroy_file_row);
    }
  } while (pos);

}

void lib_update_file(file_t *file) {
  GtkCTree* ctree;
  GtkCTreeNode* node;

  ctree = GTK_CTREE(lookup_widget(global.win, "lib_tree"));
  node = gtk_ctree_find_by_row_data(ctree, NULL, file);  
  if (node == NULL) return;

  sprintf(tstr[0], "%.2f MB", (double)(file->size)/1024/1024);
  gtk_ctree_node_set_text(ctree, node, 1, tstr[0]);
  sprintf(tstr[0], "%d", file->bitrate);
  gtk_ctree_node_set_text(ctree, node, 2, tstr[0]);
  sprintf(tstr[0], "%d", file->frequency);
  gtk_ctree_node_set_text(ctree, node, 3, tstr[0]);
  sprintf(tstr[0], "%d:%s%d", file->length/60, 
	  (file->length%60)<10?"0":"", file->length%60);
  gtk_ctree_node_set_text(ctree, node, 4, tstr[0]);

}


void rec_set_flag (GtkCTree *ctree, GtkCTreeNode *node,
		   int* data) {
  file_t* file;
  
  if (!GTK_CTREE_ROW (node)->is_leaf) return;

  file = gtk_ctree_node_get_row_data(ctree, node);
  file->flags |= (*data);
}

void lib_set_flag(int val, GtkCTreeNode* node) {
  GtkCTree* ctree;
  
  ctree = GTK_CTREE(lookup_widget(global.win, "lib_tree"));
  gtk_ctree_post_recursive(ctree, node, 
			   (GtkCTreeFunc)rec_set_flag, &val);
}

void rec_del_flag (GtkCTree *ctree, GtkCTreeNode *node,
		   int* data) {
  file_t* file;
  
  if (!GTK_CTREE_ROW (node)->is_leaf) return;

  file = gtk_ctree_node_get_row_data(ctree, node);
  file->flags &= (0xff^(*data));
}

void lib_del_flag(int val, GtkCTreeNode* node) {
  GtkCTree* ctree;

  ctree = GTK_CTREE(lookup_widget(global.win, "lib_tree"));
  gtk_ctree_post_recursive(ctree, node, 
			   (GtkCTreeFunc)rec_del_flag, &val);
}

void rec_search (GtkCTree *ctree, GtkCTreeNode *node,
		 char* data) {
  file_t* file;

  if (!GTK_CTREE_ROW (node)->is_leaf) return;

  file = gtk_ctree_node_get_row_data(ctree, node);
  if (!strcmp(data, file->longname)) {
    global_file = file;
  }
}

file_t* lib_search_file(char* longname) {
  GtkCTree* ctree;

  global_file = NULL;
  ctree = GTK_CTREE(lookup_widget(global.win, "lib_tree"));
  gtk_ctree_post_recursive(ctree, NULL, 
			   (GtkCTreeFunc)rec_search,
			   longname);
  return global_file;
}

