#include <stdio.h>
#include <string.h>
#include <sys/time.h>
#include <stdlib.h>

#include <gtk/gtk.h>

#include "connection.h"
#include "global.h"
#include "hotlist.h"
#include "support.h"
#include "chat.h"
#include "mail.h"
#include "handler.h"

void add_to_hotlist(char* nick) {
  char* user;
  GtkWidget* temp;
  hot_t* data;
  GtkCTreeNode* node;

  user = is_string_in_list(global.hotlist, nick);
  if (user) {
    client_message("message", "User <%s> is already in hotlist", nick);
    return;
  }

  global.hotlist = 
    g_list_insert_sorted(global.hotlist, strdup(nick),
			 (GCompareFunc)strcasecmp);


  temp = lookup_widget(global.win, "hot_tree");
  strcpy(tstr[0], nick);
  tstr[1][0] = tstr[2][0] = tstr[3][0] = tstr[4][0] = 0;
  node = 
    gtk_ctree_insert_node(GTK_CTREE(temp), 
			  NULL, NULL, list, 5,
			  global.pix.dummy,
			  global.pix.dummyb,
			  global.pix.dummy,
			  global.pix.dummyb,
			  FALSE, FALSE);

  data = (hot_t*)malloc(sizeof(hot_t));
  data->files = 0;
  data->bytes = 0;
  gtk_ctree_node_set_row_data_full(GTK_CTREE(temp), node, (gpointer)data,
				   NULL);
  
  if (global.status.connected) send_command(CMD_CLIENT_ADD_HOTLIST, nick);
}

void remove_from_hotlist(char* nick) {
  char* user;
  GtkCTreeNode *node;
  GtkCTree* ctree;
  GtkWidget* temp;
  hot_t* data;
  hot_t* data2;

  user = is_string_in_list(global.hotlist, nick);
  if (!user) {
    client_message("message", "User <%s> is not in hotlist", user);
    return;
  }

  global.hotlist = g_list_remove(global.hotlist, user);

  node = is_user_in_hotlist(user);
  if (node) {
    ctree = GTK_CTREE(lookup_widget(global.win, "hot_tree"));

    data = gtk_ctree_node_get_row_data(ctree, node);
    temp = lookup_widget(global.win, "hot_tree");
    data2 = (hot_t*)gtk_object_get_data(GTK_OBJECT(temp), "stats");
    data2->files -= data->files;
    data2->bytes -= data->bytes;
    hotlist_update_stats();

    gtk_ctree_remove_node(ctree, node);
  }

  if (global.status.connected) {
    send_command(CMD_CLIENT_REMOVE_HOTLIST, nick);
  }
}

file_t* file_create_from_browse_response(char* data) {
  char* pos1;
  char* pos2;
  file_t* file;

  file = (file_t*)malloc(sizeof(file_t));

  pos1 = data;
  pos2 = strchr(data, ' ');
  pos2[0] = '\0';
  file->user = strdup(pos1);

  data = pos2+1;
  pos1 = strchr(data, '\"')+1;
  pos2 = strrchr(data, '\"');
  pos2[0] = '\0';
  file->winname = strdup(pos1);

  pos1 = pos2+2;
  pos2 = strchr(pos1, ' ');
  pos2[0] = 0;
  file->md5 = strdup(pos1);

  pos1 = pos2+1;
  pos2 = strchr(pos1, ' ');
  pos2[0] = 0;
  sscanf(pos1, "%ld", &(file->size));

  pos1 = pos2+1;
  pos2 = strchr(pos1, ' ');
  pos2[0] = 0;
  sscanf(pos1, "%d", &(file->bitrate));

  pos1 = pos2+1;
  pos2 = strchr(pos1, ' ');
  pos2[0] = 0;
  sscanf(pos1, "%d", &(file->frequency));

  pos1 = pos2+1;
  sscanf(pos1, "%d", &(file->length));

  file->longname = strdup(file->winname);
  convert_to_unix(file->longname);
  pos1 = extract_short_name(file->longname);
  file->shortname = strdup(pos1);

  file->ping = -1;
  file->flags = 0;
  file->linespeed = 0;

  return file;
}

void cmd_browse_response(char* data) {
  file_t* file;

  file = file_create_from_browse_response(data);
  file_insert_hotlist(file);
}

void cmd_browse_end(char* nick) {
  GtkCTreeNode* node;
  GtkCTree* ctree;

  ctree = GTK_CTREE(lookup_widget(global.win, "hot_tree"));
  node = is_user_in_hotlist(nick);
  
  if (!node) return;
  
  gtk_ctree_sort_recursive(ctree, node);
}

void cmd_hotlist_ack(char* data) {
  GtkCTree* ctree;
  GtkCTreeNode* node;
  char t[500];

  sscanf(data, "%s", t);

  ctree = GTK_CTREE(lookup_widget(global.win, "hot_tree"));
  node = is_user_in_hotlist(t);
  if (node) {
    gtk_ctree_set_node_info(ctree, node, t, 5,
			    global.pix.user2, 
			    global.pix.user2b,
			    global.pix.user2, 
			    global.pix.user2b,
			    0, 0);
  } else {
    g_warning("user not in hotlist");
  }
}

void cmd_hotlist_error(char* data) {
  client_message("error", data);
}

GtkCTreeNode* is_user_in_hotlist(char* user) {
  GtkCTree* ctree;
  char* text;
  GtkCTreeNode *node;
  
  ctree = GTK_CTREE(lookup_widget(global.win, "hot_tree"));

  node = GTK_CTREE_NODE(GTK_CLIST(ctree)->row_list);
  while(node) {
    text = GTK_CELL_PIXTEXT 
      (GTK_CTREE_ROW (node)->row.cell[ctree->tree_column])->text;
    if (!strcasecmp(user, text)) return node;
    node = GTK_CTREE_ROW(node)->sibling;
  }

  return NULL;
}

void file_insert_hotlist(file_t *file) {
  GtkCTree* ctree;
  GtkWidget* temp;
  char* text;
  char t[500];
  char* pos;
  GtkCTreeNode *node;
  GtkCTreeNode *node_update;
  GtkCTreeNode *node2 = NULL;
  hot_t *data;
  file_t* file2;

  //----------------------- new hotlist ctree -------------------------

  ctree = GTK_CTREE(lookup_widget(global.win, "hot_tree"));

  tstr[1][0] = tstr[2][0] = tstr[3][0] = tstr[4][0] = 0;

  if ((node = is_user_in_hotlist(file->user)) == NULL) {
    g_warning("User [%s] not found in hotlist", file->user);
    return;
  }
  
  node_update = node;

  temp = lookup_widget(global.win, "checkbutton18");
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp)))
    strcpy(t, file->shortname);
  else
    strcpy(t, file->longname);
  
  //  strcpy(t, file->shortname);

  /////////////////
  pos = strtok(t, "/");
  while (pos) {
    if (strlen(pos) <= 0) {
      pos = strtok(NULL, "/");
      continue;
    }
    node2 = node;
    node = GTK_CTREE_ROW(node)->children;
    while (node) {
      text = GTK_CELL_PIXTEXT 
	(GTK_CTREE_ROW (node)->row.cell[ctree->tree_column])->text;
      if (strcmp(pos, text) == 0) break;
      node = GTK_CTREE_ROW(node)->sibling;
    }
    if (!node) break;
    if (GTK_CTREE_ROW (node)->is_leaf) break;
    pos = strtok(NULL, "/");
  }
  
  // do not insert identical files
  if (node && GTK_CTREE_ROW (node)->is_leaf) {
    file2 = (file_t*)gtk_ctree_node_get_row_data(ctree, node);    
    if (!strcmp(file2->longname, file->longname)) {
      printf("do not insert [%s]\n", file->longname);
      return;
    }
  }

  data = gtk_ctree_node_get_row_data(ctree, node_update);
  data->files++;
  data->bytes += file->size;
  temp = lookup_widget(global.win, "hot_tree");
  data = (hot_t*)gtk_object_get_data(GTK_OBJECT(temp), "stats");
  data->files++;
  data->bytes += file->size;
  hotlist_update_stats();

  node = node2;
  do {
    strcpy(tstr[0], pos);
    pos = strtok(NULL, "/");
    if (pos) {
      node = 
	gtk_ctree_insert_node(ctree, node, NULL, list, 5,
			      global.pix.folder, 
			      global.pix.folderb,
			      global.pix.folder_open, 
			      global.pix.folder_openb,
			      FALSE, FALSE);
    } else {
      sprintf(tstr[1], "%.2f MB", (double)(file->size)/1024/1024);
      sprintf(tstr[2], "%d", file->bitrate);
      sprintf(tstr[3], "%d", file->frequency);
      sprintf(tstr[4], "%d:%s%d", file->length/60, 
	      (file->length%60)<10?"0":"", file->length%60);
      
      node = gtk_ctree_insert_node(ctree,
				   node, NULL, list, 5,
				   NULL, NULL, NULL, NULL,
				   TRUE, FALSE);
      
      gtk_ctree_node_set_row_data_full(ctree, node, (gpointer)file,
				       (GtkDestroyNotify)destroy_file_row);
    }
  } while (pos);

}

void cmd_user_sign_on(char *data) {
  GtkCTree* ctree;
  GtkCTreeNode* node;
  char t[500];

  sscanf(data, "%s", t);

  ctree = GTK_CTREE(lookup_widget(global.win, "hot_tree"));
  node = is_user_in_hotlist(t);
  if (node) {
    gtk_ctree_set_node_info(ctree, node, t, 5,
			    global.pix.user1, 
			    global.pix.user1b,
			    global.pix.user1, 
			    global.pix.user1b,
			    0, 0);
  } else {
    g_warning("user not in hotlist");
  }
  send_mail(t);
  //  send_command(CMD_CLIENT_BROWSE, t);
}

void cmd_user_sign_off(char *data) {
  GtkCTree* ctree;
  GtkCTreeNode* node;
  char t[500];

  sscanf(data, "%s", t);

  ctree = GTK_CTREE(lookup_widget(global.win, "hot_tree"));
  node = is_user_in_hotlist(t);
  if (node) {
    gtk_ctree_set_node_info(ctree, node, t, 5,
			    global.pix.user2, 
			    global.pix.user2b,
			    global.pix.user2, 
			    global.pix.user2b,
			    0, 0);
  } else {
    g_warning("user not in hotlist");
  }
}

void make_hot_glist (GtkCTree *ctree, GtkCTreeNode *node,
		     char* data) {
  file_t* file;
  GtkCList* clist;
  int row;
  char (*compare_func)(const char* str1, const char *str2);
  GtkToggleButton* temp;

  clist = GTK_CLIST(lookup_widget(global.win, "clist5"));
  temp = 
    GTK_TOGGLE_BUTTON(lookup_widget(global.win, "checkbutton17"));
  if (gtk_toggle_button_get_active(temp)) compare_func = strstr;
  else compare_func = strcasestr;

  if (GTK_CTREE_ROW (node)->is_leaf) {
    file = gtk_ctree_node_get_row_data(ctree, node);
    if (compare_func(file->longname, data)) {
      strcpy(tstr[0], file->user);
      strcpy(tstr[1], file->shortname);
      sprintf(tstr[2], "%.2f MB", (double)(file->size)/1024/1024);
      sprintf(tstr[3], "%d", file->bitrate);
      sprintf(tstr[4], "%d", file->frequency);
      sprintf(tstr[5], "%d:%s%d", file->length/60, 
	      (file->length%60)<10?"0":"", file->length%60);
      row = gtk_clist_append(clist, list);
      gtk_clist_set_row_data_full (clist, row, (gpointer)file, NULL);
    }
  }
}

void hotlist_search(char* expression) {
  GtkCTree* ctree;

  printf("hotlist_search\n");
  ctree = GTK_CTREE(lookup_widget(global.win, "hot_tree"));

  gtk_ctree_post_recursive(ctree, NULL, (GtkCTreeFunc)make_hot_glist,
			   (gpointer)expression);
  
}

void hotlist_update_stats() {
  GtkWidget* temp;
  hot_t* data;
  char str[1024];

  temp = lookup_widget(global.win, "hot_tree");
  data = (hot_t*)gtk_object_get_data(GTK_OBJECT(temp), "stats");

  temp = lookup_widget(global.win, "label229");
  sprintf(str, "%d", data->files);
  gtk_label_set_text(GTK_LABEL(temp), str);
  temp = lookup_widget(global.win, "label231");
  sprintf(str, "%lu", data->bytes/1024/1024);
  gtk_label_set_text(GTK_LABEL(temp), str);
}
