#include <stdio.h>
#include <string.h>
#include <dirent.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <gtk/gtk.h>
#include "support.h"
#include "dirselect.h"
#include "connection.h"
#include "global.h"

int exist_subdirs(char* dirname) {
  DIR* dir;
  struct dirent* entry;
  struct stat buf;
  char name[1024];

  if ((dir = opendir(dirname)) == NULL) return 0;
  while ((entry = readdir(dir)) != NULL) {
    if (!strncmp(entry->d_name, ".", 1)) continue;
    if (!strncmp(entry->d_name, "..", 2)) continue;
    
    strcpy(name, dirname);
    strcat(name, "/");
    strcat(name, entry->d_name);
    stat(name, &buf);
    if (S_ISDIR(buf.st_mode)) {
      closedir(dir);
      return 1;
    }
  }
  closedir(dir);

  return 0;
}

void insert_subdirs(GtkCTree* ctree, GtkCTreeNode* node) {
  DIR* dir;
  char name[1024];
  char* longname;
  struct dirent* entry;
  struct stat buf;
  int cnt;
  GtkCTreeNode* n;

  longname = gtk_ctree_node_get_row_data(ctree, node);

  if (GTK_CTREE_ROW(node)->children) return;

  if ((dir = opendir(longname)) == NULL) return;

  while ((entry = readdir(dir)) != NULL) {
    if (!strncmp(entry->d_name, ".", 1)) continue;
    if (!strncmp(entry->d_name, "..", 2)) continue;
    
    strcpy(name, longname);
    if (name[strlen(name)-1] != '/') strcat(name, "/");
    strcat(name, entry->d_name);
    stat(name, &buf);
    if (S_ISDIR(buf.st_mode)) {
      strcpy(list[0], entry->d_name);
      cnt = exist_subdirs(name);
      if (cnt) {
	n = gtk_ctree_insert_node(ctree, node, NULL, list, 5, 
				  global.pix.folder, 
				  global.pix.folderb,
				  global.pix.folder_open, 
				  global.pix.folder_openb,
				  FALSE, FALSE);
      } else {
	n = gtk_ctree_insert_node(ctree, node, NULL, list, 5, 
				  global.pix.folder, 
				  global.pix.folderb,
				  global.pix.folder_open, 
				  global.pix.folder_openb,
				  TRUE, FALSE);
      }
      gtk_ctree_node_set_row_data(ctree, n, strdup(name));
    }
  }
  closedir(dir);
  gtk_ctree_sort_node(ctree, node);
}

void
on_ctree1_tree_expand                  (GtkCTree        *ctree,
                                        GtkCTreeNode    *node,
                                        gpointer         user_data)
{
  GtkCTreeNode* n;

  n = GTK_CTREE_ROW(node)->children;
  while (n) {
    insert_subdirs(ctree, n);
    n = GTK_CTREE_ROW(n)->sibling;
  }
}

void update_dir_tree() {
  GtkCTreeNode* node;
  GtkCTree* ctree;
  DIR* dir;
  int cnt;

  ctree = GTK_CTREE(lookup_widget(global.dir_select_win, "ctree1"));
  node = GTK_CTREE_NODE(GTK_CLIST(ctree)->row_list);
  if (node) gtk_ctree_remove_node(ctree, node);
  node = NULL;

  strcpy(list[0], "/");

  if ((dir = opendir(list[0])) == NULL) {
    printf("could not open [%s]\n", list[0]);
    return ;
  }

  cnt = exist_subdirs(list[0]);
  
  if (cnt > 0) {
    node = gtk_ctree_insert_node(ctree, node, NULL, list, 5, 
				 global.pix.folder, 
				 global.pix.folderb,
				 global.pix.folder_open, 
				 global.pix.folder_openb,
				 FALSE, TRUE);
    gtk_ctree_node_set_row_data(ctree, node, strdup(list[0]));
    insert_subdirs(ctree, node);
    gtk_ctree_expand(ctree, node);
  } else {
    node = gtk_ctree_insert_node(ctree, node, NULL, list, 5, 
				 global.pix.folder, 
				 global.pix.folderb,
				 global.pix.folder_open, 
				 global.pix.folder_openb,
				 TRUE, FALSE);
    gtk_ctree_node_set_row_data(ctree, node, strdup(list[0]));
  }
  
  closedir(dir);
}
