#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <sys/time.h>
#include <string.h>
#include <fcntl.h>
#include <errno.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>

#include "support.h"
#include "connection.h"
#include "global.h"
#include "transfer.h"
#include "handler.h"
#include "log.h"
#include "share.h"

void connection_close(socket_t* socket, char* reason) {
  GtkStatusbar* status;
  GtkWidget* temp;
  char* t;

  if (global.status.connecting) {
    status = GTK_STATUSBAR(lookup_widget(global.connect_win, "connect_status"));
    gtk_statusbar_push(status, 1, reason);
    temp = lookup_widget(global.connect_win, "connection_ok");
    gtk_widget_set_sensitive(temp, TRUE);
  }

  if (reason)
    client_message("message", reason);

  // delete private users
  if (global.private_users) {
    g_list_free(global.private_users);
    global.private_users = NULL;
  }

  // delete ignored users
  if (global.ignored_users) {
    g_list_free(global.ignored_users);
    global.ignored_users = NULL;

    if (global.ignore_win) {
      temp = lookup_widget(global.ignore_win, "ignore_list");
      gtk_clist_clear(GTK_CLIST(temp));
    }
  }
  
  // delete search hotlist
  temp = lookup_widget(global.win, "clist5");
  gtk_clist_clear(GTK_CLIST(temp));

  {
    GtkCTree* ctree;
    GtkCTreeNode *node;
    
    ctree = GTK_CTREE(lookup_widget(global.win, "hot_tree"));
    
    node = GTK_CTREE_NODE(GTK_CLIST(ctree)->row_list);
    while(node) {
      t = strdup(GTK_CELL_PIXTEXT(GTK_CTREE_ROW (node)->row.cell[ctree->tree_column])->text);
      gtk_ctree_set_node_info(ctree, node, t, 5,
			      global.pix.dummy, 
			      global.pix.dummyb,
			      global.pix.dummy, 
			      global.pix.dummyb,
			      0, 0);
      node = GTK_CTREE_ROW(node)->sibling;
      free(t);
    }
  }

  temp = lookup_widget(global.win, "menu_connect");
  temp = GTK_BIN(temp)->child;
  gtk_label_set_text(GTK_LABEL(temp), "Connect");

  // delete search
  temp = lookup_widget(global.win, "search_list");
  gtk_clist_clear(GTK_CLIST(temp));

  // closing socket
  if (socket->input >= 0) {
    gdk_input_remove(socket->input);
    socket->input = -1;
  }
  if (socket->timeout >= 0) {
    gtk_timeout_remove(socket->timeout);
    socket->timeout = -1;
  }
  global.status.connecting = 0;
  global.status.connected = 0;
  global.status.searching = 0;
  global.status.whois_hide = 0;

  global.user.status = STATUS_INACTIVE;
  update_user_stats();
  
  lib_del_flag(FLAG_SHARED, NULL);

  close(socket->fd);
}

int connection_timeout(gpointer data) {
  socket_t* socket;

  socket = (socket_t*)data;
  
  if (socket->cnt>= socket->max_cnt) {
    connection_close(socket, "Timed out!");
    return 1;
  }
  socket->cnt++;

  return 1;
}

int connect_napster() {
  GtkStatusbar* status;
  GtkWidget* temp;
  char* text;
  char* pos1;

  status = GTK_STATUSBAR(lookup_widget(global.connect_win, "connect_status"));

  if (global.status.connected || global.status.connecting) {
    return -1;
  }
  global.status.connecting = 1;

  temp = lookup_widget(global.connect_win, "combo_entry12");
  text = strdup(gtk_entry_get_text(GTK_ENTRY(temp)));
  
  if (!strcasecmp("Official Server", text)) {
    free(text);
    gtk_statusbar_push(status, 1, " Searching for best Server...");
    if (get_best_server() != 0) {
      return -1;
    } else return 0;
  } else if (!strcasecmp("Last Server", text)) {
    free(text);
    if (global.last_server) {
      gtk_statusbar_push(status, 1, " Connecting to last server...");
      global.server.address.ip = strdup(global.last_server->ip);
      global.server.address.ip_long = 
	inet_addr(global.server.address.ip);
      global.server.address.port = global.last_server->port;
      if (global.server.address.description)
	free(global.server.address.description);
      global.server.address.description = strdup("Last Server");

      return connect_to_server();
    } else {
      gtk_statusbar_push(status, 1, " No Last Server found!");
      return -1;
    }
  } else {
    pos1 = strtok(text, ":");
    global.server.address.ip = strdup(pos1);
    global.server.address.ip_long = 
      inet_addr(global.server.address.ip);

    pos1 = strtok(NULL, " ");
    global.server.address.port = atoi(pos1);
    pos1 = strtok(NULL, " ");
    if (global.server.address.description)
      free(global.server.address.description);
    global.server.address.description = strdup(pos1);

    free(text);
    return connect_to_server();
  }

  return 0;
}

int get_best_server() {
  int res;
  GtkStatusbar* status;
  struct hostent* h = NULL;
  char IP[100];

  status = GTK_STATUSBAR(lookup_widget(global.connect_win, "connect_status"));

  h = gethostbyname("server.napster.com");
  if (h)
    sprintf(IP, "%u.%u.%u.%u", 
	    h->h_addr[0] & 0xff,
	    h->h_addr[1] & 0xff,
	    h->h_addr[2] & 0xff,
	    h->h_addr[3] & 0xff);
  else {
    sprintf(IP, "64.124.41.17");
  }
      
#ifdef CONNECTION_DEBUG
  printf("Napster meta server resolved to %s\n", IP);
#endif

  global.server.address.ip = strdup(IP);
  global.server.address.ip_long = inet_addr(global.server.address.ip);
  global.server.address.port = 8875;
  global.server.address.description = NULL;
  res = connect_socket(&global.server);

  if ((res != 0) && (res != EINPROGRESS)) {
    if (res == ENETUNREACH)
      gtk_statusbar_push(status, 1, " Network unreachable");
    else
      gtk_statusbar_push(status, 1, " Cannot connect to Meta Server");
    return -1;
  }
  // receiving best server
  global.server.input =
    gdk_input_add(global.server.fd, GDK_INPUT_READ, 
		  GTK_SIGNAL_FUNC(get_best_server_read), &global.server);
  
  global.server.max_cnt = 20;
  global.server.timeout =
    gtk_timeout_add(1000, connection_timeout, &global.server);

  return 0;
}

int get_best_server_read(gpointer data, 
			 gint source, 
			 GdkInputCondition condition) {
  int length;
  socket_t* socket;
  unsigned char buffer[100+1];
  char* pos;

  socket = (socket_t*)data;

  gdk_input_remove(socket->input);
  socket->input = -1;
  gtk_timeout_remove(socket->timeout);
  socket->timeout = -1;

  while ((length = recv(socket->fd, buffer, 100, 0)) <= 0) {
    if (length <= 0) {
      connection_close(socket, "Could not get best server");
      return 1;
    }
  }  

  buffer[length] = '\0';

  pos = strtok(buffer, ":");
  global.server.address.ip = strdup(pos);
  global.server.address.ip_long = inet_addr(pos);
  
  pos = strtok(NULL, " ");
  global.server.address.port = atoi(pos);

#ifdef CONECTION_DEBUG
  printf("got server [%s][%d]\n", global.server.address.ip,
	 global.server.address.port);
#endif

  if (strcmp(global.server.address.ip, "127.0.0.1")) {
    connection_close(socket, "Got best Server");
    connect_to_server();
  } else {
    connection_close(socket, "Could not get best Server");
    return -1;
  }

  return 1;
}


int connect_to_server() {
  GtkStatusbar* status;
  GtkWidget* temp;
  int res;

  global.status.connecting = 1;

  status = GTK_STATUSBAR(lookup_widget(global.connect_win, "connect_status"));
  gtk_statusbar_push(status, 1, " Connecting to server...");

  res = connect_socket(&(global.server));

  if ((res != 0) && (res != EINPROGRESS)) {
    temp = lookup_widget(global.connect_win, "connection_ok");
    gtk_widget_set_sensitive(temp, TRUE);
    if (res == ENETUNREACH)
      gtk_statusbar_push(status, 1, " Network unreachable");
    else
      gtk_statusbar_push(status, 1, " Cannot connect to server");
    global.status.connecting = 0;
    return -1;
  }

  global.server.input =
    gdk_input_add(global.server.fd, GDK_INPUT_WRITE, 
		  GTK_SIGNAL_FUNC(server_login),
		  &(global.server));  
  global.server.max_cnt = 1000;
  global.server.timeout =
    gtk_timeout_add(1000, connection_timeout, &(global.server));

  return 0;
}

int server_login(gpointer data, gint source, GdkInputCondition condition) {
  GtkStatusbar* status;
  GtkWidget* toggle;
  int res;
  int port;

  gdk_input_remove(global.server.input);

  status = GTK_STATUSBAR(lookup_widget(global.connect_win, "connect_status"));
  gtk_statusbar_push(status, 1, " Logging in...");
  toggle = lookup_widget(global.connect_win, "new_user");

  if (global.network.firewall) port = 0;
  else port = global.network.port;

  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(toggle))) {
    res = send_command(CMD_CLIENT_REGISTER, global.user.username);
    if (send_command(CMD_CLIENT_LOGIN_REGISTER, "%s %s %d \"Lopster %s\" %d %s",
		     global.user.username, global.user.password, port,
		     VERSION, global.network.linespeed, 
		     global.user.email) != 0) {
      connection_close(&global.server, "Could not login...");
      return -1;
    }
  } else {
    if (send_command(CMD_CLIENT_LOGIN, "%s %s %d \"Lopster %s\" %d",
		     global.user.username, global.user.password, port,
		     VERSION, global.network.linespeed) != 0) {
    /*
    if (send_command(CMD_CLIENT_LOGIN, "%s %s %d \"TekNap-1.1\" %d",
		     global.user.username, global.user.password, port,
		     global.network.linespeed) != 0) {
    */
      connection_close(&global.server, "Could not login...");
      return -1;
    }
  }

  global.server.input =
    gdk_input_add(global.server.fd, GDK_INPUT_READ, 
		  GTK_SIGNAL_FUNC(server_get_input),
		  &(global.server));  
  return 0;
}

int server_get_input(gpointer data, gint source, GdkInputCondition condition) {
  static char mess[2048];
  gint16 type;
  socket_t * socket;

  socket = (socket_t*)data;

  type = receive_command(global.server.fd, mess);

  if (type < 0) {
    return 1;
  }

  log("protocol", "R: %4d L: %4d [%s]\n", type, strlen(mess), mess);
  socket->cnt = 0;
  handle_command(type, mess);
  
  return 1;
}


int connect_socket(socket_t* s) {
  int protocol;
  struct sockaddr_in server;
  int sock;
  int res;

  protocol = getprotobyname("IP")->p_proto;
  sock = socket(AF_INET, SOCK_STREAM, protocol);

  if (sock < 0) {
    return -1;
  }
  s->fd = sock;
  s->cnt = 0;

  server.sin_family = AF_INET;
  server.sin_addr.s_addr = s->address.ip_long;
  server.sin_port = htons(s->address.port);
  
  if (server.sin_addr.s_addr == -1) {
    return -1;
  }
  
  fcntl(sock, F_SETFL, O_NONBLOCK);
  res = connect(sock, (struct sockaddr *) &server, sizeof(server));

  return errno;
}

int send_command(gint16 type, const char *fmt, ...) {
  va_list ap;
  unsigned char *msg;
  unsigned char data[2048];
  gint sendt = 0;
  gint16 length;
  gint16 length2;
  int res;

  if (!(global.status.connected || global.status.connecting)) return -1;

  va_start (ap, fmt);
  vsprintf (data, fmt, ap);
  va_end (ap);

  length = strlen(data);
  msg = (gchar *)malloc((length + 5)*sizeof(gchar));

  log("protocol", "S: %4d L: %4d [%s]\n", type, strlen(data), data);

  length2 = BSWAP16(length);
  type = BSWAP16(type);

  memcpy(msg, &length2, 2);
  memcpy(&msg[2], &type, 2);
  memcpy(&msg[4], data, strlen(data));

  msg[length+4] = 0;

  while(sendt < (length+4)) {
    res = send(global.server.fd, msg+sendt, length+4-sendt, 0);
    if (res == -1) {
      g_warning("send error");
      free(msg);
      return -1;
    }
    if (res == 0) {
      g_warning("0 char sent");
    }
    sendt += res;
  }
  free(msg);
  
  return 0;
}

gint16 receive_command(int sock, char* data) {
  int res;
  static int progress = 0;
  static unsigned char buffer[2048];
  static int length = 0;
  static gint16 c_type;
  static gint16 c_length;

  if (progress == 0) {
    if (length < 4) {
      res = recv(sock, buffer+length, 4-length, 0);
      if (res > 0) {
	length += res;
      } else if (res == 0) {
	length = progress = 0;
	connection_close(&global.server, "Remote Close");
      } else {
	g_warning("1 recv error\n");
	length = progress = 0;
	connection_close(&global.server, "Error");
      }      
    }
    if (length == 4) {
      length = 0;
      progress++;
      memcpy(&c_length, buffer, 2);
      memcpy(&c_type, &buffer[2], 2);

      c_length = BSWAP16(c_length);
      c_type = BSWAP16(c_type);
    }
    return -1;
  } 

  if (progress == 1) {
    if (length < c_length) {
      res = recv(sock, buffer+length, c_length-length, 0);
	
      if (res > 0) {
	length += res;
      } else if (res == 0) {
	length = progress = 0;
	connection_close(&global.server, "Remote Close");
      } else {
	g_warning("2 recv error\n");
      }
    }
    if (length == c_length) {
      buffer[length] = '\0';
      strcpy(data, buffer);
      progress = 0;
      length = 0;
      return c_type;
    }
  }

  return -1;
}

int handle_upload_request(gpointer data, gint source, 
			  GdkInputCondition condition) {
  
  struct sockaddr_in from;
  int len;
  transfer_t* transfer;

  transfer = transfer_new();
  transfer->status = S_CONNECTING;

  len = sizeof(from);
  transfer->sock.fd =
    accept(global.upload_socket.fd, (struct sockaddr *)&from, &len);
  if (transfer->sock.fd < 0) {
    free(transfer);
    return 1;
  }
  fcntl(transfer->sock.fd, F_SETFL, O_NONBLOCK);
  
  send(transfer->sock.fd, "1", 1, 0);

  transfer->sock.input = 
    gdk_input_add(transfer->sock.fd, GDK_INPUT_READ, 
		  GTK_SIGNAL_FUNC(incoming_header), transfer);
  
  return 1;
}

void create_upload_port(int send) {
  int len = 1;
  int sock;
  int protocol;
  struct sockaddr_in server;
  
  if (global.upload_socket.fd >= 0) {
    if (global.upload_socket.input > 0)
      gdk_input_remove(global.upload_socket.input);
    close(global.upload_socket.fd);
  }
  if (send) {
    if ((global.network.port == 0) || global.network.firewall) {
      if (global.status.connected) {
	send_command(CMD_CLIENT_CHANGE_DATA_PORT, "0");
      }
      return;
    }
  }

  protocol = getprotobyname("IP")->p_proto;
  sock = socket(AF_INET, SOCK_STREAM, protocol);

  if (sock < 0) return;

  global.upload_socket.address.ip = strdup("127.0.0.1");
  global.upload_socket.address.ip_long = htonl(INADDR_ANY);
  global.upload_socket.address.port = global.network.port;
  global.upload_socket.fd = sock;
  global.upload_socket.cnt = 0;

  server.sin_family = AF_INET;
  server.sin_addr.s_addr = global.upload_socket.address.ip_long;
  server.sin_port = htons(global.upload_socket.address.port);

  setsockopt(sock, SOL_SOCKET, SO_REUSEADDR, &len, sizeof(len));

  if (bind(sock, (struct sockaddr *)&server, sizeof(server)) < 0) {
    close(sock);
    g_warning("bind error\n");
    return;
  }
  listen(sock, 10 + global.network.max_uploads);

  log("protocol", "Listen for incoming connections on port [%d]\n", global.upload_socket.address.port);

  if (send && global.status.connected) {
    send_command(CMD_CLIENT_CHANGE_DATA_PORT, "%d", global.upload_socket.address.port);
  }

  global.upload_socket.input = 
    gdk_input_add(sock, GDK_INPUT_READ,
		  GTK_SIGNAL_FUNC(handle_upload_request), NULL);

  return;
}
