#define C_NONE               0
#define C_WHISPER            1
#define C_WHOIS              2
#define C_EMOTE              3
#define C_JOIN               4
#define C_SEND               6
#define C_HELP               7
#define C_BAN                8
#define C_BROWSE             9
#define C_CHLEVEL           10
#define C_CLEAR             11
#define C_CLOAK             12
#define C_CONN              13
#define C_DATAPORT          14
#define C_DEOP              15
#define C_DISC              16
#define C_EMAIL             17
#define C_KICK              19
#define C_KILL              20
#define C_KILLSERV          21  
#define C_LEVEL             22
#define C_LINK              23
#define C_LINKS             24
#define C_LIST              25
#define C_LISTBANS          26  
#define C_ME                27
#define C_MSG               28
#define C_MOTD              29
#define C_MUZZLE            30
#define C_NOTIFY            31
#define C_OP                33
#define C_OPLIST            34  
#define C_WALLOP            35
#define C_PART              36
#define C_PASSWORD          37  
#define C_PING              38
#define C_QINFO             39
#define C_QUIT              40
#define C_REMSERV           41 
#define C_SEARCH            42
#define C_SERVER            43
#define C_SHOWPATH          44
#define C_SPEED             45
#define C_STATS             46
#define C_TOPIC             47
#define C_ULADD             48
#define C_ULDIRS            49
#define C_ULREM             50
#define C_ULSTATS           51
#define C_UNBAN             52
#define C_UNLINK            53
#define C_UNMUZZLE          54
#define C_UNREG             55
#define C_USERMODE          56 
#define C_USERNAME          57
#define C_VERSION           58
#define C_SCHEME            59
#define C_ALIAS             60
#define C_AFK               62
#define C_PUBLIC            64
#define C_REPLY             65
#define C_PRIVATE           66
#define C_MAIL              67
#define C_DELMAIL           68
#define C_IGNORE            69
#define C_CHCLEAR           70
#define C_UNIGNORE          71
#define C_CHBAN             72
#define C_CHUNBAN           73
#define C_NUKE              74
#define C_UNNUKE            75
#define C_GLOBAL            76
#define C_CVERSION          77
#define C_ECHO              78
#define C_CHLIMIT           79
#define C_SSTATS            80
#define C_CHMODE            81
#define C_SPING             82
#define C_CHWALLOP          83
#define C_DROP              84
#define C_TEST              85
#define C_KILLGHOST         86
#define C_FRIEND            87
#define C_ENEMY             88
#define C_HOTADD            89
#define C_HOTREM            90

typedef enum {
  L_LEECH,
  L_USER,
  L_MOD,
  L_ADMIN,
  L_ELITE
} level_t;

typedef enum {
  F_CHAT,
  F_UMOD,
  F_INFO,
  F_MISC,
  F_OP,
  F_MOD,
  F_CLIENT
} folder_t;

#define NO_FOLDERS          7

extern const char FolderNames[NO_FOLDERS][64];

typedef struct {
  char* name;            // name of the command
  char* syntax;          // syntax
  char* description;     // description or (see....) if alias
  level_t level;
  folder_t folder;
  int id;                // command id
  int is_alias;          // 1 if alias otherwise 0
} command_t;

int command_new(int id, char* iname, char* syntax, char* ides,
		level_t level, folder_t ifolder);
int command_rename(int iid, char* iname);
GList* command_search(char* prefix);
command_t* command_is_command(char* iname);
char* command_get_alias_string(int id);
int command_make_alias(char* iname, char* alias);
void command_delete_alias_for(int id);
void command_delete_all();
