#include <string.h>
#include <stdio.h>
#include <sys/time.h>
#include <stdlib.h>
#include <gtk/gtk.h>

#include "connection.h"
#include "global.h"
#include "search.h"
#include "handler.h"
#include "support.h"

void update_search_stats() {
  GtkWidget* temp;
  int i1;
  char t[1024];

  temp = lookup_widget(global.win, "search_list");
  i1 = GTK_CLIST(temp)->rows;
  temp = lookup_widget(global.win, "search_entry");
  if (global.status.searching > 0) {
    sprintf(t, "%d search results....searching (%d)...", i1, global.status.searching);
  } else {
    sprintf(t, "%d search results", i1);
  }
  gtk_entry_set_text(GTK_ENTRY(temp), t);
}

void cmd_search_response(char* data) {
  file_t* file;

  file = file_create_from_search_response(data);
  file_insert_search(file);
  update_search_stats();
}

void cmd_end_of_search() {

  if (global.status.searching == 0) return;

  global.status.searching--;
  update_search_stats();
}

file_t* file_create_from_search_response(char* data) {
  file_t* new_file;
  char* pos1;
  char* pos2;

  new_file = (file_t*)malloc(sizeof(file_t));

  pos1 = strchr(data, '\"')+1;
  pos2 = strrchr(data, '\"');
  pos2[0] = '\0';
  new_file->winname = strdup(pos1);

  pos1 = pos2+2;
  pos2 = strchr(pos1, ' ');
  pos2[0] = 0;
  new_file->md5 = strdup(pos1);

  pos1 = pos2+1;
  pos2 = strchr(pos1, ' ');
  pos2[0] = 0;
  sscanf(pos1, "%ld", &(new_file->size));

  pos1 = pos2+1;
  pos2 = strchr(pos1, ' ');
  pos2[0] = 0;
  sscanf(pos1, "%d", &(new_file->bitrate));

  pos1 = pos2+1;
  pos2 = strchr(pos1, ' ');
  pos2[0] = 0;
  sscanf(pos1, "%d", &(new_file->frequency));

  pos1 = pos2+1;
  pos2 = strchr(pos1, ' ');
  pos2[0] = 0;
  sscanf(pos1, "%d", &(new_file->length));

  pos1 = pos2+1;
  pos2 = strchr(pos1, ' ');
  pos2[0] = 0;
  new_file->user = strdup(pos1);

  pos1 = pos2+1;
  pos2 = strchr(pos1, ' ');
  pos2[0] = 0;
  sscanf(pos1, "%lu", &(new_file->ip));

  pos1 = pos2+1;
  sscanf(pos1, "%d", &(new_file->linespeed));
  
  new_file->longname = strdup(new_file->winname);
  convert_to_unix(new_file->longname);
  pos1 = extract_short_name(new_file->longname);
  new_file->shortname = strdup(pos1);

  new_file->ping = -1;
  new_file->flags = 0;

  return new_file;
}

void send_search_request(gboolean local) {
  GtkWidget* temp;
  char data[1024];
  char str[500];
  char str2[500];
  char str3[500];
  int val1, val2;

  if (!global.status.connected) {
    g_warning("not connected!");
    return;
  }
  global.status.searching++;

  update_search_stats();

  data[0] = 0;
  temp = lookup_widget(global.win, "search_artist");
  strcpy(str, gtk_entry_get_text(GTK_ENTRY(temp)));
  if (strlen(str) > 0) {
    sprintf(str2, "FILENAME CONTAINS \"%s\" ", str);
    strcat(data, str2);
  }
  temp = lookup_widget(global.win, "search_results");
  sprintf(str, "%d", 
	  gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(temp)));
  sprintf(str2, "MAX_RESULTS %s", str);
  strcat(data, str2);
  
  temp = lookup_widget(global.win, "combo_speed");
  strcpy(str, gtk_entry_get_text(GTK_ENTRY(temp)));
  if (strlen(str) > 0) {
    temp = lookup_widget(global.win, "combo_speed2");
    strcpy(str2, gtk_entry_get_text(GTK_ENTRY(temp)));
    if (strlen(str2) > 0) {
      sprintf(str3, " LINESPEED \"%s\" %d", str, speed2int(str2));
      strcat(data, str3);
    }
  }

  temp = lookup_widget(global.win, "combo_bitrate");
  strcpy(str, gtk_entry_get_text(GTK_ENTRY(temp)));
  if (strlen(str) > 0) {
    temp = lookup_widget(global.win, "combo_bitrate2");
    strcpy(str2, gtk_entry_get_text(GTK_ENTRY(temp)));
    if (strlen(str2) > 0) {
      sprintf(str3, " BITRATE \"%s\" \"%s\"", str, str2);
      strcat(data, str3);
    }
  }

  temp = lookup_widget(global.win, "combo_freq");
  strcpy(str, gtk_entry_get_text(GTK_ENTRY(temp)));
  if (strlen(str) > 0) {
    temp = lookup_widget(global.win, "combo_freq2");
    strcpy(str2, gtk_entry_get_text(GTK_ENTRY(temp)));
    if (strlen(str2) > 0) {
      sprintf(str3, " FREQ \"%s\" \"%s\"", str, str2);
      strcat(data, str3);
    }
  }

  temp = lookup_widget(global.win, "entry71");
  strcpy(str, gtk_entry_get_text(GTK_ENTRY(temp)));
  if (strlen(str) > 0) {
    temp = lookup_widget(global.win, "spinbutton12");
    val1 = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(temp));
    temp = lookup_widget(global.win, "spinbutton13");
    val2 = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(temp));
    sprintf(str3, " DURATION \"%s\" \"%d\"", str, val1*60+val2);
    strcat(data, str3);
  }

  temp = lookup_widget(global.win, "entry70");
  strcpy(str, gtk_entry_get_text(GTK_ENTRY(temp)));
  if (strlen(str) > 0) {
    temp = lookup_widget(global.win, "spinbutton10");
    val1 = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(temp));
    temp = lookup_widget(global.win, "spinbutton11");
    val2 = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(temp));
    sprintf(str3, " SIZE \"%s\" \"%d\"", str, (val1*1024+val2)*1024);
    strcat(data, str3);
  }

  temp = lookup_widget(global.win, "entry69");
  strcpy(str, gtk_entry_get_text(GTK_ENTRY(temp)));
  if (strlen(str) > 0) {
    sprintf(str2, " FILENAME EXCLUDES \"%s\"", str);
    strcat(data, str2);
  }
  
  if (local) strcat(data, " LOCAL");

  send_command(CMD_CLIENT_SEARCH, data);
}

void file_insert_search(file_t *file) {
  GtkWidget* temp;
  int row;
  GdkPixmap *pixmap = NULL;
  GdkBitmap *bitmap = NULL;
  
  temp = lookup_widget(global.win, "search_list");
  
  strcpy(tstr[0], file->shortname);
  sprintf(tstr[1], "%.2f MB", (double)(file->size)/1024/1024);
  sprintf(tstr[2], "%d", file->bitrate);
  sprintf(tstr[3], "%d:%s%d", file->length/60, 
	  (file->length%60)<10?"0":"", file->length%60);
  strcpy(tstr[4], file->user);
  strcpy(tstr[5], LineSpeed[file->linespeed]);
  strcpy(tstr[6], "unknown");

  row = gtk_clist_append(GTK_CLIST(temp), &list[0]);
  gtk_clist_set_row_data_full (GTK_CLIST(temp), row,
			       (gpointer)file,
			       (GtkDestroyNotify)destroy_file_row);

  if (file->linespeed > 10 || file->linespeed < 1) {
    pixmap = global.pix.sgray;
    bitmap = global.pix.sgrayb;
  } else if (file->linespeed <= 3) {
    pixmap = global.pix.sred;
    bitmap = global.pix.sredb;
  } else if (file->linespeed <= 6) {
    pixmap = global.pix.syellow;
    bitmap = global.pix.syellowb;
  } else if (file->linespeed <= 10) {
    pixmap = global.pix.sgreen;
    bitmap = global.pix.sgreenb;
  } else {
    pixmap = global.pix.sgray;
    bitmap = global.pix.sgrayb;
  }

  gtk_clist_set_pixtext (GTK_CLIST(temp), row, 0,
			 tstr[0], 5, pixmap, bitmap);
}

