#include <gtk/gtk.h>
#include <sys/stat.h>
#include <dirent.h>
#include <sys/time.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "connection.h"
#include "global.h"
#include "scheme.h"
#include "support.h"

GList* scheme_set_up_default(GList* scheme) {
  scheme = style_new(scheme, "text", "#c5c5c5", "NULL", "NULL", 0);
  scheme = style_new(scheme, "user", "#007de7", "NULL", "NULL", 0);
  scheme = style_new(scheme, "yourself", "#e5cf00", "NULL", "NULL", 0);
  scheme = style_new(scheme, "friend", "#de5a6a", "NULL", "NULL", 0);
  scheme = style_new(scheme, "whisper", "#ff5001", "#151515", "NULL", 0);
  scheme = style_new(scheme, "join", "#007f26", "NULL", "NULL", 0);
  scheme = style_new(scheme, "part", "#007f26", "NULL", "NULL", 0);
  scheme = style_new(scheme, "error", "#ff0000", "NULL", "NULL", 0);
  scheme = style_new(scheme, "message", "#ff8600", "NULL", "NULL", 0);
  scheme = style_new(scheme, "highlight", "#71de00", "NULL", "NULL", 0);
  scheme_save(scheme, "default");
  if (scheme == global.colors) {
    free(global.scheme);
    global.scheme = strdup("default");
  }
  return scheme;
}

GList* scheme_load(GList* scheme, char* name) {
  char filename[2048];
  char temp[2048];
  char temp2[2048];
  char* pos;
  char* sname;
  char* sfore;
  char* sback;
  char* sfont;
  FILE* file;
  
  strcpy(temp2, name);
  sprintf(filename, "%s/schemes/%s", global.lopster_home, temp2);

  ///////////////////////
  if (!scheme_is_valid(temp2)) {
    g_warning("scheme [%s] not valid, loading default", temp2);
    if (!scheme_is_valid("default")) {
      g_warning("scheme [default] not valid, setting up default");
      scheme = scheme_set_up_default(scheme);
    } else {
      if ((scheme = scheme_load(scheme, "default")) == NULL) {
	g_warning("could not load scheme [default] setting up default");
	scheme = scheme_set_up_default(scheme);
      }
    }
  } else {
    scheme = style_new(scheme, "text", "NULL", "NULL", "NULL", 0);
    scheme = style_new(scheme, "user", "NULL", "NULL", "NULL", 0);
    scheme = style_new(scheme, "yourself", "NULL", "NULL", "NULL", 0);
    scheme = style_new(scheme, "friend", "NULL", "NULL", "NULL", 0);
    scheme = style_new(scheme, "whisper", "NULL", "NULL", "NULL", 0);
    scheme = style_new(scheme, "join", "NULL", "NULL", "NULL", 0);
    scheme = style_new(scheme, "part", "NULL", "NULL", "NULL", 0);
    scheme = style_new(scheme, "error", "NULL", "NULL", "NULL", 0);
    scheme = style_new(scheme, "message", "NULL", "NULL", "NULL", 0);
    scheme = style_new(scheme, "highlight", "NULL", "NULL", "NULL", 0);

    file = fopen(filename, "r");
    if (file == NULL) {
      g_warning("Could not load scheme %s\n", filename);
      return NULL;
    }
    fgets(temp, 1024, file);
    while (fgets(temp, 1024, file)) {
      if (temp[0] == '#') continue;
      while (1) {
	pos = strtok(temp, " \t[]");
	if (pos == NULL) {
	  g_warning("Error in scheme file %s\n", filename);
	  return NULL;
	}
	if (strlen(pos) > 0) {
	  sname = strdup(pos);
	  break;
	}
      }
      while (1) {
	pos = strtok(NULL, " \t[]");
	if (pos == NULL) {
	  g_warning("Error in scheme file %s\n", filename);
	  return NULL;
	}
	if (strlen(pos) > 0) {
	  sfore = strdup(pos);
	  break;
	}
      }
      while (1) {
	pos = strtok(NULL, " \t[]");
	if (pos == NULL) {
	  g_warning("Error in scheme file %s\n", filename);
	  return NULL;
	}
	if (strlen(pos) > 0) {
	  sback = strdup(pos);
	  break;
	}
      }
      while (1) {
	pos = strtok(NULL, " \t[]");
	if (pos == NULL) {
	  g_warning("Error in scheme file %s\n", filename);
	  return NULL;
	}
	if (strlen(pos) > 0) {
	  sfont = strdup(pos);
	  break;
	}
      }
      style_new(scheme, sname, sfore, sback, sfont, 1);
      free(sname);
      free(sfore);
      free(sback);
      free(sfont);
    }
    if (scheme == global.colors) {
      free(global.scheme);
      global.scheme = strdup(temp2);
    }
    
    fclose(file);
  }
  return scheme;
}

void scheme_save(GList* scheme, char* name) {
  char filename[2048];
  char temp[2048];
  style_t* style;
  FILE* file;
  int i1;

  sprintf(filename, "%s/schemes/%s", global.lopster_home, name);
  if ((file = fopen(filename, "w")) == NULL) {
    sprintf(temp, "Could not save scheme [%s]\n", name);
    g_warning(temp);
    return;
  }
    
  fprintf(file, "LSF1.1\n");
  for (i1 = 0; i1 < g_list_length(scheme); i1++) {
    style =  (style_t*)(g_list_nth(scheme, i1)->data);
    fprintf(file, "%s [%s][%s][%s]\n", style->name,
	    style->n_fore, style->n_back, style->n_font);
  }
  fclose(file);

  scheme_update_list();
}

void scheme_delete(char* name) {
  char filename[2048];

  sprintf(filename, "%s/schemes/%s", global.lopster_home, name);
  unlink(filename);
  scheme_update_list();
}

int scheme_is_valid(char* name) {
  struct stat st;
  FILE* file;
  char temp[2048];

  sprintf(temp, "%s/schemes/%s", global.lopster_home, name);

  if (stat(temp, &st) < 0) return 0;
  
  if ((file = fopen(temp, "r")) == NULL) return 0;

  fgets(temp, 1024, file);
  if (strncmp(temp, "LSF1.1", 6)) return 0;

  fclose(file);
  
  return 1;
}

void scheme_update_list() {
  char dirname[2048];
  GtkWidget* temp;
  GList* list2;
  struct dirent* entry;
  struct stat buf;
  char filename[2048];
  DIR* dir;

  if (!global.options_win) return;

  sprintf(dirname, "%s/schemes", global.lopster_home);

  list2 = NULL;
  temp = lookup_widget(global.options_win, "combo7");
  if ((dir = opendir(dirname)) == NULL) {
    g_warning("could not open dir [%s]", dirname);
  } else {
    while ((entry = readdir(dir)) != NULL) {
      //      if (!strncmp(entry->d_name, ".", 1)) continue;
      //      if (!strncmp(entry->d_name, "..", 2)) continue;
      sprintf(filename, "%s/%s", dirname, entry->d_name);
      stat(filename, &buf);
      if (S_ISREG(buf.st_mode)) {
	if (scheme_is_valid(entry->d_name)) {
	  list2 = g_list_insert_sorted(list2, strdup(entry->d_name),
				       (GCompareFunc)strcasecmp);
	}
      }
    }
    closedir(dir);
  }
  if (list2) {
    gtk_combo_set_popdown_strings (GTK_COMBO (temp), list2);
    g_list_free (list2);
  }
  temp = lookup_widget(global.options_win, "combo_entry15");
  gtk_entry_set_text(GTK_ENTRY(temp), global.scheme);
}

GList* style_new(GList* scheme, 
		 char* name, char* fore, char* back, char* font,
		 int update) {
  style_t* style;
  GdkColor color;

  style = style_search(scheme, name);

  if (!style) {
    if (update) return scheme;
    style = (style_t*)malloc(sizeof(style_t));
    scheme = g_list_append(scheme, style);
    style->name = strdup(name);
    style->n_fore = strdup("NULL");
    style->n_back = strdup("NULL");
    style->n_font = strdup("NULL");
    style->fore = NULL;
    style->back = NULL;
    style->font = NULL;
  }

  if (fore) {
    style->n_fore = strdup(fore);
    if (strcmp(fore, "NULL")) {
      gdk_color_parse(fore, &color);
      style->fore = gdk_color_copy(&color);
    } else {
      style->fore = NULL;
    }
  }
  if (back) {
    style->n_back = strdup(back);
    if (strcmp(back, "NULL")) {
      gdk_color_parse(back, &color);
      style->back = gdk_color_copy(&color);
    } else {
      style->back = NULL;
    }
  }
  if (font) {
    style->n_font = strdup(font);
    if (strcmp(font, "NULL")) {
      style->font = gdk_font_load(font);
    } else {
      style->font =  NULL;
    }
  }

  return scheme;
}

style_t* style_search(GList* scheme, char* name) {
  style_t* style;
  int i1;

  if (!scheme) return NULL;
  for (i1 = 0; i1 < g_list_length(scheme); i1++) {
    style = 
      (style_t*)(g_list_nth(scheme, i1)->data);
    if (!strcasecmp(name, style->name)) {
      return style;
    }
  }
  return NULL;
}

style_t* style_get(GList* scheme, char* name) {
  style_t* style;
  static style_t* d_style = NULL;

  style = style_search(scheme, name);
  if (!style) {
    if (d_style == NULL) {
      d_style = (style_t*)malloc(sizeof(style_t));
      d_style->name = strdup("dummy style");
      d_style->font = NULL;
      d_style->fore = NULL;
      d_style->back = NULL;
      d_style->n_fore = strdup("NULL");
      d_style->n_back = strdup("NULL");
      d_style->n_font = strdup("NULL");
    }
    return d_style;
  }
  return style;
}

