#include <dirent.h>
#include <ctype.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/time.h>
#include <netdb.h>
#include <fcntl.h>
#include <errno.h>
#include <signal.h>

#include <gtk/gtk.h>

#include "support.h"
#include "md5.h"
#include "connection.h"
#include "commands.h"
#include "interface.h"
#include "chat.h"
#include "callbacks.h"
#include "scheme.h"
#include "handler.h"
#include "log.h"
#include "global.h"
#include "share.h"
#include "transfer.h"
#include "hotlist.h"

#include "../pixmaps/speedgreen.xpm"
#include "../pixmaps/speedyellow.xpm"
#include "../pixmaps/speedred.xpm"
#include "../pixmaps/speedgray.xpm"
#include "../pixmaps/folder.xpm"
#include "../pixmaps/folder_open.xpm"
#include "../pixmaps/user1.xpm"
#include "../pixmaps/user2.xpm"
#include "../pixmaps/ignore.xpm"
#include "../pixmaps/enemy.xpm"
#include "../pixmaps/enemy2.xpm"
#include "../pixmaps/friend.xpm"
#include "../pixmaps/d16x16.xpm"

const char Level[5][20] = {
  "Leech",
  "User",
  "Moderator",
  "Admin",
  "Elite"
};
const char UserStatus[4][20] = {
  "Incative",
  "Active",
  "Remote",
  "Cloaked"
};
const char LineSpeed[11][20] = {
  "unknown",
  "14.4 kbps",
  "28.8 kbps",
  "33.3 kbps",
  "56.7 kbps",
  "64K ISDN",
  "128K ISDN",
  "Cable",
  "DSL",
  "T1",
  "T3+"
};
const char LineSpeedShort[11][20] = {
  "?",
  "14.4",
  "28.8",
  "33.3",
  "56.7",
  "64K",
  "128K",
  "Cable",
  "DSL",
  "T1",
  "T3+"
};

char Network[3][20] = {
  "Unknown",
  "Opennap",
  "Napster"
};

const int ColorTable[10][10] = {
  {  0,  1,  2,  3,  4,  5,  6,  7,  8,  9},
  { 10, 11, 12, 13, 14, 15,  0,  1,  1,  1},
  { -2, -2, -2, -2, -2, -2, -2, -2, -2, -2},
  {  1,  4,  3,  5,  2,  6, 10, 15, -3, -3},
  {  1,  1,  1,  1,  1,  1,  1,  1, -4, -4},
  { 14,  7,  9,  8, 12, 13, 11,  0, 15,  5},
  { -6, -6, -6, -6, -6, -6, -6, -6, -6, -6},
  { -7, -7, -7, -7, -7, -7, -7, -7, -7, -7},
  { -8, -8, -8, -8, -8, -8, -8, -8, -8, -8},
  { -9, -9, -9, -9, -9, -9, -9, -9, -9, -9}
};
const int ColorTable2[8] = {
   1,  4,  3,  5,  2,  6, 10,  15
};

global_t global;
char tstr[10][512];
char* list[10] = {
  tstr[0], tstr[1],
  tstr[2], tstr[3],
  tstr[4], tstr[5],
  tstr[6], tstr[7],
  tstr[8], tstr[9]
};


void geo_error(int cnt, char* line) {
  printf("unparsable line %d in geometry file: [%s]\n", cnt, line);
}

char* is_clist(char* line) {
  if (!strncasecmp(line, "DOWNLOAD_COLUMN", 15)) {
    return "transfer_down";
  } else if (!strncasecmp(line, "UPLOAD_COLUMN", 13)) {
    return "transfer_up";
  } else if (!strncasecmp(line, "HOTTREE_COLUMN", 14)) {
    return "hot_tree";
  } else if (!strncasecmp(line, "HOTSEARCH_COLUMN", 16)) {
    return "clist5";
  } else if (!strncasecmp(line, "SEARCH_COLUMN", 13)) {
    return "search_list";
  } else if (!strncasecmp(line, "LIB_COLUMN", 10)) {
    return "lib_tree";
  } else {
    return NULL;
  }
}

void read_geometry() {
  char File[1024];
  FILE* file;
  char line[500];
  char* pos1;
  char* pos2;
  int line_cnt;
  GtkCList* clist;

  strcpy(File, global.lopster_home);
  strcat(File, "/geometry");

  if ((file = fopen(File, "r")) == NULL) return;

  line_cnt = 0;
  while (fgets(line, 400, file)) {
    line_cnt++;
    (strchr(line, '\n'))[0] = 0;
    if ((line[0] == '#') || 
	(line[0] == ' ') ||
	(line[0] == 0)) {
    } else if (!strncasecmp(line, "POSITION", 8)) {
      pos1 = strchr(line, '=');
      if (!pos1) {
	geo_error(line_cnt, line);
	continue;
      }
      pos2 = strrchr(pos1+1, ' ');
      if (!pos2) {
	geo_error(line_cnt, line);
	continue;
      }
      pos2[0] = 0;
      gtk_window_reposition(GTK_WINDOW(global.win),
			    atoi(pos1+1), atoi(pos2+1));
    } else if (!strncasecmp(line, "SIZE", 4)) {
      pos1 = strchr(line, '=');
      if (!pos1) {
	geo_error(line_cnt, line);
	continue;
      }
      pos2 = strrchr(pos1+1, ' ');
      if (!pos2) {
	geo_error(line_cnt, line);
	continue;
      }
      pos2[0] = 0;
      gtk_window_set_default_size(GTK_WINDOW (global.win),
				  atoi(pos1+1), atoi(pos2+1));
    } else if ((pos1 = is_clist(line)) != NULL) {
      clist = GTK_CLIST(lookup_widget(global.win, pos1));
      pos1 = strchr(line, '=');
      if (!pos1) {
	geo_error(line_cnt, line);
	continue;
      }
      pos2 = strrchr(pos1+1, ',');
      if (!pos2) {
	geo_error(line_cnt, line);
	continue;
      }
      gtk_clist_set_column_width (clist, atoi(pos1+1), atoi(pos2+1));
    } else {
      geo_error(line_cnt, line);
    }
  }
}

void write_geometry() {
  char filename[1024];
  FILE* fd;
  GtkCList* clist;
  int i1;

  sprintf(filename, "%s/geometry", global.lopster_home);

  if ((fd = fopen(filename, "w")) == NULL) {
    g_warning("could not save geometry");
    return;
  }

  fprintf(fd, "SIZE=%d %d\n", global.win->allocation.width, 
	  global.win->allocation.height);
  clist = GTK_CLIST(lookup_widget(global.win, "transfer_down"));
  for (i1 = 0; i1 < clist->columns; i1++) {
    fprintf(fd, "DOWNLOAD_COLUMN=%d,%d\n", i1, 
	    clist->column[i1].width);
  }
  clist = GTK_CLIST(lookup_widget(global.win, "transfer_up"));
  for (i1 = 0; i1 < clist->columns; i1++) {
    fprintf(fd, "UPLOAD_COLUMN=%d,%d\n", i1, 
	    clist->column[i1].width);
  }
  clist = GTK_CLIST(lookup_widget(global.win, "hot_tree"));
  for (i1 = 0; i1 < clist->columns; i1++) {
    fprintf(fd, "HOTTREE_COLUMN=%d,%d\n", i1, 
	    clist->column[i1].width);
  }
  clist = GTK_CLIST(lookup_widget(global.win, "clist5"));
  for (i1 = 0; i1 < clist->columns; i1++) {
    fprintf(fd, "HOTSEARCH_COLUMN=%d,%d\n", i1, 
	    clist->column[i1].width);
  }
  clist = GTK_CLIST(lookup_widget(global.win, "search_list"));
  for (i1 = 0; i1 < clist->columns; i1++) {
    fprintf(fd, "SEARCH_COLUMN=%d,%d\n", i1, 
	    clist->column[i1].width);
  }
  clist = GTK_CLIST(lookup_widget(global.win, "lib_tree"));
  for (i1 = 0; i1 < clist->columns; i1++) {
    fprintf(fd, "LIB_COLUMN=%d,%d\n", i1, 
	    clist->column[i1].width);
  }

  fclose(fd);
}

void sigpipe_handler(int val) {
  printf("sigpipe: Broken pipe: %d\n", val);
}

struct hostent* resolv_address(char* address) {
  struct hostent* h;
  int i1 = 0, i2 = 0, i3 = 0, i4 = 0;
  char n[4];

  h = gethostbyname(address);
  if (h == NULL) {
    sscanf(address, "%d.%d.%d.%d", &i1, &i2, &i3, &i4);
    n[0] = i1;
    n[1] = i2;
    n[2] = i3;
    n[3] = i4;
    h = gethostbyaddr(n, 4, AF_INET);
  }
  return h;
}

void update_user_stats() {
  GtkWidget* temp;
  char t[1024];

  // user
  temp = lookup_widget(global.win, "label271");
  gtk_label_set_text(GTK_LABEL(temp), global.user.username);
  temp = lookup_widget(global.win, "label272");
  gtk_label_set_text(GTK_LABEL(temp), Level[global.user.level]);
  temp = lookup_widget(global.win, "label273");
  gtk_label_set_text(GTK_LABEL(temp), UserStatus[global.user.status]);
  temp = lookup_widget(global.win, "label274");
  if (global.reply)
    sprintf(t, "Reply: %s", global.reply);
  else
    sprintf(t, "Reply: <Empty>");
  gtk_label_set_text(GTK_LABEL(temp), t);

  // server
  if (global.status.connected) {
    temp = lookup_widget(global.win, "label276");
    gtk_label_set_text(GTK_LABEL(temp), 
		       global.server.address.description?global.server.address.description:"???");
    temp = lookup_widget(global.win, "label277");
    sprintf(t, "%s:%d", global.server.address.ip,
	    global.server.address.port);
    gtk_label_set_text(GTK_LABEL(temp), t);
    temp = lookup_widget(global.win, "label278");
    gtk_label_set_text(GTK_LABEL(temp), 
		       Network[global.server.address.network]);
  } else {
    temp = lookup_widget(global.win, "label276");
    gtk_label_set_text(GTK_LABEL(temp), "Not connected");
    temp = lookup_widget(global.win, "label277");
    gtk_label_set_text(GTK_LABEL(temp), "");
    temp = lookup_widget(global.win, "label278");
    gtk_label_set_text(GTK_LABEL(temp), "");
  }
}

char* strcasestr(char* str, const char* sub) {
  int len = strlen(sub);
  int max_pos = strlen(str)-len;
  int str_pos;
  int sub_pos;

  str_pos = 0;
  sub_pos = 0;
  while (str_pos <= max_pos) {
    while (toupper(str[str_pos+sub_pos]) == 
	   toupper(sub[sub_pos])) {
      sub_pos++;
      if (sub_pos == len) return &(str[str_pos]);
    }
    str_pos++;
    sub_pos = 0;
  }
  
  return NULL;
}

int speed2int(char* linespeed) {
  int i1;

  for (i1 = 0; i1 < 11; i1++) {
    if (!strcmp(linespeed, LineSpeed[i1])) return i1;
  }

  g_warning("speed not found");
  return 0;
}

int level2int(char* level) {
  int i1;

  if (level[0] == '\"') {
    level++;
    level[strlen(level)-1] = 0;
  }
  for (i1 = 0; i1 < 5; i1++) {
    if (!strcmp(level, Level[i1])) return i1;
  }

  g_warning("level not found");
  return -1;
}

int status2int(char* status) {
  int i1;

  if (status[0] == '\"') {
    status++;
    status[strlen(status)-1] = 0;
  }
  for (i1 = 0; i1 < 4; i1++) {
    if (!strcmp(status, UserStatus[i1])) return i1;
  }

  g_warning("status not found");
  return 0;
}

int idle_function(gpointer data) {
  GtkWidget* temp;

  if (global.auto_connect) {
    on_connect_activate(NULL, NULL);
    temp = lookup_widget(global.connect_win, "combo_entry12");
    gtk_entry_set_text(GTK_ENTRY(temp), "Last Server");
    on_connection_ok_clicked(NULL, NULL);
  }

  return 0;
}

void read_rc() {
  char RCFile[1024];
  FILE* file;
  char line[500];
  char* pos1;
  char* pos2;
  int section = 0;
  address_t* server;
  GtkWidget* temp;

  strcpy(RCFile, global.lopster_home);
  strcat(RCFile, "/lopsterrc");

  if ((file = fopen(RCFile, "r")) == NULL) {
    g_warning("could not load rc-file");
    global.channels = 
      g_list_append(global.channels, strdup("Lopster"));

    server = (address_t*)malloc(sizeof(address_t));
    server->ip = strdup("207.195.111.2");
    server->ip_long = inet_addr(server->ip);
    server->port = 8888;
    server->description = strdup("bitchx.dimension6.com");
    server->no_connected = 0;
    global.servers = 
      g_list_insert_sorted(global.servers, server,
			   (GCompareFunc)server_comp);
  } else {
    while (fgets(line, 400, file)) {
      (strchr(line, '\n'))[0] = 0;
      if ((line[0] == '#') || 
	  (line[0] == ' ') ||
	  (line[0] == 0)) {
      } else if (!strncasecmp(line, "Section", 7)) {
	pos1 = strchr(line, '[')+1;
	pos2 = strrchr(line, ']');
	pos2[0] = 0;
	if (!strcasecmp(pos1, "User"))
	  section = 1;
	else if (!strcasecmp(pos1, "Path"))
	  section = 2;
	else if (!strcasecmp(pos1, "Network"))
	  section = 3;
	else if (!strcasecmp(pos1, "Hotlist"))
	  section = 4;
	else if (!strcasecmp(pos1, "Server"))
	  section = 5;
	else if (!strcasecmp(pos1, "Chat"))
	  section = 6;
	else if (!strcasecmp(pos1, "Buttons"))
	  section = 7;
	else if (!strcasecmp(pos1, "Global"))
	  section = 8;
	else if (!strcasecmp(pos1, "Library"))
	  section = 9;
	else {
	  g_warning("unknown section in rc-file [%s]", pos1);
	}
      } else if (section == 1) {
	if (!strncasecmp(line, "NAME", 4)) {
	  strcpy(global.user.username, &line[5]);
	} else if (!strncasecmp(line, "PASSWORD", 8)) {
	  strcpy(global.user.password, &line[9]);
	} else if (!strncasecmp(line, "EMAIL", 5)) {
	  strcpy(global.user.email, &line[6]);
	} else {
	  g_warning("unknown tag in section USER [%s]", line);
	}
      } else if (section == 2) {
	if (!strncasecmp(line, "DOWNLOAD", 8)) {
	  global.path.download = strdup(&line[9]);
	} else if (!strncasecmp(line, "SHARED", 6)) {
	  pos1 = strchr(line, '=')+1;
	  global.path.shared = 
	    g_list_append(global.path.shared, strdup(pos1));
	} else {
	  g_warning("unknown tag in section PATH [%s]", line);
	}
      } else if (section == 3) {
	if (!strncasecmp(line, "LINESPEED", 9)) {
	  sscanf(line+10, "%d", &(global.network.linespeed));
	} else if (!strncasecmp(line, "PORT", 4)) {
	  sscanf(line+5, "%d", &(global.network.port));
	} else if (!strncasecmp(line, "MAX_DOWNLOADS", 13)) {
	  sscanf(line+14, "%d", &(global.network.max_downloads));
	} else if (!strncasecmp(line, "MAX_UPLOADS", 11)) {
	  sscanf(line+12, "%d", &(global.network.max_uploads));
	} else if (!strncasecmp(line, "MAX_TRANSFERS", 13)) {
	  sscanf(line+14, "%d", &(global.network.max_transfers));
	} else if (!strncasecmp(line, "FIREWALL", 8)) {
	  sscanf(line+9, "%d", &(global.network.firewall));
	} else if (!strncasecmp(line, "AutoConnect", 11)) {
	  sscanf(line+12, "%d", &(global.auto_connect));
	} else {
	  g_warning("unknown tag in section NETWORK [%s]", line);
	}
      } else if (section == 4) {
	if (!strncasecmp(line, "USER", 4)) {
	  pos1 = strchr(line, '=') + 1;
	  add_to_hotlist(pos1);
	} else if (!strncasecmp(line, "ShortNames", 10)) {
	  pos1 = strchr(line, '=') + 1;
	  temp = lookup_widget(global.win, "checkbutton18");
	  if (atoi(pos1))
	    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), TRUE);
	  else
	    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), FALSE);
	} else {
	  g_warning("unknown tag in section HOTLIST [%s]", line);
	}
      } else if (section == 5) {
	if (!strncasecmp(line, "Server", 6)) {
	  server = (address_t*)malloc(sizeof(address_t));
	  pos1 = strchr(line, '=') + 1;
	  pos2 = strchr(line, ':');
	  pos2[0] = 0;
	  server->ip = strdup(pos1);
	  pos1 = pos2+1;
	  pos2 = strchr(pos1, ':');
	  pos2[0] = 0;
	  sscanf(pos1, "%d", &(server->port));
	  pos1 = pos2+1;
	  pos2 = strchr(pos1, ':');
	  pos2[0] = 0;
	  server->description = strdup(pos1);
	  pos1 = pos2+1;
	  sscanf(pos1, "%d", &(server->no_connected));
	  global.servers =
	    g_list_insert_sorted(global.servers, server,
				 (GCompareFunc)server_comp);
	} else if (!strncasecmp(line, "Last", 4)) {
	  global.last_server = 
	    (address_t*)malloc(sizeof(address_t));
	  pos1 = strchr(line, '=') + 1;
	  pos2 = strchr(line, ':');
	  pos2[0] = 0;
	  global.last_server->ip = strdup(pos1);
	  pos1 = pos2+1;
	  pos2 = strchr(pos1, ':');
	  pos2[0] = 0;
	  sscanf(pos1, "%d", &(global.last_server->port));
	  pos1 = pos2+1;
	  pos2 = strchr(pos1, ':');
	  pos2[0] = 0;
	  global.last_server->description = strdup(pos1);
	  pos1 = pos2+1;
	  sscanf(pos1, "%d", &(global.last_server->no_connected));
	} else {
	  g_warning("unknown tag in section SERVER [%s]", line);
	}
      } else if (section == 6) {
	if (!strncasecmp(line, "Alias", 5)) {
	  pos1 = strchr(line, '=')+1;
	  pos2 = strchr(line, ':');
	  pos2[0] = 0;
	  pos2++;
	  command_make_alias(pos2, pos1);
	} else if (!strncasecmp(line, "Highlight", 9)) {
	  pos1 = strchr(line, '=')+1;
	  global.highlight = 
	    g_list_append(global.highlight, strdup(pos1));
	} else if (!strncasecmp(line, "Friend", 6)) {
	  pos1 = strchr(line, '=')+1;
	  global.frienduser = 
	    g_list_append(global.frienduser, strdup(pos1));
	} else if (!strncasecmp(line, "Enemy", 5)) {
	  pos1 = strchr(line, '=')+1;
	  global.enemyuser = 
	    g_list_append(global.enemyuser, strdup(pos1));
	} else if (!strncasecmp(line, "Scheme", 6)) {
	  pos1 = strchr(line, '=')+1;
	  global.scheme = strdup(pos1);
	} else if (!strncasecmp(line, "ShowJoins", 9)) {
	  pos1 = strchr(line, '=')+1;
	  global.show_joins = atoi(pos1);
	} else if (!strncasecmp(line, "PublicIgnore", 12)) {
	  pos1 = strchr(line, '=')+1;
	  global.ignore_public_ignore = atoi(pos1);
	} else if (!strncasecmp(line, "SendIgnore", 10)) {
	  pos1 = strchr(line, '=')+1;
	  global.send_ignore = atoi(pos1);
	} else if (!strncasecmp(line, "Channel", 7)) {
	  pos1 = strchr(line, '=')+1;
	  global.channels = 
	    g_list_append(global.channels, strdup(pos1));
	} else if (!strncasecmp(line, "Logging", 7)) {
	  pos1 = strchr(line, '=')+1;
	  global.logging = atoi(pos1);
	} else if (!strncasecmp(line, "ColorParse", 10)) {
	  pos1 = strchr(line, '=')+1;
	  global.parse_color = atoi(pos1);
	} else {
	  g_warning("unknown tag in section CHAT [%s]", line);
	}
      } else if (section == 7) {
	if (!strncasecmp(line, "Chat", 4)) {
	  pos1 = strchr(line, '=')+1;
	  temp = lookup_widget(global.win, "button114");
	  set_button_state(temp, atoi(pos1));
	} else if (!strncasecmp(line, "Connect", 7)) {
	  pos1 = strchr(line, '=')+1;
	  global.connect_button = atoi(pos1);
	} else if (!strncasecmp(line, "Search", 6)) {
	  pos1 = strchr(line, '=')+1;
	  temp = lookup_widget(global.win, "button115");
	  set_button_state(temp, atoi(pos1));
	} else if (!strncasecmp(line, "Hot1", 4)) {
	  pos1 = strchr(line, '=')+1;
	  temp = lookup_widget(global.win, "button116");
	  set_button_state(temp, atoi(pos1));
	} else if (!strncasecmp(line, "Hot2", 4)) {
	  pos1 = strchr(line, '=')+1;
	  temp = lookup_widget(global.win, "button118");
	  set_button_state(temp, atoi(pos1));
	} else if (!strncasecmp(line, "Transfer", 7)) {
	  pos1 = strchr(line, '=')+1;
	  temp = lookup_widget(global.win, "button119");
	  set_button_state(temp, atoi(pos1));
	} else if (!strncasecmp(line, "Mail", 4)) {
	  pos1 = strchr(line, '=')+1;
	  temp = lookup_widget(global.win, "button130");
	  set_button_state(temp, atoi(pos1));
	} else {
	  g_warning("unknown tag in section BUTTONS [%s]", line);
	}
      } else if (section == 8) {
	if (!strncasecmp(line, "Player", 6)) {
	  pos1 = strchr(line, '=') + 1;
	  global.player = strdup(pos1);
	} else {
	  g_warning("unknown tag in section PLAYER [%s]", line);
	}
      } else if (section == 9) {
	if (!strncasecmp(line, "ShortNames", 10)) {
	  pos1 = strchr(line, '=') + 1;
	  temp = lookup_widget(global.win, "checkbutton19");
	  if (atoi(pos1))
	    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), TRUE);
	  else
	    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), FALSE);
	} else if (!strncasecmp(line, "AutoSave", 8)) {
	  pos1 = strchr(line, '=') + 1;
	  temp = lookup_widget(global.win, "checkbutton20");
	  if (atoi(pos1))
	    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), TRUE);
	  else
	    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), FALSE);
	} else {
	  g_warning("unknown tag in section LIBRARY [%s]", line);
	}
      } else {
	g_warning("unparsable line [%s]", line);
      }
    }
    fclose(file);
  }
}

void write_rc() {
  char RCFile[1024];
  FILE* file;
  GList* dlist;
  address_t* server;
  command_t* comm;
  int i1;
  char* str;
  GtkWidget* temp;

  strcpy(RCFile, global.lopster_home);
  strcat(RCFile, "/lopsterrc");

  if ((file = fopen(RCFile, "w")) != NULL) {
    fprintf(file, "# DANGER! do not edit this file\n");
    fprintf(file, "###################################\n");
    fprintf(file, "\nSection [USER]\n");
    fprintf(file, "Name=%s\n", global.user.username);
    fprintf(file, "Password=%s\n", global.user.password);
    fprintf(file, "EMail=%s\n", global.user.email);

    fprintf(file, "\nSection [PATH]\n");
    if (global.path.download)
      fprintf(file, "Download=%s\n", global.path.download);
    if (global.path.shared) {
      for (i1 = 0; i1 < g_list_length(global.path.shared); i1++) {
	str = (char*)(g_list_nth(global.path.shared, i1)->data);
	fprintf(file, "Shared=%s\n", str);
      }
    }

    fprintf(file, "\nSection [GLOBAL]\n");
    if (global.player)
      fprintf(file, "Player=%s\n", global.player);

    fprintf(file, "\nSection [Network]\n");
    fprintf(file, "Linespeed=%d\n", global.network.linespeed);
    fprintf(file, "Port=%d\n", global.network.port);
    fprintf(file, "Max_Downloads=%d\n", global.network.max_downloads);
    fprintf(file, "Max_Uploads=%d\n", global.network.max_uploads);
    fprintf(file, "Max_Transfers=%d\n", global.network.max_transfers);
    fprintf(file, "Firewall=%d\n", global.network.firewall);
    fprintf(file, "AutoConnect=%d\n", global.auto_connect);
    
    fprintf(file, "\nSection [Hotlist]\n");
    
    if (global.hotlist) {
      dlist = g_list_first(global.hotlist);
      while (dlist) {
	str = (char*)(dlist->data);
	fprintf(file, "User=%s\n", str);
	dlist = g_list_next(dlist);
      }
    }
    temp = lookup_widget(global.win, "checkbutton18");
    if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
      fprintf(file, "ShortNames=1\n");
    } else {
      fprintf(file, "ShortNames=0\n");
    }

    fprintf(file, "\nSection [Server]\n");
    
    if (global.servers) {
      dlist = g_list_first(global.servers);
      while (dlist) {
	server = (address_t*)(dlist->data);
	fprintf(file, "Server=%s:%d:%s:%d\n", server->ip, 
		server->port, server->description, server->no_connected);
	dlist = g_list_next(dlist);
      }
    }
    if (global.last_server) {
      fprintf(file, "Last=%s:%d:%s:%d\n", global.last_server->ip, 
	      global.last_server->port, 
	      global.last_server->description, 0);
    }

    // chat
    fprintf(file, "\nSection [Chat]\n");
    for (i1 = 0; i1 < g_list_length(global.commands); i1++) {
      comm = 
	(command_t*)(g_list_nth(global.commands, i1)->data);
      if (comm->is_alias) {
	fprintf(file, "Alias=%s:%s\n", comm->name, &(comm->syntax[4]));
      }
    }
    if (global.highlight) {
      for (i1 = 0; i1 < g_list_length(global.highlight); i1++) {
	str = (char*)(g_list_nth(global.highlight, i1)->data);
	fprintf(file, "Highlight=%s\n", str);
      }
    }
    if (global.frienduser) {
      for (i1 = 0; i1 < g_list_length(global.frienduser); i1++) {
	str = (char*)(g_list_nth(global.frienduser, i1)->data);
	fprintf(file, "Friend=%s\n", str);
      }
    }
    if (global.enemyuser) {
      for (i1 = 0; i1 < g_list_length(global.enemyuser); i1++) {
	str = (char*)(g_list_nth(global.enemyuser, i1)->data);
	fprintf(file, "Enemy=%s\n", str);
      }
    }
    fprintf(file, "Scheme=%s\n", global.scheme);
    fprintf(file, "ShowJoins=%d\n", global.show_joins);
    fprintf(file, "PublicIgnore=%d\n", global.ignore_public_ignore);
    fprintf(file, "SendIgnore=%d\n", global.send_ignore);
    fprintf(file, "Logging=%d\n", global.logging);

    if (global.channels) {
      for (i1 = 0; i1 < g_list_length(global.channels); i1++) {
	str = (char*)(g_list_nth(global.channels, i1)->data);
	fprintf(file, "Channel=%s\n", str);
      }
    }
    fprintf(file, "ColorParse=%d\n", global.parse_color);
    

    // buttons
    fprintf(file, "\nSection [Buttons]\n");
    temp = lookup_widget(global.win, "pix2");
    fprintf(file, "Chat=%d\n", GTK_WIDGET_VISIBLE(temp));
    temp = lookup_widget(global.win, "pix4");
    fprintf(file, "Search=%d\n", GTK_WIDGET_VISIBLE(temp));
    temp = lookup_widget(global.win, "pix6");
    fprintf(file, "Hot1=%d\n", GTK_WIDGET_VISIBLE(temp));
    temp = lookup_widget(global.win, "pix7");
    fprintf(file, "Hot2=%d\n", GTK_WIDGET_VISIBLE(temp));
    temp = lookup_widget(global.win, "pix10"); 
    fprintf(file, "Transfer=%d\n", GTK_WIDGET_VISIBLE(temp));
    temp = lookup_widget(global.win, "pix16"); 
    fprintf(file, "Mail=%d\n", GTK_WIDGET_VISIBLE(temp));
    fprintf(file, "Connect=%d\n", global.connect_button);

    fprintf(file, "\nSection [Library]\n");
    temp = lookup_widget(global.win, "checkbutton19");
    if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
      fprintf(file, "ShortNames=1\n");
    } else {
      fprintf(file, "ShortNames=0\n");
    }
    temp = lookup_widget(global.win, "checkbutton20");
    if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
      fprintf(file, "AutoSave=1\n");
    } else {
      fprintf(file, "AutoSave=0\n");
    }


    fclose(file);
  } else {
    g_warning("could not write rc-file %s", RCFile);
  }

}

void create_dir(char* dir) {
  struct stat st;

  if (stat(dir, &st) < 0) {
    mkdir(dir, 7*64);
  }
}

void setup_commands() {
  command_new(C_WHISPER, "whisper", 
	      "/whipser <user> <text>",
	      "Send a private message <text> to the User <user>",
	      L_USER, F_CHAT);
  command_new(C_EMOTE, "emote", 
	      "/emote <text>",
	      "Send action description <text> on the current channel.",
	      L_USER, F_CHAT);
  command_new(C_JOIN, "join", 
	      "/join <channel>",
	      "Join channel <channel>.",
	      L_USER, F_CHAT);

  command_new(C_EMAIL, "email",
	      "/email <address>",
	      "Change e-mail address to <address>.",
	      L_USER, F_UMOD);
  command_new(C_SPEED, "speed",
	      "/speed [<user>] [<speed>]",
	      "It will change the link speed for <user> (moderator or higher). If no user is given your own link speed is modified",
	      L_USER, F_UMOD);
  command_new(C_DATAPORT, "dataport",
	      "dataport [<user>] <port>",
	      "Changes the dataport of <user> to <port>. If no user is specified it changes your own port",
	      L_USER, F_UMOD);
  command_new(C_PASSWORD, "password",
	      "/password [<user>] <password>",
	      "It will change the password for <user> (moderator or higher). If no user is given your own password is modified",
	      L_USER, F_UMOD);
  command_new(C_LEVEL, "level",
	      "/level <user> <level>",
	      "Change level of <user> with a lower level than yours.",
	      L_USER, F_UMOD);
  command_new(C_USERMODE, "usermode",
	      "/usermode <user> <ALL|NONE|<[-]<modes>>>",
	      "Set user mode. Available modes: ERROR BAN CHANGE KILL LEVEL SERVER MUZZLE PORT WALLOP CLOAK FLOOD PING. Actually i don't know the meaning of this command.",
	      L_USER, F_UMOD);

  command_new(C_WHOIS, "whois", 
	      "/whois [<user>]",
	      "Show whois info for <user>.",
	      L_USER, F_INFO);
  command_new(C_HELP, "help", 
	      "/help [<command>]",
	      "Type /help for a list of commands, type /help <command> for a description of command <command>",
	      L_USER, F_INFO);
  /*
  command_new(C_BROWSE, "browse",
	      "/browse <user>",
	      "Browse <user>'s shared files.",
	      L_USER, F_INFO);
  */
  command_new(C_DISC, "disc",
	      "/disc",
	      "Disconnect from server.",
	      L_USER, F_MISC);

  command_new(C_SEND, "send", 
	      "/send <type> [<arg>....]",
	      "?",
	      L_MOD, F_MOD);
  command_new(C_BAN, "ban", 
	      "/ban <user|ip> [<reason>]",
	      "Ban user or ip from server (moderator or higher)",
	      L_MOD, F_MOD);
  command_new(C_UNBAN, "unban",
	      "/unban <user|ip>",
	      "Remove the ban on a user or ip (moderator or higher).",
	      L_MOD, F_MOD);
  command_new(C_CLOAK, "cloak", 
	      "/cloak",
	      "Toggle your invisible state (moderator or higher).",
	      L_MOD, F_MOD);


  command_new(C_CHCLEAR, "chclear", 
	      "/chclear",
	      "Clear the current channel from users with a lower level than yours.",
	      L_USER, F_OP);
  command_new(C_KILL, "kill",
	      "/kill <user>",
	      "Kill (disconnect) <user> with a lower lower level than yours.",
	      L_USER, F_MOD);
  command_new(C_LINKS , "links",
	      "/links",
	      "Show links between servers.",
	      L_USER, F_INFO);
  command_new(C_LIST, "list",
	      "/list",
	      "List available channels.",
	      L_USER, F_CLIENT);
  command_new(C_LISTBANS, "listbans",
	      "/listbans [<channel>]",
	      "List banned users and ip's for <channel> if channel is given. If no argument is given, the server bans are listed",
	      L_USER, F_INFO);
  command_new(C_PART, "part",
	      "/part",
	      "Part the current channel.",
	      L_USER, F_CHAT);
  command_new(C_WALLOP, "wallop",
	      "/wallop <text>",
	      "Send a message to all users with level moderator or higher (moderator or higher).",
	      L_MOD, F_MOD);
  command_new(C_STATS, "stats",
	      "/stats",
	      "Show server statistics.",
	      L_USER, F_INFO);
  command_new(C_SCHEME, "scheme",
	      "/scheme <name>",
	      "Loading Color scheme <name>.",
	      L_USER, F_CLIENT);
  command_new(C_ALIAS, "alias",
	      "/alias <alias> <command>",
	      "Making new <alias> for <command>.",
	      L_USER, F_CLIENT);
  command_new(C_AFK, "afk",
	      "/afk [<text>]",
	      "If argument text is given, your status is set to AFK. Users sending you private messages will receive <text> as a private message. If no argument is given AFK is deactivated.",
	      L_USER, F_CLIENT);
  command_new(C_PUBLIC, "public",
	      "/public <text>",
	      "Force to send public message",
	      L_USER, F_CHAT);
  command_new(C_REPLY, "reply",
	      "/reply <text>",
	      "Reply to the use who sent the last private message",
	      L_USER, F_CHAT);
  command_new(C_PRIVATE, "private",
	      "/private <user>",
	      "Create new page for private messaging to <user>",
	      L_USER, F_CHAT);
  command_new(C_MAIL, "mail",
	      "/mail [<user> [<message>]]",
	      "This command is used to save a <message> for <user> that is sent as a private message when <user> joins. If argument <message> is not given, the current saved message for <user> is displayed if argument <user> is given, otherwise all mails are displayed",
	      L_USER, F_CLIENT);
  command_new(C_DELMAIL, "delmail",
	      "/delmail [<user>]",
	      "This command deletes the saved message for <user>. If no argument is given all messages will be deleted.",
	      L_USER, F_CLIENT);
  command_new(C_CONN, "conn",
	      "/conn",
	      "Connect to the last server used.",
	      L_USER, F_MISC);
  command_new(C_MOTD, "motd",
	      "/motd",
	      "Show server's \"Message Of The Day\".",
	      L_USER, F_INFO);
  command_new(C_QUIT, "quit",
	      "/quit",
	      "Exit program.",
	      L_USER, F_MISC);
  command_new(C_IGNORE, "ignore",
	      "/ignore [<user>]",
	      "ignore user <user>. If User is not given, ignore list is shown",
	      L_USER, F_CHAT);
  command_new(C_UNIGNORE, "unignore",
	      "/unignore <user>",
	      "Unignores <user>",
	      L_USER, F_CHAT);
  command_new(C_MUZZLE, "muzzle",
	      "/muzzle <user> [<reason>]",
	      "Muzzle <user> with a lower level than yours.",
	      L_USER, F_OP);
  command_new(C_UNMUZZLE, "unmuzzle",
	      "/unmuzzle <user>",
	      "Unmuzzle <user> with a lower level than yours.",
	      L_USER, F_OP);
  command_new(C_CHBAN, "chban",
	      "/chban <channel> <user|ip> [<reason>]",
	      "Ban <user|ip> from <channel>",
	      L_USER, F_OP);
  command_new(C_CHUNBAN, "chunban",
	      "/chunban <channel> <user|ip> [<reason>]",
	      "Unban <user|ip> from <channel>",
	      L_USER, F_OP);
  command_new(C_TOPIC, "topic",
	      "/topic <chn> <topic>",
	      "Set the topic of channel <chn> to <topic> (moderator or higher).",
	      L_USER, F_OP);
  command_new(C_VERSION, "version",
	      "/version",
	      "Show server version (moderator or higher).",
	      L_MOD, F_MOD);
  command_new(C_CLEAR, "clear",
	      "/clear",
	      "Clears to current channel window",
	      L_USER, F_CLIENT);
  command_new(C_NUKE, "nuke",
	      "/nuke <user>",
	      "Nuke a <user> (delete account)",
	      L_MOD, F_MOD);
  command_new(C_UNNUKE, "unnuke",
	      "/unnuke <user>",
	      "Nuke a <user> (delete accout)",
	      L_MOD, F_MOD);
  command_new(C_GLOBAL, "global",
	      "/global <text>",
	      "Send global message to all users (admin or higher).",
	      L_MOD, F_MOD);
  command_new(C_KICK, "kick",
	      "/kick <channel> <user> [<reason>]",
	      "Kick <user> with a lower level than yours from the <channel>.",
	      L_USER, F_OP);
  command_new(C_CVERSION, "cversion",
	      "/cversion",
	      "Prints out the client version, if in a channel via public message",
	      L_USER, F_INFO);
  command_new(C_PING, "ping",
	      "/ping <user>",
	      "Ping <user>.",
	      L_USER, F_MISC);
  command_new(C_SPING, "sping",
	      "/sping <server>",
	      "Ping <server>.",
	      L_USER, F_MISC);
  command_new(C_ECHO, "echo",
	      "/echo <text>",
	      "Echo <text> to current window. What's this command good for?",
	      L_USER, F_CLIENT);
  command_new(C_CHLIMIT, "chlimit",
	      "/chlimit <channel> <limit>",
	      "Change max. user limit of <channel> to <limit>",
	      L_USER, F_OP);
  command_new(C_CHLEVEL, "chlevel", 
	      "/chlevel <channel> <level>",
	      "Set the minimum level required to join <channel> (moderator or higher)",
	      L_USER, F_OP);
  command_new(C_SSTATS, "sstats", 
	      "/sstats",
	      "Show the server stats (moderator or higher)",
	      L_USER, F_INFO);
  command_new(C_CHMODE, "chmode",
	      "/chmode <channel> <+|-><mode>",
	      "Set mode for <channel>. Mode may be one of PRIVATE, MODERATED, INVITE, TOPIC. (moderator or higher)",
	      L_USER, F_OP);
  command_new(C_CHWALLOP, "chwallop",
	      "/chwallop <message>",
	      "Send message to all channel operators",
	      L_USER, F_OP);
  command_new(C_DROP, "drop",
	      "/drop [<channel> [<reason>]]",
	      "marks the specified channel (or the current if not argument is given) as being user created such that its state is not stored in the persistent channels file and will disappear once all users part from it",
	      L_USER, F_OP);
  command_new(C_OP, "op",
	      "/op [<channel>] <user>",
	      "Set <user> as operator on the current channel (moderator or higher).",
	      L_USER, F_OP);
  command_new(C_DEOP, "deop",
	      "/deop  [<channel>] <user>",
	      "Remove <user> as operator on the current channel (moderator or higher).",
	      L_USER, F_OP);
  command_new(C_OPLIST, "oplist",
	      "/oplist [<channel>]",
	      "List operators on the current channel (moderator or higher). The list will be returned in the form of a private message from pseudo-user 'ChanServ'.it seems that this command is not yet suported by opennap",
	      L_USER, F_OP);
  /*
  command_new(C_TEST, "test",
	      "/test",
	      "call test function",
	      L_USER, F_MISC);
  */
  command_new(C_KILLGHOST, "killghost",
	      "/killghost <ghost> [<passwd>]",
	      "kill yout <ghost>. if no passwd is given, the current password is used",
	      L_USER, F_MISC);
  command_new(C_FRIEND, "friend",
	      "/friend <user>",
	      "Add/remove a user to/from the friend list",
	      L_USER, F_CLIENT);
  command_new(C_ENEMY, "enemy",
	      "/enemy <user>",
	      "Add/remove a user to/from the enemy list",
	      L_USER, F_CLIENT);
  command_new(C_HOTADD, "hotadd",
	      "/hotadd <user>",
	      "Add a user to the hot list",
	      L_USER, F_CLIENT);
  command_new(C_HOTREM, "hotrem",
	      "/hotrem <user>",
	      "Remove a user from the hot list",
	      L_USER, F_CLIENT);

  /*
  command_new(C_KILLSERV, "killserv",
		   "/killserv <adr> [<reason>]",
		   "Kill (shutdown) server <adr> (elite only).");
  command_new(C_LINK , "link",
		   "/link <adr>:<pt> [<rmt>]",
		   "Attempt to link the current server to server <adr> at port <pt>.  If <rmt> is given, link from that server instead of the current one. Requires level admin or higher.");
  command_new(C_NOTIFY, "notify",
                   "/notify [+|-<user>]",
		   "Without parameters: show hotlist. +user: add user to hotlist. -user: remove user from hotlist.");
  command_new(C_REMSERV, "remserv",
                   "/remserv <srv> [<reason>]",
		   "Request server <srv> to be removed from the list of allowed links (elite only).");
  command_new(C_SERVER, "server",
                   "/server [<adr>:<pt>:<meta>]",
		   "Connect to server <adr> at port <pt>, treating the server as a \"metaserver\" (like the usual napster.com servers) if <meta> is '1', else like a normal server.  If you omit the server string, a window with your server list will pop up which lets you choose a server from the list.");
  command_new(C_UNLINK, "unlink",
                   "/unlink <adr> [<reason>]",
		   "Unlink the current server from server <adr> (admin or higher).");
  command_new(C_USERNAME, "username",
                   "/username <username>",
		   "Change username to <username> (only available when disconnected).");

  */
}

void create_pixmaps() {
  GtkStyle *style;

  style = gtk_widget_get_style(global.win);
  global.pix.sgreen = 
    gdk_pixmap_create_from_xpm_d(global.win->window,
				 &(global.pix.sgreenb),
				 &style->bg[GTK_STATE_NORMAL],
				 speedgreen_xpm);
  global.pix.sred = 
    gdk_pixmap_create_from_xpm_d(global.win->window,
				 &(global.pix.sredb),
				 &style->bg[GTK_STATE_NORMAL],
				 speedred_xpm);
  global.pix.syellow = 
    gdk_pixmap_create_from_xpm_d(global.win->window,
				 &(global.pix.syellowb),
				 &style->bg[GTK_STATE_NORMAL],
				 speedyellow_xpm);
  global.pix.sgray = 
    gdk_pixmap_create_from_xpm_d(global.win->window,
				 &(global.pix.sgrayb),
				 &style->bg[GTK_STATE_NORMAL],
				 speedgray_xpm);

  global.pix.folder = 
    gdk_pixmap_create_from_xpm_d(global.win->window,
				 &(global.pix.folderb),
				 &style->bg[GTK_STATE_NORMAL],
				 folder);
  global.pix.folder_open = 
    gdk_pixmap_create_from_xpm_d(global.win->window,
				 &(global.pix.folder_openb),
				 &style->bg[GTK_STATE_NORMAL],
				 folder_open);
  global.pix.user1 = 
    gdk_pixmap_create_from_xpm_d(global.win->window,
				 &(global.pix.user1b),
				 &style->bg[GTK_STATE_NORMAL],
				 user_on);
  global.pix.user2 = 
    gdk_pixmap_create_from_xpm_d(global.win->window,
				 &(global.pix.user2b),
				 &style->bg[GTK_STATE_NORMAL],
				 user_off);
  global.pix.ignore = 
    gdk_pixmap_create_from_xpm_d(global.win->window,
				 &(global.pix.ignoreb),
				 &style->bg[GTK_STATE_NORMAL],
				 ignore_xpm);
  global.pix.enemy = 
    gdk_pixmap_create_from_xpm_d(global.win->window,
				 &(global.pix.enemyb),
				 &style->bg[GTK_STATE_NORMAL],
				 enemy_xpm);
  global.pix.enemy2 = 
    gdk_pixmap_create_from_xpm_d(global.win->window,
				 &(global.pix.enemy2b),
				 &style->bg[GTK_STATE_NORMAL],
				 enemy2_xpm);
  global.pix.friend = 
    gdk_pixmap_create_from_xpm_d(global.win->window,
				 &(global.pix.friendb),
				 &style->bg[GTK_STATE_NORMAL],
				 friend_xpm);
  global.pix.dummy = 
    gdk_pixmap_create_from_xpm_d(global.win->window,
				 &(global.pix.dummyb),
				 &style->bg[GTK_STATE_NORMAL],
				 dummy_xpm);
}

void setup_widgets() {
  GtkWidget* temp;
  char* pos;

  temp = lookup_widget(global.win, "search_list");
  gtk_clist_set_sort_column(GTK_CLIST(temp), 0);
  gtk_clist_set_auto_sort(GTK_CLIST(temp), TRUE);
  gtk_clist_set_compare_func(GTK_CLIST(temp), search_compare);

  temp = lookup_widget(global.win, "Console_text");
  gtk_text_set_word_wrap(GTK_TEXT(temp), 1);

  temp = lookup_widget(global.win, "entry45");
  pos = make_string_from_list(global.highlight, "\"");
  gtk_entry_set_text(GTK_ENTRY(temp), pos);

  temp = lookup_widget(global.win, "entry46");
  pos = make_string_from_list(global.frienduser, " ");
  gtk_entry_set_text(GTK_ENTRY(temp), pos);

  temp = lookup_widget(global.win, "entry51");
  pos = make_string_from_list(global.enemyuser, " ");
  gtk_entry_set_text(GTK_ENTRY(temp), pos);


  temp = lookup_widget(global.win, "checkbutton7");
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp),
			       global.show_joins);

  temp = lookup_widget(global.win, "checkbutton14");
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp),
			       global.send_ignore);

  temp = lookup_widget(global.win, "checkbutton10");
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp),
			       global.ignore_public_ignore);

  temp = lookup_widget(global.win, "checkbutton21");
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp),
			       global.parse_color);

  temp = lookup_widget(global.win, "spinbutton5");
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp),
			    global.network.max_downloads);
  temp = lookup_widget(global.win, "spinbutton6");
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp),
			    global.network.max_uploads);
  temp = lookup_widget(global.win, "spinbutton8");
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp),
			    global.network.max_transfers);

  temp = lookup_widget(global.win, "button122");
  gtk_widget_set_sensitive(temp, FALSE);
  temp = lookup_widget(global.win, "button123");
  gtk_widget_set_sensitive(temp, FALSE);
  temp = lookup_widget(global.win, "button124");
  gtk_widget_set_sensitive(temp, FALSE);

  temp = lookup_widget(global.win, "channel_list");
  gtk_clist_set_sort_column(GTK_CLIST(temp), 0);
  gtk_clist_set_auto_sort(GTK_CLIST(temp), TRUE);
  gtk_clist_set_compare_func(GTK_CLIST(temp), channel_compare);

}

void setup_buttons() {
  GtkWidget* temp;

  temp = lookup_widget(global.win, "button114");  //chat
  set_up_button(temp, "pix1",  "pix2",  "frame98");
  temp = lookup_widget(global.win, "button130");  //mail
  set_up_button(temp, "pix15", "pix16", "vbox54");
  temp = lookup_widget(global.win, "button115");  //search
  set_up_button(temp, "pix3",  "pix4",  "frame3");
  temp = lookup_widget(global.win, "button116");  //hot1
  set_up_button(temp, "pix5",  "pix6",  "vbox46");
  temp = lookup_widget(global.win, "button118");  //hot2
  set_up_button(temp, "pix8",  "pix7",  "vbox55");
  temp = lookup_widget(global.win, "button119");  //transfer
  set_up_button(temp, "pix9",  "pix10", "hbox125");
}

void global_init() {
  GtkWidget* temp;
  time_t tim;
  char str[1024];
  hot_t* hot;

  global.connect_win = NULL;
  global.resume_win = NULL;
  global.ban_win = NULL;
  global.ignore_win = NULL;
  global.dir_select_win = NULL;
  global.whois_win = NULL;
  global.server_win = NULL;
  global.user_win = NULL;
  global.status.searching = 0;
  global.status.building = 0;
  global.status.exiting = 0;
  global.status.connected = 0;
  global.status.connecting = 0;
  global.status.whois_hide = 0;
  strcpy(global.current_room, "Console");
  global.servers = NULL;
  global.ignored_users = NULL;
  global.network.cur_uploads = 0;
  global.network.cur_downloads = 0;
  global.network.max_uploads = 1;
  global.network.max_downloads = 3;
  global.network.max_transfers = 3;
  global.network.firewall = 0;
  global.network.port = 6699;
  global.commands = NULL;
  global.upload_socket.fd = -1;
  global.colors = NULL;
  global.highlight = NULL;
  global.frienduser = NULL;
  global.enemyuser = NULL;
  global.chat_history = NULL;
  global.show_joins = 1;
  global.ignore_public_ignore = 0;
  global.send_ignore = 0;
  global.auto_connect = 0;
  global.logging = 0;
  global.afk = NULL;
  global.private_users = NULL;
  global.reply = NULL;
  global.mails = NULL;
  global.last_server = NULL;
  global.player = NULL;
  global.path.shared = NULL;
  global.path.download = NULL;
  global.schemes = NULL;
  global.connect_button = 0;
  global.parse_color = 1;
  global.user.level = L_USER;
  global.user.status = STATUS_INACTIVE;
  global.server.address.network = N_UNKNOWN;

  global.style[0] = gtk_widget_get_style(global.win);

  global.style[1] = gtk_style_new();
  global.style[1]->font = global.style[0]->font;
  global.style[1]->fg[GTK_STATE_NORMAL].pixel = 
    global.style[0]->fg[GTK_STATE_SELECTED].pixel;
  global.style[1]->fg[GTK_STATE_NORMAL].red = 65535;
  global.style[1]->fg[GTK_STATE_NORMAL].green = 0;
  global.style[1]->fg[GTK_STATE_NORMAL].blue = 0;

  global.style[2] = gtk_style_new();
  global.style[2]->font = global.style[0]->font;
  global.style[2]->base[GTK_STATE_NORMAL].pixel = 
    global.style[0]->base[GTK_STATE_NORMAL].pixel;
  global.style[2]->base[GTK_STATE_NORMAL].red = 0;
  global.style[2]->base[GTK_STATE_NORMAL].green = 0;
  global.style[2]->base[GTK_STATE_NORMAL].blue = 0;

  global.style[2]->text[GTK_STATE_NORMAL].pixel = 
    global.style[0]->text[GTK_STATE_NORMAL].pixel;
  global.style[2]->text[GTK_STATE_NORMAL].red = 65535;
  global.style[2]->text[GTK_STATE_NORMAL].green = 65535;
  global.style[2]->text[GTK_STATE_NORMAL].blue = 65535;

  temp = lookup_widget(global.win, "Console_text");
  gtk_widget_set_style(temp, global.style[2]);  

  sprintf(str, "%s/.lopster", getenv("HOME"));
  global.lopster_home = strdup(str);
  create_dir(str);
  sprintf(str, "%s/log", global.lopster_home);
  create_dir(str);
  sprintf(str, "%s/schemes", global.lopster_home);
  create_dir(str);

  time(&tim);
  global.session_start = strdup(ctime(&tim));
  global.session_start[strlen(global.session_start)-1] = 0;

  printf("Lopster started at %s\n", global.session_start);

  temp = lookup_widget(global.win, "hot_tree");
  hot = (hot_t*)malloc(sizeof(hot_t));
  hot->files = 0;
  hot->bytes = 0;
  gtk_object_set_data(GTK_OBJECT(temp), "stats", hot);

  gdk_color_parse("#ffffff", &global.color_table[0]);  // W
  gdk_color_parse("#000000", &global.color_table[1]);  // Bl
  gdk_color_parse("#0000aa", &global.color_table[2]);  // b_
  gdk_color_parse("#00aa00", &global.color_table[3]);  // g_
  gdk_color_parse("#aa0000", &global.color_table[4]);  // r_
  gdk_color_parse("#aa5500", &global.color_table[5]);  // y_
  gdk_color_parse("#aa00aa", &global.color_table[6]);  // p_
  gdk_color_parse("#ff5555", &global.color_table[7]);  // R_
  gdk_color_parse("#ffff55", &global.color_table[8]);  // Y_
  gdk_color_parse("#55ff55", &global.color_table[9]);  // G
  gdk_color_parse("#00aaaa", &global.color_table[10]); // c
  gdk_color_parse("#55ffff", &global.color_table[11]); // C
  gdk_color_parse("#5555ff", &global.color_table[12]); // B_
  gdk_color_parse("#ff55ff", &global.color_table[13]); // P_
  gdk_color_parse("#555555", &global.color_table[14]); //dG
  gdk_color_parse("#aaaaaa", &global.color_table[15]); // w_

  // setting up
  read_geometry();

  // setting up signal handlers
  signal(SIGPIPE, sigpipe_handler);

  // setting up commands
  setup_commands();

  // setting up show/hide buttons
  setup_buttons();

  // creating pixmaps
  create_pixmaps();

  // reading rc file
  read_rc();
  
  // setting up colors
  if (!global.scheme) global.scheme = strdup("default");
  global.colors = scheme_load(global.colors, global.scheme);

  // setting up some GtkWidgets
  setup_widgets();

  // setting up shared files
  if (!lib_load()) lib_refresh();

  // creating  listening port
  create_upload_port(TRUE);
  
  update_user_stats();

  gtk_idle_add(idle_function, NULL);
  global.dl = gtk_timeout_add(2000, download_inspector, NULL);
}

void global_exit() {
  GtkWidget* temp;
  
  gtk_timeout_remove(global.dl);

  if (global.upload_socket.fd >= 0) {
    if (global.upload_socket.input > 0)
      gdk_input_remove(global.upload_socket.input);
    close(global.upload_socket.fd);
  }
  
  write_rc();

  write_geometry();

  temp = lookup_widget(global.win, "checkbutton20");
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
    on_button134_clicked(NULL, NULL);
  }
  
  // deleting commands
  command_delete_all();
  
  // and delete the global file list
}


char* extract_short_name(char* longname) {
  char dir_sep;
  char* pos1;
  char* pos2;

  // extracting short name
  dir_sep = '/';   // ext file system

  pos1 = strchr(longname, dir_sep);
  pos2 = strrchr(longname, dir_sep);
  if (pos1 == pos2) {  // none or only one sep found
    return longname;
  } else {
    pos2[0] = 'Q';
    pos1 = strrchr(longname, dir_sep);
    pos2[0] = dir_sep;
    pos1++;
    return pos1;
  }
}

char* convert_to_win(char* name) {
  char* ptr;
   
  ptr = name;
  if (!ptr || !*ptr) return NULL;

  while(*ptr) {
    if (*ptr == '/') *ptr = '\\';
    ptr++;
  }

  return ptr;
}

char* convert_to_unix(char* name) {
  char* ptr;
   
  ptr = name;
  if (!ptr || !*ptr) return NULL;

  while(*ptr) {
    if (*ptr == '\\') *ptr = '/';
    ptr++;
  }

  return ptr;
}

void destroy_file_row(gpointer data) {
  file_t* file;

  file = (file_t*)data;
  
  if (file->longname) free(file->longname);
  if (file->shortname) free(file->shortname);
  if (file->winname) free(file->winname);
  if (file->user) free(file->user);
  if (file->md5) free(file->md5);
  free(file);
}

unsigned int get_bits(unsigned char* buffer, int start, int no) {
  unsigned int res = 0;

  res |= buffer[0]<<24 | buffer[1]<<16 |
    buffer[2]<<8 | buffer[3];
  
  res <<= start;
  res >>= (32-no);
  return res;
}

void file_parse_header(file_t *file) {
  FILE* fd;
  unsigned char buffer[4];  // header
  int mpeg_version;
  int mpeg_layer;
  int res;
  long framesize;
  long totalframes;
  short br[2][4][16] = {
    {  // mpeg 2
      { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
      { 0, 32, 48, 56, 64, 80, 96, 112, 128, 144, 160, 176, 192, 224, 256, 0 }, // 
      { 0, 8, 16, 24, 32, 40, 48, 56, 64, 80, 96, 112, 128, 144, 160, 0 },      // 
      { 0, 8, 16, 24, 32, 40, 48, 56, 64, 80, 96, 112, 128, 144, 160, 0 }       // 
    },
    {  // mpeg1
      { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
      { 0, 32, 40, 48, 56, 64, 80, 96, 112, 128, 160, 192, 224, 256, 320, 0 },     // layer III
      { 0, 32, 48, 56, 64, 80, 96, 112, 128, 160, 192, 224, 256, 320, 384, 0 },    // layer II
      { 0, 32, 64, 96, 128, 160, 192, 224, 256, 288, 320, 352, 384, 416, 448, 0 }  // layer I
    }
  };

  int freq[2][4] = {
    {22050, 24000, 16000, 0},
    {44100, 48000, 32000, 0}
  };

  if ((fd = fopen(file->longname, "r")) != NULL) {
    if (fread(buffer, sizeof(char), 4, fd) != 4) {
      //      printf("could not read header [%s]\n", file->longname);
      return;
    }
    // i think this is not correct sometimes
    while (get_bits(buffer, 0, 11) != 0x7ff) {
      buffer[0] = buffer[1];
      buffer[1] = buffer[2];
      buffer[2] = buffer[3];
      if (fread(&buffer[3], sizeof(char), 1, fd) != 1) {
	//	printf("could not read header [%s]\n", file->longname);
	return;
      }
    }
  } else {
//    printf("could not open file for reading header [%s]\n", file->longname);
    return;
  }

  // sync word
  res = get_bits(buffer, 0, 12);
  
  // MPEG Version
  mpeg_version = get_bits(buffer, 12, 1);

  // MPEG Layer
  mpeg_layer = get_bits(buffer, 13, 2);

  // Protection Bit
  res = get_bits(buffer, 15, 1);

  // Bitrate
  res = get_bits(buffer, 16, 4);
  file->bitrate = br[mpeg_version][mpeg_layer][res];

  // Fequency
  res = get_bits(buffer, 20, 2);
  file->frequency = freq[mpeg_version][res];
  if ((file->bitrate == 0) || (file->frequency == 0)) {
    //    printf("corrupted header! [%s]\n", file->longname);
    return;
  }

  framesize = 144000 * file->bitrate / file->frequency;
  totalframes = (file->size / (framesize + 1)) - 1;
  file->length = (time_t) (totalframes * 1152 / file->frequency);

  // Padding Bit
  res = get_bits(buffer, 22, 1);
  
  // Private Bit
  res = get_bits(buffer, 23, 1);
  
  // Mode
  res = get_bits(buffer, 24, 2);
  
  // Mode Extention
  res = get_bits(buffer, 26, 2);
  
  // Copyright
  res = get_bits(buffer, 28, 1);
  
  // Original Home
  res = get_bits(buffer, 29, 1);
  
  // Enphasis
  res = get_bits(buffer, 30, 2);
  
  fclose(fd);
}

void file_calc_md5(file_t *file) {
  //  file->md5 = MD5File(file->longname, file->md5);
  file->md5 = strdup("NOTCOMPUTED");
}

gint
search_compare (GtkCList      *clist,
		gconstpointer  ptr1,
		gconstpointer  ptr2) {
  file_t* file1;
  file_t* file2;

  GtkCListRow *row1 = (GtkCListRow *) ptr1;
  GtkCListRow *row2 = (GtkCListRow *) ptr2;

  file1 = row1->data;
  file2 = row2->data;

  if (!file2) return (file1!=NULL);
  if (!file1) return -1;

  if (clist->sort_column == 0) {
    return strcasecmp (file1->shortname, file2->shortname);
  } else if (clist->sort_column == 1) {
    if (file1->size < file2->size) return -1;
    if (file1->size > file2->size) return 1;
    return 0;
  } else if (clist->sort_column == 2) {
    if (file1->bitrate < file2->bitrate) return -1;
    if (file1->bitrate > file2->bitrate) return 1;
    return 0;
  } else if (clist->sort_column == 3) {
    if (file1->length < file2->length) return -1;
    if (file1->length > file2->length) return 1;
    return 0;
  } else if (clist->sort_column == 4) {
    return strcasecmp (file1->user, file2->user);
  } else if (clist->sort_column == 5) {
    if (file1->linespeed < file2->linespeed) return -1;
    if (file1->linespeed > file2->linespeed) return +1;
    return 0;
  } else if (clist->sort_column == 6) {
    if (file1->ping < file2->ping) return -1;
    if (file1->ping > file2->ping) return +1;
    return 0;
  } else {
    return strcasecmp (file1->shortname, file2->shortname);
  }
}

gint
lib_compare (GtkCList      *clist,
	     gconstpointer  ptr1,
	     gconstpointer  ptr2) {
  file_t* file1;
  file_t* file2;

  GtkCListRow *row1 = (GtkCListRow *) ptr1;
  GtkCListRow *row2 = (GtkCListRow *) ptr2;

  file1 = row1->data;
  file2 = row2->data;

  if (!file2) return (file1!=NULL);
  if (!file1) return -1;

  if (clist->sort_column == 0) {
    return strcasecmp (file1->shortname, file2->shortname);
  } else if (clist->sort_column == 1) {
    if (file1->size < file2->size) return -1;
    if (file1->size > file2->size) return 1;
    return 0;
  } else if (clist->sort_column == 2) {
    if (file1->bitrate < file2->bitrate) return -1;
    if (file1->bitrate > file2->bitrate) return 1;
    return 0;
  } else if (clist->sort_column == 3) {
    if (file1->frequency < file2->frequency) return -1;
    if (file1->frequency > file2->frequency) return 1;
    return 0;
  } else if (clist->sort_column == 4) {
    if (file1->length < file2->length) return -1;
    if (file1->length > file2->length) return 1;
    return 0;
  } else {
    return strcmp (file1->shortname, file2->shortname);
  }
}

gint
channel_compare (GtkCList      *clist,
		 gconstpointer  ptr1,
		 gconstpointer  ptr2) {

  char *text1 = NULL;
  char *text2 = NULL;
  int u1, u2;

  GtkCListRow *row1 = (GtkCListRow *) ptr1;
  GtkCListRow *row2 = (GtkCListRow *) ptr2;

  text1 = GTK_CELL_TEXT (row1->cell[clist->sort_column])->text;
  text2 = GTK_CELL_TEXT (row2->cell[clist->sort_column])->text;

  if (!text2)
    return (text1 != NULL);

  if (!text1)
    return -1;

  if ((clist->sort_column == 4) || (clist->sort_column == 0)) {
    return strcasecmp (text1, text2);
  } else if ((clist->sort_column == 1) || 
	     (clist->sort_column == 2) || 
	     (clist->sort_column == 3)) {
    sscanf(text1, "%d", &u1);
    sscanf(text2, "%d", &u2);
    if (u1 < u2) return -1;
    if (u1 > u2) return 1;
    return 0;
  } else {
    return 0;
  }
}

gint
dir_compare (GtkCList      *clist,
	     gconstpointer  ptr1,
	     gconstpointer  ptr2) {

  char *text1 = NULL;
  char *text2 = NULL;

  GtkCListRow *row1 = (GtkCListRow *) ptr1;
  GtkCListRow *row2 = (GtkCListRow *) ptr2;

  text1 = GTK_CELL_TEXT (row1->cell[clist->sort_column])->text;
  text2 = GTK_CELL_TEXT (row2->cell[clist->sort_column])->text;

  if (!text2)
    return (text1 != NULL);

  if (!text1)
    return -1;

  return strcasecmp (text1, text2);
}

gint
server_compare (GtkCList      *clist,
		 gconstpointer  ptr1,
		 gconstpointer  ptr2) {

  char *text1 = NULL;
  char *text2 = NULL;
  int u1, u2;

  GtkCListRow *row1 = (GtkCListRow *) ptr1;
  GtkCListRow *row2 = (GtkCListRow *) ptr2;

  text1 = GTK_CELL_TEXT (row1->cell[clist->sort_column])->text;
  text2 = GTK_CELL_TEXT (row2->cell[clist->sort_column])->text;

  if (!text2)
    return (text1 != NULL);

  if (!text1)
    return -1;

  if ((clist->sort_column == 3) || 
      (clist->sort_column == 0)) {
    return strcmp (text1, text2);
  } else if ((clist->sort_column == 2) || 
	     (clist->sort_column == 4) || 
	     (clist->sort_column == 5) || 
	     (clist->sort_column == 6)) {
    sscanf(text1, "%d", &u1);
    sscanf(text2, "%d", &u2);
    if (u1 < u2) return -1;
    if (u1 > u2) return 1;
    return 0;
  } else {
    return 0;
  }
}

void cmd_eval_whois(char* data) {
  char* pos1;
  GtkEntry* entry;
  GtkWidget* temp;
  int t1;
  char str[200];
  int self;

  if (global.whois_win == NULL) {
    global.whois_win = create_whois_win();
  }
  gtk_window_set_title (GTK_WINDOW (global.whois_win), "Whois User");
  temp = lookup_widget(global.whois_win, "label116");
  gtk_label_set_text(GTK_LABEL(temp), "Online");

#ifdef GLOBAL_DEBUG
  printf("whois: %d\n", global.status.whois_hide);
#endif
  if (global.status.whois_hide == 0) {
    gtk_widget_show(global.whois_win);
  } else {
    global.status.whois_hide--;
  }

  pos1 = strchr(data, ' ');
  pos1[0] = 0;
  entry = GTK_ENTRY(lookup_widget(global.whois_win, "entry56"));
  gtk_entry_set_text(entry, data);
  if (strcmp(data, global.user.username) == 0) self = 1;
  else self = 0;
  data = pos1+1;

  pos1 = strchr(data, ' ');
  pos1[0] = 0;
  entry = GTK_ENTRY(lookup_widget(global.whois_win, "entry25"));
  gtk_entry_set_text(entry, "Level: ");
  gtk_entry_append_text(entry, data);
  if (self) {
    global.user.level = level2int(data);
#ifdef GLOBAL_DEBUG
    printf("user level: %d\n", global.user.level);
#endif
  }
  data = pos1+1;

  pos1 = strchr(data, ' ');
  pos1[0] = 0;
  entry = GTK_ENTRY(lookup_widget(global.whois_win, "entry26"));
  sscanf(data, "%d", &t1);
  sprintf(str, "%dh %dmin %dsec", 
	  t1/(60*60), (t1%(60*60))/60, t1%60);
  gtk_entry_set_text(entry, str);
  data = pos1+2;
  
  pos1 = strchr(data, '"');
  pos1[0] = 0;
  entry = GTK_ENTRY(lookup_widget(global.whois_win, "entry27"));
  gtk_widget_set_sensitive(GTK_WIDGET(entry), TRUE);
  gtk_entry_set_text(entry, data);
  data = pos1+2;

  pos1 = strchr(data, ' ');
  pos1[0] = 0;
  entry = GTK_ENTRY(lookup_widget(global.whois_win, "entry28"));
  gtk_widget_set_sensitive(GTK_WIDGET(entry), TRUE);
  gtk_entry_set_text(entry, data);
  global.user.status = status2int(data);
  data = pos1+1;

  pos1 = strchr(data, ' ');
  pos1[0] = 0;
  entry = GTK_ENTRY(lookup_widget(global.whois_win, "entry62"));
  gtk_widget_set_sensitive(GTK_WIDGET(entry), TRUE);
  gtk_entry_set_text(entry, "Shared: ");
  gtk_entry_append_text(entry, data);
  data = pos1+1;

  pos1 = strchr(data, ' ');
  pos1[0] = 0;
  entry = GTK_ENTRY(lookup_widget(global.whois_win, "entry30"));
  gtk_widget_set_sensitive(GTK_WIDGET(entry), TRUE);
  gtk_entry_set_text(entry, data);
  gtk_entry_append_text(entry, " downs");
  data = pos1+1;

  pos1 = strchr(data, ' ');
  pos1[0] = 0;
  entry = GTK_ENTRY(lookup_widget(global.whois_win, "entry59"));
  gtk_widget_set_sensitive(GTK_WIDGET(entry), TRUE);
  gtk_entry_set_text(entry, data);
  gtk_entry_append_text(entry, " ups");
  data = pos1+1;

  pos1 = strchr(data, ' ');
  pos1[0] = 0;
  entry = GTK_ENTRY(lookup_widget(global.whois_win, "entry61"));
  gtk_widget_set_sensitive(GTK_WIDGET(entry), TRUE);
  sscanf(data, "%d", &t1);
  gtk_entry_set_text(entry, "Link: ");
  gtk_entry_append_text(entry, LineSpeed[t1]);
  data = pos1+2;

  pos1 = strchr(data, '"');
  pos1[0] = 0;
  entry = GTK_ENTRY(lookup_widget(global.whois_win, "entry60"));
  gtk_widget_set_sensitive(GTK_WIDGET(entry), TRUE);
  gtk_entry_set_text(entry, data);

  entry = GTK_ENTRY(lookup_widget(global.whois_win, "entry34"));
  gtk_entry_set_text(entry, "");

  if (self) update_user_stats();
  
  // Vetinari18 "User" 3027 " #German " "Active" 1415 0 0 5 "v2.0 BETA 7"
  // 3 1 213.6.110.212 1083 0 unknown
  temp = lookup_widget(global.whois_win, "vbox60");
  if (global.user.level < L_MOD) {
    gtk_widget_hide(temp);
    return;
  } else {
    gtk_widget_show(temp);
  }

  data = pos1+2;
  pos1 = strchr(data, ' ');
  pos1[0] = 0;
  entry = GTK_ENTRY(lookup_widget(global.whois_win, "entry63"));
  gtk_entry_set_text(entry, data);
  gtk_entry_append_text(entry, " downs");
  data = pos1+1;

  pos1 = strchr(data, ' ');
  pos1[0] = 0;
  entry = GTK_ENTRY(lookup_widget(global.whois_win, "entry64"));
  gtk_entry_set_text(entry, data);
  gtk_entry_append_text(entry, " ups");
  data = pos1+1;

  pos1 = strchr(data, ' ');
  pos1[0] = 0;
  entry = GTK_ENTRY(lookup_widget(global.whois_win, "entry65"));
  gtk_entry_set_text(entry, data);
  data = pos1+1;

  pos1 = strchr(data, ' ');
  pos1[0] = 0;
  entry = GTK_ENTRY(lookup_widget(global.whois_win, "entry66"));
  gtk_entry_set_text(entry, data);
  data = pos1+1;

  pos1 = strchr(data, ' ');
  pos1[0] = 0;
  entry = GTK_ENTRY(lookup_widget(global.whois_win, "entry67"));
  gtk_entry_set_text(entry, data);
  data = pos1+1;

  entry = GTK_ENTRY(lookup_widget(global.whois_win, "entry68"));
  gtk_entry_set_text(entry, data);
}

void cmd_eval_whowas(char* data) {
  char* pos1;
  GtkEntry* entry;
  GtkWidget* temp;
  time_t last_seen;
  char str[200];
  
  if (global.whois_win == NULL) {
    global.whois_win = create_whois_win();
  }
  gtk_widget_show(global.whois_win);

  gtk_window_set_title (GTK_WINDOW (global.whois_win), "Whowas User");
  
  temp = lookup_widget(global.whois_win, "label116");
  gtk_label_set_text(GTK_LABEL(temp), "Last Seen");

  pos1 = strchr(data, ' ');
  pos1[0] = 0;
  entry = GTK_ENTRY(lookup_widget(global.whois_win, "entry56"));
  gtk_entry_set_text(entry, data);
  data = pos1+1;

  if (data[0] == '\"') {
    data++;
    pos1 = strchr(data, '"');
  } else {
    pos1 = strchr(data, ' ');
  }
  pos1[0] = 0;
  entry = GTK_ENTRY(lookup_widget(global.whois_win, "entry25"));
  gtk_entry_set_text(entry, data);
  if (data[0] == '\"') pos1++;
  data = pos1+1;

  entry = GTK_ENTRY(lookup_widget(global.whois_win, "entry26"));
  sscanf(data, "%ld", &last_seen);
  sprintf(str, "%s", ctime(&last_seen));
  gtk_entry_set_text(entry, str);

  entry = GTK_ENTRY(lookup_widget(global.whois_win, "entry34"));
  gtk_entry_set_text(entry, "");


  temp = lookup_widget(global.whois_win, "entry27");
  gtk_entry_set_text(GTK_ENTRY(temp), "");
  gtk_widget_set_sensitive(temp, FALSE);

  temp = lookup_widget(global.whois_win, "entry28");
  gtk_entry_set_text(GTK_ENTRY(temp), "");
  gtk_widget_set_sensitive(temp, FALSE);

  temp = lookup_widget(global.whois_win, "entry62");
  gtk_entry_set_text(GTK_ENTRY(temp), "");
  gtk_widget_set_sensitive(temp, FALSE);

  temp = lookup_widget(global.whois_win, "entry30");
  gtk_entry_set_text(GTK_ENTRY(temp), "");
  gtk_widget_set_sensitive(temp, FALSE);

  temp = lookup_widget(global.whois_win, "entry59");
  gtk_entry_set_text(GTK_ENTRY(temp), "");
  gtk_widget_set_sensitive(temp, FALSE);

  temp = lookup_widget(global.whois_win, "entry61");
  gtk_entry_set_text(GTK_ENTRY(temp), "");
  gtk_widget_set_sensitive(temp, FALSE);

  temp = lookup_widget(global.whois_win, "entry60");
  gtk_entry_set_text(GTK_ENTRY(temp), "");
  gtk_widget_set_sensitive(temp, FALSE);


  temp = lookup_widget(global.whois_win, "vbox60");
  gtk_widget_hide(temp);
}

void cmd_server_stats(char* data) {
  GtkWidget* temp;
  int songs, gics, users;
  char t[500];

  sscanf(data, "%d %d %d", &users, &songs, &gics);
  temp = lookup_widget(global.win, "label280");
  sprintf(t, "%d Users", users);
  gtk_label_set_text(GTK_LABEL(temp), t);
  temp = lookup_widget(global.win, "label281");
  sprintf(t, "%d Songs",songs);
  gtk_label_set_text(GTK_LABEL(temp), t);
  temp = lookup_widget(global.win, "label282");
  sprintf(t, "%d GB", gics);
  gtk_label_set_text(GTK_LABEL(temp), t);
}

void napigator_read(gpointer data, int source, 
		    GdkInputCondition condition) {
  int n;
  static char buf[1024];
  static int progress = 0;
  char* line = buf;
  char* line_end;
  static int offset = 0;
  char* pos;
  GtkWidget* temp;
  int hide_napster;

  temp = lookup_widget(global.server_win, "checkbutton6");
  hide_napster = 
    gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp));
  temp = lookup_widget(global.server_win, "server_list");

  n = recv(source, buf+offset, sizeof(buf) -1-offset, 0);
  if (n <= 0) {
    gdk_input_remove(global.napigator.input);
    close(source);
    temp = lookup_widget(global.server_win, "button104");
    gtk_widget_set_sensitive(temp, TRUE);
    line = buf;
    offset = 0;
    progress = 0;
    return;
  }
  buf[n+offset] = 0;

  if (progress == 0) {  // header
    while ((line_end = strchr(line, '\r')) != NULL) {
      line_end[0] = 0;
      if (!strcmp(line, "Content-Type: text/html")) {
	progress = 1;
	line = line_end+2;
	break;
      }
      line = line_end+2;
    }
    strcpy(buf, line);
    line = buf;
    offset = strlen(buf);
  }

  if (progress == 1) {
    while ((line_end = strchr(line, '\n')) != NULL) {
      line_end[0] = 0;
      if (strlen(line) >= 3) {
	pos = strtok(line, " ");
	if (!pos) {
	  gdk_input_remove(global.napigator.input);
	  close(source);
	  return;
	}
	strcpy(tstr[1], pos);
	pos = strtok(NULL, " ");
	if (!pos) {
	  gdk_input_remove(global.napigator.input);
	  close(source);
	  return;
	}
	strcpy(tstr[2], pos);
	pos = strtok(NULL, " ");
	if (!pos) {
	  gdk_input_remove(global.napigator.input);
	  close(source);
	  return;
	}
	strcpy(tstr[3], pos);
	pos = strtok(NULL, " ");
	if (!pos) {
	  gdk_input_remove(global.napigator.input);
	  close(source);
	  return;
	}
	strcpy(tstr[4], pos);

	pos = strtok(NULL, " ");
	if (pos) {
	  strcpy(tstr[5], pos);
	  pos = strtok(NULL, " ");
	  if (!pos) {
	    gdk_input_remove(global.napigator.input);
	    close(source);
	    return;
	  }
	  strcpy(tstr[6], pos);
	  pos = strtok(NULL, " ");
	  if (!pos) {
	    gdk_input_remove(global.napigator.input);
	    close(source);
	    return;
	  }
	  strcpy(tstr[0], pos);
	  if ((!hide_napster) || (strcasecmp("Napster", tstr[3])))
	    gtk_clist_append(GTK_CLIST(temp), list);
	}
      }
      line = line_end+1;
    }
    strcpy(buf, line);
    line = buf;
    offset = strlen(buf);
  }
}


void napigator_request(gpointer data, int source, 
		       GdkInputCondition condition) {
  int err, len;
   
  gdk_input_remove(global.napigator.input);

  len = sizeof(err);
  getsockopt(source, SOL_SOCKET, SO_ERROR, &err, &len);
  if (err) {
    g_warning("Could not create connection to www.napigator.com %d", err);
    return;
  }

  send(source, "GET /servers.php?version=107&client=lopster HTTP/1.0\n\n", 
       strlen("GET /servers.php?version=107&client=lopster HTTP/1.0\n\n"), 0);
   
  global.napigator.input = gdk_input_add(source, GDK_INPUT_READ,
					 napigator_read, NULL);
}


void napigator_get_list() {
  int res;
  GtkWidget* temp;

  global.napigator.address.ip = strdup("209.25.178.23");
  global.napigator.address.ip_long = 
    inet_addr(global.napigator.address.ip);
  global.napigator.address.port = 80;
  
  res = connect_socket(&(global.napigator));

  if ((res != 0) && (res != EINPROGRESS)) {
    temp = lookup_widget(global.server_win, "button104");
    gtk_widget_set_sensitive(temp, TRUE);
    return;
  }

  global.napigator.input =
    gdk_input_add(global.napigator.fd, GDK_INPUT_WRITE, 
		  GTK_SIGNAL_FUNC(napigator_request),
		  &(global.napigator));  
}

address_t* search_server_in_list(address_t* server) {
  GtkCList* clist;
  address_t* server2;
  int i1;

  clist = GTK_CLIST(lookup_widget(global.options_win, "server_list"));

  for (i1 = 0; i1 < clist->rows; i1++) {
    server2 = (address_t*)gtk_clist_get_row_data(clist, i1);
    if (!strcasecmp(server2->ip, server->ip))
      if (server2->port == server->port)
	return server2;
  }
  return NULL;
}

address_t* search_server_in_glist(address_t* server) {
  address_t* server2;
  GList* dlist;

  if (global.servers) {
    dlist = g_list_first(global.servers);
  while (dlist) {
      server2 = (address_t*)(dlist->data);
      if (!strcasecmp(server2->ip, server->ip))
     if (server2->port == server->port)
	  return server2;
	  dlist = g_list_next(dlist);
    }
  }

  return NULL;
}
int server_comp(const void* s1, const void* s2) {
  address_t* ser1 = (address_t*)s1;
  address_t* ser2 = (address_t*)s2;

  if (ser1->no_connected < ser2->no_connected) return +1;
  if (ser1->no_connected > ser2->no_connected) return -1;
  return 0;
}

void make_list_from_string(GList** glist, char* text, char* sep) {
  char* pos2;

  if (*glist) g_list_free(*glist);
  *glist = NULL;

  pos2 = strtok(text, sep);
  while (pos2) {
    if (strlen(pos2) > 0) {
      *glist = g_list_append(*glist, strdup(pos2));
    }
    pos2 = strtok(NULL, sep);
  }
}

char* make_string_from_list(GList* glist, char* sep) {
  static char result[1024];
  char* text;
  int i1;

  result[0] = 0;
  if (glist == NULL) {
    return result;
  }

  for (i1 = 0; i1 < g_list_length(glist); i1++) {
    text = (char*)(g_list_nth(glist, i1)->data);
    if (strlen(result) > 0) strcat(result, sep);
    strcat(result, text);
  }
  
  return result;
}

char* is_string_in_list(GList* glist, char* t) {
  GList* dlist;
  char* text;

  dlist = g_list_first(glist);
  
  while (dlist) {
    text = (char*)(dlist->data);
    if (!strcasecmp(t, text)) {
      return text;
    }
    dlist = g_list_next(dlist);
  }
  return NULL;
}

char* is_prefix_in_list(GList* glist, char* t) {
  GList* dlist;
  char* text;

  dlist = g_list_first(glist);
  
  //  printf("user: %s\n", t);
  while (dlist) {
    text = (char*)(dlist->data);
    //    printf("%s\n", text);
    if (t == NULL) return text;
    if (!strncasecmp(t, text, strlen(t))) {
      return text;
    }
    dlist = g_list_next(dlist);
  }
  return NULL;
}

int cmp_str(char* s1, char* s2) {
  int i1, len;
  
  i1 = strlen(s1);
  len = strlen(s2);

  if (i1 < len) len = i1;

  for (i1 = 0; i1 < len; i1++) {
    if (toupper(s1[i1]) != toupper(s2[i1]))
      break;
  }
  return i1;
}

int calc_list_prefix(GList* glist) {
  int res;
  int i1;
  int temp;
  char* text;

  if (g_list_length(glist) < 1) return 0;
  
  text = g_list_nth(glist, 0)->data;
  res = strlen(text);

  for (i1 = 0; i1 < g_list_length(glist); i1++) {
    temp = cmp_str(g_list_nth(glist, i1)->data, text);
    if (temp < res) res = temp;
  }
  return res;
}

int calc_command_prefix(GList* glist) {
  int res;
  int i1;
  int temp;
  char* text;
  command_t* command;

  if (g_list_length(glist) < 1) return 0;
  
  command = g_list_nth(glist, 0)->data;
  text = command->name;
  res = strlen(text);

  for (i1 = 0; i1 < g_list_length(glist); i1++) {
    command = g_list_nth(glist, i1)->data;
    temp = cmp_str(command->name, text);
    if (temp < res) res = temp;
  }
  return res;
}

void play_file(char* filename) {
  char command[1024];

  if (!global.player) return;

  sprintf(command, "%s \"%s\"&", global.player, filename);
  system(command);

  /*
  gchar *argv[4];
  gint pid;
  pid = fork();
  if(pid == 0) {
    argv[0] = "sh";
    argv[1] = "-c";
    argv[2] = command;
    argv[3] = 0;
    execve("/bin/sh", argv, environ);
    exit(127);
  }
  */
}

void convert_text(char* text) {
  int i1;
  int i2;

  for (i1 = 0, i2 = 0; i2 < strlen(text); i1++, i2++) {
    if ((text[i2] == '\\') &&(text[i2+1] == 'n')) {
      text[i1] = '\n';
      i2++;
    } else {
      text[i1] = text[i2];
    }
  }
  text[i1] = 0;
}

void set_last_server(address_t* server) {
  if (global.last_server) {
    free(global.last_server->ip);
  } else {
    global.last_server = (address_t*)malloc(sizeof(address_t));
    global.last_server->description = strdup("Last Server");
  }

  global.last_server->ip = strdup(server->ip);
  global.last_server->ip_long = server->ip_long;
  global.last_server->port = server->port;
}

void set_options_channels() {
  GList* dlist;
  int i1;
  GtkWidget* temp;
  char* pos;

  if (!global.options_win) return;

  dlist = NULL;
  temp = lookup_widget(global.win, "channel_list");
  for (i1 = 0; i1 < GTK_CLIST(temp)->rows; i1++) {
    gtk_clist_get_text(GTK_CLIST(temp), i1, 0, &pos);
    dlist = g_list_append(dlist, strdup(pos));
  }
  if (dlist) {
    temp = lookup_widget(global.options_win, "combo8");
    gtk_combo_set_popdown_strings (GTK_COMBO (temp), dlist);
  }
}

void set_button_state(GtkWidget* button, int open) {
  GtkWidget* temp;
  
  if (open) {
    temp = GTK_WIDGET(gtk_object_get_data(GTK_OBJECT(button), "pix_open"));
    gtk_widget_hide(temp);
    temp = GTK_WIDGET(gtk_object_get_data(GTK_OBJECT(button), "pix_closed"));
    gtk_widget_show(temp);
    temp = GTK_WIDGET(gtk_object_get_data(GTK_OBJECT(button), "con_widget"));
    gtk_widget_show(temp);
  } else {
    temp = GTK_WIDGET(gtk_object_get_data(GTK_OBJECT(button), "pix_open"));
    gtk_widget_show(temp);
    temp = GTK_WIDGET(gtk_object_get_data(GTK_OBJECT(button), "pix_closed"));
    gtk_widget_hide(temp);
    temp = GTK_WIDGET(gtk_object_get_data(GTK_OBJECT(button), "con_widget"));
    gtk_widget_hide(temp);
  }
}

int toggle_button_state(GtkWidget* button) {
  GtkWidget* temp;
  
  temp = GTK_WIDGET(gtk_object_get_data(GTK_OBJECT(button), "con_widget"));

  if (GTK_WIDGET_VISIBLE(temp)) {
    set_button_state(button, 0);
    return 0;
  } else {
    set_button_state(button, 1);
    return 1;
  }
}

void set_up_button(GtkWidget* button, 
		   char* pix1, char* pix2, char *wid) {
  GtkObject* obj;
  GtkWidget* temp;

  obj = GTK_OBJECT(button);
  temp = lookup_widget(button, pix1);
  gtk_object_set_data(obj, "pix_open", temp);
  temp = lookup_widget(button, pix2);
  gtk_object_set_data(obj, "pix_closed", temp);
  temp = lookup_widget(button, wid);
  gtk_object_set_data(obj, "con_widget", temp);
}

void show_bans(char* channel) {
  GtkWidget* temp;
  char str[1024];

  if (global.ban_win) {
    temp = lookup_widget(global.ban_win, "clist3");
    gtk_clist_clear(GTK_CLIST(temp));
  } else {
    global.ban_win = create_ban_win();
    gtk_widget_show(global.ban_win);
  }

  if (channel) {
    sprintf(str, "Banned Users for Channel %s\n", channel);
    send_command(CMD_CLIENT_CHANNEL_BAN_LIST, channel);
  } else {
    sprintf(str, "Global banned Users");
    send_command(CMD_CLIENT_BANLIST, "");
  }
  gtk_window_set_title(GTK_WINDOW(global.ban_win), str);
}

void cmd_banlist_entry(char* data) {
  char* pos;
  time_t l1;
  GtkWidget* temp;

  if (!global.ban_win) return;

  temp = lookup_widget(global.ban_win, "clist3");
  sscanf(data, "%s %s", tstr[0], tstr[1]);
  data = strchr(data, '\"')+1;
  pos = strrchr(data, '\"');
  pos[0] = 0;
  strcpy(tstr[3], data);
  data = pos + 2;
  sscanf(data, "%ld\n", &l1);
  sprintf(tstr[2], "%s", ctime(&l1));
  gtk_clist_append(GTK_CLIST(temp), list);
}

/////////////////////////////////////////////////////////////
// the code of the cparse() is almost copied from TekNap
/////////////////////////////////////////////////////////////
char* cparse(char *input) {
  int read;
  int write;
  int noappend = 1;
  static char output[2048];

  read = write = 0;

  while (input[read]) {
    if (input[read] == '%') {
      read++;
      switch (input[read]) {
      case 'k':
	output[write++] = '\003';
	output[write++] = '3';
	output[write++] = '0';
	break;
      case 'r':
	output[write++] = '\003';
	output[write++] = '3';
	output[write++] = '1';
	break;
      case 'g':
	output[write++] = '\003';
	output[write++] = '3';
	output[write++] = '2';
	break;
      case 'y':
	output[write++] = '\003';
	output[write++] = '3';
	output[write++] = '3';
	break;
      case 'b':
	output[write++] = '\003';
	output[write++] = '3';
	output[write++]   = '4';
	break;
      case 'm':
      case 'p':
	output[write++] = '\003';
	output[write++] = '3';
	output[write++]   = '5';
	break;
      case 'c':
	output[write++] = '\003';
	output[write++] = '3';
	output[write++]   = '6';
	break;
      case 'w':
	output[write++] = '\003';
	output[write++] = '3';
	output[write++]   = '7';
	break;
	
      case 'K':
	output[write++] = '\003';
	output[write++] = '5';
	output[write++]   = '0';
	break;
      case 'R':
	output[write++] = '\003';
	output[write++] = '5';
	output[write++]   = '1';
	break;
      case 'G':
	output[write++] = '\003';
	output[write++] = '5';
	output[write++]   = '2';
	break;
      case 'Y':
	output[write++] = '\003';
	output[write++] = '5';
	output[write++]   = '3';
	break;
      case 'B':
	output[write++] = '\003';
	output[write++] = '5';
	output[write++]   = '4';
	break;
      case 'M':
      case 'P':
	output[write++] = '\003';
	output[write++] = '5';
	output[write++]   = '5';
	break;
      case 'C':
	output[write++] = '\003';
	output[write++] = '5';
	output[write++]   = '6';
	break;
      case 'W':
	output[write++] = '\003';
	output[write++] = '5';
	output[write++]   = '7';
	break;
	
      case '0': case '1': case '2': case '3': 
      case '4': case '5': case '6': case '7':
	output[write++] = '\003';
	output[write++] = ',';
	output[write++] = '4';
	output[write++]   = input[read];
	break;
	
      case 'F':
	output[write++] = '\006';
	break;
      case 'n':
	output[write++] = '\003';
	output[write++] = '\017';
	break;
      case 'N':
	noappend = 1;
	break;
      case '%':
	output[write++] = input[read];
	break;
      default:
	output[write++] = '%';
	output[write++] = input[read];
	break;
      }
      read++;
    } else {
      output[write++] = input[read++];
    }
  }
  if (noappend == 0) {
    output[write++] = '\003';
    output[write++] = '-';
    output[write++] = '1';
  }
  output[write] = 0;

  return output;
}

void client_message(char* color, const char *fmt, ...) {
  va_list ap;
  char t[1024];
  char text[1024];

  va_start (ap, fmt);
  vsprintf (text, fmt, ap);
  va_end (ap);

  if (!strcmp(color, "error"))
    chat_print(color, "(Error) ");
  else
    chat_print(color, "(Message) ");
  sprintf(t, "%s Client %s", global.current_room, text);
  cmd_public_message_no_log(t);
  log("Client", text);
}

int in_channel() {
  if (is_string_in_list(global.private_users, global.current_room)) return 0;
  if (!strcmp("Console", global.current_room)) return 0;
  if (!strcmp("Channels", global.current_room)) return 0;

  return 1;
}

void cmd_sping(char* data) {
  time_t tim;
  char t[1024];

  time(&tim);
  strcpy(t, ctime(&tim));
  t[strlen(t)-1] = 0;
  client_message("message", "Server pinged you [%s]", t);
}

void cmd_ping(char* data) {
  client_message("message", "%s has pinged you!", data);
  send_command(CMD_CLIENT_PONG, data);
}

void cmd_pong(char* data) {
  time_t tim;
  char t[1024];

  time(&tim);
  strcpy(t, ctime(&tim));
  t[strlen(t)-1] = 0;
  client_message("message", "pong from %s [%s]", data, t);
}

void cmd_set_port(char* data) {
  global.network.port = atoi(data);
  create_upload_port(FALSE);
  client_message("message", "Your data port was set to %d!",
		 global.network.port);
}

void toggle_friend(char* user) {
  char *text;
  char t2[1024];
  GtkWidget* temp;

  if ((text=is_string_in_list(global.frienduser, user)) == NULL) {
    global.frienduser = g_list_append(global.frienduser, strdup(user));
    sprintf(t2, "is now a friend to %s", user);
  } else {
    global.frienduser = g_list_remove(global.frienduser, text);
    sprintf(t2, "is no longer a friend to %s", user);
  }
  if (global.send_ignore) send_emote(t2);
  update_user(user);

  temp = lookup_widget(global.win, "entry46");
  text = make_string_from_list(global.frienduser, " ");
  gtk_entry_set_text(GTK_ENTRY(temp), text);
  if (global.options_win) {
    temp = lookup_widget(global.options_win, "entry44");
    gtk_entry_set_text(GTK_ENTRY(temp), text);
  }
  temp = lookup_widget(global.win, "button123");
  gtk_widget_set_sensitive(temp, FALSE);
}

void toggle_enemy(char* user) {
  char *text;
  char t2[1024];
  GtkWidget* temp;

  if ((text=is_string_in_list(global.enemyuser, user)) == NULL) {
    global.enemyuser = g_list_append(global.enemyuser, strdup(user));
    sprintf(t2, "has a new enemy: %s", user);
  } else {
    global.enemyuser = g_list_remove(global.enemyuser, text);
    sprintf(t2, "is no longer an enemy to %s", user);
  }
  if (global.send_ignore) send_emote(t2);
  update_user(user);

  temp = lookup_widget(global.win, "entry51");
  text = make_string_from_list(global.enemyuser, " ");
  gtk_entry_set_text(GTK_ENTRY(temp), text);
  if (global.options_win) {
    temp = lookup_widget(global.options_win, "entry52");
    gtk_entry_set_text(GTK_ENTRY(temp), text);
  }
  temp = lookup_widget(global.win, "button124");
  gtk_widget_set_sensitive(temp, FALSE);
}
