#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <gtk/gtk.h>

#include "support.h"
#include "chat.h"
#include "global.h"
#include "mail.h"

void print_mail(char* user) {
  GList* dlist;
  mail_t* mail;

  dlist = g_list_first(global.mails);
  
  if (user) {
    chat_print("message", "<====== Mails for <%s> ======>\n", user);
  } else {
    chat_print("message", "<====== Mails ======>\n");
  }
  while (dlist) {
    mail = (mail_t*)(dlist->data);
    if ((user == NULL) || (!strcasecmp(user, mail->user))) {
      chat_print("message", " <%s>: %s\n", mail->user, mail->message);
    }
    dlist = g_list_next(dlist);
  }

}

void del_mail(char* user) {
  GtkWidget* temp2;
  int row;
  mail_t* mail;
  int no = 0;

  while ((mail = is_user_in_mail(global.mails, user)) != NULL) {
    temp2 = lookup_widget(global.win, "clist7");
    row = gtk_clist_find_row_from_data (GTK_CLIST(temp2), mail);
    gtk_clist_remove(GTK_CLIST(temp2), row);
    no++;
  }
  if (user)
    chat_print("message", "<== %d Mails deleted for <%s> ==>\n", 
	       no, user);
  else
    chat_print("message", "<== All Mails deleted (%d) ==>\n", no);
}

void mail_destroy(mail_t* mail) {
  free(mail->user);
  free(mail->message);

  global.mails = g_list_remove(global.mails, mail);
  if (g_list_length(global.mails) <= 0) global.mails = NULL;
}

int add_mail(char* user, char* text) {
  GtkWidget* temp;
  char* pos;
  int row;
  mail_t* mail;

  if (strlen(text) <= 0) return 0;
  if (strlen(user) <= 0) return 0;

  pos = text;
  while (text) {
    while (pos-text < 100) {
      pos = strchr(pos+1, ' ');
      if (!pos) break;
    }
    if (pos) pos[0] = 0;

    mail = (mail_t*)malloc(sizeof(mail_t));
    mail->user = strdup(user);
    mail->message = strdup(text);
    global.mails = g_list_append(global.mails, mail);

    strcpy(tstr[0], user);
    strcpy(tstr[1], text);
  
    temp = lookup_widget(global.win, "clist7");
    row = gtk_clist_append(GTK_CLIST(temp), list);
    
    gtk_clist_set_row_data_full(GTK_CLIST(temp), row, mail,
				(GtkDestroyNotify)mail_destroy);

    if (!pos) break;
    text = pos+1;
  }
  
  return 1;
}	

void send_mail(char* user) {
  GtkWidget* temp;
  char t[1024];
  int found = 0;
  int row;
  time_t tim;
  mail_t* mail;

  while (1) {
    mail = is_user_in_mail(global.mails, user);
    if (!mail) break;
    if (!found)
      send_private(mail->user, "This is an automatic mail for you:");
    
    temp = lookup_widget(global.win, "clist7");
    row = gtk_clist_find_row_from_data (GTK_CLIST(temp), mail);

    send_private(mail->user, mail->message);
    gtk_clist_remove(GTK_CLIST(temp), row);
    found = 1;
  }
  
  if (found) {
    temp = lookup_widget(global.win, "text11");
    time(&tim);
    strcpy(t, ctime(&tim));
    t[strlen(t)-1] = 0;
    strcat(t, ": Mail sent to <");
    strcat(t, user);
    strcat(t, ">\n");
    gtk_text_insert(GTK_TEXT(temp), NULL, NULL, NULL, 
		    t, strlen(t));
  }
}

mail_t* is_user_in_mail(GList* glist, char* user) {
  GList* dlist;
  mail_t* mail;

  dlist = g_list_first(glist);
  
  while (dlist) {
    mail = (mail_t*)(dlist->data);
    if (user == NULL) return mail;
    if (!strcasecmp(user, mail->user)) return mail;
    dlist = g_list_next(dlist);
  }
  return NULL;
}

