#include <time.h>
#include <stdio.h>
#include <stdlib.h>
#include <gtk/gtk.h>
#include <string.h>

#include "global.h"
#include "log.h"

FILE* search_log_in_list(char* des) {
  GList* dlist;
  log_t* log;
  char str[512];

  dlist = g_list_first(global.logs);
  while (dlist) {
    log = (log_t*)(dlist->data);
    if (!strcasecmp(des, log->description)) {
      return log->fd;
    }
    dlist = g_list_next(dlist);
  }

  log = (log_t*)malloc(sizeof(log_t));
  sprintf(str, "%s/log/%s.log", global.lopster_home, des);
  log->fd = fopen(str, "a+");
  log->filename = strdup(str);
  log->description = strdup(des);
  global.logs = g_list_append(global.logs, log);

  if (log->fd) {
    fprintf(log->fd, "===========================================\n");
    fprintf(log->fd, " Lopster session: %s\n", global.session_start);
    fprintf(log->fd, "===========================================\n");
    fflush(log->fd);
  }
  return log->fd;
}

void log (char* des, const char *fmt, ...) {
  va_list ap;
  FILE* file;

  if (!global.logging) return;
  // do not log protocol
  if (!strcmp("protocol", des)) return;

  file = search_log_in_list(des);

  if (file == NULL) return;
  
  va_start (ap, fmt);
  vfprintf (file, fmt, ap);
  fflush(file);
  va_end (ap);
}

