#include <stdlib.h>
#include <ctype.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>

#include <gtk/gtk.h>

#include "support.h"
#include "commands.h"
#include "global.h"
#include "connection.h"
#include "chat.h"
#include "transfer.h"
#include "share.h"
#include "hotlist.h"
#include "search.h"
#include "log.h"
#include "scheme.h"

char* getCommandName(int type) {
  static char ret[200];

  switch (type) {
  case   0: sprintf(ret, "error message [SERVER]");break;
  case   2: sprintf(ret, "client login message [CLIENT]");break;
  case   3: sprintf(ret, "login ack [SERVER]");break;
  case   4: sprintf(ret, "??? [CLIENT]");break;
  case   6: sprintf(ret, "alternate login format [CLIENT]");break;
  case   7: sprintf(ret, "client registration message [CLIENT]");break;
  case   8: sprintf(ret, "registration success [SERVER]");break;
  case   9: sprintf(ret, "nickname already registered [SERVER]");break;
  case  10: sprintf(ret, "invalid nickname [SERVER]");break;
  case  11: sprintf(ret, "??? [CLIENT]");break;
  case  14: sprintf(ret, "login options [CLIENT]");break;
  case 100: sprintf(ret, "client notification of shared file [CLIENT]");break;
  case 102: sprintf(ret, "remove file [CLIENT]");break;
  case 200: sprintf(ret, "client search request [CLIENT]");break;
  case 201: sprintf(ret, "search response [SERVER]");break;
  case 202: sprintf(ret, "end of search response from server [SERVER]");break;
  case 203: sprintf(ret, "download request [CLIENT]");break;
  case 204: sprintf(ret, "download ack [SERVER]");break;
  case 205: sprintf(ret, "private message to/from another user [CLIENT, SERVER]");break;
  case 206: sprintf(ret, "get error [SERVER]");break;
  case 207: sprintf(ret, "add hotlist entry [CLIENT]");break;
  case 208: sprintf(ret, "hotlist [CLIENT]");break;
  case 209: sprintf(ret, "user signon [SERVER]");break;
  case 210: sprintf(ret, "user signoff [SERVER]");break;
  case 211: sprintf(ret, "browse a user's files [CLIENT]");break;
  case 212: sprintf(ret, "browse response [SERVER]");break;
  case 213: sprintf(ret, "end of browse list [SERVER]");break;
  case 214: sprintf(ret, "server stats [CLIENT, SERVER]");break;
  case 215: sprintf(ret, "request resume [CLIENT]");break;
  case 216: sprintf(ret, "resume search response [SERVER]");break;
  case 217: sprintf(ret, "end of resume search list [SERVER]");break;
  case 218: sprintf(ret, "downloading file [CLIENT]");break;
  case 219: sprintf(ret, "download complete [CLIENT]");break;
  case 220: sprintf(ret, "uploading file [CLIENT]");break;
  case 221: sprintf(ret, "upload complete [CLIENT]");break;
  case 300: sprintf(ret, "optional ports [CLIENT]");break;
  case 301: sprintf(ret, "hotlist ack [SERVER]");break;
  case 302: sprintf(ret, "hotlist error [SERVER]");break;
  case 303: sprintf(ret, "remove user from hotlist [CLIENT]");break;
  case 320: sprintf(ret, "user ignore list [CLIENT, SERVER]");break;
  case 321: sprintf(ret, "user ignore list entry [SERVER]");break;
  case 322: sprintf(ret, "add user to ignore list [CLIENT, SERVER]");break;
  case 323: sprintf(ret, "remove user from ignore list [CLIENT]");break;
  case 324: sprintf(ret, "user is not ignored [SERVER]");break;
  case 325: sprintf(ret, "user is already ignored [SERVER]");break;
  case 326: sprintf(ret, "clear ignore list [CLIENT, SERVER]");break;
  case 400: sprintf(ret, "join channel [CLIENT]");break;
  case 401: sprintf(ret, "part channel [CLIENT]");break;
  case 402: sprintf(ret, "send public message [CLIENT]");break;
  case 403: sprintf(ret, "public message [SERVER]");break;
  case 404: sprintf(ret, "error message [SERVER]");break;
  case 405: sprintf(ret, "join acknowledge [SERVER]");break;
  case 406: sprintf(ret, "join message [SERVER]");break;
  case 407: sprintf(ret, "user parted channel [SERVER]");break;
  case 408: sprintf(ret, "channel user list entry [SERVER]");break;
  case 409: sprintf(ret, "end of channel user list [SERVER]");break;
  case 410: sprintf(ret, "channel topic [CLIENT, SERVER]");break;
  case 500: sprintf(ret, "alternate download request [CLIENT]");break;
  case 501: sprintf(ret, "alternate download ack [SERVER]");break;
  case 600: sprintf(ret, "request user's link speed [CLIENT]");break;
  case 601: sprintf(ret, "link speed response [SERVER]");break;
  case 603: sprintf(ret, "whois request [CLIENT]");break;
  case 604: sprintf(ret, "whois response [SERVER]");break;
  case 605: sprintf(ret, "whowas response [SERVER]");break;
  case 606: sprintf(ret, "change user level [CLIENT]");break;
  case 607: sprintf(ret, "upload request [CLIENT]");break;
  case 608: sprintf(ret, "accept upload request [CLIENT]");break;
  case 610: sprintf(ret, "kill (disconnect) a user [CLIENT]");break;
  case 611: sprintf(ret, "nuke a user [CLIENT]");break;
  case 612: sprintf(ret, "ban user [CLIENT]");break;
  case 613: sprintf(ret, "set data port for user [CLIENT, SERVER]");break;
  case 614: sprintf(ret, "unban user [CLIENT]");break;
  case 615: sprintf(ret, "show bans for server [CLIENT]");break;
  case 616: sprintf(ret, "ip ban notification [SERVER]");break;
  case 617: sprintf(ret, "list channels [CLIENT, SERVER]");break;
  case 618: sprintf(ret, "channel list entry [SERVER]");break;
  case 619: sprintf(ret, "queue limit [CLIENT]");break;
  case 620: sprintf(ret, "queue limit [SERVER]");break;
  case 621: sprintf(ret, "message of the day [CLIENT, SERVER]");break;
  case 622: sprintf(ret, "muzzle a user [CLIENT]");break;
  case 623: sprintf(ret, "unmuzzle a user [CLIENT]");break;
  case 624: sprintf(ret, "un-nuke a user [CLIENT]");break;
  case 625: sprintf(ret, "change a user's linespeed [CLIENT]");break;
  case 626: sprintf(ret, "data port error [CLIENT, SERVER]");break;
  case 627: sprintf(ret, "operator message [CLIENT, SERVER]");break;
  case 628: sprintf(ret, "global message [CLIENT, SERVER]");break;
  case 629: sprintf(ret, "banned users [SERVER]");break;
  case 700: sprintf(ret, "change link speed [CLIENT]");break;
  case 701: sprintf(ret, "change user password [CLIENT]");break;
  case 702: sprintf(ret, "change email address [CLIENT]");break;
  case 703: sprintf(ret, "change data port [CLIENT]");break;
  case 751: sprintf(ret, "ping user [CLIENT, SERVER]");break;
  case 752: sprintf(ret, "pong response [CLIENT, SERVER]");break;
  case 753: sprintf(ret, "???");break;
  case 800: sprintf(ret, "reload config [CLIENT]");break;
  case 801: sprintf(ret, "server version [CLIENT]");break;
  case 810: sprintf(ret, "set config [CLIENT]");break;
  case 820: sprintf(ret, "clear channel");break;
  case 821: sprintf(ret, "???");break;
  case 822: sprintf(ret, "???");break;
  case 823: sprintf(ret, "???");break;
  case 824: sprintf(ret, "emote [CLIENT, SERVER]");break;
  case 825: sprintf(ret, "user list entry [SERVER]");break;
  case 826: sprintf(ret, "???");break;
  case 827: sprintf(ret, "???");break;
  case 830: sprintf(ret, "list users in channel [CLIENT, SERVER]");break;
  default: sprintf(ret, "UNKNWON");break;
  }

  return ret;
}

void do_command(int type, char* data) {
  GtkWidget* temp;
  GtkWidget* temp2;
  char t[500];
  char* pos;
  int i1;
  style_t* style;
  address_t* server;

  switch (type) {
  case 0:
    temp = lookup_widget(global.win, "Console_text");
    cmd_error_message(data);
    if (global.status.connecting)
      connection_close(&(global.server), data);
    break;
  case 3:
    global.status.connecting = 0;
    global.status.connected = 1;
    gtk_widget_hide(global.connect_win);
    gtk_widget_destroy(global.connect_win);
    global.connect_win = NULL;

    server = search_server_in_glist(&global.server.address);
    if (server) server->no_connected++;

    temp = lookup_widget(global.win, "statusbar_left");
    sprintf(t, " (%s) Connected to %s:%d", 
	    global.user.username,
	    global.server.address.ip,
	    global.server.address.port);
    gtk_statusbar_push(GTK_STATUSBAR(temp), 1, t);
    log("protocol", "%s\n", t);

    if (!global.status.building) lib_commit();

    chat_print("message", "Adding Hotlist entries....\n");
    if (global.hotlist) {
      for (i1 = 0; i1 < g_list_length(global.hotlist); i1++) {
	send_command(208, g_list_nth(global.hotlist, i1)->data);
      }
    }

    chat_print("message", "Ignoring enemy users....\n");
    if (global.enemyuser) {
      for (i1 = 0; i1 < g_list_length(global.enemyuser); i1++) {
	send_command(322, g_list_nth(global.enemyuser, i1)->data);
      }
    }

    chat_print("message", "Joining channels....\n");
    if (global.channels) {
      for (i1 = 0; i1 < g_list_length(global.channels); i1++) {
	join_channel(g_list_nth(global.channels, i1)->data);
      }
    }

    set_last_server(&(global.server.address));
    break;
  case 8:
    break;
  case 9:
    connection_close(&(global.server), "Nick already registered");
    break;
  case 10:
    connection_close(&(global.server), "Invalid Nick");
    break;
  case 201:
    cmd_search_response(data);
    break;
  case 202:
    cmd_end_of_search();
    break;
  case 204:
    cmd_download_ack(data);
    break;
  case 205:
    cmd_private_message(data);
    break;
  case 206:
    cmd_get_error(data);
    break;
  case 209:
    cmd_user_sign_on(data);
    break;
  case 210:
    cmd_user_sign_off(data);
    break;
  case 212:
    cmd_browse_response(data);
    break;
  case 213:
    cmd_browse_end(data);
    break;
  case 214:
    cmd_server_stats(data);
    break;
  case 216:
    sscanf(data, "%s %*s %*s %s %*s %s %s",
	   tstr[1], tstr[0], tstr[2], tstr[3]);
    strcpy(tstr[3], LineSpeed[atoi(tstr[3])]);

    temp = lookup_widget(global.resume_win, "clist2");
    gtk_clist_append(GTK_CLIST(temp), list);
    
    break;
  case 301:
    cmd_hotlist_ack(data);
    break;
  case 302:
    cmd_hotlist_error(data);
    break;
  case 320:
    //doing nothing for now
    break;
  case 321:
    cmd_ignore_entry(data);
    break;
  case 322:
    cmd_ignore_user(data, TRUE);
    break;
  case 323:
    cmd_ignore_user(data, FALSE);
    break;
  case 324:
    // doing nothing here
  case 325:
    break;
  case 401:
    cmd_part_channel(data);
    break;
  case 403:
    cmd_public_message(data);
    break;
  case 404:
    cmd_error_message(data);
    break;
  case 405:
    cmd_create_channel(data);
    break;
  case 406:
    cmd_join_message(data);
    break;
  case 407:
    cmd_part_message(data);
    break;
  case 408:
    cmd_user_online(data);
    break;
  case 409:
    break; // doing nothing for now.
  case 410:
    cmd_channel_topic(data);
    break;
  case 420:
    // end of ban list
    break;
  case 421:
    cmd_banlist_entry(data);
    break;
  case 425:
    // for now print an error
    chat_print("message", "%s\n", data);
    break;
  case 501:
    cmd_alternate_ack(data);
    break;
  case 601:
    cmd_linkspeed_response(data);
    break;
  case 604:
    cmd_eval_whois(data);
    break;
  case 605:
    cmd_eval_whowas(data);
    break;
  case 607:
    cmd_upload_request(data);
    break;
  case 609:
    cmd_get_error(data);
    break;
  case 615:
    break;
  case 616:
    cmd_banlist_entry(data);
    break;
  case 617:
    set_options_channels();
    break;
  case 618:
    pos = strchr(data, ' ');
    pos[0] = 0;
    strcpy(tstr[0], data);
    data = pos+1;
    pos = strchr(data, ' ');
    pos[0] = 0;
    strcpy(tstr[1], data);
    data = pos+1;

    strcpy(tstr[4], data);

    tstr[2][0] = tstr[3][0] = 0;
    temp2 = lookup_widget(global.win, "channel_list");
    gtk_clist_append(GTK_CLIST(temp2), list);
    break;
  case 620:
    cmd_remote_queued(data);
    break;
  case 621:
    temp = lookup_widget(global.win, "Console_text");
    style = style_get(global.colors, "text");
    gtk_text_insert(GTK_TEXT(temp), style->font, 
		    style->fore, style->back, 
		    data, strlen(data));
    gtk_text_insert(GTK_TEXT(temp), style->font, 
		    style->fore, style->back, 
		    "\n", 1);
    break;
  case 627:
    cmd_operator_message(data);
    break;
  case 628:
    cmd_global_message(data);
    break;
  case 629:
    if (!global.ban_win) break;
    temp = lookup_widget(global.ban_win, "clist3");
    strcpy(tstr[0], data);
    tstr[1][0] = 0;
    tstr[2][0] = 0;
    tstr[3][0] = 0;
    gtk_clist_append(GTK_CLIST(temp), list);
    break;
  case 750:
    cmd_sping(data);
    break;
  case 751:
    cmd_ping(data);
    break;
  case 752:
    cmd_pong(data);
    break;
  case 824:
    cmd_emote(data);
    break;
  case 825:
    cmd_list_user(data);
    break;
  case 827:
    set_options_channels();
    break;
  case 828:
    pos = strchr(data, ' ');
    pos[0] = 0;
    strcpy(tstr[0], data);
    data = pos+1;
    pos = strchr(data, ' ');
    pos[0] = 0;
    strcpy(tstr[1], data);
    data = pos+1;

    data = strchr(data, ' ')+1;
    pos = strchr(data, ' ');
    pos[0] = 0;
    strcpy(tstr[3], data);
    data = pos+1;

    pos = strchr(data, ' ');
    pos[0] = 0;
    strcpy(tstr[2], data);
    data = pos+2;

    pos = strrchr(data, '\"');
    pos[0] = 0;
    strcpy(tstr[4], data);

    temp2 = lookup_widget(global.win, "channel_list");
    gtk_clist_append(GTK_CLIST(temp2), list);
    break;
  case 830:
    cmd_list_user_end();
    break;
  case 10112:
    client_message("message","Linked Server %s", data);
    break;
  default:
    log("protocol", "** Unknown\n");
    client_message("error", 
		   "** not implemented yet: %d: [%s]\n[%s]", 
		   type, getCommandName(type), data);
    break;
  }
}
