#ifndef _GLOBAL_H_
#define _GLOBAL_H_

#define STYLE_NUMBER         3
#define STYLE_TAB1           0
#define STYLE_TAB2           1
#define STYLE_CHAT           2

#define UPDATE_DELAY      1000
#define TRANSFER_HISTORY    20

#ifdef WORDS_BIGENDIAN
#define BSWAP16(x) ((((x) & 0xff) << 8) | (((x) >> 8) & 0xff))
#define BSWAP32(x) (((x) << 24) | (((x) & 0x0000ff00) << 8) | ((x) >> 24) | (((x) & 0x00ff0000) >> 8))
#else
#define BSWAP16(x) (x)
#define BSWAP32(x) (x)
#endif

extern const char LineSpeed[11][20];
extern const char LineSpeedShort[11][20];
extern const int ColorTable[10][10];
extern const int ColorTable2[8];
extern char tstr[10][512];
extern char* list[10];

typedef struct {
  int files;
  unsigned long bytes;
} hot_t;

typedef struct {
  char* ip;
  unsigned long ip_long;
  int port;
  char* description;
  int no_connected;
} address_t;

typedef struct {
  address_t address;
  int fd;
  int input;
  int timeout;
  int cnt;               // intern counter
  int max_cnt;           // max count for timeout
} socket_t;

typedef struct {
  char username[100];
  char password[100];
  char email[100];
  int level;
} user_t;

typedef struct {
  char* download;
  GList* shared;
} path_t;

typedef struct {
  int linespeed;
  int port;
  int max_downloads;
  int max_uploads;
  int max_transfers;
  int firewall;
  int cur_uploads;
  int cur_downloads;
} network_t;

typedef struct {
  char connected;
  char connecting;
  char searching;
  char building;
  char exiting;
} status_t;

typedef struct {
  char* longname;
  char* shortname;
  char* winname;
  long size;
  char* user;
  unsigned long ip;
  char* md5;
  int bitrate;
  int frequency;
  int length;
  int linespeed;
  int ping;
  int flags;   // 1=in lib  2=shared
} file_t;

typedef struct {
  char* longname;
  char* shortname;
  char* winname;
  char* localname;
  char* md5;
  char* user;
  int linespeed;

  long progress;
  double rate;
  int timeleft;
  time_t start_time;
  int status;
  long size;
  socket_t sock;
  FILE* file;
  int type;
  long history[TRANSFER_HISTORY];
  int hist_pos;
} transfer_t;

typedef struct {
  char* name;
  char* n_fore;
  char* n_back;
  char* n_font;
  GdkFont *font;
  GdkColor *fore;
  GdkColor *back;
} style_t;

typedef struct {
  GdkPixmap *sgray;
  GdkBitmap *sgrayb;
  GdkPixmap *sgreen;
  GdkBitmap *sgreenb;
  GdkPixmap *syellow;
  GdkBitmap *syellowb;
  GdkPixmap *sred;
  GdkBitmap *sredb;

  GdkPixmap *folder;
  GdkBitmap *folderb;
  GdkPixmap *folder_open;
  GdkBitmap *folder_openb;
  GdkPixmap *user1;
  GdkBitmap *user1b;
  GdkPixmap *user2;
  GdkBitmap *user2b;
  GdkPixmap *ignore;
  GdkBitmap *ignoreb;
  GdkPixmap *enemy;
  GdkBitmap *enemyb;
  GdkPixmap *enemy2;
  GdkBitmap *enemy2b;
  GdkPixmap *friend;
  GdkBitmap *friendb;
  GdkPixmap *dummy;
  GdkBitmap *dummyb;
  
} pix_t;

typedef struct {
  //wins
  GtkWidget* win;
  GtkWidget* connect_win;
  GtkWidget* dir_select_win;
  GtkWidget* whois_win;
  GtkWidget* options_win;
  GtkWidget* resume_win;
  GtkWidget* ban_win;
  GtkWidget* ignore_win;
  GtkWidget* server_win;
  GtkWidget* user_win;

  //options
  socket_t server;              // connected server
  socket_t napigator;           // napigator server
  socket_t upload_socket;       // listen socket file transfer
  user_t user;                  // you
  path_t path;                  // the dl and ul paths
  status_t status;
  network_t network;            // network options
  address_t* last_server;
  pix_t pix;                    // pix for intern use
  GList* servers;               // list of servers
  GList* ignored_users;         // list of ignored users
  GList* commands;              // the list of commands
  GList* colors;                // the color scheme
  GList* highlight;             // the highlighted text
  GList* frienduser;            // the friend users
  GList* enemyuser;             // the enemy users
  GList* private_users;
  GList* chat_history;
  GList* hotlist;
  GList* mails;
  GList* channels;
  GList* schemes;
  GList* logs;

  int history_pos;
  char current_room[100];
  int popup_row;
  GtkWidget* popup_list;
  int dir_select_mode;
  int connect_button;
  int dl;
  char* lopster_home;
  char* scheme;
  char* afk;
  char* reply;
  char* player;
  char* session_start;

  int show_joins;
  int auto_connect;
  int ignore_public_ignore;
  int send_ignore;
  int parse_color;
  int logging;
  GtkStyle* style[STYLE_NUMBER];
  GdkColor color_table[16];
} global_t;

extern global_t global;

char* strcasestr(char* str, const char* sub);
int speed2int(char* linespeed);
int idle_function(gpointer data);
void global_init();
void global_exit();

void create_dir(char* dir);

char* extract_short_name(char* longname);
char* convert_to_win(char* name);
char* convert_to_unix(char* name);

void destroy_file_row(gpointer data);
void file_parse_header(file_t *file);
void file_calc_md5(file_t *file);

gint search_compare (GtkCList      *clist,
		     gconstpointer  ptr1,
		     gconstpointer  ptr2);
gint lib_compare (GtkCList      *clist,
		  gconstpointer  ptr1,
		  gconstpointer  ptr2);
gint channel_compare (GtkCList      *clist,
		      gconstpointer  ptr1,
		      gconstpointer  ptr2);
gint
server_compare (GtkCList      *clist,
		 gconstpointer  ptr1,
		 gconstpointer  ptr2);

void send_search_request();
void cmd_eval_whois(char* data);
void cmd_eval_whowas(char* data);

void cmd_server_stats(char* data);

void napigator_get_list();

address_t* search_server_in_list(address_t* server);
int server_comp(const void* s1, const void* s2);

void make_list_from_string(GList** glist, char* text, char* sep);
char* make_string_from_list(GList* glist, char* sep);
char* is_string_in_list(GList* glist, char* t);
char* is_prefix_in_list(GList* glist, char* t);
int calc_list_prefix(GList* glist);
int calc_command_prefix(GList* glist);
address_t* search_server_in_glist(address_t* server);
void write_rc();
void play_file(char* filename);
void convert_text(char* text);
void set_last_server(address_t* server);
void set_options_channels();
void set_button_state(GtkWidget* button, int open);
int toggle_button_state(GtkWidget* button);
void set_up_button(GtkWidget* button, 
		   char* pix1, char* pix2, char *wid);
void show_bans(char* channel);
void cmd_banlist_entry(char* data);
char* cparse(char *input);
void client_message(char* color, const char *fmt, ...);
int in_channel();
void cmd_sping(char* data);
void cmd_ping(char* data);
void cmd_pong(char* data);

#endif
