#include <sys/time.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#include <gtk/gtk.h>

#include "global.h"
#include "commands.h"

const char FolderNames[5][64] = {
  "Chat Commands",
  "Preferences",
  "Misc Commands",
  "Moderator Commands",
  "Opennap Commands"
};

int command_new(int id, char* iname, char* syntax, char* ides,
		level_t ilevel, folder_t ifolder) {
  command_t* new_comm;
  
  if (!iname) {
    g_warning("no command name given");
    return 0;
  }
  if (command_is_command(iname)) {
    g_warning("chat command already exists");
    return 0;
  }
  new_comm = (command_t*)malloc(sizeof(command_t));
  new_comm->id = id;
  new_comm->name = strdup(iname);
  new_comm->syntax = strdup(syntax);
  new_comm->description = strdup(ides);
  new_comm->is_alias = 0;
  new_comm->level = ilevel;
  new_comm->folder = ifolder;

  global.commands = 
    g_list_append(global.commands, new_comm);

  return 1;
}

int command_rename(int iid, char* iname) {
  command_t* comm;
  
  comm = command_is_command(iname);
  
  if (!comm) {
    g_warning("chat command does not exists");
    return 0;
  }
  
  free(comm->name);
  comm->name = strdup(iname);

  return 1;
}

GList* command_search(char* prefix) {
  GList* result = NULL;
  command_t* comm;
  int len = strlen(prefix);
  int i1;

  for (i1 = 0; i1 < g_list_length(global.commands); i1++) {
    comm = 
      (command_t*)(g_list_nth(global.commands, i1)->data);
    if (!strncasecmp(prefix, comm->name, len))
      result = g_list_append(result, comm);
  }
  
  return result;
}

command_t* command_is_command(char* iname) {
  command_t* comm;
  int i1;

  for (i1 = 0; i1 < g_list_length(global.commands); i1++) {
    comm = 
      (command_t*)(g_list_nth(global.commands, i1)->data);
    if (!strcasecmp(iname, comm->name))
      return comm;
  }
  
  return NULL;
}

char* command_get_alias_string(int id) {
  command_t* comm;
  int i1;
  static char result[1024];

  result[0] = 0;
  for (i1 = 0; i1 < g_list_length(global.commands); i1++) {
    comm = 
      (command_t*)(g_list_nth(global.commands, i1)->data);
    if ((comm->id == id) && (comm->is_alias)) {
      if (strlen(result) > 0) strcat(result, " ");
      strcat(result, comm->name);
    }
  }
  
  return result;
}

int command_make_alias(char* iname, char* alias) {
  command_t* comm;
  command_t* new_alias;
  char temp[1024];

  if (!iname) {
    g_warning("no command name given");
    return 0;
  }
  comm = command_is_command(alias);
  if (comm) {
    g_warning("chat command does already exists");
    return 0;
  }
  if (!alias) {
    g_warning("no alias name given");
    return 0;
  }
  comm = command_is_command(iname);
  if (!comm) {
    g_warning("chat command does not exists");
    return 0;
  }

  new_alias = (command_t*)malloc(sizeof(command_t));
  new_alias->id = comm->id;
  new_alias->name = strdup(alias);
  sprintf(temp, "see %s", iname);
  new_alias->syntax = strdup(temp);
  sprintf(temp, "This is an alias for <%s>", iname);
  new_alias->description = strdup(temp);
  new_alias->is_alias = 1;
  new_alias->level = comm->level;
  new_alias->folder = comm->folder;
  global.commands =
    g_list_append(global.commands, new_alias);

  return 1;
}

void command_delete_alias_for(int id) {
  command_t* comm;
  int i1;

  i1 = 0;
  while (i1 < g_list_length(global.commands)) {
    comm = 
      (command_t*)(g_list_nth(global.commands, i1)->data);
    if ((comm->id == id) && (comm->is_alias)) {
      global.commands = 
	g_list_remove(global.commands, comm);
    } else {
      i1++;
    }
  }
}

void command_delete_all() {
  command_t* comm;

  while (g_list_length(global.commands) > 0) {
    comm = 
      (command_t*)(g_list_first(global.commands)->data);
    global.commands = 
      g_list_remove(global.commands, comm);

    free(comm->name);
    free(comm->syntax);
    free(comm->description);
  }
  global.commands = NULL;
}
