void chat_print(char* color, const char *fmt, ...);
void chat_print_channel(char* page, char* color, 
			const char *fmt, ...);
void chat_print_channel_color(char* room, char* color, 
			      GdkColor* fore, GdkColor* back,
			      char *text);
void chat_print_colored(char* room, char* base_color, char* text);

void join_channel(char* name);
void cmd_create_channel (char* name);
void create_private_page (char* name);
void cmd_part_channel(char* data);
void cmd_channel_topic(char* data);

void cmd_public_message(char* data);
void cmd_private_message(char* data);
void cmd_emote(char* data);
void cmd_global_message(char* data);
void cmd_operator_message(char* data);
void cmd_error_message(char* data);
void cmd_join_message(char* data);
void cmd_part_message(char* data);

void send_emote(char* text);
void send_private(char* nick, char* text);

void cmd_ignore_user(char* data, gboolean toogle);
void cmd_ignore_entry(char* data);
void cmd_list_user(char* data);  // unused at moment
void cmd_list_user_end();        // unused at moment

void cmd_user_online(char* data);
void mark_user(char* user, GdkPixmap *pix, GdkBitmap *bit);
void update_user(char* user);
void update_users(GList* glist);
void delete_user_list(GList** glist);
int search_user_in_list(GtkCList* list, char* user);
GList* user_search(char* user);

char* search_highlight_string(char* string, int* len);
gint user_compare (GtkCList      *clist,
		   gconstpointer  ptr1, gconstpointer  ptr2);
void highlight(char* page, int high);

//
void set_afk(char* message);
