#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdlib.h>
#include <gtk/gtk.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <dirent.h>
#include <sys/stat.h>
#include <sys/utsname.h>
#include <sys/time.h>

#include "global.h"
#include "interface.h"
#include "support.h"
#include "connection.h"
#include "callbacks.h"
#include "share.h"
#include "hotlist.h"
#include "commands.h"
#include "chat.h"
#include "transfer.h"
#include "dirselect.h"
#include "connection.h"
#include "scheme.h"
#include "mail.h"

///////////////////////////
// CONNECTION
///////////////////////////

void
on_connect_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget* win;
  GtkWidget* temp;
  GList *combo4_items = NULL;
  GtkWidget* combo;
  char server_str[1024];
  address_t* server;
  GList* dlist;
  
  if (global.status.connecting) return;

  temp = lookup_widget(global.win, "menu_connect");
  temp = GTK_BIN(temp)->child;
  gtk_label_set_text(GTK_LABEL(temp), "Reconnect");

  win = create_connection_win();

  temp = lookup_widget(win, "button84");
  set_up_button(temp, "pix11", "pix12", "frame58");
  set_button_state(temp, global.connect_button);
  
  combo = lookup_widget(win, "combo4");
  if (global.servers) {
    dlist = g_list_first(global.servers);
    while (dlist) {
      server = (address_t*)(dlist->data);
      sprintf(server_str, "%s:%d %s", server->ip, 
	      server->port, server->description);
      combo4_items = g_list_append (combo4_items, 
				    strdup(server_str));
      dlist = g_list_next(dlist);
    }
  }

  if (global.last_server) {
    combo4_items = g_list_insert (combo4_items, "Last Server", 0);
    combo4_items = g_list_insert (combo4_items, "Official Server", 1);
  } else {
    combo4_items = g_list_insert (combo4_items, "Official Server", 0);
  }

  gtk_combo_set_popdown_strings (GTK_COMBO (combo), combo4_items);
  g_list_free (combo4_items);

  global.connect_win = win;
  gtk_widget_show(win);

  temp = lookup_widget(win, "connection_name");
  gtk_entry_set_text(GTK_ENTRY(temp), global.user.username);
  temp = lookup_widget(win, "connection_pass");
  gtk_entry_set_text(GTK_ENTRY(temp), global.user.password);
}


void
on_disconnect_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  if(global.status.connected) {
    connection_close(&(global.server), NULL);
  }
  lib_del_flag(FLAG_SHARED, NULL);
}

void
on_connection_ok_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* entry;
  GtkWidget* win;
  int res;

  win = global.connect_win;

  button = GTK_BUTTON(lookup_widget(global.connect_win, "connection_ok"));
  gtk_widget_set_sensitive(GTK_WIDGET(button), FALSE);

  entry = lookup_widget(win, "connection_name");
  strcpy(global.user.username, gtk_entry_get_text(GTK_ENTRY(entry)));
  entry = lookup_widget(win, "connection_pass");
  strcpy(global.user.password, gtk_entry_get_text(GTK_ENTRY(entry)));

  if (global.status.connected) {
    on_disconnect_activate(NULL, NULL);
  }
  res = connect_napster();

  if (res < 0) {
    gtk_widget_set_sensitive(GTK_WIDGET(button), TRUE);
  }
}


void
on_connection_cancel_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* win;

  win = global.connect_win;
  if (global.status.connecting) {
    connection_close(&global.server, "Canceled!");
  } else {
    gtk_widget_hide(win);
    gtk_widget_destroy(win);
    global.connect_win = NULL;
  }
}

void
on_connection_win_destroy              (GtkObject       *object,
                                        gpointer         user_data)
{
  GtkWidget* win;

  win = GTK_WIDGET(object);
  if (global.status.connecting) {
    connection_close(&global.server, "Canceled!");
  }

  gtk_widget_hide(win);
  gtk_widget_destroy(win);
  global.connect_win = NULL;
}


void
on_preferences_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  
  GtkWidget* win;
  GtkWidget* temp;
  GList* dlist;
  GList* list2;
  int row;
  address_t* server;
  command_t* command;
  char* pos;
  style_t* style;

  if (global.options_win) return;
  win = create_options_win();

  temp = lookup_widget(win, "text8");
  gtk_text_set_word_wrap(GTK_TEXT(temp), 1);
  gtk_widget_set_style(temp, global.style[2]);  

  temp = lookup_widget(win, "text9");
  gtk_text_set_word_wrap(GTK_TEXT(temp), 1);

  // user
  temp = lookup_widget(win, "entry4");
  gtk_entry_set_text(GTK_ENTRY(temp), global.user.username);
  temp = lookup_widget(win, "entry5");
  gtk_entry_set_text(GTK_ENTRY(temp), global.user.password);
  temp = lookup_widget(win, "entry7");
  gtk_entry_set_text(GTK_ENTRY(temp), global.user.email);

  // paths
  temp = lookup_widget(win, "entry14");
  if (global.path.download)
    gtk_entry_set_text(GTK_ENTRY(temp), global.path.download);
  temp = lookup_widget(win, "entry13");
  pos = make_string_from_list(global.path.shared, ";");
  gtk_entry_set_text(GTK_ENTRY(temp), pos);
  
  // network
  temp = GTK_COMBO(lookup_widget(win, "combo3"))->entry;
  gtk_entry_set_text(GTK_ENTRY(temp), LineSpeed[global.network.linespeed]);
  temp = lookup_widget(win, "spinbutton2");
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp), (gfloat)global.network.port);
  temp = lookup_widget(win, "spinbutton1");
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp), (gfloat)global.network.max_downloads);
  temp = lookup_widget(win, "spinbutton3");
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp), (gfloat)global.network.max_uploads);
  temp = lookup_widget(win, "spinbutton7");
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp), (gfloat)global.network.max_transfers);
  temp = lookup_widget(win, "checkbutton4");
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), global.network.firewall);
  temp = lookup_widget(win, "checkbutton13");
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), global.auto_connect);

  gtk_widget_show(win);
  global.options_win = win;

  // servers
  temp = lookup_widget(win, "server_list");
  if (global.servers) {
    dlist = g_list_first(global.servers);
    while (dlist) {
      server = (address_t*)(dlist->data);
      sprintf(tstr[0], "%s:%d", server->ip, server->port);
      strcpy(tstr[1], server->description);
      row = gtk_clist_append(GTK_CLIST(temp), &list[0]);
      gtk_clist_set_row_data(GTK_CLIST(temp), row, dlist->data);
      
      dlist = g_list_next(dlist);
    }
  }
  
  // chat commands
  list2 = NULL;
  temp = lookup_widget(win, "combo6");
  if (global.commands) {
    dlist = g_list_first(global.commands);
    while (dlist) {
      command = (command_t*)(dlist->data);
      if (command->is_alias == 0)
	list2 = g_list_append (list2, command->name);
      dlist = g_list_next(dlist);
    }
    gtk_combo_set_popdown_strings (GTK_COMBO (temp), list2);
    g_list_free (list2);
  }

  scheme_update_list();

  // the colors
  list2 = NULL;
  temp = lookup_widget(win, "combo5");
  if (global.colors) {
    dlist = g_list_first(global.colors);
    while (dlist) {
      style = (style_t*)(dlist->data);
      list2 = g_list_append (list2, style->name);
      dlist = g_list_next(dlist);
    }
    gtk_combo_set_popdown_strings (GTK_COMBO (temp), list2);
    g_list_free (list2);
  }

  // highlight
  temp = lookup_widget(win, "entry42");
  pos = make_string_from_list(global.highlight, "\"");
  gtk_entry_set_text(GTK_ENTRY(temp), pos);

  // friend user
  temp = lookup_widget(win, "entry44");
  pos = make_string_from_list(global.frienduser, " ");
  gtk_entry_set_text(GTK_ENTRY(temp), pos);

  // enemy user
  temp = lookup_widget(win, "entry52");
  pos = make_string_from_list(global.enemyuser, " ");
  gtk_entry_set_text(GTK_ENTRY(temp), pos);

  temp = lookup_widget(win, "checkbutton11");
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), global.show_joins);
  temp = lookup_widget(win, "checkbutton12");
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), global.ignore_public_ignore);
  temp = lookup_widget(win, "checkbutton15");
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), global.send_ignore);
  temp = lookup_widget(win, "checkbutton22");
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), global.parse_color);
  temp = lookup_widget(win, "checkbutton16");
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), global.logging);

  // channels
  temp = lookup_widget(win, "clist6");
  if (global.channels) {
    for (row = 0; row < g_list_length(global.channels); row++) {
      sprintf(tstr[0], g_list_nth(global.channels, row)->data);
      gtk_clist_append(GTK_CLIST(temp), &list[0]);
    }
  }

  if (global.player) {
    temp = lookup_widget(win, "entry53");
    gtk_entry_set_text(GTK_ENTRY(temp), global.player);
  }

  set_options_channels();
}


void
on_exit_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  if (global.status.building) {
    global.status.exiting = 1;
    return;
  }
  
  if(global.status.connected) {
    on_disconnect_activate(NULL, NULL);
  }
  global_exit();
  gtk_main_quit();
}


void
on_join_chatrooms_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget* temp;

  if (!global.status.connected) {
    g_warning("not connected");
    return;
  }
  
  temp = lookup_widget(global.win, "notebook3");
  gtk_notebook_set_page(GTK_NOTEBOOK(temp), 1);
  temp = lookup_widget(global.win, "channel_list");
  
  if (GTK_CLIST(temp)->rows == 0) {
    on_hidden1_activate(NULL, NULL);
  }
  
}


void
on_napster_faq_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_send_feedback_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_about_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  //  GtkWidget* about_win = NULL;

  //  about_win = create_about();
  //  gtk_widget_show(about_win);
}


void
on_about_close_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* about_dialog;

  about_dialog = lookup_widget(GTK_WIDGET(button), "about_win");

  gtk_widget_destroy(about_dialog);
}




void
on_button6_clicked                     (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* temp;
  
  temp = lookup_widget(GTK_WIDGET(button), "search_artist");
  gtk_entry_set_text(GTK_ENTRY(temp), "");
  temp = lookup_widget(GTK_WIDGET(button), "search_results");
  gtk_entry_set_text(GTK_ENTRY(temp), "100");
  temp = lookup_widget(GTK_WIDGET(button), "combo_bitrate");
  gtk_entry_set_text(GTK_ENTRY(temp), "");
  temp = lookup_widget(GTK_WIDGET(button), "combo_bitrate2");
  gtk_entry_set_text(GTK_ENTRY(temp), "");
  temp = lookup_widget(GTK_WIDGET(button), "combo_freq");
  gtk_entry_set_text(GTK_ENTRY(temp), "");
  temp = lookup_widget(GTK_WIDGET(button), "combo_freq2");
  gtk_entry_set_text(GTK_ENTRY(temp), "");
  temp = lookup_widget(GTK_WIDGET(button), "combo_speed");
  gtk_entry_set_text(GTK_ENTRY(temp), "");
  temp = lookup_widget(GTK_WIDGET(button), "combo_speed2");
  gtk_entry_set_text(GTK_ENTRY(temp), "");
}


void
on_button7_clicked                     (GtkButton       *button,
                                        gpointer         user_data)
{
  send_search_request();
}



void
on_button29_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkTree* tree;

  if (!global.dir_select_win) {
    global.dir_select_win = create_dir_select_win();
    tree = GTK_TREE(lookup_widget(global.dir_select_win, "tree1"));
    create_tree(tree, "/");
  }
  gtk_widget_show(global.dir_select_win);
  global.dir_select_mode = 1;
}


void
on_button26_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkTree* tree;

  if (!global.dir_select_win) {
    global.dir_select_win = create_dir_select_win();
    tree = GTK_TREE(lookup_widget(global.dir_select_win, "tree1"));
    create_tree(tree, "/");
  }
  gtk_widget_show(global.dir_select_win);
  global.dir_select_mode = 2;
}


void
on_button27_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* temp;

  temp = lookup_widget(global.options_win, "entry13");

  gtk_entry_set_text(GTK_ENTRY(temp), "");
}


void
on_button30_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* win;

  win = lookup_widget(GTK_WIDGET(button), "options_win");
  on_button96_clicked(button, user_data);
  gtk_widget_hide(win);
  gtk_widget_destroy(win);
}


void
on_button31_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* win;

  win = lookup_widget(GTK_WIDGET(button), "options_win");

  gtk_widget_hide(win);
  gtk_widget_destroy(win);
}


void
on_ok_button1_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* win;

  gchar* filename;
  win = lookup_widget(GTK_WIDGET(button), "fileselection1");
  filename = gtk_file_selection_get_filename(GTK_FILE_SELECTION(win));


}


void
on_cancel_button1_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* win;

  win = lookup_widget(GTK_WIDGET(button), "fileselection1");
  gtk_widget_hide(win);
  gtk_widget_destroy(win);
}




void
on_button33_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* temp;

  temp = lookup_widget(GTK_WIDGET(button), "add_user_win");
  gtk_widget_hide(temp);
  gtk_widget_destroy(temp);
}


void
on_button10_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{

  GtkWidget* win;

  win = create_add_user_win();
  gtk_widget_show(win);

}





void
on_refresh1_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  lib_refresh();
}


void
on_button23_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
  // joining chat room
  on_join_chatrooms_activate(NULL, user_data);
}

void
on_button24_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkNotebook* notebook;
  int current;
  GtkWidget* page;
  GtkWidget* label;
  char* user;

  notebook = GTK_NOTEBOOK(lookup_widget(global.win, "notebook3"));
  current = gtk_notebook_get_current_page(notebook);

  if (current < 2) return;

  user = is_string_in_list(global.private_users, global.current_room);
  if (user) {
    global.private_users = 
      g_list_remove(global.private_users, user);
    gtk_notebook_remove_page(notebook, current);
  } else {
    if (global.status.connected) {
      page = gtk_notebook_get_nth_page(notebook, current);
      if (page == NULL){
	g_warning("ops");
	return;
      }
      label = gtk_notebook_get_tab_label(notebook, page);
      send_command(401, GTK_LABEL(label)->label);
    } else {
      gtk_notebook_remove_page(notebook, current);
    }
  }

}


void
on_chat_entry_activate                 (GtkEditable     *editable,
                                        gpointer         user_data)
{
#define MAX_HISTORY   1000
  GtkEntry* entry;
  GtkWidget* temp;
  char t[1024];
  char* text;
  char* text2;
  char* pos;
  char* pos2;
  command_t* command;
  int i1, i2;
  int type;
  struct utsname uts;
  time_t tim;
  int cnt;

  entry = GTK_ENTRY(editable);
  text = strdup(gtk_entry_get_text(entry));
  if (strlen(text) <= 0) return;

  global.chat_history = g_list_append(global.chat_history, strdup(text));

  convert_text(text);
  if (global.parse_color) text2 = cparse(text);
  else text2 = text;

  while (g_list_length(global.chat_history) > MAX_HISTORY) {
    pos = g_list_nth_data(global.chat_history, 0);
    free(pos);
    global.chat_history = g_list_remove(global.chat_history, pos);
  }
  global.history_pos = g_list_length(global.chat_history);
  
  if (text2[0] == '/') {
    if (global.commands == NULL) {
      g_warning("no commands declared!");
      return;
    }
    pos = strchr(text2, ' ');
    if (pos) pos[0] = 0;
    command = command_is_command(text2+1);
    if (!command) {
      client_message("error", "Unknown command! Type /help for a list of commands.");
      gtk_entry_set_text(entry, "");
      return;
    }
    switch (command->id) {
    case C_NONE:
      g_warning("command with id C_NONE");
      break;
    case C_WHISPER:
      if ((!pos) || (pos[1] == 0)) {
	client_message("error", "Wrong format in command /whisper");
	break;
      }

      pos2 = strchr(pos+1, ' ');
      if ((!pos2) || (pos2[1] == 0)) {
	client_message("error", "Wrong format in command /whisper");
	break;
      }
      pos2[0] = 0;
      send_private(pos+1, pos2+1);
      break;
    case C_WHOIS:
      if ((!pos) || (pos[1] == 0)) 
	send_command(603, global.user.username);
      else 
	send_command(603, pos+1);
      break;
    case C_EMOTE:
      if ((!pos) || (pos[1] == 0)) {
	client_message("error", "Wrong format in command /emote");
	break;
      }
      send_emote(pos+1);
      break;
    case C_JOIN:
      if ((!pos) || (pos[1] == 0)) {
	client_message("error", "Wrong format in command /join");
	break;
      } else sprintf(t, pos+1);
      join_channel(t);
      break;
    case C_SEND:
      if ((!pos) || (pos[1] == 0)) {
	client_message("error", "Wrong format in command /send");
	break;
      }
      pos2 = strchr(pos+1, ' ');
      if (pos2) {
	pos2[0] = 0;
	type = atoi(pos+1);
	send_command(type, pos2+1);
      } else {
	type = atoi(pos+1);
	send_command(type, "");
      }
      break;
    case C_BROWSE:
      if ((!pos) || (pos[1] == 0)) {
	client_message("error", "Wrong format in command /browse");
	break;
      }
      sprintf(t, pos+1);
      add_to_hotlist(t);
      break;
    case C_BAN:
      if ((!pos) || (pos[1] == 0)) {
	client_message("error", "Wrong format in command /ban");
	break;
      }
      pos2 = strchr(pos+1, ' ');
      if ((!pos2) || (pos2[1] == 0)) {
	send_command(612, pos+1);
      } else {
	pos2[0] = 0;
	send_command(612, "%s \"%s\"", pos+1, pos2+1);
      }
      break;
    case C_UNBAN:
      if ((!pos) || (pos[1] == 0)) {
	client_message("error", "Wrong format in command /ban");
	break;
      }
      pos2 = strchr(pos+1, ' ');
      if ((!pos2) || (pos2[1] == 0)) {
	send_command(614, pos+1);
      } else {
	pos2[0] = 0;
	send_command(614, "%s \"%s\"", pos+1, pos2+1);
      }
      break;
    case C_CHCLEAR:
      if ((!pos) || (pos[1] == 0)) {
	if (!in_channel()) {
	  client_message("message", "/chclear is not supported without argument in this page");
	} else {
	  send_command(820, global.current_room);
	}
      } else {
	send_command(820, pos+1);
      }
      break;
    case C_DISC:
      on_disconnect_activate(NULL, NULL);
      break;
    case C_CLOAK:
      send_command(652, "");
      break;
    case C_EMAIL:
      if ((!pos) || (pos[1] == 0)) {
	client_message("error", "Wrong format in command /email");
	break;
      }
      send_command(702, pos+1);
      break;
    case C_KILL:
      if ((!pos) || (pos[1] == 0)) {
	client_message("error", "Wrong format in command /kill");
	break;
      }
      send_command(610, pos+1);
      break;
    case C_LEVEL:
      if ((!pos) || (pos[1] == 0)) {
	client_message("error", "Wrong format in command /level");
	break;
      }
      sprintf(t, pos+1);
      pos2 = strchr(pos+1, ' ');
      if ((!pos2) || (pos2[1] == 0)) {
	client_message("error", "Wrong format in command /level");
	break;
      }
      send_command(606, pos+1);
      break;
    case C_LINKS:
      send_command(10112, "");
      break;
    case C_LIST:
      on_join_chatrooms_activate(NULL, user_data);
      break;
    case C_LISTBANS:
      if ((!pos) || (pos[1] == 0)) {
	show_bans(NULL);
      } else {
	show_bans(pos+1);
      }
      break;
    case C_PART:
      on_button24_clicked(NULL, NULL);
      break;
    case C_OPMSG:
      if ((!pos) || (pos[1] == 0)) {
	client_message("error", "Wrong format in command /opmsg");
	break;
      }
      send_command(627, pos+1);
      break;
    case C_STATS:
      send_command(214, "");
      break;
    case C_SCHEME:
      if ((!pos) || (pos[1] == 0)) {
	client_message("error", "Wrong format in command /scheme");
	break;
      }
      global.colors = scheme_load(global.colors, pos+1);
      break;
    case C_ALIAS:
      if ((!pos) || (pos[1] == 0)) {
	client_message("error", "Wrong format in command /alias");
	break;
      }

      pos2 = strchr(pos+1, ' ');
      pos2[0] = 0;
      if ((!pos2) || (pos2[1] == 0)) {
	client_message("error", "Wrong format in command /alias");
	break;
      }
      command_make_alias(pos2+1, pos+1);
      break;
    case C_AFK:
      if ((!pos) || (pos[1] == 0))
	set_afk(NULL);
      else set_afk(pos+1);
      break;
    case C_PUBLIC:
      if ((!pos) || (pos[1] == 0)) {
	client_message("error", "Wrong format in command /public");
	break;
      }
      if (!in_channel()) {
	client_message("message", "/public not supported in this page");
	break;
      }
      send_command(402, "%s %s", global.current_room, pos+1);
      break;
    case C_REPLY:
      if (global.reply == NULL) {
	client_message("message", "Noone to reply");
	break;
      }
      if ((!pos) || (pos[1] == 0)) {
	client_message("error", "Wrong format in command /reply");
	break;
      }
      send_private(global.reply, pos+1);
      break;
    case C_PRIVATE:
      if ((!pos) || (pos[1] == 0)) {
	client_message("error", "Wrong format in command /private");
	break;
      }
      if (is_string_in_list(global.private_users, pos+1)) {
	client_message("message", "User is already in private list");
	return;
      }
      
      global.private_users = 
	g_list_append(global.private_users, strdup(pos+1));
      
      create_private_page(pos+1);
      break;
    case C_MAIL:
      if ((!pos) || (pos[1] == 0)) {
	print_mail(NULL);
	break;
      }
      sprintf(t, "%s ", pos+1);
      pos2 = strchr(pos+1, ' ');

      if ((!pos2) || (pos2[1] == 0)) {
	print_mail(t);
      } else {
	pos2[0] = 0;
	add_mail(pos+1, pos2+1);
      }
      break;
    case C_DELMAIL:
      if ((!pos) || (pos[1] == 0)) {
	del_mail(NULL);
	break;
      }
      sprintf(t, "%s", pos+1);
      del_mail(t);

      break;
    case C_CONN:
      on_connect_activate(NULL, NULL);
      temp = lookup_widget(global.connect_win, "combo_entry12");
      gtk_entry_set_text(GTK_ENTRY(temp), "Last Server");
      on_connection_ok_clicked(NULL, NULL);
      break;
    case C_MOTD:
      send_command(621, "");
      break;
    case C_QUIT:
      on_exit_activate(NULL, NULL);
      break;
    case C_IGNORE:
      if ((!pos) || (pos[1] == 0)) {
	on_show_ignore_list_activate(NULL, NULL);
	break;
      }
      send_command(322, pos+1);
      break;
    case C_MUZZLE:
      if ((!pos) || (pos[1] == 0)) {
	client_message("error", "Wrong format in command /muzzle");
	break;
      }
      pos2 = strchr(pos+1, ' ');
      if ((!pos2) || (pos2[1] == 0)) {
	send_command(622, pos+1);
      } else {
	pos2[0] = 0;
	send_command(622, "%s \"%s\"", pos+1, pos2+1);
      }
      break;
    case C_UNMUZZLE:
      if ((!pos) || (pos[1] == 0)) {
	client_message("error", "Wrong format in command /muzzle");
	break;
      }
      send_command(623, pos+1);
      break;
    case C_SPEED:
      if ((!pos) || (pos[1] == 0)) {
	client_message("error", "Wrong format in command /speed");
	break;
      }
      pos2 = strchr(pos+1, ' ');
      if ((!pos2) || (pos2[1] == 0)) {
	send_command(700, pos+1);
      } else {
	send_command(625, pos+1);
      }
      break;
    case C_PASSWORD:
      if ((!pos) || (pos[1] == 0)) {
	client_message("error", "Wrong format in command /password");
	break;
      }
      pos2 = strchr(pos+1, ' ');
      if ((!pos2) || (pos2[1] == 0)) {
	send_command(701, pos+1);
      } else {
	send_command(753, pos+1);
      }
      break;
    case C_TOPIC:
      if ((!pos) || (pos[1] == 0)) {
	client_message("error", "Wrong format in command /topic");
	break;
      }
      pos2 = strchr(pos+1, ' ');
      if ((!pos2) || (pos2[1] == 0)) {
	client_message("error", "Wrong format in command /topic");
	break;
      }
      send_command(410, pos+1);
      break;
    case C_VERSION:
      send_command(801, "");
      break;
    case C_CLEAR:
      sprintf(t, "%s_text", global.current_room);
      temp = lookup_widget(global.win, t);
      gtk_text_set_point(GTK_TEXT(temp), 0);
      gtk_text_forward_delete(GTK_TEXT(temp),
			      gtk_text_get_length(GTK_TEXT(temp)));
      break;
    case C_UNIGNORE:
      if ((!pos) || (pos[1] == 0)) {
	client_message("error", "Wrong format in command /unignore");
	break;
      }
      send_command(323, pos+1);
      break;
    case C_CHBAN:
      if ((!pos) || (pos[1] == 0)) {
	client_message("error", "Wrong format in command /chban");
	break;
      }
      pos2 = strchr(pos+1, ' ');
      if ((!pos2) || (pos2[1] == 0)) {
	client_message("error", "Wrong format in command /chban");
	break;
      }
      pos2[0] = 0;
      strcpy(t, pos+1);
      pos = pos2;
      pos2 = strchr(pos+1, ' ');
      if ((!pos2) || (pos2[1] == 0)) {
	send_command(422, "%s %s", t, pos+1);
      } else {
	pos2[0] = 0;
	send_command(422, "%s %s \"%s\"", t, pos+1, pos2+1);
      }
      break;
    case C_CHUNBAN:
      if ((!pos) || (pos[1] == 0)) {
	client_message("error", "Wrong format in command /chunban");
	break;
      }
      pos2 = strchr(pos+1, ' ');
      if ((!pos2) || (pos2[1] == 0)) {
	send_command(424, pos+1);
	break;
      }
      pos2[0] = 0;
      strcpy(t, pos+1);
      pos = pos2;
      pos2 = strchr(pos+1, ' ');
      if ((!pos2) || (pos2[1] == 0)) {
	send_command(423, "%s %s", t, pos+1);
      } else {
	pos2[0] = 0;
	send_command(423, "%s %s \"%s\"", t, pos+1, pos2+1);
      }
      break;
    case C_NUKE:
      if ((!pos) || (pos[1] == 0)) {
	client_message("error", "Wrong format in command /nuke");
	break;
      }
      send_command(611, pos+1);
      break;
    case C_UNNUKE:
      if ((!pos) || (pos[1] == 0)) {
	client_message("error", "Wrong format in command /unnuke");
	break;
      }
      send_command(624, pos+1);
      break;
    case C_GLOBAL:
      if ((!pos) || (pos[1] == 0)) {
	client_message("error", "Wrong format in command /global");
	break;
      }
      send_command(628, pos+1);
      break;
    case C_KICK:
      if ((!pos) || (pos[1] == 0)) {
	client_message("error", "Wrong format in command /kick");
	break;
      }
      pos2 = strchr(pos+1, ' ');
      if ((!pos2) || (pos2[1] == 0)) {
	client_message("error", "Wrong format in command /kick");
	break;
      }
      pos2[0] = 0;
      strcpy(t, pos+1);
      pos = pos2;
      pos2 = strchr(pos+1, ' ');
      if ((!pos2) || (pos2[1] == 0)) {
	send_command(829, "%s %s", t, pos+1);
      } else {
	pos2[0] = 0;
	send_command(829, "%s %s \"%s\"", t, pos+1, pos2+1);
      }
      break;
    case C_CVERSION:
      if (uname(&uts) < 0) {
	sprintf(t, "Lopster %s", VERSION);
      } else {
	sprintf(t, "Lopster %s / %s %s %s",
		VERSION, uts.nodename, uts.sysname, uts.release);
      }   
      if (in_channel()) {
	send_command(402, "%s %s", global.current_room, t);
      } else {
	client_message("message", t);
      }
      break;
    case C_PING:
      if ((!pos) || (pos[1] == 0)) {
	client_message("error", "Wrong format in command /ping");
	break;
      }
      time(&tim);
      strcpy(t, ctime(&tim));
      t[strlen(t)-1] = 0;
      client_message("message", "pinging %s [%s]", pos+1, t);
      send_command(751, pos+1);
      break;
    case C_ECHO:
      if ((!pos) || (pos[1] == 0)) {
	client_message("error", "Wrong format in command /echo");
	break;
      }
      chat_print_colored(global.current_room, "text", pos+1);
      chat_print("text", "\n");
      break;
    case C_HELP:
      if ((!pos) || (pos[1] == 0)) {
	chat_print("message", "[Available Commands]\n");
	for (i2 = 0; i2 < 5; i2++) {
	  chat_print("message", " ");
	  chat_print("error", FolderNames[i2]);
	  cnt = 0;
	  for (i1 = 0; i1 < g_list_length(global.commands); i1++) {
	    command = (command_t*)(g_list_nth(global.commands, i1)->data);
	    if (command->folder == i2) {
	      if (cnt%5==0) chat_print("NULL", "\n      ");
	      else chat_print("NULL", ", ");
	      chat_print("message", "/%s", command->name);
	      cnt++;
	    }
	  }
	  chat_print("NULL", "\n");
	}
	chat_print("text", "Type ");
	chat_print("message", "/help <command>");
	chat_print("text", " for more information!\n");
      } else {
	pos++;
	pos2 = strchr(pos, ' ');
	if (pos2) pos2[0] = 0;
	command = command_is_command(pos);
	if (command) {
	  chat_print("text", "Syntax: ");
	  chat_print("message", "%s\n", command->syntax);
	  chat_print("text", "%s\n", command->description);
	} else {
	  client_message("error", "This is not a command!");
	}
      }
      break;
    default:
      client_message("error", "Command not implemented yet");
      //      printf("tried to do command [%d][%s][%s]\n",
      //	     command->id, command->name, command->description);
      break;
    }
    gtk_entry_set_text(entry, "");
    return;
  } else {
    if (is_string_in_list(global.private_users, global.current_room)) {
      send_private(global.current_room, text2);
    } else {
      if (!strcmp(global.current_room, "Console")) return;
      send_command(402, "%s %s", global.current_room, text2);
    }
    gtk_entry_set_text(entry, "");
  }
  free(text);
}


void
on_notebook3_switch_page               (GtkNotebook     *notebook,
                                        GtkNotebookPage *page,
                                        gint             page_num,
                                        gpointer         user_data)
{
  GtkWidget* label;
  
  label = page->tab_label;
  strcpy(global.current_room, GTK_LABEL(label)->label);
  gtk_widget_set_style(label, global.style[0]);  

}


gboolean
on_search_list_button_press_event      (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  GtkWidget* pop;
  int row, column;

  if (event->button == 3) {
    if (!gtk_clist_get_selection_info(GTK_CLIST(widget),
				      (int)event->x, (int)event->y,
				      &row, &column))
      row = -1;
    if (row == -1) return FALSE;
    
    global.popup_row = row;
    global.popup_list = widget;
    gtk_clist_select_row (GTK_CLIST(widget), row, 0);
    pop = create_search_list_popup();
    gtk_menu_popup(GTK_MENU(pop), NULL, NULL, 
		   NULL, NULL, 1, 10);
  }

  return FALSE;
}

//////////////////////////////////////////
// whois stuff
void
on_who_is_user_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkCList* list;
  file_t* file;

  list = GTK_CLIST(global.popup_list);
  
  file = (file_t*)gtk_clist_get_row_data(list, global.popup_row);
  if (file) send_command(603, file->user);
}

// end whois stuff
//////////////////////////////////////////


//////////////////////////////////////////
// download stuff
void
on_download_selected_activate         (GtkMenuItem     *menuitem,
				       gpointer         user_data)
{
  GtkCList* clist;
  GList* row_list;
  file_t* file;
  int row;

  clist = GTK_CLIST(global.popup_list);
  row_list = clist->selection;

  while (row_list) {
    row = (int)row_list->data;
    file = (file_t*)gtk_clist_get_row_data(clist, row);
    download_file(file);
    row_list = row_list->next;
  }
  
}

void
on_download_activate            (GtkMenuItem     *menuitem,
				 gpointer         user_data)
{
  GtkCList* list;
  file_t* file;

  list = GTK_CLIST(global.popup_list);
  
  file = (file_t*)gtk_clist_get_row_data(list, global.popup_row);
  
  download_file(file);
}


// end download stuff
/////////////////////////////////

//////////////////////////////////////////
// hotlist stuff

void
on_button32_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* temp;
  char user[200];

  temp = lookup_widget(GTK_WIDGET(button), "entry16");
  strcpy(user, gtk_entry_get_text(GTK_ENTRY(temp)));

  add_to_hotlist(user);

  temp = lookup_widget(GTK_WIDGET(button), "add_user_win");
  gtk_widget_hide(temp);
  gtk_widget_destroy(temp);
}

void
on_add_to_hot_list_activate       (GtkMenuItem     *menuitem,
				   gpointer         user_data)
{
  GtkWidget* win;

  win = create_add_user_win();
  gtk_widget_show(win);
}



void
on_add_user_to_hotlist_activate        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkCList* list;
  file_t* file;

  list = GTK_CLIST(global.popup_list);
  file = (file_t*)gtk_clist_get_row_data(list, global.popup_row);
  if (!file) return;
  
  add_to_hotlist(file->user);
}


void
on_add_selected_users_to_hotlist_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkCList* list;
  GList* row_list;
  file_t* file;
  int row;
  int insert;

  list = GTK_CLIST(global.popup_list);
  row_list = list->selection;

  while (row_list) {
    row = (int)row_list->data;
    file = (file_t*)gtk_clist_get_row_data(list, row);
    insert = 1;

    if (file) {
      add_to_hotlist(file->user);
    }
    row_list = row_list->next;
  }


}

gboolean
on_online_button_press_event         (GtkWidget       *widget,
				      GdkEventButton  *event,
				      gpointer         user_data)
{
  GtkWidget* pop;
  GtkWidget* temp;
  int row, column;
  char *text;
  char t[500];
  GdkPixmap *pixmap = NULL;
  GdkBitmap *bitmap = NULL;
  guint8 space;

  if (event->button == 3) {
    if (!gtk_clist_get_selection_info(GTK_CLIST(widget),
				      (int)event->x, (int)event->y,
				      &row, &column))
      row = -1;
    
    if (row == -1) return FALSE;


    global.popup_row = row;
    global.popup_list = widget;

    gtk_clist_select_row (GTK_CLIST(widget), row, 0);
    gtk_clist_get_pixtext (GTK_CLIST(widget), row, 0,
			   &text, &space,
			   &pixmap, &bitmap);
    pop = create_online_popup1();
    strcpy(t, text);

    if (is_string_in_list(global.ignored_users, t)) {
      temp = lookup_widget(pop, "whisper_mode");
      gtk_widget_set_sensitive(temp, FALSE);
      temp = lookup_widget(pop, "private_mode");
      gtk_widget_set_sensitive(temp, FALSE);
    }
    temp = lookup_widget(pop, "ignore_user");
    if (is_string_in_list(global.ignored_users, t)) {
      gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (temp),
				      TRUE);
    }
    gtk_signal_connect (GTK_OBJECT (temp), "activate",
			GTK_SIGNAL_FUNC (on_ignore_user_activate),
			NULL);
    temp = lookup_widget(pop, "friend1");
    if (is_string_in_list(global.frienduser, t)) {
      gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (temp),
				      TRUE);
    }
    gtk_signal_connect (GTK_OBJECT (temp), "activate",
			GTK_SIGNAL_FUNC (on_friend1_activate),
			NULL);
    temp = lookup_widget(pop, "enemy1");
    if (is_string_in_list(global.enemyuser, t)) {
      gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (temp),
				      TRUE);
    }
    gtk_signal_connect (GTK_OBJECT (temp), "activate",
			GTK_SIGNAL_FUNC (on_enemy1_activate),
			NULL);
    gtk_menu_popup(GTK_MENU(pop), NULL, NULL, 
		   NULL, NULL, 1, 10);


  }

  return FALSE;
}

// end hotlist stuff
/////////////////////////////////

/////////////////////////////////
// list stuff
void
on_list_click_column                   (GtkCList        *clist,
                                        gint             column,
                                        gpointer         user_data)
{
  if (column == clist->sort_column) {
    if (clist->sort_type == GTK_SORT_ASCENDING)
      gtk_clist_set_sort_type(clist, GTK_SORT_DESCENDING);
    else
      gtk_clist_set_sort_type(clist, GTK_SORT_ASCENDING);
  } else {
    gtk_clist_set_sort_column(clist, column);
    gtk_clist_set_sort_type(clist, GTK_SORT_DESCENDING);
  }

  gtk_clist_freeze (clist);
  gtk_clist_sort(clist);
  gtk_clist_thaw(clist);

}
// end list stuff
/////////////////////////////////


gboolean
on_transfer_down_button_press_event    (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  GtkWidget* pop;
  int row, column;
  GtkWidget* temp;

  if (event->button == 3) {
    if (!gtk_clist_get_selection_info(GTK_CLIST(widget),
				     (int)event->x, (int)event->y,
				     &row, &column))
      row = -1;
      
    if (row == -1) return FALSE;
    global.popup_row = row;
    global.popup_list = widget;
    gtk_clist_select_row (GTK_CLIST(widget), row, 0);
    pop = create_download_popup();
    gtk_menu_popup(GTK_MENU(pop), NULL, NULL, NULL, NULL, 1, 10);

    if (!global.player) {
      temp = lookup_widget(pop, "play_file");
      gtk_widget_set_sensitive(temp, FALSE);
    }
    
  }
  return FALSE;
}


void
on_cancel_download_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkCList* list;
  transfer_t* transfer;

  list = GTK_CLIST(global.popup_list);
  
  transfer = (transfer_t*)gtk_clist_get_row_data(list, global.popup_row);
  
  if (transfer) transfer_end(transfer, S_CANCELED);
}


void
on_delete_download_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkCList* list;
  transfer_t* transfer;

  list = GTK_CLIST(global.popup_list);
  
  transfer = (transfer_t*)gtk_clist_get_row_data(list, global.popup_row);
  
  if (transfer) {
    transfer_end(transfer, S_CANCELED);
    gtk_clist_remove(list, global.popup_row);
  }
}


void
on_retry_download_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkCList* list;
  transfer_t* transfer;

  list = GTK_CLIST(global.popup_list);
  transfer = (transfer_t*)gtk_clist_get_row_data(list, global.popup_row);
  
  // this is a copy from [download_file(file_t* file)]
  if ((global.network.max_downloads > global.network.cur_downloads) &&
      (global.network.max_transfers > global.network.cur_downloads+global.network.cur_uploads)) {
    transfer->status = S_WAITING;
    //    printf("sending download request [%s]\n", transfer->winname);
    send_command(203, "%s \"%s\"", 
		 transfer->user, transfer->winname);
    transfer->sock.timeout = 
      gtk_timeout_add(UPDATE_DELAY, transfer_timeout_cb, transfer);
    global.network.cur_downloads++;
  } else {
    transfer->status = S_QUEUED;
    //    printf("download queued [%s]\n", transfer->winname);
  }
}


void
on_who_is_user_activate2               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkCList* list;
  transfer_t* transfer;

  list = GTK_CLIST(global.popup_list);
  
  transfer = (transfer_t*)gtk_clist_get_row_data(list, global.popup_row);
  if (transfer) send_command(603, transfer->user);
}


void
on_button64_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkCList* list;
  int i1;
  transfer_t* transfer;

  list = GTK_CLIST(lookup_widget(global.win, "transfer_down"));
  i1 = 0;
  while (1) {
    if (i1 >= list->rows) break;
    transfer = (transfer_t*)gtk_clist_get_row_data(list, i1);
    if (transfer->status == S_FINISHED) {
      gtk_clist_remove(list, i1);
    } else {
      i1++;
    }
  }
  list = GTK_CLIST(lookup_widget(global.win, "transfer_up"));
  i1 = 0;
  while (1) {
    if (i1 >= list->rows) break;
    transfer = (transfer_t*)gtk_clist_get_row_data(list, i1);
    if (transfer->status == S_FINISHED) {
      gtk_clist_remove(list, i1);
    } else {
      i1++;
    }
  }
}


void
on_button80_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* temp;
  GtkWidget* temp2;
  char* text;

  temp2 = lookup_widget(GTK_WIDGET(button), "entry39");

  if (global.dir_select_mode == 1) {
    temp = lookup_widget(global.options_win, "entry14");
    gtk_entry_set_text(GTK_ENTRY(temp),
		       gtk_entry_get_text(GTK_ENTRY(temp2)));
  } else {
    temp = lookup_widget(global.options_win, "entry13");
    text = gtk_entry_get_text(GTK_ENTRY(temp));
    if (strlen(text) > 0)
      gtk_entry_append_text(GTK_ENTRY(temp), ";");
    gtk_entry_append_text(GTK_ENTRY(temp),
			  gtk_entry_get_text(GTK_ENTRY(temp2)));
  }

  gtk_widget_hide(global.dir_select_win);
}


void
on_button81_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_hide(global.dir_select_win);
}


void
on_dir_select_win_destroy              (GtkObject       *object,
                                        gpointer         user_data)
{
  gtk_widget_destroy(global.dir_select_win);
  global.dir_select_win = NULL;
}


void
on_search_artist_activate              (GtkEditable     *editable,
                                        gpointer         user_data)
{
  gtk_signal_emit_stop_by_name(GTK_OBJECT(editable), "activate");
  send_search_request();
}


void
on_search_results_activate             (GtkEditable     *editable,
                                        gpointer         user_data)
{
  send_search_request();
}



gboolean
on_chat_entry_key_press_event          (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{
  GtkEntry* entry;
  GtkWidget* temp;
  char* text;
  char* text2;
  char comm[1024];
  char t[1024];
  GList* list;
  int row;
  GdkPixmap *pixmap = NULL;
  GdkBitmap *bitmap = NULL;
  guint8 space;
  GList* c_list;
  int i1;
  command_t* command;
  static int cnt = 0;

  //  printf("key: [%d][%d]\n", event->keyval, event->state);
  if (event->type == GDK_KEY_PRESS) {
    entry = GTK_ENTRY(widget);
    if ((event->keyval == 119) &&     // w
	(event->state == 8)) {        // ALT
      text = gtk_entry_get_text(entry);
      gtk_entry_set_text(entry, "");
      if (strlen(text) <= 0) return TRUE;
      
      // looking for channel online list
      if (is_string_in_list(global.private_users, global.current_room)) return TRUE;
      if (!in_channel()) return TRUE;
      sprintf(comm, "%s_online", global.current_room);
      temp = lookup_widget(global.win, comm);
      // and searching for a selected user
      list = GTK_CLIST(temp)->selection;
      if (list) row = (int)list->data;
      else return TRUE;
      
      gtk_clist_get_pixtext (GTK_CLIST(temp), row, 0,
			     &text2, &space,
			     &pixmap, &bitmap);
      
      send_private(text2, text);
      cnt = 0;
    } else if (event->keyval == 65289) {     // tab
      cnt++;
      gtk_signal_emit_stop_by_name(GTK_OBJECT(widget), "key_press_event");

      text = strdup(gtk_entry_get_text(entry));

      if (strlen(text) <= 0) return TRUE;
      text2 = strrchr(text, ' ');
      if ((text[0] != '/') || (text2)) {
	if (text2) text2++;
	else text2 = text;

	if (text2[0] == '@') text2++;
	c_list = user_search(text2);
	
	switch (g_list_length(c_list)) {
	case 0:
	  //	  client_message("error", "no fitting user found");
	  gdk_beep();
	  cnt = 0;
	  break;
	case 1:
	  text2[0] = 0;
	  strcpy(t, text);
	  strcat(t, c_list->data);
	  gtk_entry_set_text(entry, t);
	  cnt = 0;
	  break;
	default:
	  gdk_beep();
	  i1 = calc_list_prefix(c_list);
	  text2[0] = 0;
	  strcpy(t, text);
	  strncat(t, c_list->data, i1);
	  gtk_entry_set_text(entry, t);

	  if (cnt > 1) {
	    strcpy(t, "******** Available Users:\n");
	    for (i1 = 0; i1 < g_list_length(c_list); i1++) {
	      if (i1 > 0) strcat(t, ", ");
	      strcat(t, g_list_nth(c_list, i1)->data);
	    }
	    chat_print("message", "%s\n", t);
	    cnt = 0;
	  }
	  break;
	}
      } else {
	text2 = strdup(text+1);
	c_list = command_search(text2);

	switch (g_list_length(c_list)) {
	case 0:
	  //	  client_message("error", "no fitting command found");
	  gdk_beep();
	  cnt = 0;
	  break;
	case 1:
	  command = (command_t*)(c_list->data);
	  sprintf(comm,"/%s ", command->name);
	  gtk_entry_set_text(entry, comm);
	  cnt = 0;
	  break;
	default:
	  gdk_beep();
	  i1 = calc_command_prefix(c_list);
	  command = (command_t*)(c_list->data);
	  comm[0] = '/';
	  comm[1] = 0;
	  strncat(comm, command->name, i1);
	  gtk_entry_set_text(entry, comm);

	  if (cnt > 1) {
	    strcpy(t, "******** Available Commands:\n");
	    for (i1 = 0; i1 < g_list_length(c_list); i1++) {
	      if (i1 > 0) strcat(t, ", /");
	      else strcat(t, "/");
	      command = (command_t*)(g_list_nth(c_list, i1)->data);
	      strcat(t, command->name);
	    }
	    chat_print("message", "%s\n", t);
	    cnt = 0;
	  }
	  break;
	}
	free(text2);
      }
    } else if ((event->keyval == 65362) || (event->keyval == 65364)) {
      cnt = 0;
      if (event->keyval == 65362) {     // Up
	if (global.history_pos > 0) global.history_pos--;
	else global.history_pos = 0;
      }
      if (event->keyval == 65364) {     // Down
	if (global.history_pos < g_list_length(global.chat_history))
	  global.history_pos++;
	else global.history_pos = g_list_length(global.chat_history);
      }
      c_list = g_list_nth(global.chat_history, global.history_pos);
      if (c_list) {
	text = c_list->data;
	if (text) gtk_entry_set_text(GTK_ENTRY(widget), text);
      } else {
	gtk_entry_set_text(GTK_ENTRY(widget), "");
      }
      gtk_signal_emit_stop_by_name(GTK_OBJECT(widget), "key_press_event");
    } else {
      cnt = 0;
    }
  }

  return 1;
}


void
on_whois_win_destroy                   (GtkObject       *object,
                                        gpointer         user_data)
{
  gtk_widget_destroy(global.whois_win);
  global.whois_win = NULL;
}


void
on_button82_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_hide(global.whois_win);
}


void
on_button83_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
  char* nick;
  GtkWidget* temp;

  temp = lookup_widget(global.whois_win, "entry24");
  nick = gtk_entry_get_text(GTK_ENTRY(temp));
  
  add_to_hotlist(nick);
}


gboolean
on_transfer_up_button_press_event      (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  GtkWidget* pop;
  int row, column;

  if (event->button == 3) {
    if (!gtk_clist_get_selection_info(GTK_CLIST(widget),
				     (int)event->x, (int)event->y,
				     &row, &column))
      row = -1;
      
    if (row == -1) return FALSE;
    global.popup_row = row;
    global.popup_list = widget;
    gtk_clist_select_row (GTK_CLIST(widget), row, 0);
    pop = create_upload_popup();
    gtk_menu_popup(GTK_MENU(pop), NULL, NULL, NULL, NULL, 1, 10);
  }

  return FALSE;
}


void
on_cancel_upload_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkCList* list;
  transfer_t* transfer;

  list = GTK_CLIST(global.popup_list);
  
  transfer = (transfer_t*)gtk_clist_get_row_data(list, global.popup_row);
  
  if (transfer) transfer_end(transfer, S_CANCELED);
}


void
on_delete_upload_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkCList* list;
  transfer_t* transfer;

  list = GTK_CLIST(global.popup_list);
  
  transfer = (transfer_t*)gtk_clist_get_row_data(list, global.popup_row);
  
  if (transfer) {
    transfer_end(transfer, S_CANCELED);
    gtk_clist_remove(list, global.popup_row);
  }
}

void
on_entry34_activate                    (GtkEditable     *editable,
                                        gpointer         user_data)
{
  GtkWidget* temp;
  char user[200];
  
  temp = lookup_widget(GTK_WIDGET(editable), "entry34");
  strcpy(user, gtk_entry_get_text(GTK_ENTRY(temp)));
  send_command(603, user);
}


void
on_entry16_activate                    (GtkEditable     *editable,
                                        gpointer         user_data)
{
  GtkWidget* temp;
  char user[200];

  temp = lookup_widget(GTK_WIDGET(editable), "entry16");
  strcpy(user, gtk_entry_get_text(GTK_ENTRY(temp)));

  add_to_hotlist(user);

  temp = lookup_widget(GTK_WIDGET(editable), "add_user_win");
  gtk_widget_hide(temp);
  gtk_widget_destroy(temp);
}


void
on_togglebutton2_toggled               (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  GtkWidget* temp;
  GtkWidget* temp2;

  temp = lookup_widget(GTK_WIDGET(togglebutton), "label125");
  temp2 = lookup_widget(GTK_WIDGET(togglebutton), "entry35");

  if (gtk_toggle_button_get_active(togglebutton)) {
    gtk_widget_set_sensitive(temp, TRUE);
    gtk_widget_set_sensitive(temp2, TRUE);
  } else {
    gtk_widget_set_sensitive(temp, FALSE);
    gtk_widget_set_sensitive(temp2, FALSE);
  }
  
}


void
on_button84_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
  global.connect_button = toggle_button_state(GTK_WIDGET(button));
}


int add_server_to_list(address_t* server) {
  GtkWidget* temp;
  int row;

  if (search_server_in_list(server)) return 0;
  
  sprintf(tstr[0], "%s:%d", server->ip, server->port);
  strcpy(tstr[1], server->description);

  temp = lookup_widget(global.options_win, "server_list");

  row = gtk_clist_append(GTK_CLIST(temp), list);
  gtk_clist_set_row_data(GTK_CLIST(temp), row, server);
  return 1;
}

void
on_button85_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* temp;
  int val;
  address_t* server;

  temp = lookup_widget(GTK_WIDGET(button), "entry38");
  strcpy(tstr[1], gtk_entry_get_text(GTK_ENTRY(temp)));
  if (strlen(tstr[1]) <= 0) return;
  gtk_entry_set_text(GTK_ENTRY(temp), "");

  server = (address_t*)malloc(sizeof(address_t));
  server->ip = strdup(tstr[1]);
  server->ip_long = inet_addr(server->ip);
  temp = lookup_widget(GTK_WIDGET(button), "spinbutton4");
  val = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(temp));
  server->port = val;

  temp = lookup_widget(GTK_WIDGET(button), "entry37");
  strcpy(tstr[1], gtk_entry_get_text(GTK_ENTRY(temp)));
  gtk_entry_set_text(GTK_ENTRY(temp), "");
  server->description = strdup(tstr[1]);
  
  server->no_connected = 0;

  if (add_server_to_list(server) == 0) {
    free(server);
  }
}

void
on_button86_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{

  GtkCList* list;
  GList* row_list;
  int row;

  list = GTK_CLIST(lookup_widget(GTK_WIDGET(button), "server_list"));

  while ((row_list = list->selection) != NULL) {
    row = (int)row_list->data;
    gtk_clist_remove(list, row);
  }
}


void
on_button89_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* window;
  GtkWidget* temp;

  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_object_set_data (GTK_OBJECT (window), "window", window);
  gtk_window_set_title (GTK_WINDOW (window), "Chat");

  temp = lookup_widget(GTK_WIDGET(button), "vbox15");
  gtk_widget_unparent(temp);
  //gtk_widget_unref(temp);
  gtk_widget_unmap(temp);
  gtk_widget_unrealize(temp);
  gtk_container_add (GTK_CONTAINER (window), temp);
  
  temp = lookup_widget(GTK_WIDGET(button), "notebook1");
  //  gtk_notebook_remove_page(GTK_NOTEBOOK(temp), 0);
  
  gtk_widget_show(window);
}


void
on_button90_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{

  gtk_widget_destroy(global.ban_win);
  global.ban_win = NULL;

}


void
on_add_to_hotlist_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkCList* list;
  char *text;
  GdkPixmap *pixmap = NULL;
  GdkBitmap *bitmap = NULL;
  guint8 space;

  list = GTK_CLIST(global.popup_list);
  
  gtk_clist_get_pixtext (list, global.popup_row, 0,
			 &text, &space,
			 &pixmap, &bitmap);
  add_to_hotlist(text);
  
}


void
on_whois_user_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkCList* list;
  char comm[500];
  char *text;
  GdkPixmap *pixmap = NULL;
  GdkBitmap *bitmap = NULL;
  guint8 space;

  list = GTK_CLIST(global.popup_list);

  gtk_clist_get_pixtext (list, global.popup_row, 0,
			 &text, &space,
			 &pixmap, &bitmap);

  //  gtk_clist_get_text(list, global.popup_row, 0, &text);
  strcpy(comm, text);

  //  sprintf(comm, "%s", text);
  send_command(603, text);

}


void
on_ignore_user_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkCList* list;
  char *text;
  GdkPixmap *pixmap = NULL;
  GdkBitmap *bitmap = NULL;
  guint8 space;

  list = GTK_CLIST(global.popup_list);
  
  gtk_clist_get_pixtext (list, global.popup_row, 0,
			 &text, &space,
			 &pixmap, &bitmap);
  if (is_string_in_list(global.ignored_users, text)) {
    send_command(323, text);
  } else {
    send_command(322, text);
  }
}


void
on_show_ignore_list_activate           (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  if (global.ignore_win) {
    gtk_widget_show(global.ignore_win);
  } else {
    global.ignore_win = create_ignore_win();
    gtk_widget_show(global.ignore_win);
    send_command(320, "");
  }
}


void
on_ignore_win_destroy                  (GtkObject       *object,
                                        gpointer         user_data)
{
  
  gtk_widget_hide(global.ignore_win);
  gtk_widget_destroy(global.ignore_win);
  global.ignore_win = NULL;
}


void
on_button91_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
  int i1;
  GtkCList* clist;
  char* text;

  // clear ignore list
  clist = GTK_CLIST(lookup_widget(global.ignore_win, "ignore_list"));
  for (i1 = 0; i1 < clist->rows; i1++) {
    gtk_clist_get_text(clist, i1, 0, &text);
    send_command(323, text);
  }
  
}


void
on_button93_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_hide(global.ignore_win);
}


void
on_refresh_users_files_activate        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget* temp;
  GtkCList* clist;
  GtkCTree* ctree;
  GtkCTreeNode* node;
  GtkCTreeNode* node2;
  char *text;
  char *t;
  GdkPixmap *pixmap = NULL;
  GdkBitmap *bitmap = NULL;
  guint8 space;
  hot_t* data;
  hot_t* data2;

  clist = GTK_CLIST(global.popup_list);
  ctree = GTK_CTREE(global.popup_list);
  
  gtk_clist_get_pixtext (clist, global.popup_row, 0,
			 &text, &space,
			 &pixmap, &bitmap);
  t = strdup(text);

  node2 = gtk_ctree_node_nth(ctree, global.popup_row);

  data = gtk_ctree_node_get_row_data(ctree, node2);
  temp = lookup_widget(global.win, "hot_tree");
  data2 = (hot_t*)gtk_object_get_data(GTK_OBJECT(temp), "stats");
  data2->files -= data->files;
  data2->bytes -= data->bytes;
  data->files = 0;
  data->bytes = 0;
  hotlist_update_stats();

  node = GTK_CTREE_ROW(node2)->children;
  while(node) {
    gtk_ctree_remove_node(ctree, node);
    node = GTK_CTREE_ROW(node2)->children;
  }

  send_command(211, text);
  free(t);
}


void
on_remove_user_from_hotlist_activate   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkCList* list;
  char *text;
  char *t;

  GdkPixmap *pixmap = NULL;
  GdkBitmap *bitmap = NULL;
  guint8 space;

  list = GTK_CLIST(global.popup_list);
  
  gtk_clist_get_pixtext (list, global.popup_row, 0,
			 &text, &space,
			 &pixmap, &bitmap);
  t = strdup(text);
  remove_from_hotlist(t);
  free(t);
}


void
on_download2_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

  GtkCTree* ctree;
  GtkCTreeNode* node;
  file_t* file;

  ctree = GTK_CTREE(global.popup_list);
  
  node = gtk_ctree_node_nth(ctree, global.popup_row);
  file = (file_t*)gtk_ctree_node_get_row_data(ctree, node);
  
  download_file(file);
}


gboolean
on_hot_tree_button_press_event         (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  GtkWidget* pop;
  int row, column;
  char *text;
  GdkPixmap *pixmap = NULL;
  GdkBitmap *bitmap = NULL;
  guint8 space;

  if (event->button == 3) {
    if (!gtk_clist_get_selection_info(GTK_CLIST(widget),
				      (int)event->x, (int)event->y,
				      &row, &column))
      row = -1;
    
    if (row == -1) return FALSE;


    global.popup_row = row;
    global.popup_list = widget;

    gtk_clist_get_pixtext (GTK_CLIST(widget), row, 0,
			   &text, &space,
			   &pixmap, &bitmap);
    
    if (pixmap == global.pix.user1) {
      pop = create_hotlist_popup1();
    } else if (pixmap == global.pix.user2) {
      pop = create_hotlist_popup1();
    } else if (pixmap == global.pix.dummy) {
      pop = create_hotlist_popup1();
    } else if (pixmap == NULL) {
      pop = create_hotlist_popup2();
      gtk_clist_select_row (GTK_CLIST(widget), row, 0);
    } else return FALSE;
  
    gtk_menu_popup(GTK_MENU(pop), NULL, NULL, 
		   NULL, NULL, 1, 10);
  }

  return FALSE;
}



void
on_button60_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkCList* list;
  GtkCTree* ctree;
  GList* row_list;
  file_t* file;
  GtkCTreeNode* node;

  list = GTK_CLIST(lookup_widget(global.win, "hot_tree"));
  ctree = GTK_CTREE(lookup_widget(global.win, "hot_tree"));
  row_list = list->selection;

  while (row_list) {
    node = (GtkCTreeNode*)row_list->data;
    file = (file_t*)gtk_ctree_node_get_row_data(ctree, node);
    download_file(file);
    row_list = row_list->next;
  }

}


void
on_combo_entry14_changed               (GtkEditable     *editable,
                                        gpointer         user_data)
{
  GtkEntry* entry;
  GtkEntry* entry2;
  GtkText* des;
  GtkEntry* alias;
  char* text;
  command_t* command;
  char t[2048];

  entry = GTK_ENTRY(lookup_widget(global.options_win, "combo_entry14"));
  entry2 = GTK_ENTRY(lookup_widget(global.options_win, "entry40"));
  des = GTK_TEXT(lookup_widget(global.options_win, "text9"));
  alias = GTK_ENTRY(lookup_widget(global.options_win, "entry41"));
  
  text = gtk_entry_get_text(entry);
  command = command_is_command(text);
  if (!command) {
    g_warning("could not get command, CRITICAL!");
    return;
  }
  
  // syntax
  gtk_entry_set_text(entry2, command->syntax);

  // description
  gtk_text_backward_delete(des, gtk_text_get_length(des));
  sprintf(t, "%s\n", command->description);
  gtk_text_insert(des, NULL, NULL, NULL, t, strlen(t));

  // alias
  text = command_get_alias_string(command->id);
  gtk_entry_set_text(alias, text);
}



void
on_button101_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkEntry* entry1;
  GtkEntry* entry2;
  char* text;
  char* pos;

  command_t* command;

  entry1 = 
    GTK_ENTRY(lookup_widget(global.options_win, "combo_entry14"));
  entry2 = 
    GTK_ENTRY(lookup_widget(global.options_win, "entry41"));

  text = gtk_entry_get_text(entry1);
  command = command_is_command(text);
  if (!command) {
    g_warning("chat command does not exists");
    return;
  }
  command_delete_alias_for(command->id);
  
  text = strdup(gtk_entry_get_text(entry2));
  
  pos = strtok(text, " \t");
  while (pos) {
    if (strlen(pos) > 0)
      command_make_alias(command->name, pos);
    pos = strtok(NULL, " \t");
  }
  free(text);
  
  text = command_get_alias_string(command->id);
  gtk_entry_set_text(entry2, text);
}



void
on_button96_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{

  GtkWidget* win;
  GtkWidget* temp;
  char str[1024];
  int i1;
  address_t* new;
  char* pos;

  win = lookup_widget(GTK_WIDGET(button), "options_win");
  // user
  temp = lookup_widget(win, "entry4");
  strcpy(global.user.username, gtk_entry_get_text(GTK_ENTRY(temp)));
  temp = lookup_widget(win, "entry5");
  strcpy(global.user.password, gtk_entry_get_text(GTK_ENTRY(temp)));
  temp = lookup_widget(win, "entry7");
  strcpy(global.user.email, gtk_entry_get_text(GTK_ENTRY(temp)));
  
  // paths
  temp = lookup_widget(win, "entry14");
  if (global.path.download) free(global.path.download);
  global.path.download = strdup(gtk_entry_get_text(GTK_ENTRY(temp)));

  temp = lookup_widget(win, "entry13");
  pos = strdup(gtk_entry_get_text(GTK_ENTRY(temp)));
  make_list_from_string(&global.path.shared, pos, ";");
  free(pos);
  pos = make_string_from_list(global.path.shared, ";");
  gtk_entry_set_text(GTK_ENTRY(temp), pos);

  // network
  temp = GTK_COMBO(lookup_widget(win, "combo3"))->entry;
  strcpy(str, gtk_entry_get_text(GTK_ENTRY(temp)));
  global.network.linespeed = speed2int(str);
  temp = lookup_widget(win, "spinbutton2");
  global.network.port = 
    gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(temp));

  temp = lookup_widget(win, "spinbutton1");
  global.network.max_downloads = 
    gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(temp));
  temp = lookup_widget(global.win, "spinbutton5");
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp),
			    global.network.max_downloads);
  temp = lookup_widget(win, "spinbutton3");
  global.network.max_uploads = 
    gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(temp));
  temp = lookup_widget(global.win, "spinbutton6");
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp),
			    global.network.max_uploads);
  temp = lookup_widget(win, "spinbutton7");
  global.network.max_transfers = 
    gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(temp));
  temp = lookup_widget(global.win, "spinbutton8");
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp),
			    global.network.max_transfers);

  temp = lookup_widget(win, "checkbutton4");
  global.network.firewall =
    gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp));
  temp = lookup_widget(win, "checkbutton13");
  global.auto_connect =
    gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp));


  // servers
  if (global.servers) {
    g_list_free(global.servers);
    global.servers = NULL;
  }    

  temp = lookup_widget(win, "server_list");
  for (i1 = 0; i1 < GTK_CLIST(temp)->rows; i1++) {
    new = (address_t*)gtk_clist_get_row_data(GTK_CLIST(temp), i1);
    global.servers = 
      g_list_insert_sorted(global.servers, new,
			   (GCompareFunc)server_comp);
  }

  // highlight
  temp = lookup_widget(win, "entry42");
  pos = strdup(gtk_entry_get_text(GTK_ENTRY(temp)));
  make_list_from_string(&global.highlight, pos, "\"");
  free(pos);
  pos = make_string_from_list(global.highlight, "\"");
  gtk_entry_set_text(GTK_ENTRY(temp), pos);
  temp = lookup_widget(global.win, "entry45");
  gtk_entry_set_text(GTK_ENTRY(temp), pos);
  temp = lookup_widget(global.win, "button122");
  gtk_widget_set_sensitive(temp, FALSE);

  // friend users
  temp = lookup_widget(win, "entry44");
  pos = strdup(gtk_entry_get_text(GTK_ENTRY(temp)));
  make_list_from_string(&global.frienduser, pos, " ");
  free(pos);
  pos = make_string_from_list(global.frienduser, " ");
  gtk_entry_set_text(GTK_ENTRY(temp), pos);
  temp = lookup_widget(global.win, "entry46");
  gtk_entry_set_text(GTK_ENTRY(temp), pos);
  temp = lookup_widget(global.win, "button123");
  gtk_widget_set_sensitive(temp, FALSE);

  // enemy users
  temp = lookup_widget(win, "entry52");
  pos = strdup(gtk_entry_get_text(GTK_ENTRY(temp)));
  make_list_from_string(&global.enemyuser, pos, " ");
  free(pos);
  pos = make_string_from_list(global.enemyuser, " ");
  gtk_entry_set_text(GTK_ENTRY(temp), pos);
  temp = lookup_widget(global.win, "entry51");
  gtk_entry_set_text(GTK_ENTRY(temp), pos);
  temp = lookup_widget(global.win, "button124");
  gtk_widget_set_sensitive(temp, FALSE);


  // saving color scheme
  on_button100_clicked(NULL, NULL);
  // setting up new color scheme
  temp = lookup_widget(win, "combo_entry15");
  free(global.scheme);
  global.scheme = strdup(gtk_entry_get_text(GTK_ENTRY(temp)));
  global.colors = scheme_load(global.colors, global.scheme);
  
  // misc
  temp = lookup_widget(win, "checkbutton11");
  global.show_joins =
    gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp));
  temp = lookup_widget(global.win, "checkbutton7");
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp),
			       global.show_joins);
  
  temp = lookup_widget(win, "checkbutton12");
  global.ignore_public_ignore =
    gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp));
  temp = lookup_widget(global.win, "checkbutton10");
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp),
			       global.ignore_public_ignore);

  temp = lookup_widget(win, "checkbutton15");
  global.send_ignore =
    gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp));
  temp = lookup_widget(global.win, "checkbutton14");
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp),
			       global.send_ignore);


  temp = lookup_widget(win, "checkbutton22");
  global.parse_color =
    gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp));
  temp = lookup_widget(global.win, "checkbutton21");
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp),
			       global.parse_color);

  // channels
  if (global.channels) {
    g_list_free(global.channels);
    global.channels = NULL;
  }    
  temp = lookup_widget(win, "clist6");
  for (i1 = 0; i1 < GTK_CLIST(temp)->rows; i1++) {
    gtk_clist_get_text(GTK_CLIST(temp), i1, 0, &pos);
    global.channels = 
      g_list_insert_sorted(global.channels, strdup(pos),
			   (GCompareFunc)strcasecmp);
  }

  // ext. player
  if (global.player) {
    free(global.player);
    global.player = NULL;
  }
  temp = lookup_widget(win, "entry53");
  pos = gtk_entry_get_text(GTK_ENTRY(temp));
  if (strlen(pos) > 0) {
    global.player = strdup(pos);
  }

  // logging
  temp = lookup_widget(win, "checkbutton16");
  global.logging =
    gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp));

  // now reinitialize port for uploads
  create_upload_port();

  write_rc();
}


void destroy_temp_colors(gpointer data) {
  GList* temp_colors;
  
  temp_colors = (GList*)data;
  g_list_free(temp_colors);
}

void draw_temps(GList* temp_colors) {
  GtkWidget* temp;
  GtkWidget* win;
  style_t* style;
  char str[2048];

  win = global.options_win;

  temp = lookup_widget(win, "text8");
  gtk_text_backward_delete(GTK_TEXT(temp), 
			   gtk_text_get_length(GTK_TEXT(temp)));
  
  style = style_get(temp_colors, "join");
  strcpy(str, "[Testuser1 joined channel]\n");
  gtk_text_insert(GTK_TEXT(temp), style->font, 
		  style->fore, style->back, 
		  str, strlen(str));
  style = style_get(temp_colors, "user");
  strcpy(str, "<");
  gtk_text_insert(GTK_TEXT(temp), style->font, 
		  style->fore, style->back, 
		  str, strlen(str));
  style = style_get(temp_colors, "yourself");
  strcpy(str, "Yourself");
  gtk_text_insert(GTK_TEXT(temp), style->font, 
		  style->fore, style->back, 
		  str, strlen(str));
  style = style_get(temp_colors, "user");
  strcpy(str, "> ");
  gtk_text_insert(GTK_TEXT(temp), style->font, 
		  style->fore, style->back, 
		  str, strlen(str));
  style = style_get(temp_colors, "text");
  strcpy(str, "Hello!\n");
  gtk_text_insert(GTK_TEXT(temp), style->font, 
		  style->fore, style->back, 
		  str, strlen(str));
  style = style_get(temp_colors, "part");
  strcpy(str, "[Testuser2 left channel]\n");
  gtk_text_insert(GTK_TEXT(temp), style->font, 
		  style->fore, style->back, 
		  str, strlen(str));
  style = style_get(temp_colors, "user");
  strcpy(str, "<Testuser1 emote message>\n");
  gtk_text_insert(GTK_TEXT(temp), style->font, 
		  style->fore, style->back, 
		  str, strlen(str));
  style = style_get(temp_colors, "error");
  strcpy(str, "** type of error\n");
  gtk_text_insert(GTK_TEXT(temp), style->font, 
		  style->fore, style->back, 
		  str, strlen(str));
  style = style_get(temp_colors, "whisper");
  strcpy(str, "<from: Testuser2> This is a private message\n");
  gtk_text_insert(GTK_TEXT(temp), style->font, 
		  style->fore, style->back, 
		  str, strlen(str));
  style = style_get(temp_colors, "user");
  strcpy(str, "<");
  gtk_text_insert(GTK_TEXT(temp), style->font, 
		  style->fore, style->back, 
		  str, strlen(str));
  style = style_get(temp_colors, "friend");
  strcpy(str, "Friend_User");
  gtk_text_insert(GTK_TEXT(temp), style->font, 
		  style->fore, style->back, 
		  str, strlen(str));
  style = style_get(temp_colors, "user");
  strcpy(str, "> ");
  gtk_text_insert(GTK_TEXT(temp), style->font, 
		  style->fore, style->back, 
		  str, strlen(str));
  style = style_get(temp_colors, "text");

  style = style_get(temp_colors, "text");
  strcpy(str, "This is a message with ");
  gtk_text_insert(GTK_TEXT(temp), style->font, 
		  style->fore, style->back, 
		  str, strlen(str));
  style = style_get(temp_colors, "highlight");
  strcpy(str, "highlighted text\n");
  gtk_text_insert(GTK_TEXT(temp), style->font, 
		  style->fore, style->back, 
		  str, strlen(str));
  style = style_get(temp_colors, "message");
  strcpy(str, "This is a internal client message.\n");
  gtk_text_insert(GTK_TEXT(temp), style->font, 
		  style->fore, style->back, 
		  str, strlen(str));
  
}

void
on_combo_entry15_changed               (GtkEditable     *editable,
                                        gpointer         user_data)
{
  GtkWidget* win;
  GtkWidget* temp;
  GtkWidget* temp2;
  GList* temp_colors = NULL;
  char* text;

  win = global.options_win;
  temp = lookup_widget(win, "combo_entry15");
  
  text = gtk_entry_get_text(GTK_ENTRY(temp));

  temp = lookup_widget(global.options_win, "button98");
  temp2 = lookup_widget(global.options_win, "button99");
  if (scheme_is_valid(text)) {
    //    temp_colors = gtk_object_get_data(GTK_OBJECT(win), "temp_colors");
    temp_colors = scheme_load(temp_colors, text);
    gtk_object_set_data_full(GTK_OBJECT(win), "temp_colors", temp_colors,
			     (GtkDestroyNotify)destroy_temp_colors);
    draw_temps(temp_colors);
    gtk_widget_set_sensitive(temp, TRUE);
    gtk_widget_set_sensitive(temp2, TRUE);
  } else {
    gtk_widget_set_sensitive(temp, FALSE);
    gtk_widget_set_sensitive(temp2, FALSE);
  }
}

void
on_button87_clicked                    (GtkButton       *button,
                                        gpointer         user_data) {
}

void
on_button88_clicked                    (GtkButton       *button,
                                        gpointer         user_data) {
}

void
on_resume_download_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data) {
}

void
on_resume_files_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data) {
}

void
on_button102_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* temp;

  if (global.server_win == NULL) {
    global.server_win = create_server_win();
    gtk_widget_show(global.server_win);
    temp = lookup_widget(global.server_win, "server_list");
    gtk_clist_set_sort_column(GTK_CLIST(temp), 0);
    gtk_clist_set_auto_sort(GTK_CLIST(temp), TRUE);
    gtk_clist_set_compare_func(GTK_CLIST(temp), server_compare);
    temp = lookup_widget(global.server_win, "button104");
    on_button104_clicked(GTK_BUTTON(temp), NULL);
  } else {
    if (!GTK_WIDGET_VISIBLE(global.server_win)) {
      gtk_widget_show(global.server_win);
    }
  }

}


void
on_options_win_destroy                 (GtkObject       *object,
                                        gpointer         user_data)
{
  gtk_widget_hide(global.options_win);
  gtk_widget_destroy(global.options_win);
  global.options_win = NULL;
}


void
on_fileselection1_destroy              (GtkObject       *object,
                                        gpointer         user_data)
{

}


void
on_resume_win_destroy                  (GtkObject       *object,
                                        gpointer         user_data)
{
  gtk_widget_hide(global.resume_win);
  gtk_widget_destroy(global.resume_win);
  global.resume_win = NULL;
  
}


void
on_ban_win_destroy                     (GtkObject       *object,
                                        gpointer         user_data)
{
  gtk_widget_hide(global.ban_win);
  gtk_widget_destroy(global.ban_win);
  global.ban_win = NULL;

}


void
on_server_win_destroy                  (GtkObject       *object,
                                        gpointer         user_data)
{
  gtk_widget_hide(global.server_win);
  gtk_widget_destroy(global.server_win);
  global.server_win = NULL;
}


void
on_button103_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkCList* clist;
  GList* row_list;
  int row;
  char* text;
  address_t* server;

  clist = GTK_CLIST(lookup_widget(global.server_win, "server_list"));
  row_list = clist->selection;

  while (row_list) {
    row = (int)row_list->data;
    server = (address_t*)malloc(sizeof(address_t));

    gtk_clist_get_text(clist, row, 1, &text);
    server->ip = strdup(text);
    server->ip_long = inet_addr(server->ip);

    gtk_clist_get_text(clist, row, 2, &text);
    server->port = atoi(text);

    gtk_clist_get_text(clist, row, 0, &text);
    server->description = strdup(text);
    
    server->no_connected = 0;
    if (add_server_to_list(server) == 0) {
      free(server);
    }
    row_list = row_list->next;
    
  }
  

}


void
on_button104_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* temp;

  temp = lookup_widget(GTK_WIDGET(button), "server_list");
  gtk_clist_clear(GTK_CLIST(temp));
  
  temp = lookup_widget(GTK_WIDGET(button), "button104");
  gtk_widget_set_sensitive(temp, FALSE);

  napigator_get_list();
}


void
on_button105_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_hide(global.server_win);
}

int hex_to_int(char ch) {
  if ((ch <= '9') && (ch >= '0')) 
    return ch-'0';
  else if ((ch <= 'f') && (ch >= 'a'))
    return ch-'a'+10;
  else if ((ch <= 'F') && (ch >= 'A'))
    return ch-'A'+10;
  else return 0;
}

void convert_color(char* text, gdouble* color) {
  int temp;

  temp = hex_to_int(text[1])*16 + hex_to_int(text[2]);
  color[0] = (gdouble)temp/255.0;
  temp = hex_to_int(text[3])*16 + hex_to_int(text[4]);
  color[1] = (gdouble)temp/255.0;
  temp = hex_to_int(text[5])*16 + hex_to_int(text[6]);
  color[2] = (gdouble)temp/255.0;
}

void
on_button94_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* win;
  GtkWidget* colorsel;
  GtkWidget* temp;
  gdouble color[3];
  char* text;
  GList* temp_colors;
  style_t* style;

  win = create_colorselectiondialog1();
  gtk_object_set_data_full(GTK_OBJECT(win),
			   "foreground", (gpointer)1, NULL);

  temp = lookup_widget(win, "NULL_button2");
  temp = GTK_BIN(temp)->child;
  gtk_label_set_text(GTK_LABEL(temp), "Reset");
  temp = lookup_widget(win, "cancel_button2");
  temp = GTK_BIN(temp)->child;
  gtk_label_set_text(GTK_LABEL(temp), "Cancel");

  // setting up current color
  colorsel = GTK_COLOR_SELECTION_DIALOG(win)->colorsel;

  temp = lookup_widget(global.options_win, "combo_entry13");
  text = strdup(gtk_entry_get_text(GTK_ENTRY(temp)));

  temp_colors = 
    gtk_object_get_data(GTK_OBJECT(global.options_win), "temp_colors");
  if (temp_colors == NULL) {
    g_warning("no temp colors found");
    return;
  }
  style = style_search(temp_colors, text);
  if (!style) {
    g_warning("style not found");
    return;
  }
  convert_color(style->n_fore, color);
  
  gtk_color_selection_set_color(GTK_COLOR_SELECTION(colorsel), color);

  gtk_widget_show(win);
}


void
on_button106_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* win;
  GtkWidget* colorsel;
  GtkWidget* temp;
  gdouble color[3];
  char* text;
  GList* temp_colors;
  style_t* style;

  win = create_colorselectiondialog1();
  gtk_object_set_data_full(GTK_OBJECT(win),
			   "foreground", (gpointer)2, NULL);

  temp = lookup_widget(win, "NULL_button2");
  temp = GTK_BIN(temp)->child;
  gtk_label_set_text(GTK_LABEL(temp), "Reset");
  temp = lookup_widget(win, "cancel_button2");
  temp = GTK_BIN(temp)->child;
  gtk_label_set_text(GTK_LABEL(temp), "Cancel");

  // setting up current color
  colorsel = GTK_COLOR_SELECTION_DIALOG(win)->colorsel;

  temp = lookup_widget(global.options_win, "combo_entry13");
  text = strdup(gtk_entry_get_text(GTK_ENTRY(temp)));

  temp_colors = 
    gtk_object_get_data(GTK_OBJECT(global.options_win), "temp_colors");
  if (temp_colors == NULL) {
    g_warning("no temp colors found");
    return;
  }
  style = style_search(temp_colors, text);
  if (!style) {
    g_warning("style not found");
    return;
  }
  convert_color(style->n_back, color);
  
  gtk_color_selection_set_color(GTK_COLOR_SELECTION(colorsel), color);

  gtk_widget_show(win);
}


void
on_button107_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* win;
  GtkWidget* fontsel;
  GtkWidget* temp;
  char* text;
  GList* temp_colors;
  style_t* style;
  
  win = create_fontselectiondialog1();

  temp = lookup_widget(win, "NULL_button1");
  temp = GTK_BIN(temp)->child;
  gtk_label_set_text(GTK_LABEL(temp), "Reset");
  
  temp = lookup_widget(win, "cancel_button3");
  temp = GTK_BIN(temp)->child;
  gtk_label_set_text(GTK_LABEL(temp), "Cancel");
  
  // setting up font
  fontsel = GTK_FONT_SELECTION_DIALOG(win)->fontsel;
  temp = lookup_widget(global.options_win, "combo_entry13");
  text = strdup(gtk_entry_get_text(GTK_ENTRY(temp)));

  temp_colors = 
    gtk_object_get_data(GTK_OBJECT(global.options_win), "temp_colors");
  if (temp_colors == NULL) {
    g_warning("no temp colors found");
    return;
  }
  style = style_search(temp_colors, text);
  if (!style) {
    g_warning("style not found");
    return;
  }
  
  gtk_font_selection_set_font_name(GTK_FONT_SELECTION(fontsel), style->n_font);

  gtk_widget_show(win);
}


void
on_colorselectiondialog1_destroy       (GtkObject       *object,
                                        gpointer         user_data)
{
  GtkWidget* temp;
  temp = GTK_WIDGET(object);
  gtk_widget_destroy(temp);
}


void
on_fontselectiondialog1_destroy        (GtkObject       *object,
                                        gpointer         user_data)
{
  GtkWidget* temp;
  temp = GTK_WIDGET(object);
  gtk_widget_destroy(temp);

}


void
on_cancel_button3_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* temp;
  temp = lookup_widget(GTK_WIDGET(button), "fontselectiondialog1");
  gtk_widget_destroy(temp);

}


void set_color(gdouble* color, int fore) {
  GtkWidget* temp;
  char* text;
  GList* temp_colors;
  char color_str[20];
  char hex[17] = "0123456789abcdef";
  int int_val;

  temp = lookup_widget(global.options_win, "combo_entry13");
  text = gtk_entry_get_text(GTK_ENTRY(temp));

  temp_colors = 
    gtk_object_get_data(GTK_OBJECT(global.options_win), "temp_colors");
  if (temp_colors == NULL) {
    g_warning("no temp colors found");
    return;
  }

  if (color == NULL) {
    if (fore)
      temp_colors = 
	style_new(temp_colors, text, "NULL", NULL, NULL, 1);
    else
      temp_colors = 
	style_new(temp_colors, text, NULL, "NULL", NULL, 1);
    
    draw_temps(temp_colors);
    return;
  }

  color_str[0] = '#';
  int_val = (int)(color[0]*255);
  color_str[1] = hex[int_val/16];
  color_str[2] = hex[int_val%16];
  int_val = (int)(color[1]*255);
  color_str[3] = hex[int_val/16];
  color_str[4] = hex[int_val%16];
  int_val = (int)(color[2]*255);
  color_str[5] = hex[int_val/16];
  color_str[6] = hex[int_val%16];
  color_str[7] = 0;
  if (fore)
    temp_colors = 
      style_new(temp_colors, text, color_str, NULL, NULL, 1);
  else
    temp_colors = 
      style_new(temp_colors, text, NULL, color_str, NULL, 1);

  draw_temps(temp_colors);
}

void
on_ok_button2_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* colorsel;
  GtkWidget* temp;
  static gdouble color[3];
  gpointer* pointer;

  // setting fore or background
  temp = lookup_widget(GTK_WIDGET(button), "colorselectiondialog1");
  colorsel = GTK_COLOR_SELECTION_DIALOG(temp)->colorsel;
  pointer = gtk_object_get_data(GTK_OBJECT(temp), "foreground");
  if (pointer == NULL) {
    g_warning("shit color");
    return;
  }

  gtk_color_selection_get_color(GTK_COLOR_SELECTION(colorsel), color);

  gtk_widget_destroy(temp);
  
  switch ((int)pointer) {
  case 1:
    set_color(color, 1);
    break;
  case 2:
    set_color(color, 0);
    break;
  default:
    g_warning("unknwon data");
    break;
  }
}


void
on_button100_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* temp;
  char* text;
  GList* temp_colors;

  temp = lookup_widget(global.options_win, "combo_entry15");
  
  temp_colors = 
    gtk_object_get_data(GTK_OBJECT(global.options_win), "temp_colors");
  if (temp_colors == NULL) {
    g_warning("no temp colors found!");
    return;
  }

  text = strdup(gtk_entry_get_text(GTK_ENTRY(temp)));
  scheme_save(temp_colors, text);
}

void set_font(char* font) {
  GtkWidget* temp;
  char* text;
  GList* temp_colors;

  temp = lookup_widget(global.options_win, "combo_entry13");
  text = gtk_entry_get_text(GTK_ENTRY(temp));

  temp_colors = 
    gtk_object_get_data(GTK_OBJECT(global.options_win), "temp_colors");
  if (temp_colors == NULL) {
    g_warning("no temp colors found");
    return;
  }

  if (font) temp_colors = style_new(temp_colors, text, NULL, NULL, font, 1);
  else temp_colors = style_new(temp_colors, text, NULL, NULL, "NULL", 1);

  draw_temps(temp_colors);
}


void
on_ok_button3_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* temp;
  GtkWidget* fontsel;
  char* font;

  temp = lookup_widget(GTK_WIDGET(button), "fontselectiondialog1");
  fontsel = GTK_FONT_SELECTION_DIALOG(temp)->fontsel;

  if (gtk_font_selection_get_font_name(GTK_FONT_SELECTION(fontsel))) {
    font = strdup(gtk_font_selection_get_font_name(GTK_FONT_SELECTION(fontsel)));
    set_font(font);
  }
  gtk_widget_destroy(temp);
}

void
on_user_win_destroy                    (GtkObject       *object,
                                        gpointer         user_data)
{
  gtk_widget_hide(global.user_win);
  gtk_widget_destroy(global.user_win);
  global.user_win = NULL;
}



void
on_button111_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* temp;
  char* text;

  temp = lookup_widget(GTK_WIDGET(button), "clist4");
  gtk_clist_clear(GTK_CLIST(temp));

  temp = lookup_widget(GTK_WIDGET(button), "button111");
  gtk_widget_set_sensitive(temp, FALSE);

  temp = lookup_widget(GTK_WIDGET(button), "entry43");
  text = gtk_entry_get_text(GTK_ENTRY(temp));

  send_command(830, text);
}


void
on_button112_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_hide(global.user_win);
  gtk_widget_destroy(global.user_win);
  global.user_win = NULL;
}


void
on_button114_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  toggle_button_state(GTK_WIDGET(button));
}


void
on_entry45_activate                    (GtkEditable     *editable,
                                        gpointer         user_data)
{
  on_button122_clicked(NULL, NULL);
}


void
on_entry46_activate                    (GtkEditable     *editable,
                                        gpointer         user_data)
{
  on_button123_clicked(NULL, NULL);
}


void
on_checkbutton7_toggled                (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  GtkWidget* temp;

  temp = lookup_widget(global.win, "checkbutton7");
  global.show_joins = 
    gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp));

  if (global.options_win) {
    temp = lookup_widget(global.options_win, "checkbutton11");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), global.show_joins);
  }

}


void
on_button115_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  toggle_button_state(GTK_WIDGET(button));
}


void
on_button116_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* temp;

  if (!toggle_button_state(GTK_WIDGET(button))) {
    temp = lookup_widget(global.win, "button118");
    set_button_state(temp, 1);
  }
}


// next tow for seach in hotlist
void
on_button117_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkCList* clist;
  GtkWidget* temp;
  char* text;

  clist = GTK_CLIST(lookup_widget(global.win, "clist5"));
  
  gtk_clist_clear(clist);
  temp = lookup_widget(global.win, "entry48");

  text = strdup(gtk_entry_get_text(GTK_ENTRY(temp)));

  hotlist_search(text);
  
  free(text);
}


void
on_entry48_activate                    (GtkEditable     *editable,
                                        gpointer         user_data)
{
  on_button117_clicked(NULL, NULL);
}


void
on_button118_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* temp;

  if (!toggle_button_state(GTK_WIDGET(button))) {
    temp = lookup_widget(global.win, "button116");
    set_button_state(temp, 1);
  }
}


void
on_button119_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  toggle_button_state(GTK_WIDGET(button));
}


void
on_spinbutton5_changed                 (GtkEditable     *editable,
                                        gpointer         user_data)
{
  GtkWidget* temp;

  temp = GTK_WIDGET(editable);
  global.network.max_downloads = 
    gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(temp));

  if (global.options_win) {
    temp = lookup_widget(global.options_win, "spinbutton1");
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp),
			      global.network.max_downloads);
  }
}


void
on_spinbutton6_changed                 (GtkEditable     *editable,
                                        gpointer         user_data)
{
  GtkWidget* temp;

  temp = GTK_WIDGET(editable);
  global.network.max_uploads = 
    gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(temp));
  if (global.options_win) {
    temp = lookup_widget(global.options_win, "spinbutton3");
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp),
			      global.network.max_uploads);
  }
}

void
on_spinbutton8_changed                 (GtkEditable     *editable,
                                        gpointer         user_data)
{
  GtkWidget* temp;

  temp = GTK_WIDGET(editable);
  global.network.max_transfers = 
    gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(temp));
  if (global.options_win) {
    temp = lookup_widget(global.options_win, "spinbutton7");
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp),
			      global.network.max_transfers);
  }
}

void
on_button120_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  lib_refresh();
}


void
on_button98_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* temp;
  char* text;
  GList* temp_colors = NULL;

  temp = lookup_widget(global.options_win, "combo_entry15");
  
  text = strdup(gtk_entry_get_text(GTK_ENTRY(temp)));
  if (scheme_is_valid(text)) {
    temp_colors = scheme_load(temp_colors, text);
    gtk_object_set_data_full(GTK_OBJECT(global.options_win),
			     "temp_colors", temp_colors,
			     (GtkDestroyNotify)destroy_temp_colors);
    draw_temps(temp_colors);
  }
}


void
on_button99_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* temp;
  char* text;

  temp = lookup_widget(global.options_win, "combo_entry15");
  text = strdup(gtk_entry_get_text(GTK_ENTRY(temp)));
  scheme_delete(text);
  free(text);
}


void
on_button122_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  char* pos;
  GtkEntry* temp;
  GtkWidget* temp2;

  temp = GTK_ENTRY(lookup_widget(global.win, "entry45"));
  pos = strdup(gtk_entry_get_text(temp));
  make_list_from_string(&global.highlight, pos, "\"");
  free(pos);
  pos = make_string_from_list(global.highlight, "\"");
  gtk_entry_set_text(temp, pos);
  if (global.options_win) {
    temp = GTK_ENTRY(lookup_widget(global.options_win, "entry42"));
    gtk_entry_set_text(temp, pos);
  }
  temp2 = lookup_widget(global.win, "button122");
  gtk_widget_set_sensitive(temp2, FALSE);
}

void
on_button123_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  char* pos;
  GtkEntry* temp;
  GtkWidget* temp2;

  temp = GTK_ENTRY(lookup_widget(global.win, "entry46"));
  pos = strdup(gtk_entry_get_text(temp));
  delete_user_list(&global.frienduser);
  make_list_from_string(&global.frienduser, pos, " ");
  update_users(global.frienduser);
  free(pos);
  pos = make_string_from_list(global.frienduser, " ");
  gtk_entry_set_text(temp, pos);
  if (global.options_win) {
    temp = GTK_ENTRY(lookup_widget(global.options_win, "entry44"));
    gtk_entry_set_text(temp, pos);
  }
  temp2 = lookup_widget(global.win, "button123");
  gtk_widget_set_sensitive(temp2, FALSE);

}


void
on_checkbutton9_toggled                (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  GtkWidget* temp;
  char* text;
  char str[1024];
  char str2[1024];
  time_t tim;
  
  time(&tim);

  temp = lookup_widget(global.win, "entry50");
  if (gtk_toggle_button_get_active(togglebutton)) {
    temp = lookup_widget(global.win, "button125");
    gtk_widget_set_sensitive(temp, FALSE);
    temp = lookup_widget(global.win, "entry50");
    gtk_widget_set_sensitive(temp, TRUE);
    text = gtk_entry_get_text(GTK_ENTRY(temp));

    sprintf(str2, ctime(&tim));
    str2[strlen(str2)-1] = 0;
    sprintf(str, "%s [%s]", text, str2);
    global.afk = strdup(str);
  } else {
    temp = lookup_widget(global.win, "entry50");
    gtk_widget_set_sensitive(temp, FALSE);
    temp = lookup_widget(global.win, "button125");
    gtk_widget_set_sensitive(temp, FALSE);
    if (global.afk) {
      free(global.afk);
      global.afk = NULL;
    }
  }

}


void
on_checkbutton10_toggled               (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  GtkWidget* temp;

  temp = lookup_widget(global.win, "checkbutton10");
  global.ignore_public_ignore = 
    gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp));
  if (global.options_win) {
    temp = lookup_widget(global.options_win, "checkbutton12");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), 
				 global.ignore_public_ignore);
  }
}


void
on_entry50_changed                     (GtkEditable     *editable,
                                        gpointer         user_data)
{
  GtkWidget* temp;
  
  temp = lookup_widget(global.win, "button125");
  gtk_widget_set_sensitive(temp, TRUE);
}


void
on_play_file2_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkCList* list;
  file_t* file;

  list = GTK_CLIST(global.popup_list);
  
  file = (file_t*)gtk_clist_get_row_data(list, global.popup_row);
  
  if (file) {
    play_file(file->longname);
  }
  
}


void
on_play_file_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkCList* list;
  transfer_t* transfer;

  list = GTK_CLIST(global.popup_list);
  
  transfer = (transfer_t*)gtk_clist_get_row_data(list, global.popup_row);
  
  if (transfer) {
    play_file(transfer->localname);
  }
}


void
on_cancel_button2_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* temp;
  temp = lookup_widget(GTK_WIDGET(button), "colorselectiondialog1");
  gtk_widget_destroy(temp);
}

void
on_NULL_button2_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* temp;
  gpointer* pointer;

  // setting fore or background
  temp = lookup_widget(GTK_WIDGET(button), "colorselectiondialog1");
  pointer = gtk_object_get_data(GTK_OBJECT(temp), "foreground");
  if (pointer == NULL) {
    g_warning("shit color");
    return;
  }

  // color = NULL
  gtk_widget_destroy(temp);
  
  switch ((int)pointer) {
  case 1:
    set_color(NULL, 1);
    break;
  case 2:
    set_color(NULL, 0);
    break;
  default:
    g_warning("unknwon data");
    break;
  }

}


void
on_NULL_button1_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* temp;

  temp = lookup_widget(GTK_WIDGET(button), "fontselectiondialog1");
  set_font(NULL);

  gtk_widget_destroy(temp);

}


void
on_button124_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  char* pos;
  GtkEntry* temp;
  GtkWidget* temp2;

  temp = GTK_ENTRY(lookup_widget(global.win, "entry51"));
  pos = strdup(gtk_entry_get_text(temp));
  delete_user_list(&global.enemyuser);
  make_list_from_string(&global.enemyuser, pos, " ");
  update_users(global.enemyuser);
  free(pos);
  pos = make_string_from_list(global.enemyuser, " ");
  gtk_entry_set_text(temp, pos);

  if (global.options_win) {
    temp = GTK_ENTRY(lookup_widget(global.options_win, "entry52"));
    gtk_entry_set_text(temp, pos);
  }

  temp2 = lookup_widget(global.win, "button124");
  gtk_widget_set_sensitive(temp2, FALSE);
}


void
on_button125_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  char* text;
  GtkWidget* temp;

  temp = lookup_widget(global.win, "button125");
  if (!GTK_WIDGET_IS_SENSITIVE(temp)) {
    return;
  }
  temp = lookup_widget(global.win, "entry50");
  text = strdup(gtk_entry_get_text(GTK_ENTRY(temp)));
  set_afk(text);
  free(text);
}


void
on_entry51_activate                    (GtkEditable     *editable,
                                        gpointer         user_data)
{
  on_button124_clicked(NULL, NULL);
}


void
on_entry50_activate                    (GtkEditable     *editable,
                                        gpointer         user_data)
{
  on_button125_clicked(NULL, NULL);
}


gboolean
on_entry49_key_press_event             (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{
  on_entry46_key_press_event(widget, event, user_data);
  return 1;
}



void
on_entry45_changed                     (GtkEditable     *editable,
                                        gpointer         user_data)
{
  GtkWidget* temp;
  
  temp = lookup_widget(global.win, "button122");
  gtk_widget_set_sensitive(temp, TRUE);
}


void
on_entry46_changed                     (GtkEditable     *editable,
                                        gpointer         user_data)
{
  GtkWidget* temp;
  
  temp = lookup_widget(global.win, "button123");
  gtk_widget_set_sensitive(temp, TRUE);
}


void
on_entry51_changed                     (GtkEditable     *editable,
                                        gpointer         user_data)
{
  GtkWidget* temp;
  
  temp = lookup_widget(global.win, "button124");
  gtk_widget_set_sensitive(temp, TRUE);
}


gboolean
on_entry46_key_press_event             (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{
  GtkEntry* entry;
  char* text;
  char* text2;
  char t[1024];
  GList* c_list;
  int i1;
  static int cnt = 0;

  if (is_string_in_list(global.private_users, global.current_room)) return FALSE;

  //  printf("key: [%d][%d]\n", event->keyval, event->state);
  if ((event->type == GDK_KEY_PRESS) && (event->keyval == 65289)) {     // tab
    entry = GTK_ENTRY(widget);
    gtk_signal_emit_stop_by_name(GTK_OBJECT(widget), "key_press_event");
    text = strdup(gtk_entry_get_text(entry));

    if (strlen(text) <= 0) return TRUE;
    text2 = strrchr(text, ' ');
    if (text2) text2++;
    else text2 = text;
    c_list = user_search(text2);
	
    switch (g_list_length(c_list)) {
    case 0:
      //	  client_message("error", "no fitting user found");
      gdk_beep();
      break;
    case 1:
      text2[0] = 0;
      strcpy(t, text);
      strcat(t, c_list->data);
      gtk_entry_set_text(entry, t);
      break;
    default:
      gdk_beep();
      cnt++;
      i1 = calc_list_prefix(c_list);
      text2[0] = 0;
      strcpy(t, text);
      strncat(t, c_list->data, i1);
      gtk_entry_set_text(entry, t);
      
      if (cnt > 1) {
	strcpy(t, "******** Available Users:\n");
	for (i1 = 0; i1 < g_list_length(c_list); i1++) {
	  if (i1 > 0) strcat(t, ", ");
	  strcat(t, g_list_nth(c_list, i1)->data);
	}
	chat_print("message", "%s\n", t);
	cnt = 0;
      }
      break;
    }
  }

  return 1;
}


gboolean
on_entry51_key_press_event             (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{
  on_entry46_key_press_event(widget, event, user_data);
  return 1;
}


void
on_button126_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* temp;
  int i1;
  
  temp = lookup_widget(global.win, "button126");
  gtk_widget_set_sensitive(temp, FALSE);

  global.status.searching = 0;

  temp = lookup_widget(global.win, "search_list");
  i1 = GTK_CLIST(temp)->rows;
  temp = lookup_widget(global.win, "search_entry");
  sprintf(tstr[0], "%d songs matched....aborted...", i1);
  gtk_entry_set_text(GTK_ENTRY(temp), tstr[0]);
}


void
on_delete_file_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkCList* clist;
  file_t* file;

  if (global.popup_row == -1) return;

  clist = GTK_CLIST(global.popup_list);
  
  file = (file_t*)gtk_clist_get_row_data(clist, global.popup_row);
  file->flags &= (0xff^FLAG_IN_LIB);
  file->flags |= FLAG_DELETE;

  lib_commit();
}

void
on_private_mode_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkCList* list;
  char *text;
  GdkPixmap *pixmap = NULL;
  GdkBitmap *bitmap = NULL;
  guint8 space;

  list = GTK_CLIST(global.popup_list);
  gtk_clist_get_pixtext (list, global.popup_row, 0,
			 &text, &space,
			 &pixmap, &bitmap);

  if (is_string_in_list(global.private_users, text)) {
    client_message("message", "User is already in private list");
    return;
  }

  global.private_users = 
    g_list_append(global.private_users, strdup(text));

  create_private_page(text);
}


void
on_checkbutton14_toggled               (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  GtkWidget* temp;

  temp = lookup_widget(global.win, "checkbutton14");
  global.send_ignore = 
    gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp));

  if (global.options_win) {
    temp = lookup_widget(global.options_win, "checkbutton15");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), global.send_ignore);
  }
}


void
on_button127_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* temp;
  char* text;
  int row;

  temp = lookup_widget(global.options_win, "combo_entry16");
  text = gtk_entry_get_text(GTK_ENTRY(temp));

  if (strlen(text) <= 0) return;
  strcpy(tstr[0], text);
  gtk_entry_set_text(GTK_ENTRY(temp), "");

  temp = lookup_widget(global.options_win, "clist6");
  row = gtk_clist_append(GTK_CLIST(temp), list);
}


void
on_button128_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkCList* list;
  GList* row_list;
  int row;

  list = GTK_CLIST(lookup_widget(GTK_WIDGET(button), "clist6"));

  while ((row_list = list->selection) != NULL) {
    row = (int)row_list->data;
    gtk_clist_remove(list, row);
  }
}


void
on_button129_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  on_hidden1_activate(NULL, NULL);
}


void
on_button131_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* temp1;
  GtkWidget* temp2;
  char* user;
  char* text;
  int len;

  temp1 = lookup_widget(global.win, "entry55");
  temp2 = lookup_widget(global.win, "text12");

  len = gtk_text_get_length(GTK_TEXT(temp2));
  text = (char*)malloc(sizeof(char)*len+1);
  strncpy(text, GTK_TEXT(temp2)->text.ch, len);
  text[len] = 0;

  user = gtk_entry_get_text(GTK_ENTRY(temp1));

  if (add_mail(user, text)) {
    //    gtk_entry_set_text(GTK_ENTRY(temp1), "");
    gtk_text_set_point(GTK_TEXT(temp2), 0);
    gtk_text_forward_delete(GTK_TEXT(temp2),
			    gtk_text_get_length(GTK_TEXT(temp2)));
  }

  free(text);
}


void
on_button132_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkCList* list;
  GList* row_list;
  int row;

  list = GTK_CLIST(lookup_widget(GTK_WIDGET(button), "clist7"));

  while ((row_list = list->selection) != NULL) {
    row = (int)row_list->data;
    gtk_clist_remove(list, row);
  }
}


void
on_button130_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  toggle_button_state(GTK_WIDGET(button));
}

void
on_button133_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkCList* list;
  int i1;
  transfer_t* transfer;

  list = GTK_CLIST(lookup_widget(global.win, "transfer_down"));
  i1 = 0;
  while (1) {
    if (i1 >= list->rows) break;
    transfer = (transfer_t*)gtk_clist_get_row_data(list, i1);
    if ((transfer->status != S_WAITING) &&
	(transfer->status != S_CONNECTING) &&
	(transfer->status != S_INFO) &&
	(transfer->status != S_INFO1) &&
	(transfer->status != S_INFO2) &&
	(transfer->status != S_INFO3) &&
	(transfer->status != S_QUEUED) &&
	(transfer->status != S_DOWNLOADING)) {
      gtk_clist_remove(list, i1);
    } else {
      i1++;
    }
  }
  list = GTK_CLIST(lookup_widget(global.win, "transfer_up"));
  i1 = 0;
  while (1) {
    if (i1 >= list->rows) break;
    transfer = (transfer_t*)gtk_clist_get_row_data(list, i1);
    if ((transfer->status != S_WAITING) &&
	(transfer->status != S_CONNECTING) &&
	(transfer->status != S_INFO) &&
	(transfer->status != S_INFO1) &&
	(transfer->status != S_INFO2) &&
	(transfer->status != S_INFO3) &&
	(transfer->status != S_UPLOADING)) {
      gtk_clist_remove(list, i1);
    } else {
      i1++;
    }
  }
}


void
on_hot_tree_tree_select_row            (GtkCTree        *ctree,
                                        GtkCTreeNode    *node,
                                        gint             column,
                                        gpointer         user_data)
{
  char *text;
  GdkPixmap *pixmap = NULL;
  GdkBitmap *bitmap = NULL;
  guint8 space;
  hot_t* data;
  GtkWidget* temp;
  char str[1024];

  gtk_ctree_node_get_pixtext (ctree, node, 0, &text, &space,
			      &pixmap, &bitmap);
    
  if ((pixmap != global.pix.user1) &&
      (pixmap != global.pix.user2) &&
      (pixmap != global.pix.dummy)) return;
  
  data = gtk_ctree_node_get_row_data(ctree, node);
  temp = lookup_widget(global.win, "label221");
  gtk_label_set_text(GTK_LABEL(temp), text);
  temp = lookup_widget(global.win, "label223");
  sprintf(str, "%d", data->files);
  gtk_label_set_text(GTK_LABEL(temp), str);
  temp = lookup_widget(global.win, "label225");
  sprintf(str, "%lu", data->bytes/1024/1024);
  gtk_label_set_text(GTK_LABEL(temp), str);
}


void
on_friend1_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkCList* list;
  char *text;
  char t[500];
  char t2[1024];
  GdkPixmap *pixmap = NULL;
  GdkBitmap *bitmap = NULL;
  guint8 space;
  GtkWidget* temp;

  list = GTK_CLIST(global.popup_list);
  
  gtk_clist_get_pixtext (list, global.popup_row, 0,
			 &text, &space,
			 &pixmap, &bitmap);
  strcpy(t, text);

  if ((text=is_string_in_list(global.frienduser, t)) == NULL) {
    global.frienduser = g_list_append(global.frienduser, strdup(t));
    sprintf(t2, "is now a friend to %s", t);
  } else {
    global.frienduser = g_list_remove(global.frienduser, text);
    sprintf(t2, "is no longer a friend to %s", t);
  }
  if (global.send_ignore) send_emote(t2);
  update_user(t);

  temp = lookup_widget(global.win, "entry46");
  text = make_string_from_list(global.frienduser, " ");
  gtk_entry_set_text(GTK_ENTRY(temp), text);
  if (global.options_win) {
    temp = lookup_widget(global.options_win, "entry44");
    gtk_entry_set_text(GTK_ENTRY(temp), text);
  }
  temp = lookup_widget(global.win, "button123");
  gtk_widget_set_sensitive(temp, FALSE);
}


void
on_enemy1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkCList* list;
  char *text;
  char t[500];
  char t2[1024];
  GdkPixmap *pixmap = NULL;
  GdkBitmap *bitmap = NULL;
  guint8 space;
  GtkWidget* temp;

  list = GTK_CLIST(global.popup_list);
  
  gtk_clist_get_pixtext (list, global.popup_row, 0,
			 &text, &space,
			 &pixmap, &bitmap);
  strcpy(t, text);

  if ((text=is_string_in_list(global.enemyuser, t)) == NULL) {
    global.enemyuser = g_list_append(global.enemyuser, strdup(t));
    sprintf(t2, "has a new enemy: %s", t);
  } else {
    global.enemyuser = g_list_remove(global.enemyuser, text);
    sprintf(t2, "is no longer an enemy to %s", t);
  }
  if (global.send_ignore) send_emote(t2);
  update_user(t);

  temp = lookup_widget(global.win, "entry51");
  text = make_string_from_list(global.enemyuser, " ");
  gtk_entry_set_text(GTK_ENTRY(temp), text);
  if (global.options_win) {
    temp = lookup_widget(global.options_win, "entry52");
    gtk_entry_set_text(GTK_ENTRY(temp), text);
  }
  temp = lookup_widget(global.win, "button124");
  gtk_widget_set_sensitive(temp, FALSE);
}


void rec_save (GtkCTree *ctree, GtkCTreeNode *node,
	       char* data) {
  file_t* file;
  FILE* fd = (FILE*)data;

  if (!GTK_CTREE_ROW (node)->is_leaf) return;

  file = gtk_ctree_node_get_row_data(ctree, node);
  fprintf(fd, "\"%s\" %s %ld %d %d %d\n", 
	  file->longname, file->md5, file->size,
	  file->bitrate, file->frequency, file->length);
}

void
on_button134_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  char filename[1024];
  FILE* fd;
  GtkCTree* ctree;

  sprintf(filename, "%s/shared", global.lopster_home);

  if ((fd = fopen(filename, "w")) == NULL) {
    g_warning("could not save shared files");
    return;
  }
  ctree = GTK_CTREE(lookup_widget(global.win, "lib_tree"));
  gtk_ctree_post_recursive(ctree, NULL, (GtkCTreeFunc)rec_save, fd);
  fclose(fd);
}


gboolean
on_entry55_key_press_event             (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{
  on_entry46_key_press_event(widget, event, user_data);
  return FALSE;
}


void
on_remove_subtree1_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkCTree* ctree;
  GtkCTreeNode* node;

  if (global.popup_row == -1) return;

  ctree = GTK_CTREE(global.popup_list);
  
  node = gtk_ctree_node_nth(ctree, global.popup_row);
  lib_del_flag(FLAG_IN_LIB, node);

  lib_commit();
}


void
on_delete_subtree1_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkCTree* ctree;
  GtkCTreeNode* node;

  if (global.popup_row == -1) return;

  ctree = GTK_CTREE(global.popup_list);
  
  node = gtk_ctree_node_nth(ctree, global.popup_row);
  lib_del_flag(FLAG_IN_LIB, node);
  lib_set_flag(FLAG_DELETE, node);

  lib_commit();
}


gboolean
on_lib_tree_button_press_event         (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  GtkWidget* pop;
  int row, column;
  char *text;
  GdkPixmap *pixmap = NULL;
  GdkBitmap *bitmap = NULL;
  guint8 space;

  if (event->button == 3) {
    if (!gtk_clist_get_selection_info(GTK_CLIST(widget),
				      (int)event->x, (int)event->y,
				      &row, &column))
      row = -1;
    
    global.popup_row = row;
    global.popup_list = widget;

    gtk_clist_get_pixtext (GTK_CLIST(widget), row, 0,
			   &text, &space,
			   &pixmap, &bitmap);
    
    if (pixmap == NULL) {
      pop = create_lib_popup2();
      gtk_clist_select_row (GTK_CLIST(widget), row, 0);
    } else {
      pop = create_lib_popup1();
      gtk_clist_select_row (GTK_CLIST(widget), row, 0);
    }  
    gtk_menu_popup(GTK_MENU(pop), NULL, NULL, 
		   NULL, NULL, 1, 10);
  }
  return FALSE;
}


void
on_remove_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkCList* clist;
  file_t* file;

  if (global.popup_row == -1) return;

  clist = GTK_CLIST(global.popup_list);
  
  file = (file_t*)gtk_clist_get_row_data(clist, global.popup_row);
  file->flags &= (0xff^FLAG_IN_LIB);

  lib_commit();
}


gboolean
on_clist5_button_press_event           (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  GtkWidget* pop;
  int row, column;

  if (event->button == 3) {
    if (!gtk_clist_get_selection_info(GTK_CLIST(widget),
				      (int)event->x, (int)event->y,
				      &row, &column))
      row = -1;
    if (row == -1) return FALSE;
    
    global.popup_row = row;
    global.popup_list = widget;
    gtk_clist_select_row (GTK_CLIST(widget), row, 0);
    pop = create_hotlist_popup3();
    gtk_menu_popup(GTK_MENU(pop), NULL, NULL, 
		   NULL, NULL, 1, 10);
  }

  return FALSE;
}

void
on_join_channel1_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkCList* clist;
  char* text;

  if (global.popup_row == -1) return;

  clist = GTK_CLIST(global.popup_list);
  gtk_clist_get_text(clist, global.popup_row, 0, &text);
  join_channel(text);
}

void
on_normal1_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget* temp;
  
  temp = lookup_widget(global.win, "channel_list");
  gtk_clist_clear(GTK_CLIST(temp));
  
  gtk_clist_set_column_visibility (GTK_CLIST(temp), 2, FALSE);
  gtk_clist_set_column_visibility (GTK_CLIST(temp), 3, FALSE);
  send_command(617, "");
}

void
on_hidden1_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget* temp;
  
  temp = lookup_widget(global.win, "channel_list");
  gtk_clist_clear(GTK_CLIST(temp));
  
  gtk_clist_set_column_visibility (GTK_CLIST(temp), 2, TRUE);
  gtk_clist_set_column_visibility (GTK_CLIST(temp), 3, TRUE);
  send_command(827, "");
}


gboolean
on_channel_list_button_press_event     (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  GtkWidget* pop;
  int row, column;

  if (event->button == 3) {
    if (!gtk_clist_get_selection_info(GTK_CLIST(widget),
				      (int)event->x, (int)event->y,
				      &row, &column))
      row = -1;
    global.popup_row = row;
    global.popup_list = widget;
    gtk_clist_select_row (GTK_CLIST(widget), row, 0);
    pop = create_channel_popup();
    gtk_menu_popup(GTK_MENU(pop), NULL, NULL, 
		   NULL, NULL, 1, 10);
  }

  return FALSE;
}


void
on_checkbutton21_toggled               (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  GtkWidget* temp;

  temp = lookup_widget(global.win, "checkbutton21");
  global.parse_color = 
    gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp));

  if (global.options_win) {
    temp = lookup_widget(global.options_win, "checkbutton22");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), global.parse_color);
  }
}


gboolean
on_window_key_press_event              (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{
  GtkWidget* temp;

  //  printf("key: [%d][%d]\n", event->keyval, event->state);
  if (event->type == GDK_KEY_PRESS) {
    if ((event->keyval >= 49) &&      // 1-9
	(event->keyval <= 57) &&
	(event->state == 8)) {        // ALT
      temp = lookup_widget(global.win, "notebook3");
      gtk_notebook_set_page(GTK_NOTEBOOK(temp), (event->keyval-49));
    } else if ((event->keyval >= 49) &&      // 1-9
	       (event->keyval <= 57) &&
	       (event->state == 4)) {        // STRG
      temp = lookup_widget(global.win, "notebook1");
      gtk_notebook_set_page(GTK_NOTEBOOK(temp), (event->keyval-49));
    } else if ((event->keyval == 97) &&      // a
	       (event->state == 8)) {        // ALT
      temp = lookup_widget(global.win, "notebook3");
      gtk_notebook_prev_page(GTK_NOTEBOOK(temp));
    } else if ((event->keyval == 113) &&     // q
	       (event->state == 8)) {        // ALT
      temp = lookup_widget(global.win, "notebook1");
      gtk_notebook_prev_page(GTK_NOTEBOOK(temp));
    } else if ((event->keyval == 115) &&     // s
	       (event->state == 8)) {        // ALT
      temp = lookup_widget(global.win, "notebook3");
      gtk_notebook_next_page(GTK_NOTEBOOK(temp));
    } else if ((event->keyval == 119) &&     // w
	       (event->state == 8)) {        // ALT
      temp = lookup_widget(global.win, "notebook1");
      gtk_notebook_next_page(GTK_NOTEBOOK(temp));
    }
  }
  return 1;
}

