/* 
logpp (Log PreProcessor) 0.15 - common.h
Copyright (C) 2006-2008 Risto Vaarandi

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

#ifndef COMMON_H
#define COMMON_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

/* on some platforms must be included before stdio.h */
#include <stdarg.h>

/* fopen(), fclose(), fgets(), vfprintf(), fprintf() 
   also, on some platforms other headers (like stdlib.h) use stdio.h */
#include <stdio.h> 

/* system types - used by other headers */
#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif

/* stat(), open() */
#ifdef HAVE_SYS_STAT_H
#include <sys/stat.h>
#endif

/* read(), write(), stat(), lseek(), close(), fcntl(), dup(),
   dup2(), pipe(), fork(), exec(), setsid(), chdir(), getopt() 
   man page examples include sys/types.h and sys/stat.h before */
#ifdef HAVE_UNISTD_H
#include <unistd.h> 
#endif

/* open(), fcntl() 
   man page examples include sys/types.h and unistd.h before */
#ifdef HAVE_FCNTL_H
#include <fcntl.h> 
#endif

/* gettimeofday()
   select() is declared in sys/time.h on some platforms (like Solaris) */
#ifdef HAVE_SYS_TIME_H
#include <sys/time.h>
#endif

/* select() - some platforms don't have sys/select.h and use 
   sys/types.h, sys/time.h and unistd.h for select() */
#ifdef HAVE_SYS_SELECT_H
#include <sys/select.h>
#endif

/* waitpid() */
#ifdef HAVE_SYS_WAIT_H
#include <sys/wait.h> 
#endif

/* openlog(), closelog(), syslog(), vsyslog() */
#ifdef HAVE_SYSLOG_H
#include <syslog.h>
#endif

/* sigaction() */
#ifdef HAVE_SIGNAL_H
#include <signal.h>
#endif

/* errno */
#ifdef HAVE_ERRNO_H
#include <errno.h>
#endif

/* malloc(), free(), exit(), strtol()
   getopt() is declared in stdlib.h on some platforms (like Solaris) */
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif

/* strlen(), strcpy(), strncpy(), strcmp(), strerror(),
   memcpy(), memccpy(), memchr() */
#ifdef HAVE_STRING_H
#if !defined STDC_HEADERS && defined HAVE_MEMORY_H
#include <memory.h>
#endif
#include <string.h>
#endif

/* strcasecmp(), strncasecmp() */
#ifdef HAVE_STRINGS_H
#include <strings.h>
#endif

/* replacement for strcasecmp() if it does not exist */
#ifndef HAVE_STRCASECMP
#define strcasecmp(a,b) strcmp((a),(b))
#endif

/* replacement for strncasecmp() if it does not exist */
#ifndef HAVE_STRNCASECMP
#define strncasecmp(a,b,c) strncmp((a),(b),(c))
#endif

/* isspace(), isdigit() */
#include <ctype.h> 

/* pcre_compile(), pcre_study(), pcre_exec(), pcre_version(), pcre_free() */
#ifdef HAVE_LIBPCRE
#ifdef HAVE_PCRE_H
#include <pcre.h>
#endif
/* regcomp(), regexec(), regfree() */
#else
#ifdef HAVE_REGEX_H
#include <regex.h>
#endif
#endif

#endif /* COMMON_H */
