/* logjam - a GTK client for LiveJournal.
 * Copyright (C) 2000-2002 Evan Martin <evan@livejournal.com>
 *
 * vim: tabstop=4 shiftwidth=4 noexpandtab :
 * $Id: tools.c,v 1.1 2002/11/26 05:41:29 martine Exp $
 */

#include "config.h"
#include <gtk/gtk.h>

#include "tools.h"
#include "util.h"

typedef struct {
	gunichar c;
	char *escaped;
} htmlescape;
htmlescape htmlescapes[] = {
	{ '<', "&lt;" },
	{ '>', "&gt;" },
	{ '&', "&amp;" },
	/* FIXME: add more entities here?
	 * the above are all that are really necessary, though. */
	{ 0, 0 }
};

void
tools_html_escape_selected(LJWin *ljw) {
	GtkTextBuffer *buffer;
	GtkTextIter start, end, pos, nextpos;
	htmlescape *esc;
	gunichar c;
	int len;

	buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(ljw->eentry));

	if (!gtk_text_buffer_get_selection_bounds(buffer, &start, &end)) {
		/* no selection; give them some help. */
		lj_message(GTK_WIDGET(ljw), LJ_MSG_INFO, TRUE,
				_("HTML Escape Help"),
				_("Some characters (such as '<' and '&') are reserved in HTML, and may not display correctly in your post.\n"
				"To properly escape these characters, first select a block of text and try this command again.\n"));
		return;
	}

	gtk_text_buffer_begin_user_action(buffer); /* atomic, in terms of undo */

	for (pos = start; 
			gtk_text_iter_in_range(&pos, &start, &end);
			gtk_text_iter_forward_char(&pos)) {
		c = gtk_text_iter_get_char(&pos);
		for (esc = htmlescapes; esc->c != 0; esc++) {
			if (esc->c == c) break;
		}
		/* if this character isn't in the to-escape list, continue. */
		if (esc->c == 0) continue;

		nextpos = pos;
		gtk_text_iter_forward_char(&nextpos);
		gtk_text_buffer_delete(buffer, &pos, &nextpos);
		len = strlen(esc->escaped);
		gtk_text_buffer_insert(buffer, &pos, esc->escaped, len);

		/* to counteract the pos++ in the for loop */
		gtk_text_iter_backward_char(&pos);
		
		/* changing the buffer invalidates this iterator */
		gtk_text_buffer_get_selection_bounds(buffer, &start, &end);
	}

	gtk_text_buffer_move_mark_by_name(buffer, "insert", &end);
	gtk_text_buffer_move_mark_by_name(buffer, "selection_bound", &end);

	gtk_text_buffer_end_user_action(buffer);
}

void
tools_remove_linebreak_selected(LJWin *ljw) {
	GtkTextBuffer *buffer;
	GtkTextIter start, end, pos, nextpos;
	gint nlrun = 0;
	gboolean leading = TRUE;

	buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(ljw->eentry));

	if (!gtk_text_buffer_get_selection_bounds(buffer, &start, &end)) {
		/* no selection; give them some help. */
		lj_message(GTK_WIDGET(ljw), LJ_MSG_INFO, TRUE,
				_("Linebreak removal Help"),
				_("When you paste text into LogJam, linebreaks from the original are preserved, and will normally show up in your post on the server. You can have LogJam remove extraneous linebreaks from your entry, but you must make a specific selection of the text you wish this to happen on first.\n\nNote that you can also use the \"don't autoformat\" option on your post."));
		return;
	}
 
	gtk_text_buffer_begin_user_action(buffer); /* atomic, in terms of undo */

	for (pos = start; 
			gtk_text_iter_in_range(&pos, &start, &end);
			gtk_text_iter_forward_char(&pos)) {
		
		/* we remove linebreaks as we see them; but later we will
		 * make up for our deletions by inserting spaces or \n\ns
		 * as appropriate. */
		if (gtk_text_iter_ends_line(&pos)) {
			if (!leading) /* leading linebreaks should just be removed */
				nlrun++;
			nextpos = pos;
			gtk_text_iter_forward_line(&nextpos);
			gtk_text_buffer_delete(buffer, &pos, &nextpos);

			gtk_text_iter_backward_char(&pos);

			gtk_text_buffer_get_selection_bounds(buffer, &start, &end);

			continue;
		}
		
		leading = FALSE;
		
		/* make up for what we removed, according to how long a run
		 * it was. */
		if (nlrun == 1) { /* line separators turn into a space */
			nlrun = 0;
			gtk_text_buffer_insert(buffer, &pos, " ", 1);
			gtk_text_buffer_get_selection_bounds(buffer, &start, &end);
		} else if (nlrun > 1) { /* paragraph breaks are normalized */
			nlrun = 0;
			gtk_text_buffer_insert(buffer, &pos, "\n\n", 2);
			
			/* this is safe, since we've just added two characters. */
			gtk_text_iter_forward_chars(&pos, 2);

			gtk_text_buffer_get_selection_bounds(buffer, &start, &end);
		}
	}

	gtk_text_buffer_move_mark_by_name(buffer, "insert", &end);
	gtk_text_buffer_move_mark_by_name(buffer, "selection_bound", &end);
	
	gtk_text_buffer_end_user_action(buffer);
}

void
tools_insert_file(LJWin *ljw) {
	GtkWidget *filesel;

	filesel = gtk_file_selection_new(_("Select File"));
	/* this should really be a systemwide setting, but the gtk file selector
	 * sucks. */
	gtk_file_selection_hide_fileop_buttons(GTK_FILE_SELECTION(filesel));
	lj_dialog_init(filesel, GTK_WIDGET(ljw), NULL, -1, -1);
	if (gtk_dialog_run(GTK_DIALOG(filesel)) == GTK_RESPONSE_OK) {
		const gchar *filename = NULL;

		filename = gtk_file_selection_get_filename(
				GTK_FILE_SELECTION(filesel));
		lj_insert_file(ljw, filename);
	}
	gtk_widget_destroy(filesel);
}

