/* logjam - a GTK client for LiveJournal.
 * Copyright (C) 2000-2002 Evan Martin <evan@livejournal.com>
 *
 * vim: tabstop=4 shiftwidth=4 noexpandtab :
 * $Id: protocol.h,v 1.5 2002/10/03 01:11:43 martine Exp $
 */

#ifndef PROTOCOL_H
#define PROTOCOL_H

#include "ljtypes.h"

GHashTable* lj_protocol_hash_new(void);
GHashTable* lj_protocol_request_new(const char *mode, 
		const char *username, const char *password, const char *usejournal);
GHashTable* lj_protocol_parse_response(const char *res);
int lj_protocol_request_succeeded(GHashTable *result);
void lj_protocol_hash_free(GHashTable *hash);
GString* lj_protocol_request_to_string(GHashTable* request);

#endif /* PROTOCOL_H */
