#include "links.h"

struct list_head cache = {&cache, &cache};

long cache_size;

int cache_count = 0;

long cache_info(int type)
{
	int i = 0;
	struct cache_entry *ce;
	switch (type) {
		case CI_BYTES:
			return cache_size;
		case CI_FILES:
			foreach(ce, cache) i++;
			return i;
		case CI_LOCKED:
			foreach(ce, cache) i += !!ce->refcount;
			return i;
		case CI_LOADING:
			foreach(ce, cache) i += is_entry_used(ce);
			return i;
		case CI_LIST:
			return (long) &cache;
		default:
			internal("cache_info: bad request");
	}
	return 0;
}

unsigned char *extract_proxy(unsigned char *url)
{
	char *a;
	if (strlen(url) < 8 || casecmp(url, "proxy://", 8)) return url;
	if (!(a = strchr(url + 8, '/'))) return url;
	return a + 1;
}

int find_in_cache(unsigned char *url, struct cache_entry **f)
{
	struct cache_entry *e;
	url = extract_proxy(url);
	foreach(e, cache) if (!strcmp(e->url, url)) {
		del_from_list(e);
		add_to_list(cache, e);
		*f = e;
		return 0;
	}
	return -1;
}

int get_cache_entry(unsigned char *url, struct cache_entry **f)
{
	struct cache_entry *e;
	if (!find_in_cache(url, f)) return 0;
	shrink_memory(0);
	url = extract_proxy(url);
	if (!(e = mem_alloc(sizeof(struct cache_entry)))) return -1;
	memset(e, 0, sizeof(struct cache_entry));
	if (!(e->url = mem_alloc(strlen(url)+1))) {
		mem_free(e);
		return -1;
	}
	strcpy(e->url, url);
	e->length = -1;
	e->incomplete = 1;
	e->data_size = 0;
	init_list(e->frag);
	e->count = cache_count++;
	e->refcount = 0;
	add_to_list(cache, e);
	*f = e;
	return 0;
}

int get_cache_data(struct cache_entry *e, unsigned char **d, int *l)
{
	struct fragment *frag;
	*d = NULL; *l = 0;
	if ((void *)(frag = e->frag.next) == &e->frag) return -1;
	*d = frag->data;
	*l = frag->length;
	return 0;
}

#define sf(x) e->data_size += x, cache_size += x

int add_fragment(struct cache_entry *e, int offset, unsigned char *data, int length)
{
	struct fragment *f;
	struct fragment *nf;
	int a = 0;
	int trunc = 0;
	if (!length) return 0;
	e->count = cache_count++;
	foreach(f, e->frag) {
		if (f->offset > offset) break;
		if (f->offset <= offset && f->offset+f->length >= offset) {
			if (offset+length > f->offset+f->length) {
				if (memcmp(f->data+offset-f->offset, data, f->offset+f->length-offset)) trunc = 1;
				if (!(f = mem_realloc(f, sizeof(struct fragment) + offset-f->offset+length))) return -1;
				a = 1;
				sf((offset+length) - (f->offset+f->length));
				/*add_at_pos(f, nf);
				del_from_list(f);
				f = nf;*/
				f->prev->next = f; f->next->prev = f;
				f->length = offset-f->offset+length;
			} else {
				if (memcmp(f->data+offset-f->offset, data, length)) trunc = 1;
			}
			memcpy(f->data+offset-f->offset, data, length);
			goto ch_o;
		}
	}
	if (!(nf = mem_alloc(sizeof(struct fragment)+length))) return -1;
	a = 1;
	sf(length);
	nf->offset = offset;
	nf->length = length;
	memcpy(nf->data, data, length);
	add_at_pos(f->prev, nf);
	f = nf;
	ch_o:
	while ((void *)f->next != &e->frag && f->offset+f->length >= f->next->offset) {
		if (f->offset+f->length < f->next->offset+f->next->length) {
			if (!(nf = mem_realloc(f, sizeof(struct fragment)+f->next->offset-f->offset+f->next->length))) goto ff;
			add_at_pos(f, nf);
			del_from_list(f);
			f = nf;
			if (memcmp(f->data+f->next->offset-f->offset, f->next->data, f->offset+f->length-f->next->offset)) trunc = 1;
			memcpy(f->data+f->length, f->next->data+f->offset+f->length-f->next->offset, f->next->offset+f->next->length-f->offset-f->length);
			sf(f->next->offset+f->next->length-f->offset-f->length);
			f->length = f->next->offset+f->next->length-f->offset;
			ff:;
		} else {
			if (memcmp(f->data+f->next->offset-f->offset, f->next->data, f->next->length)) trunc = 1;
		}
		del_from_list(nf = f->next);
		sf(-nf->length);
		mem_free(nf);
	}
	if (trunc) truncate_entry(e, offset + length);
	return a;
}

void truncate_entry(struct cache_entry *e, int off)
{
	struct fragment *f, *g;
	foreach(f, e->frag) {
		if (f->offset >= off) {
			del:
			while ((void *)f != &e->frag) {
				sf(-f->length);
				g = f->next;
				del_from_list(f);
				mem_free(f);
				f = g;
			}
			return;
		}
		if (f->offset + f->length > off) {
			f->length = off - f->offset;
			sf(-(f->offset + f->length - off));
			f = f->next;
			goto del;
		}
	}
}

void delete_entry_content(struct cache_entry *e)
{
	e->count = cache_count++;
	free_list(e->frag);
	e->length = -1;
	e->incomplete = 1;
	if ((cache_size -= e->data_size) < 0) {
		internal("cache_size underflow: %ld", cache_size);
		cache_size = 0;
	}
	e->data_size = 0;
	if (e->last_modified) {
		mem_free(e->last_modified);
		e->last_modified = NULL;
	}
}

void delete_cache_entry(struct cache_entry *e)
{
	if (e->refcount) internal("deleteing locked cache entry");
#ifdef DEBUG
	if (is_entry_used(e)) internal("deleting loading cache entry");
#endif
	delete_entry_content(e);
	del_from_list(e);
	mem_free(e->url);
	if (e->head) mem_free(e->head);
	if (e->last_modified) mem_free(e->last_modified);
	if (e->redirect) mem_free(e->redirect);
	mem_free(e);
}

void garbage_collection(int u)
{
	struct cache_entry *e, *f;
	long ncs = cache_size;
	int no = 0;
	if (!u && cache_size <= memory_cache_size) return;
	for (e = cache.prev; (void *)e != &cache; e = e->prev) {
		if (!u && ncs <= memory_cache_size * MEMORY_CACHE_GC_PERCENT) goto g;
		if (e->refcount || is_entry_used(e)) {
			no = 1;
			e->tgc = 0;
			continue;
		}
		e->tgc = 1;
		if ((ncs -= e->data_size) < 0) {
			internal("cache_size underflow: %ld", ncs);
			ncs = 0;
		}
	}
	if (!no && ncs) internal("cache_size(%ld) is larger than size of all objects(%ld)", cache_size, cache_size - ncs);
	g:
	if ((void *)(e = e->next) == &cache) return;
	if (!u) for (f = e; (void *)f != &cache; f = f->next) {
		if (ncs + f->data_size <= memory_cache_size * MEMORY_CACHE_GC_PERCENT) {
			ncs += f->data_size;
			f->tgc = 0;
		}
	}
	for (f = e; (void *)f != &cache;) {
		f = f->next;
		if (f->prev->tgc) delete_cache_entry(f->prev);
	}
	if (!no && cache_size > memory_cache_size * MEMORY_CACHE_GC_PERCENT) {
		internal("garbage collection doesn't work, cache size %ld", cache_size);
	}
}
