/****************************************************************************
** $Id: globals.cpp,v 1.5 1999/12/13 17:07:44 riemer Exp $
**
** copyright            : (C) 1999-2000 by Tilo Riemer
**
** email                :  riemer@ppprs1.phy.tu-dresden.de
**
**----------------------------------------------------------------------------
**
**----------------------------------------------------------------------------
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as
** published by the Free Software Foundation; either version 2 of the
** License, or (at your option) any later version.
**
*****************************************************************************/

#include <iostream.h>
#include <stdlib.h>

//----------------------------------------------------------------------------

#include <qfile.h>
#include <qtextstream.h>

//----------------------------------------------------------------------------

#include "globals.h"

//----------------------------------------------------------------------------

bool isInCvsPass(QString cvsRoot)
{
   QFile f;
   QString line;

   //read .cvspass
   QString fileName = getenv("HOME");
   fileName += "/.cvspass";
   
   f.setName(fileName);
   if(f.open(IO_ReadOnly)) {//file is readable
      QTextStream textStream(&f); 

      while(!textStream.atEnd()) {
         line = textStream.readLine();
         if(line.find(cvsRoot) == 0) 
         {
            f.close();
            return true;
         }
      }
      f.close();
   }
   else 
      return false;

   return false;
}

//----------------------------------------------------------------------------

void login(QString cvsRoot)
{
   QString command;

   QString terminal = getenv("TERM");
   if(terminal.isEmpty()) terminal = "xterm";   
   
   command = terminal + " -geometry 80x10 -T \"" + cvsRoot + "\" ";
   command += "-e cvs -d ";
   command += cvsRoot;
   command += " login";
 
   system(command);
}

//----------------------------------------------------------------------------

int analyzeCVSROOT(QString& connectMethod, QString& userName, 
   QString& host, QString& rootDir)
{
   QString _connectMethod;
   QString _userName;
   QString _host;
   QString _rootDir;
   
   QString line = getenv("CVSROOT");
   int pos, posAt, posStartRootDir;
   int method = ACCESS_METHOD_ERROR;   //error as default
   
   if((posAt = line.find("@")) > -1) {//remote
      if(posAt < 2) return ACCESS_METHOD_ERROR;   //no space for user :-(

      //connectMethod
      QString left = line.left(posAt);
      if(left.find(":") != 0) return ACCESS_METHOD_ERROR;   //no ":" at position 0
      pos = left.find(":", 1);
      _connectMethod = left.mid(1, pos - 1);
      if( (QString::compare(_connectMethod, "ext"))
           && (QString::compare(_connectMethod, "server"))
           && (QString::compare(_connectMethod, "pserver")) ) 
      {//default remote access!
         _userName = left.mid(1, posAt - 1);
         if(_userName.length() == 0) return ACCESS_METHOD_ERROR;   //no user
         _connectMethod = "";
         method = ACCESS_RSH;
      }
      else 
      {//ext, server or pserver         
         //user
         _userName = left.right(posAt - pos - 1);
         if(_userName.length() == 0) return ACCESS_METHOD_ERROR;   //no user
 
         if(QString::compare(_connectMethod, "ext") == 0)     
            method = (ACCESS_RSH & RSH_EXT);
         else 
         if(QString::compare(_connectMethod, "server") == 0)  
            method = (ACCESS_RSH & RSH_SERVER);
         else
         if(QString::compare(_connectMethod, "pserver") == 0) 
            method = ACCESS_PSERVER;
         else 
            return ACCESS_METHOD_ERROR;
      }
      
      //host
      _host = line.mid(posAt + 1, line.find(":", posAt) - posAt - 1);
         
      posStartRootDir = posAt + _host.length() + 2;
   }
   else {//local
      _userName = getenv("USER");
      _host = "localhost";
      _connectMethod = "local";
      posStartRootDir = 0;
      method = ACCESS_LOCAL;
   }
      
   _rootDir = line.mid(posStartRootDir, line.length() - posStartRootDir);

   connectMethod = _connectMethod;
   userName      = _userName;
   host          = _host;
   rootDir       = _rootDir;

   return method;
}

//----------------------------------------------------------------------------
