/****************************************************************************
** $Id: controls.cpp,v 1.2 1999/12/14 02:14:20 riemer Exp $
**
** copyright            : (C) 1999-2000 by Tilo Riemer
**
** email                :  riemer@ppprs1.phy.tu-dresden.de
**
**----------------------------------------------------------------------------
**
**----------------------------------------------------------------------------
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as
** published by the Free Software Foundation; either version 2 of the
** License, or (at your option) any later version.
**
*****************************************************************************/

#include <qlayout.h>
#include <qpushbutton.h>
#include <qgroupbox.h> 
#include <qbuttongroup.h> 
#include <qfontmetrics.h> 

//----------------------------------------------------------------------------

#include "controls.h"

//----------------------------------------------------------------------------

IntValueLineEdit::IntValueLineEdit(QWidget * parent, const char * name)
: QLineEdit(parent, name)
{
   m_pIntValidator = 0;
}

//------------------------------------------------------------------------------

IntValueLineEdit::IntValueLineEdit(const QString &text, QWidget * parent, 
   const char * name)
: QLineEdit(text, parent, name)
{
   m_pIntValidator = 0;
}

//------------------------------------------------------------------------------

IntValueLineEdit::IntValueLineEdit(const int bottom, const int top, 
   QWidget * parent, const char * name)
: QLineEdit(parent, name)
{
   m_pIntValidator = new QIntValidator(bottom, top, this);
   setValidator(m_pIntValidator);
}

//------------------------------------------------------------------------------

IntValueLineEdit::IntValueLineEdit(const int bottom, const int top, 
   const QString &text, QWidget * parent, const char * name)
: QLineEdit(text, parent, name)
{
   m_pIntValidator = new QIntValidator(bottom, top, this);
   setValidator(m_pIntValidator);
}

//------------------------------------------------------------------------------

void IntValueLineEdit::setRange(const int bottom, const int top)
{
   if(m_pIntValidator)
      m_pIntValidator->setRange(bottom, top);
}

//------------------------------------------------------------------------------

int IntValueLineEdit::bottom() const
{
   if (m_pIntValidator)
      return m_pIntValidator->bottom();
   else 
      return 0;
}

//------------------------------------------------------------------------------

int IntValueLineEdit::top() const
{
   if (m_pIntValidator)
      return m_pIntValidator->top();
   else 
      return 0;
}

//------------------------------------------------------------------------------

void IntValueLineEdit::setText ( const QString & text)
{
   validate();
   QLineEdit::setText(text);
} 

//------------------------------------------------------------------------------

void IntValueLineEdit::validate()
{
   QString value;

   if(m_pIntValidator){
      if(text().toInt() > m_pIntValidator->top()){
         value.setNum(m_pIntValidator->top());
         QLineEdit::setText(value);
      }
      else
      if(text().toInt() < m_pIntValidator->bottom()){
         value.setNum(m_pIntValidator->bottom());
         QLineEdit::setText(value);
      }
   }
}

//------------------------------------------------------------------------------

void IntValueLineEdit::focusOutEvent(QFocusEvent *e)
{
   validate();
   QLineEdit::focusOutEvent(e);
}

//------------------------------------------------------------------------------
//------------------------------------------------------------------------------

TagOperationControl::TagOperationControl(QStringList *tagList, const QString& checkBoxLabel,
   QWidget *parent, bool tagEnabled, bool useSticky, const char *name)
: QWidget(parent, name)
{
   m_pTagList = tagList;
   
   QBoxLayout *topLayer = new QVBoxLayout(this, 5);

   m_pCheckBox = new QCheckBox(checkBoxLabel, this);
   m_pCheckBox->setChecked(true);
   connect(m_pCheckBox, SIGNAL(toggled(bool)), this, SLOT(enableControls(bool)));
   topLayer->addWidget(m_pCheckBox);

   QButtonGroup *tagBox = new QButtonGroup(4, Vertical, this);
   tagBox->setExclusive(true);
   topLayer->addWidget(tagBox);

   QWidget *bg = new QWidget(tagBox);
   QGridLayout *gridLayer = new QGridLayout(bg, 4, 2, 5);

   //revision
   m_pLabelRev = new QRadioButton(tr("Revision:"), bg);
   m_pLabelRev->setChecked(true);
   connect(m_pCheckBox, SIGNAL(toggled(bool)), m_pLabelRev, SLOT(setEnabled(bool)));
   tagBox->insert(m_pLabelRev);
   gridLayer->addWidget(m_pLabelRev, 0, 0);

   m_pRevision = new QLineEdit(bg);
   connect(m_pLabelRev, SIGNAL(toggled(bool)), m_pRevision, SLOT(setEnabled(bool)));
   gridLayer->addWidget(m_pRevision, 0, 1);
   

   //tag
   m_pLabelTag = new QRadioButton(tr("Tag:"), bg);
   connect(m_pCheckBox, SIGNAL(toggled(bool)), m_pLabelTag, SLOT(setEnabled(bool)));
   tagBox->insert(m_pLabelTag);
   gridLayer->addWidget(m_pLabelTag, 1, 0);

   m_pTagChoice = new QComboBox( true, bg);
   for(unsigned int i = 0; i < m_pTagList->count(); i++) {
      m_pTagChoice->insertItem((*m_pTagList)[i]);
   }
   connect(m_pLabelTag, SIGNAL(toggled(bool)), m_pTagChoice, SLOT(setEnabled(bool)));
   m_pTagChoice->setEnabled(false);
   gridLayer->addWidget(m_pTagChoice, 1, 1);


   //date
   m_pLabelDate = new QRadioButton(tr("Date:"), bg);
   connect(m_pCheckBox, SIGNAL(toggled(bool)), m_pLabelDate, SLOT(setEnabled(bool)));
   tagBox->insert(m_pLabelDate);
   gridLayer->addWidget(m_pLabelDate, 2, 0);

   QWidget *dateBg = new QWidget(bg);
   gridLayer->addWidget(dateBg, 2, 1);
   
   QBoxLayout *dateLayer = new QHBoxLayout(dateBg, 5);

   m_pDateLabel = new QLabel(tr("YYYY.MM.DD"), dateBg);
   m_pDateLabel->setEnabled(false);
   connect(m_pLabelDate, SIGNAL(toggled(bool)), m_pDateLabel, SLOT(setEnabled(bool)));
   dateLayer->addWidget(m_pDateLabel);

   m_pYear = new IntValueLineEdit(1970, 9999, dateBg);
   m_pYear->setMaxLength(4);
   m_pYear->setMinimumWidth(m_pYear->fontMetrics().width("000000"));
   m_pYear->setText("1999");
   m_pYear->setEnabled(false);
   connect(m_pLabelDate, SIGNAL(toggled(bool)), m_pYear, SLOT(setEnabled(bool)));
   dateLayer->addWidget(m_pYear);

   m_pMonth = new IntValueLineEdit(1, 12, dateBg);
   m_pMonth->setMaxLength(2);
   m_pMonth->setMinimumWidth(m_pMonth->fontMetrics().width("000"));
   m_pMonth->setText("12");
   m_pMonth->setEnabled(false);
   connect(m_pLabelDate, SIGNAL(toggled(bool)), m_pMonth, SLOT(setEnabled(bool)));
   dateLayer->addWidget(m_pMonth);

   m_pDay = new IntValueLineEdit(1, 31, dateBg);
   m_pDay->setMaxLength(2);
   m_pDay->setMinimumWidth(m_pDay->fontMetrics().width("000"));
   m_pDay->setText("2");
   m_pDay->setEnabled(false);
   connect(m_pLabelDate, SIGNAL(toggled(bool)), m_pDay, SLOT(setEnabled(bool)));
   dateLayer->addWidget(m_pDay);

   dateLayer->addSpacing(10);
   
   m_pTimeLabel = new QLabel(tr("HH:MM"), dateBg);
   connect(m_pLabelDate, SIGNAL(toggled(bool)), m_pTimeLabel, SLOT(setEnabled(bool)));
   m_pTimeLabel->setEnabled(false);
   dateLayer->addWidget(m_pTimeLabel);

   m_pHour = new IntValueLineEdit(0, 24, dateBg);
   m_pHour->setMaxLength(2);
   m_pHour->setMinimumWidth(m_pHour->fontMetrics().width("000"));
   m_pHour->setText("00");
   m_pHour->setEnabled(false);
   connect(m_pLabelDate, SIGNAL(toggled(bool)), m_pHour, SLOT(setEnabled(bool)));
   dateLayer->addWidget(m_pHour);

   m_pMinute = new IntValueLineEdit(0, 59, dateBg);
   m_pMinute->setMaxLength(2);
   m_pMinute->setMinimumWidth(m_pMinute->fontMetrics().width("000"));
   m_pMinute->setText("00");
   m_pMinute->setEnabled(false);
   connect(m_pLabelDate, SIGNAL(toggled(bool)), m_pMinute, SLOT(setEnabled(bool)));
   dateLayer->addWidget(m_pMinute);


   //sticky
   m_pLabelSticky = new QRadioButton(tr("Reset Sticky Tag:"), bg);
   connect(m_pCheckBox, SIGNAL(toggled(bool)), m_pLabelSticky, SLOT(setEnabled(bool)));
   tagBox->insert(m_pLabelSticky);
   gridLayer->addWidget(m_pLabelSticky, 3, 0);
   

   if(!useSticky)  m_pLabelSticky->hide();
   if(!tagEnabled) m_pCheckBox->setChecked(false);

}

//------------------------------------------------------------------------------

void TagOperationControl::enableControls(bool on)
{
   if(on) {
      if(m_pLabelRev->isChecked()) m_pRevision->setEnabled(true);
      if(m_pLabelTag->isChecked()) m_pTagChoice->setEnabled(true);
      if(m_pLabelDate->isChecked()) m_pDateLabel->setEnabled(true);
      if(m_pLabelDate->isChecked()) m_pYear->setEnabled(true);
      if(m_pLabelDate->isChecked()) m_pMonth->setEnabled(true);
      if(m_pLabelDate->isChecked()) m_pDay->setEnabled(true);
      if(m_pLabelDate->isChecked()) m_pTimeLabel->setEnabled(true);
      if(m_pLabelDate->isChecked()) m_pHour->setEnabled(true);
      if(m_pLabelDate->isChecked()) m_pMinute->setEnabled(true);
   }
   else {
      m_pRevision->setEnabled(false);
      m_pTagChoice->setEnabled(false);
      m_pDateLabel->setEnabled(false);
      m_pYear->setEnabled(false);
      m_pMonth->setEnabled(false);
      m_pDay->setEnabled(false);
      m_pTimeLabel->setEnabled(false);
      m_pHour->setEnabled(false);
      m_pMinute->setEnabled(false);
   }
}

//------------------------------------------------------------------------------

QString TagOperationControl::cvsParameter()
{
   if(!m_pCheckBox->isChecked()) {
      return QString::null;
   }
   else {
      if(m_pLabelRev->isChecked()) {
         return ("-r " + m_pRevision->text());
      }
      else
      if(m_pLabelTag->isChecked()) {
         return ("-r " + m_pTagChoice->currentText());
      }
      else
      if(m_pLabelDate->isChecked()) {
         m_pYear->validate();
         m_pMonth->validate();
         m_pDay->validate();
         QString month = m_pMonth->text().simplifyWhiteSpace();
         if(month.length() < 2) month.prepend("0");
         QString day = m_pDay->text().simplifyWhiteSpace();
         if(day.length() < 2) day.prepend("0");
      
         QString res;
         res = "-D \"" + m_pYear->text() + "-" + month + "-" + day;
         if(!m_pHour->text().isEmpty()) {
            m_pHour->validate();
            m_pMinute->validate();
            QString hour = m_pHour->text().simplifyWhiteSpace();
            if(hour.length() < 2) hour.prepend("0");
            if(hour.length() < 2) hour.prepend("0");
            QString minute = m_pMinute->text().simplifyWhiteSpace();
            if(minute.length() < 2) minute.prepend("0");
            if(minute.length() < 2) minute.prepend("0");
            res += " " + hour + ":" + minute;
         }
         res += "\"";
         
         return res;
      }
      else
      if(m_pLabelSticky->isChecked()) {
         return "-A ";
      }
   }
}

//------------------------------------------------------------------------------
