/****************************************************************************
** $Id: lincvs.h,v 1.14 1999/12/14 02:15:22 riemer Exp $
**
** copyright            : (C) 1999-2000 by Tilo Riemer
**
** email                :  riemer@ppprs1.phy.tu-dresden.de
**
**----------------------------------------------------------------------------
**
**----------------------------------------------------------------------------
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as
** published by the Free Software Foundation; either version 2 of the
** License, or (at your option) any later version.
**
*****************************************************************************/

#ifndef LINCVS_H
#define LINCVS_H

//----------------------------------------------------------------------------

#include <qmainwindow.h>
#include <qtoolbar.h>
#include <qtoolbutton.h>
#include <qmultilineedit.h>
#include <qlistview.h>
#include <qpixmap.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qdialog.h>
#include <qtimer.h>

//----------------------------------------------------------------------------

#include "cvslistview.h"

//----------------------------------------------------------------------------

class ApplicationWindow: public QMainWindow
{
   Q_OBJECT
public:
   ApplicationWindow();
   ~ApplicationWindow();

   void addProject(const char * fileName = 0, bool expand = false);

public slots:
   void addProjectSlot();
   void removeProjectSlot();
    
protected:
   void closeEvent( QCloseEvent* );
   void initMenuAndToolbar();
   void initComponents();
   void selectStyleMenu(int);
   void readCfg();
   void writeCfg();

protected slots:
   void checkOut();
   void import();
   void rereadProject();
   void stopCurAction();
   void showDirProperties();
   void checkStatus();
   void statusDir();
   void updateDir();
   void updateRevDir();
   void commitDir();
   void tagDir();
   void logDir();
   void historyDir();
   void diffDir();
   void loginDir();
   void addFiles();
   void statusFile();
   void updateFile();
   void updateRevFile();
   void commitFile();
   void tagFile();
   void logFile();
   void historyFile();
   void diffFile();
   void removeFile();

   void styleWood();
   void styleMetal();
   void stylePlatinum();
   void styleWindows();
   void styleCDE();
   void styleMotif();

   void setFont();
   void initialDirScanning();

   void about();
   void help();
   void aboutQt();

   void setCvsRsh();   //provisorium
   
private:
//    QPrinter *printer;
   QMultiLineEdit *m_pMessages;
   QToolBar *m_pTools;
   CvsDirListView *m_pWorkBenchTree;
   CvsListView *m_pFileList;
   QPixmap *m_pFurled;
   QPixmap *m_pExpanded;
   QToolButton *m_pStopAction;
   QStringList m_projectNameList;
   QString m_lastOpenedDir;
   QStringList m_tagList;
   
   QDialog *m_pCommitDlg;
   QMultiLineEdit *m_pComment;   //editor for commit dialog
   
   int m_sWood, m_sMetal, m_sPlatinum, m_sWindows, m_sCDE, m_sMotif;

   bool m_uninterruptible;
   bool m_stopAction;
   bool m_showWarning;
   
   QTimer m_timer;
};

//----------------------------------------------------------------------------

#endif
