/****************************************************************************
** $Id: directory.h,v 1.9 1999/12/02 03:17:48 riemer Exp $
**
** copyright            : (C) 1999-2000 by Tilo Riemer
**
** email                :  riemer@ppprs1.phy.tu-dresden.de
**
**----------------------------------------------------------------------------
**
**----------------------------------------------------------------------------
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as
** published by the Free Software Foundation; either version 2 of the
** License, or (at your option) any later version.
**
*****************************************************************************/

#ifndef DIRECTORY_H
#define DIRECTORY_H

//----------------------------------------------------------------------------

#include <qlistview.h>
#include <qmultilineedit.h>

//----------------------------------------------------------------------------

//durch enums ersetzen!!!
const int unknown                                    =  0;
const int probably_up_to_date                        =  1;
const int probably_up_to_date_and_timezone_incorrect =  2;
const int up_to_date                                 =  3;
const int modified                                   =  4;
const int needs_patch                                =  5;
const int needs_merge                                =  6;
const int needs_checkout                             =  7;
const int missing                                    =  8;
const int conflict                                   =  9;
const int added                                      = 10;
const int removed                                    = 11;

//----------------------------------------------------------------------------

class Entry
{
public:
   Entry(const QString& fileName, const int state) 
   {
      m_fileName = fileName;
      m_state = state;
   }

   void setState(int s) {m_state = s;}
   
   QString fileName() {return m_fileName;}
   int state() {return m_state;}
   
protected:
   QString m_fileName;
   int m_state;
};

//----------------------------------------------------------------------------

class Directory : public QListViewItem
{
public:
   Directory( QListView * parent, const QString& fileName, QListView *fileListView);
   Directory( QListViewItem * parent, const QString& fileName, QListView *fileListView);

   void readSubDirs();
   
   QString fullName() {return m_fullName;}
   QString rootDir() {return m_rootDir;}
   QString repository() {return m_repository;}
   QString userName() {return m_userName;}
   QString host() {return m_host;}
   QString connectMethod() {return m_connectMethod;}

   bool haveCvsDir() {return m_haveCvsDir || m_subDirHasCvsDir;}
   bool analyzeDirs();
   void addDir(QString newDir);
   void statusOfDir(QMultiLineEdit *output);
   void updateDir(QMultiLineEdit *output, const QString& tagParameter = QString::null);
   void commitDir(QMultiLineEdit *output, QString comment);
   void anyCommandDir(QMultiLineEdit *output, QString cvsCommand);
   void addFiles(QMultiLineEdit *output, QStringList *stringList);
   void statusOfFile(QMultiLineEdit *output, 
                     bool clearOutput = true);
   void updateFile(QMultiLineEdit *output, const QString& tagParameter = QString::null, 
                   bool clearOutput = true);
   void commitFile(QMultiLineEdit *output, 
                   QString comment, bool clearOutput = true);
   void anyCommandFile(QMultiLineEdit *output, 
                       QString cvsCommand, bool clearOutput = true);
   void removeFile(QMultiLineEdit *output, bool& showWarning, bool clearOutput = true);
   void activateItem();
   void setAndAppendEntry(QString fileName, int stateId);
   void setAllToUpToDate();
   void checkStatus(QListViewItem *item = 0);   //0 --> for all entries

   Directory* searchDirOfRepository(QString repository);
   Directory* searchDirOfPath(QString path);

   bool loginOk(bool showMessage = false);
   bool entriesFileModified();

protected:
   void init(const QString& fileName, QListView *fileListView);
   bool checkCvsDir();
   void activate();
 
   bool setEntry(QString fileName, int stateId);
   int alignWithEntries(QString name, int stateId);
   void setStatusInFileListView(QListViewItem *item, QString line);

   QString m_fullName;
   bool m_readable;
   bool m_haveCvsDir;
   bool m_subDirHasCvsDir;
   QListView *m_pFileListView;

   QString m_rootDir;
   QString m_repository;
   QString m_userName;
   QString m_host;
   QString m_connectMethod;
   
   QList <Entry> m_entries;
   QString m_modTimeOfEntries;
};

//----------------------------------------------------------------------------

#endif

