/****************************************************************************
** $Id: dialogs.h,v 1.6 1999/12/14 02:15:16 riemer Exp $
**
** copyright            : (C) 1999-2000 by Tilo Riemer
**
** email                :  riemer@ppprs1.phy.tu-dresden.de
**
**----------------------------------------------------------------------------
**
**----------------------------------------------------------------------------
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as
** published by the Free Software Foundation; either version 2 of the
** License, or (at your option) any later version.
**
*****************************************************************************/

#ifndef DIALOGS_H
#define DIALOGS_H

//----------------------------------------------------------------------------

#include <qdialog.h>
#include <qlineedit.h>
#include <qmultilineedit.h> 
#include <qcombobox.h>
#include <qstringlist.h> 
#include <qbuttongroup.h> 
#include <qradiobutton.h> 

//----------------------------------------------------------------------------

#include "globals.h"
#include "controls.h"

//----------------------------------------------------------------------------

const int MODE_PSERVER = 0;
const int MODE_RSH     = 1;
const int MODE_LOCAL   = 2;

//----------------------------------------------------------------------------

class CheckOutAndImportDlg: public QDialog
{
   Q_OBJECT
public:
   CheckOutAndImportDlg(QStringList *tagList, bool checkoutImport01, 
                        QString caption, QWidget *parent=0, 
                        const char *name=0, bool modal=TRUE, WFlags f=0 );
    
   QString user() const       {return m_pUser->text();}
   QString module() const     {return m_pLineModule->text();}
   QString server() const     {return m_pLineServer->text();}
   QString repository() const {return m_pLineRepository->text();}
   QString localDir() const   {return m_pLineLocalDir->text();}  
   QString comment() const    {return m_pComment->text();}  
   QString tag1() const       {return m_pTag1->text();}  
   QString tag2() const       {return m_pTag2->text();}  
   
   int mode()                 {return m_mode;}
   int rshMode();
   QString cvsRsh() {return m_pRshLine->text();}
   QString cvsParameter();
   
protected slots:   
   void showDirOpenDlg();
   void chooseMode(int);
   void chooseRshMethod(bool);
   
protected:
   QLineEdit *m_pUser;
   QLineEdit *m_pLineModule;
   QLineEdit *m_pLineServer;
   QLineEdit *m_pLineRepository;
   QLineEdit *m_pLineLocalDir;
   QButtonGroup *m_pRshBox;
   QRadioButton *m_pExt;
   QRadioButton *m_pServer;
   QLineEdit *m_pRshLine;
   QLineEdit *m_pTag1;
   QLineEdit *m_pTag2;
   QMultiLineEdit *m_pComment;
   int       m_mode;

   TagOperationControl *m_pTagCtl;
};

//----------------------------------------------------------------------------

class TagDlg: public QDialog
{
   Q_OBJECT
public:
   TagDlg(QStringList *tagList, QString caption, QWidget *parent=0, 
          const char *name=0, bool modal=TRUE, WFlags f=0 );

   enum DialogCode { Tag = 1, BranchTag };

protected slots:
   void tagged();
   void branchTagged();
   
protected:
   QStringList *m_pTagList;
   QComboBox * m_pTagChoice;
   
   void adaptTagList();
};

//----------------------------------------------------------------------------

class TagUpdateDlg: public QDialog
{
   Q_OBJECT
public:
   TagUpdateDlg(QStringList *tagList, QString caption, QWidget *parent=0, 
          const char *name=0, bool modal=TRUE, WFlags f=0 );

   QString cvsParameter();

protected:
   TagOperationControl *m_pTagCtl;
};

//----------------------------------------------------------------------------

#endif   //DIALOGS_H
