/****************************************************************************
** $Id: controls.h,v 1.2 1999/12/14 02:14:12 riemer Exp $
**
** copyright            : (C) 1999-2000 by Tilo Riemer
**
** email                :  riemer@ppprs1.phy.tu-dresden.de
**
**----------------------------------------------------------------------------
**
**----------------------------------------------------------------------------
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as
** published by the Free Software Foundation; either version 2 of the
** License, or (at your option) any later version.
**
*****************************************************************************/

#ifndef CONTROLS_H
#define CONTROLS_H

//----------------------------------------------------------------------------

#include <qlineedit.h> 
#include <qvalidator.h>
#include <qcombobox.h>
#include <qstringlist.h> 
#include <qcheckbox.h> 
#include <qlabel.h>
#include <qradiobutton.h> 

//------------------------------------------------------------------------------

class IntValueLineEdit : public QLineEdit
{
   Q_OBJECT
public:
   IntValueLineEdit(QWidget * parent, const char * name=0);
   IntValueLineEdit(const QString &, QWidget * parent, const char * name=0);
   IntValueLineEdit(const int bottom, const int top, 
                    QWidget * parent, const char * name=0);
   IntValueLineEdit(const int bottom, const int top, 
                    const QString &, QWidget * parent, const char * name=0);
   
   void setRange(const int bottom, const int top);
   int bottom() const;
   int top() const;
   
public slots:
   void setText(const QString &);
   void validate();
   
protected:   
   void focusOutEvent(QFocusEvent *); 
   
   QIntValidator *m_pIntValidator;
};

//------------------------------------------------------------------------------

class TagOperationControl: public QWidget
{
   Q_OBJECT
public:
   TagOperationControl(QStringList *tagList, const QString& checkBoxLabel, 
                       QWidget *parent=0, bool tagEnabled = true, 
                       bool useSticky = true, const char *name=0);

   QString cvsParameter();
   
public slots:
   void enableControls(bool on);

protected:
   QStringList *m_pTagList;
   QComboBox * m_pTagChoice;

   QCheckBox  *m_pCheckBox;

   QRadioButton *m_pLabelRev;
   QRadioButton *m_pLabelTag;
   QRadioButton *m_pLabelDate;
   QRadioButton *m_pLabelSticky;
   
   QLineEdit *m_pRevision;
   QLabel *m_pDateLabel;
   QLabel *m_pTimeLabel;
   IntValueLineEdit *m_pYear;
   IntValueLineEdit *m_pMonth;
   IntValueLineEdit *m_pDay;
   IntValueLineEdit *m_pHour;
   IntValueLineEdit *m_pMinute;
};

//----------------------------------------------------------------------------

#endif
