/****************************************************************************
**
** $Id: globals.cpp,v 1.36 2001/11/01 09:13:07 riemer Exp $
**
** Copyright (C) 2001 The LinCVS development team.
**    Tilo Riemer <riemer@lincvs.org>
**    Falk Brettschneider <gigafalk@yahoo.com>
**    Wim Delvaux <wim.delvaux@chello.be>
**    Jose Hernandez <joseh@tesco.net>
**    Helmut Koll <HelmutKoll@web.de>
**    Sven Trogisch <trogisch@iapp.de>
**
**
**----------------------------------------------------------------------------
**
**----------------------------------------------------------------------------
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as
** published by the Free Software Foundation; either version 2 of the
** License, or (at your option) any later version.
**
*****************************************************************************/

#include "config.h"
#include "ac_system_defs.h"

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdlib.h>
#include <iostream.h>

//----------------------------------------------------------------------------

#include <qfile.h>
#include <qdir.h>
#include <qtextstream.h>
#include <qdialog.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qobject.h> 
#include <qbutton.h>
#include <qlineedit.h>
#include <qcheckbox.h>

//----------------------------------------------------------------------------

#include "time_ac.h"
#include "globals.h"

//----------------------------------------------------------------------------

void determineTimeZoneDiff()
{
   time_t t_loc = time(0);
   struct tm *tm_utc = gmtime(&t_loc);
   time_t t_utc = mktime(tm_utc);

   timeZoneDiffInSecs = (int)t_utc - (int)t_loc;
}

//----------------------------------------------------------------------------

bool isInCvsPass(QString cvsRoot)
{
   QFile f;
   QString line;

   //read .cvspass
   QString fileName = QDir::homeDirPath();
   fileName += "/.cvspass";
   
   f.setName(fileName);
   if(f.open(IO_ReadOnly)) {//file is readable
      QTextStream textStream(&f); 

      while(!textStream.atEnd()) {
         line = textStream.readLine();
        line = line.replace( QRegExp(":2401"), ":" );
         if(line.find(cvsRoot) != -1) {
            f.close();
            return true;
         }
      }
      f.close();
   }
   else 
      return false;

   return false;
}

//----------------------------------------------------------------------------

void login(QString cvsRoot)
{
   QString command;

   //QString terminal = getenv("TERM");
   // should never happen
   if(terminal.isEmpty()) terminal = "xterm -geometry 80x10 -T";   

   cvsRoot.replace( QRegExp(" "), "\\ " );
   command = terminal + " \"" + cvsRoot + "\" ";
   command += "-e cvs -d ";
   command += cvsRoot;
   command += " login";
 
   system(command);
}

//----------------------------------------------------------------------------

int analyzeCVSROOT(QString& connectMethod, QString& userName, 
   QString& host, QString& rootDir)
{
   QString _connectMethod;
   QString _userName;
   QString _host;
   QString _rootDir;
   QString line = getenv("CVSROOT");
   int pos, posAt, posStartRootDir;
   int method = ACCESS_METHOD_ERROR;   //error as default
   
   if((posAt = line.find("@")) > -1) {//remote
      if(posAt < 2) return ACCESS_METHOD_ERROR;   //no space for user :-(

      //connectMethod
      QString left = line.left(posAt);
      if(left.find(":") != 0) return ACCESS_METHOD_ERROR;   //no ":" at position 0
      pos = left.find(":", 1);
      _connectMethod = left.mid(1, pos - 1);
      if( (QString::compare(_connectMethod, "ext"))
           && (QString::compare(_connectMethod, "server"))
           && (QString::compare(_connectMethod, "pserver")) ) 
      {//default remote access!
         _userName = left.mid(1, posAt - 1);
         if(_userName.length() == 0) return ACCESS_METHOD_ERROR;   //no user
         _connectMethod = "";
         method = ACCESS_RSH;
      }
      else 
      {//ext, server or pserver         
         //user
         _userName = left.right(posAt - pos - 1);
         if(_userName.length() == 0) return ACCESS_METHOD_ERROR;   //no user
 
         if(QString::compare(_connectMethod, "ext") == 0)     
            method = (ACCESS_RSH & RSH_EXT);
         else 
         if(QString::compare(_connectMethod, "server") == 0)  
            method = (ACCESS_RSH & RSH_SERVER);
         else
         if(QString::compare(_connectMethod, "pserver") == 0) 
            method = ACCESS_PSERVER;
         else 
            return ACCESS_METHOD_ERROR;
      }
      
      //host
      _host = line.mid(posAt + 1, line.find(":", posAt) - posAt - 1);
         
      posStartRootDir = posAt + _host.length() + 2;
   }
   else {//local
      _userName = getenv("USER");
      _host = "localhost";
      _connectMethod = "local";
      posStartRootDir = 0;
      method = ACCESS_LOCAL;
   }
      
   _rootDir = line.mid(posStartRootDir, line.length() - posStartRootDir);

   connectMethod = _connectMethod;
   userName      = _userName;
   host          = _host;
   rootDir       = _rootDir;

   return method;
}

//----------------------------------------------------------------------------

void removeDoubleSlashes(QString& s)
{
   int pos;
   while ( (pos = s.find("//")) > -1) s.replace(pos, 2, "/");
}

//----------------------------------------------------------------------------

void startSshAgent()
{
   //todo: test in shell-script for version of ssh (openssh or original ssh)
   //system("start-ssh-agent");
   system("start-ssh-agent.sh");
   
   QFile f;
   QString line;

   //now read the environment file and ascertain the PID of ssh-agent

   //read Entries
   f.setName(QDir::homeDirPath() + "/.ssh/lincvs-environment");
   cout << QDir::homeDirPath() + "/.ssh/lincvs-environment\n";
   
   sshPid = -1;
   
   if(f.open(IO_ReadOnly)) {//file is readable
      QTextStream textStream(&f); 

      while(!textStream.atEnd()) {
         line = textStream.readLine();
         if(line.find("SSH_AGENT_PID=") == 0) {
            QString tmp = line.mid(14, 20);
            QString pid = tmp.left(tmp.find(";"));
            sshPid = pid.toInt();
            cout << "sshPid = " << sshPid << "\n";
         } else if (line.find("setenv SSH_AGENT_PID ") == 0) {
            QString tmp = line.mid(21, 20);
            QChar ch;
            ch = tmp[0];
            int ch_pos = 0;
            while (ch.isDigit() && (tmp.length() > ch_pos)) {
               ch_pos++;
               ch = tmp[ch_pos];
            }
            QString pid = tmp.left(ch_pos);
            sshPid = pid.toInt();
            cout << "sshPid = " << sshPid << "\n";
         }
      }
   }   

   if (sshPid > 0) sshAgentIsRunning = true;
   else sshAgentIsRunning = false;  //sshPid not found, should never happen
}

//----------------------------------------------------------------------------

QString writeTmpFile(QString text)
{
   QString fname = createTempFile();
   
   if (fname.length()) {
      QFile file(fname);
      file.open(IO_WriteOnly);                     // open file for writing
      QTextStream s(&file);                        // serialize using f
      s << text;                                   // serialize string
      file.close();
   }
   
   return fname;
}

//----------------------------------------------------------------------------

void createTmpDir()
{
  QDir home = QDir::home();
  QDir tempDir;

  QFileInfo tmp(home, ".lincvs");
  if (tmp.exists()) {
    if (!tmp.isDir()) {
      QFile f(tmp.absFilePath());
      f.remove();  //we must check the result of remove!!!
      tempDir.mkdir(tmp.absFilePath());
    }
  } else tempDir.mkdir(tmp.absFilePath());
 
  chmod(tmp.absFilePath(), 0700);

  tmpDir = tmp.absFilePath();
}

//----------------------------------------------------------------------------

QString createTempFile()
{
  QString tmp = tmpDir + "/tmp.XXXXXX";

  char* fname = new char[tmp.length() + 1];
  strcpy(fname, tmp);
   
  int file = mkstemp(fname);
  
  QString tmpFile = fname;
  delete [] fname;      

  if (file > -1) {
    fchmod(file, 0600);
    close(file);

    return tmpFile;
  }
   
  return "";
}




