/****************************************************************************
**
** $Id: cvslistview.h,v 1.4 2001/06/28 23:03:33 joseh Exp $
**
** Copyright (C) 2001 The LinCVS development team.
**    Tilo Riemer <riemer@lincvs.org>
**    Falk Brettschneider <gigafalk@yahoo.com>
**    Wim Delvaux <wim.delvaux@chello.be>
**    Jose Hernandez <joseh@tesco.net>
**    Helmut Koll <HelmutKoll@web.de>
**    Sven Trogisch <trogisch@iapp.de>
**
**
**----------------------------------------------------------------------------
**
**----------------------------------------------------------------------------
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as
** published by the Free Software Foundation; either version 2 of the
** License, or (at your option) any later version.
**
*****************************************************************************/


#ifndef CVSLISTVIEW_H_20010626
#define CVSLISTVIEW_H_20010626

//----------------------------------------------------------------------------

#include "config.h"
#include "ac_system_defs.h"


#include <qlistview.h>
#include "directory.h"

class QPopupMenu;
class QListViewItem;
class Directory;

//----------------------------------------------------------------------------

class CvsListView: public QListView
{
   Q_OBJECT
public:
   CvsListView(QPopupMenu *menu, QWidget * parent = 0, const char * name = 0);

signals :
        void doubleClickedFile( QString S );

public slots :
        void selFile( QListViewItem * );

protected:
   void viewportMousePressEvent(QMouseEvent * e);
   void keyPressEvent ( QKeyEvent * e );

   QPopupMenu *m_pMenu;
};

//----------------------------------------------------------------------------

class CvsDirListView: public QListView
{
   Q_OBJECT
public:
   CvsDirListView(QPopupMenu *menu, QWidget * parent = 0, const char * name = 0);

   Directory * find( QString Entry );
    
protected:
   virtual void resizeEvent (QResizeEvent * e);
   void viewportMousePressEvent(QMouseEvent * e);
   void keyPressEvent ( QKeyEvent * e );
   void contentsMouseDoubleClickEvent ( QMouseEvent * e );
   void contentsMouseMoveEvent ( QMouseEvent * e );
   void contentsMousePressEvent ( QMouseEvent * e );
   void contentsMouseReleaseEvent ( QMouseEvent * e );
   
   QPopupMenu *m_pMenu;
   Directory* OldItem;
};

//----------------------------------------------------------------------------

#endif   //CVSLISTVIEW_H_20010626
