/* Driver template for the LEMON parser generator.
** The author disclaims copyright to this source code.
*/
/* First off, code is include which follows the "include" declaration
** in the input file. */
#include <stdio.h>
#line 6 "./configparser.y"

#include <assert.h>
#include <stdio.h>
#include "config.h"
#include "configfile.h"
#include "buffer.h"
#include "array.h"

#line 17 "configparser.c"
/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/* 
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands. 
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash 
**                       table.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       have fall-back values which should be used if the
**                       original value of the token will not parse.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    configparserTOKENTYPE     is the data type used for minor tokens given 
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is configparserTOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.
**    configparserARG_SDECL     A static variable declaration for the %extra_argument
**    configparserARG_PDECL     A parameter declaration for the %extra_argument
**    configparserARG_STORE     Code to store %extra_argument into yypParser
**    configparserARG_FETCH     Code to extract %extra_argument from yypParser
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
/*  */
#define YYCODETYPE unsigned char
#define YYNOCODE 34
#define YYACTIONTYPE unsigned char
#define configparserTOKENTYPE buffer *
typedef union {
  configparserTOKENTYPE yy0;
  array * yy12;
  config_cond_t yy29;
  data_unset * yy65;
  int yy67;
} YYMINORTYPE;
#define YYSTACKDEPTH 100
#define configparserARG_SDECL config_t *ctx;
#define configparserARG_PDECL ,config_t *ctx
#define configparserARG_FETCH config_t *ctx = yypParser->ctx
#define configparserARG_STORE yypParser->ctx = ctx
#define YYNSTATE 39
#define YYNRULE 23
#define YYERRORSYMBOL 20
#define YYERRSYMDT yy67
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)

/* Next are that tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < YYNSTATE                  Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   YYNSTATE <= N < YYNSTATE+YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == YYNSTATE+YYNRULE              A syntax error has occurred.
**
**   N == YYNSTATE+YYNRULE+1            The parser accepts its input.
**
**   N == YYNSTATE+YYNRULE+2            No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as
**
**      yy_action[ yy_shift_ofst[S] + X ]
**
** If the index value yy_shift_ofst[S]+X is out of range or if the value
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X or if yy_shift_ofst[S]
** is equal to YY_SHIFT_USE_DFLT, it means that the action is not in the table
** and that yy_default[S] should be used instead.  
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array and YY_REDUCE_USE_DFLT is used in place of
** YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
*/
static YYACTIONTYPE yy_action[] = {
 /*     0 */     2,    3,    4,   39,    5,   14,   22,    7,    6,   23,
 /*    10 */    20,   21,   16,   11,    5,   28,   22,   35,   36,   37,
 /*    20 */    38,    9,   10,   12,   26,   28,   13,   10,   12,   46,
 /*    30 */    20,   19,   25,   11,   24,   63,    1,    8,   15,   27,
 /*    40 */    11,   11,   29,   17,   18,   30,   31,   32,   33,   34,
 /*    50 */    57,   58,   59,   60,   61,
};
static YYCODETYPE yy_lookahead[] = {
 /*     0 */    23,   24,   25,    0,    1,    9,    3,    2,   31,   32,
 /*    10 */    26,   27,   28,   29,    1,   12,    3,   16,   17,   18,
 /*    20 */    19,    4,    5,    6,   11,   12,    4,    5,    6,    2,
 /*    30 */    26,   27,   22,   29,   10,   21,   22,   26,   26,    1,
 /*    40 */    29,   29,   13,    7,    8,   14,    4,   15,   30,    4,
 /*    50 */    10,    4,    4,    4,    4,
};
#define YY_SHIFT_USE_DFLT (-5)
static signed char yy_shift_ofst[] = {
 /*     0 */    -5,    3,   -5,   -5,   -5,   -5,    5,   17,   -5,   -5,
 /*    10 */    -5,   -5,   22,   -4,   17,   -5,   36,   -5,   22,   -5,
 /*    20 */    -5,   -5,   27,   24,   -5,   13,   38,   -5,   29,   31,
 /*    30 */    42,   32,    1,   45,   40,   47,   48,   49,   50,
};
#define YY_REDUCE_USE_DFLT (-24)
static signed char yy_reduce_ofst[] = {
 /*     0 */    14,  -23,  -24,  -24,  -24,  -24,  -24,   11,  -24,  -24,
 /*    10 */   -24,  -24,  -16,  -24,   12,  -24,  -24,  -24,    4,  -24,
 /*    20 */   -24,  -24,  -24,  -24,   10,  -23,  -24,  -24,  -24,  -24,
 /*    30 */   -24,  -24,   18,  -24,  -24,  -24,  -24,  -24,  -24,
};
static YYACTIONTYPE yy_default[] = {
 /*     0 */    41,   62,   40,   42,   43,   44,   62,   62,   45,   47,
 /*    10 */    48,   49,   62,   47,   62,   55,   62,   50,   52,   51,
 /*    20 */    54,   53,   62,   62,   41,   62,   62,   56,   62,   62,
 /*    30 */    62,   62,   62,   62,   62,   62,   62,   62,   62,
};
#define YY_SZ_ACTTAB (sizeof(yy_action)/sizeof(yy_action[0]))

/* The next table maps tokens into fallback tokens.  If a construct
** like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammer, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  int stateno;       /* The state-number */
  int major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
  YYMINORTYPE minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int yyidx;                    /* Index of top element in stack */
  int yyerrcnt;                 /* Shifts left before out of the error */
  configparserARG_SDECL                /* A place to hold %extra_argument */
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void configparserTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *yyTokenName[] = { 
  "$",             "EOL",           "ASSIGN",        "LKEY",        
  "STRING",        "INTEGER",       "LPARAN",        "RPARAN",      
  "COMMA",         "ARRAY_ASSIGN",  "LCURLY",        "RCURLY",      
  "DOLLAR",        "SRVVARNAME",    "LBRACKET",      "RBRACKET",    
  "EQ",            "MATCH",         "NE",            "NOMATCH",     
  "error",         "input",         "metalines",     "metaline",    
  "varline",       "condline",      "value",         "aelement",    
  "aelements",     "array",         "cond",          "key",         
  "context",     
};
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *yyRuleName[] = {
 /*   0 */ "input ::= metalines",
 /*   1 */ "metalines ::= metalines metaline",
 /*   2 */ "metalines ::=",
 /*   3 */ "metaline ::= varline",
 /*   4 */ "metaline ::= condline",
 /*   5 */ "metaline ::= EOL",
 /*   6 */ "varline ::= key ASSIGN value",
 /*   7 */ "key ::= LKEY",
 /*   8 */ "value ::= STRING",
 /*   9 */ "value ::= INTEGER",
 /*  10 */ "value ::= array",
 /*  11 */ "array ::= LPARAN aelements RPARAN",
 /*  12 */ "aelements ::= aelements COMMA aelement",
 /*  13 */ "aelements ::= aelements COMMA",
 /*  14 */ "aelements ::= aelement",
 /*  15 */ "aelement ::= value",
 /*  16 */ "aelement ::= STRING ARRAY_ASSIGN value",
 /*  17 */ "condline ::= context LCURLY metalines RCURLY EOL",
 /*  18 */ "context ::= DOLLAR SRVVARNAME LBRACKET STRING RBRACKET cond STRING",
 /*  19 */ "cond ::= EQ",
 /*  20 */ "cond ::= MATCH",
 /*  21 */ "cond ::= NE",
 /*  22 */ "cond ::= NOMATCH",
};
#endif /* NDEBUG */

/*
** This function returns the symbolic name associated with a token
** value.
*/
const char *configparserTokenName(int tokenType){
#ifndef NDEBUG
  if( tokenType>0 && tokenType<(sizeof(yyTokenName)/sizeof(yyTokenName[0])) ){
    return yyTokenName[tokenType];
  }else{
    return "Unknown";
  }
#else
  return "";
#endif
}

/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to configparser and configparserFree.
*/
void *configparserAlloc(void *(*mallocProc)(size_t)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( (size_t)sizeof(yyParser) );
  if( pParser ){
    pParser->yyidx = -1;
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(YYCODETYPE yymajor, YYMINORTYPE *yypminor){
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are not used
    ** inside the C code.
    */
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:
    case 13:
    case 14:
    case 15:
    case 16:
    case 17:
    case 18:
    case 19:
#line 31 "./configparser.y"
{ buffer_free((yypminor->yy0)); }
#line 374 "configparser.c"
      break;
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;
  yyStackEntry *yytos = &pParser->yystack[pParser->yyidx];

  if( pParser->yyidx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->yyidx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yymajor = yytos->major;
  yy_destructor( yymajor, &yytos->minor);
  pParser->yyidx--;
  return yymajor;
}

/* 
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from configparserAlloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void configparserFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  if( pParser==0 ) return;
  while( pParser->yyidx>=0 ) yy_pop_parser_stack(pParser);
  (*freeProc)((void*)pParser);
}

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_shift_action(
  yyParser *pParser,        /* The parser */
  int iLookAhead            /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
 
  /* if( pParser->yyidx<0 ) return YY_NO_ACTION;  */
  i = yy_shift_ofst[stateno];
  if( i==YY_SHIFT_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
    int iFallback;            /* Fallback token */
    if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
           && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
           yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
      }
#endif
      return yy_find_shift_action(pParser, iFallback);
    }
#endif
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_reduce_action(
  yyParser *pParser,        /* The parser */
  int iLookAhead            /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
 
  i = yy_reduce_ofst[stateno];
  if( i==YY_REDUCE_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer ot the minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yyidx++;
  if( yypParser->yyidx>=YYSTACKDEPTH ){
     configparserARG_FETCH;
     yypParser->yyidx--;
#ifndef NDEBUG
     if( yyTraceFILE ){
       fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
     }
#endif
     while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
     /* Here code is inserted which will execute if the parser
     ** stack every overflows */
     configparserARG_STORE; /* Suppress warning about unused %extra_argument var */
     return;
  }
  yytos = &yypParser->yystack[yypParser->yyidx];
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor = *yypMinor;
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->yyidx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->yyidx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->yystack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 21, 1 },
  { 22, 2 },
  { 22, 0 },
  { 23, 1 },
  { 23, 1 },
  { 23, 1 },
  { 24, 3 },
  { 31, 1 },
  { 26, 1 },
  { 26, 1 },
  { 26, 1 },
  { 29, 3 },
  { 28, 3 },
  { 28, 2 },
  { 28, 1 },
  { 27, 1 },
  { 27, 3 },
  { 25, 5 },
  { 32, 7 },
  { 30, 1 },
  { 30, 1 },
  { 30, 1 },
  { 30, 1 },
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  configparserARG_FETCH;
  yymsp = &yypParser->yystack[yypParser->yyidx];
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno>=0 
        && yyruleno<sizeof(yyRuleName)/sizeof(yyRuleName[0]) ){
    fprintf(yyTraceFILE, "%sReduce [%s].\n", yyTracePrompt,
      yyRuleName[yyruleno]);
  }
#endif /* NDEBUG */

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
      case 0:
        /* No destructor defined for metalines */
        break;
      case 1:
        /* No destructor defined for metalines */
        /* No destructor defined for metaline */
        break;
      case 2:
        break;
      case 3:
        /* No destructor defined for varline */
        break;
      case 4:
        /* No destructor defined for condline */
        break;
      case 5:
  yy_destructor(1,&yymsp[0].minor);
        break;
      case 6:
#line 33 "./configparser.y"
{
  buffer_copy_string_buffer(yymsp[0].minor.yy65->key, yymsp[-2].minor.yy0);
  if (NULL == array_get_element(ctx->ctx_config, yymsp[0].minor.yy65->key->ptr)) {
    array_insert_unique(ctx->ctx_config, yymsp[0].minor.yy65);
  } else {
    fprintf(stderr, "Duplicate config variable in conditional %s: %s\n", 
            ctx->ctx_name->ptr, yymsp[0].minor.yy65->key->ptr);
    ctx->ok = 0;
    yymsp[0].minor.yy65->free(yymsp[0].minor.yy65);
  }
  buffer_free(yymsp[-2].minor.yy0);
}
#line 641 "configparser.c"
  yy_destructor(2,&yymsp[-1].minor);
        break;
      case 7:
#line 46 "./configparser.y"
{
  yygotominor.yy0 = yymsp[0].minor.yy0;
  yymsp[0].minor.yy0 = NULL;
}
#line 650 "configparser.c"
        break;
      case 8:
#line 51 "./configparser.y"
{
  yygotominor.yy65 = (data_unset *)data_string_init();
  buffer_copy_string_buffer(((data_string *)(yygotominor.yy65))->value, yymsp[0].minor.yy0);
  buffer_free(yymsp[0].minor.yy0);
}
#line 659 "configparser.c"
        break;
      case 9:
#line 57 "./configparser.y"
{
  yygotominor.yy65 = (data_unset *)data_integer_init();
  ((data_integer *)(yygotominor.yy65))->value = strtol(yymsp[0].minor.yy0->ptr, NULL, 10);
  buffer_free(yymsp[0].minor.yy0);
}
#line 668 "configparser.c"
        break;
      case 10:
#line 62 "./configparser.y"
{
  yygotominor.yy65 = (data_unset *)data_array_init();
  array_free(((data_array *)(yygotominor.yy65))->value);
  ((data_array *)(yygotominor.yy65))->value = yymsp[0].minor.yy12;
}
#line 677 "configparser.c"
        break;
      case 11:
#line 67 "./configparser.y"
{
  yygotominor.yy12 = yymsp[-1].minor.yy12;
  yymsp[-1].minor.yy12 = NULL;
}
#line 685 "configparser.c"
  yy_destructor(6,&yymsp[-2].minor);
  yy_destructor(7,&yymsp[0].minor);
        break;
      case 12:
#line 72 "./configparser.y"
{
  if (buffer_is_empty(yymsp[0].minor.yy65->key) ||
      NULL == array_get_element(yymsp[-2].minor.yy12, yymsp[0].minor.yy65->key->ptr)) {
    array_insert_unique(yymsp[-2].minor.yy12, yymsp[0].minor.yy65);
  } else {
    fprintf(stderr, "Duplicate array-key: %s\n", 
            yymsp[0].minor.yy65->key->ptr);
    yymsp[0].minor.yy65->free(yymsp[0].minor.yy65);
    ctx->ok = 0;
  }
  
  yygotominor.yy12 = yymsp[-2].minor.yy12;
}
#line 704 "configparser.c"
  yy_destructor(8,&yymsp[-1].minor);
        break;
      case 13:
#line 86 "./configparser.y"
{
  yygotominor.yy12 = yymsp[-1].minor.yy12;
}
#line 712 "configparser.c"
  yy_destructor(8,&yymsp[0].minor);
        break;
      case 14:
#line 90 "./configparser.y"
{
  yygotominor.yy12 = array_init();
  array_insert_unique(yygotominor.yy12, yymsp[0].minor.yy65);
}
#line 721 "configparser.c"
        break;
      case 15:
#line 95 "./configparser.y"
{
  yygotominor.yy65 = yymsp[0].minor.yy65;
  yymsp[0].minor.yy65 = NULL;
}
#line 729 "configparser.c"
        break;
      case 16:
#line 99 "./configparser.y"
{
  buffer_copy_string_buffer(yymsp[0].minor.yy65->key, yymsp[-2].minor.yy0);
  buffer_free(yymsp[-2].minor.yy0);
  
  yygotominor.yy65 = yymsp[0].minor.yy65;
  yymsp[0].minor.yy65 = NULL;
}
#line 740 "configparser.c"
  yy_destructor(9,&yymsp[-1].minor);
        break;
      case 17:
#line 106 "./configparser.y"
{
  data_config *dc;
  
  dc = (data_config *)array_get_element(ctx->config, "global");
  assert(dc);
  ctx->ctx_name = dc->key;
  ctx->ctx_config = dc->value;
}
#line 753 "configparser.c"
        /* No destructor defined for context */
  yy_destructor(10,&yymsp[-3].minor);
        /* No destructor defined for metalines */
  yy_destructor(11,&yymsp[-1].minor);
  yy_destructor(1,&yymsp[0].minor);
        break;
      case 18:
#line 115 "./configparser.y"
{
  data_config *dc;
  buffer *b;
  
  b = buffer_init();
  buffer_copy_string_buffer(b, yymsp[-5].minor.yy0);
  buffer_append_string_buffer(b, yymsp[-3].minor.yy0);
  buffer_append_string_buffer(b, yymsp[0].minor.yy0);
  buffer_append_long(b, yymsp[-1].minor.yy29);
  
  if (NULL != (dc = (data_config *)array_get_element(ctx->config, b->ptr))) {
    ctx->ctx_name = dc->key;
    ctx->ctx_config = dc->value;
  } else {
    dc = data_config_init();
    
    buffer_copy_string_buffer(dc->key, b);
    buffer_copy_string_buffer(dc->comp_key, yymsp[-5].minor.yy0);
    buffer_append_string_buffer(dc->comp_key, yymsp[-3].minor.yy0);
    dc->cond = yymsp[-1].minor.yy29;
    
    switch(yymsp[-1].minor.yy29) {
    case CONFIG_COND_NE:
    case CONFIG_COND_EQ:
      dc->match.string = buffer_init_string(yymsp[0].minor.yy0->ptr);
      break;
#ifdef HAVE_PCRE_H
    case CONFIG_COND_NOMATCH:
    case CONFIG_COND_MATCH: {
      const char *errptr;
      int erroff;
      
      if (NULL == (dc->match.regex = 
          pcre_compile(yymsp[0].minor.yy0->ptr, 0, &errptr, &erroff, NULL))) {
	dc->match.string = buffer_init_string(errptr);
	dc->cond = CONFIG_COND_UNSET;
      }
      break;
    }
#endif
    default:
      break;
    }
    
    array_insert_unique(ctx->config, (data_unset *)dc);
	
    ctx->ctx_name = dc->key;
    ctx->ctx_config = dc->value;
  }
  buffer_free(b);
  buffer_free(yymsp[-5].minor.yy0);
  buffer_free(yymsp[-3].minor.yy0);
  buffer_free(yymsp[0].minor.yy0);
}
#line 816 "configparser.c"
  yy_destructor(12,&yymsp[-6].minor);
  yy_destructor(14,&yymsp[-4].minor);
  yy_destructor(15,&yymsp[-2].minor);
        break;
      case 19:
#line 169 "./configparser.y"
{
  yygotominor.yy29 = CONFIG_COND_EQ;
}
#line 826 "configparser.c"
  yy_destructor(16,&yymsp[0].minor);
        break;
      case 20:
#line 172 "./configparser.y"
{
  yygotominor.yy29 = CONFIG_COND_MATCH;
}
#line 834 "configparser.c"
  yy_destructor(17,&yymsp[0].minor);
        break;
      case 21:
#line 175 "./configparser.y"
{
  yygotominor.yy29 = CONFIG_COND_NE;
}
#line 842 "configparser.c"
  yy_destructor(18,&yymsp[0].minor);
        break;
      case 22:
#line 178 "./configparser.y"
{
  yygotominor.yy29 = CONFIG_COND_NOMATCH;
}
#line 850 "configparser.c"
  yy_destructor(19,&yymsp[0].minor);
        break;
  };
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yypParser->yyidx -= yysize;
  yyact = yy_find_reduce_action(yypParser,yygoto);
  if( yyact < YYNSTATE ){
    yy_shift(yypParser,yyact,yygoto,&yygotominor);
  }else if( yyact == YYNSTATE + YYNRULE + 1 ){
    yy_accept(yypParser);
  }
}

/*
** The following code executes when the parse fails
*/
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  configparserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
#line 15 "./configparser.y"

  ctx->ok = 0;

#line 884 "configparser.c"
  configparserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
){
  configparserARG_FETCH;
#define TOKEN (yyminor.yy0)
  configparserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  configparserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
  configparserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "configparserAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void configparser(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  configparserTOKENTYPE yyminor       /* The value for the token */
  configparserARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
  int yyendofinput;     /* True if we are at the end of input */
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->yyidx<0 ){
    if( yymajor==0 ) return;
    yypParser->yyidx = 0;
    yypParser->yyerrcnt = -1;
    yypParser->yystack[0].stateno = 0;
    yypParser->yystack[0].major = 0;
  }
  yyminorunion.yy0 = yyminor;
  yyendofinput = (yymajor==0);
  configparserARG_STORE;

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s\n",yyTracePrompt,yyTokenName[yymajor]);
  }
#endif

  do{
    yyact = yy_find_shift_action(yypParser,yymajor);
    if( yyact<YYNSTATE ){
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->yyerrcnt--;
      if( yyendofinput && yypParser->yyidx>=0 ){
        yymajor = 0;
      }else{
        yymajor = YYNOCODE;
      }
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE);
    }else if( yyact == YY_ERROR_ACTION ){
      int yymx;
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yymx = yypParser->yystack[yypParser->yyidx].major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->yyidx >= 0 &&
          yymx != YYERRORSYMBOL &&
          (yyact = yy_find_shift_action(yypParser,YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yyidx < 0 || yymajor==0 ){
          yy_destructor(yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
      }
      yymajor = YYNOCODE;
#endif
    }else{
      yy_accept(yypParser);
      yymajor = YYNOCODE;
    }
  }while( yymajor!=YYNOCODE && yypParser->yyidx>=0 );
  return;
}
