Summary:	Liferea (Linux RSS News Aggregator)
Name: 		liferea
Version: 	1.2.20
Release: 	1
Group: 		Applications/Internet
License: 	GPL
Source: 	%{name}-%{version}.tar.gz
URL: 		http://liferea.sourceforge.net/
BuildRoot: 	%{_tmppath}/%{name}-%{version}-%{release}-root
BuildRequires: 	gtk2-devel
BuildRequires:	gtkhtml2-devel
BuildRequires: 	libxml2-devel >= 2.5.10
BuildRequires: 	GConf2-devel
BuildRequires: 	gettext
BuildRequires: 	libtool
BuildRequires: 	pkgconfig
Requires: 	gtk2 >= 2.8.0, libxml2
Prereq:		GConf2

%description
Liferea is an aggregator for online news feeds. There are many
other news readers available, but these others are not available 
for Linux or require many extra libraries to be installed. 
Liferea tries to fill this gap by creating a fast, easy to use, 
easy to install news aggregator for GTK/GNOME.

%prep
%setup -q

%build
%configure \
	--disable-schemas-install
CFLAGS="$RPM_OPT_FLAGS" %{__make} %{?_smp_mflags}

%install
%{__rm} -rf ${RPM_BUILD_ROOT}
%makeinstall
%find_lang %{name}

%clean
%{__rm} -rf ${RPM_BUILD_ROOT}

%post
export GCONF_CONFIG_SOURCE=`gconftool-2 --get-default-source`
gconftool-2 --makefile-install-rule \
  %{_sysconfdir}/gconf/schemas/%{name}.schemas &>/dev/null

%pre
export GCONF_CONFIG_SOURCE=`gconftool-2 --get-default-source`
gconftool-2 --makefile-uninstall-rule \
  %{_sysconfdir}/gconf/schemas/%{name}.schemas >/dev/null || :

%files -f %{name}.lang
%defattr(-,root,root)
%doc COPYING AUTHORS NEWS README ChangeLog
%{_bindir}/%{name}
%{_bindir}/%{name}-bin
%{_datadir}/applications/%{name}.desktop
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/css
%dir %{_datadir}/%{name}/dtd
%dir %{_datadir}/%{name}/opml
%dir %{_datadir}/%{name}/pixmaps
%dir %{_datadir}/%{name}/doc
%dir %{_datadir}/%{name}/doc/html
%dir %{_datadir}/%{name}/xslt
%{_datadir}/%{name}/css/*.css
%{_datadir}/%{name}/dtd/html.ent
%{_datadir}/%{name}/opml/feedlist*.opml
%{_datadir}/%{name}/pixmaps/*
%{_datadir}/pixmaps/%{name}.png
%{_datadir}/%{name}/doc/html/*.html
%{_datadir}/%{name}/doc/html/*.png
%{_datadir}/%{name}/doc/html/*.css
%{_datadir}/%{name}/xslt/*.xml
%{_datadir}/%{name}/xslt/*.xslt
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/*.so
%exclude %{_libdir}/%{name}/*.la
%{_mandir}/man1/liferea.1.gz
%{_sysconfdir}/gconf/schemas/%{name}.schemas

%changelog
* Wed Sep 15 2004 Ricardo Veguilla <veguilla@hpcf.upr.edu> - 0.6.0
- Fixed %files entry for multi-language feedlists 

* Wed Sep 10 2004 Ricardo Veguilla <veguilla@hpcf.upr.edu> - 0.6.0
- Additional fixes to %files section (thanks to Michael Schwendt)

* Wed Sep 8 2004 Ricardo Veguilla <veguilla@hpcf.upr.edu> - 0.6.0
- Fixes to %files section
- %changelog section must be in reverse chronlogical order

* Thu Aug 26 2004 Lars Lindner <lars.lindner@gmx.net> 0.6.0
- Wrongs paths fixed (reported by Ricardo Veguilla)

* Sat Aug 21 2004 Lars Lindner <lars.lindner@gmx.net> 0.6.0
- Added stylesheet file to %files
- Added default feed list to %files

* Tue Aug 17 2004 Noa Resare <noa@resare.com> - 0.5.3
- removed gconf schema installation at build time
- added gconf schema installation at install time
- added manpage
- GConf2 is now a prereq

* Sat May 8 2004 Nathan Conrad <conrad@bungled.net> 0.4.9
- Removed *.la files

* Tue Apr 27 2004 Brian Pepple <bdpepple@ameritech.net> 0.4.7c-1
- Added BuildRequires: gtkhtml2-devel
- Cleaned up %configure, since this should be handled by the build environment.

* Mon Apr 26 2004 Nathan Conrad <conrad@bungled.net> 0.4.8-1
- Changed the depends a bit, and added a few things to the file listing
- Build should use the RPM_OPT_FLAGS
- Build root should have the package version number

* Sun Apr 25 2004 Brian Pepple <bdpepple@ameritech.net> 0.4.8-1
- Added more name macros

* Fri Apr  2 2004 Brian Pepple <bdpepple@ameritech.net> 0.4.8-1
- Added BuildRequires.
- Added gettext support.
- Added macros for files.
