// Video.hh, Video class for SDL
// Copyright (c) 2002 - 2003 Jesper Strandberg (skywarper@hotbrev.com)
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

#ifndef VIDEO_HH
#define VIDEO_HH

#include <string>
#include <SDL.h>
#include "Surface.hh"

class Video {
    static Video *mVideo;
    static Surface *mScreen;

    bool mFullscreen;
    bool mCursor;

    protected:
        Video(int width, int height, int bpp, const std::string &caption, int flags);

    public:
        static Video *init(int width, int height, int bpp, const std::string &caption, int flags);
        static Video *getVideo() { return mVideo; }
        ~Video() { SDL_QuitSubSystem(SDL_INIT_VIDEO); }

        static Surface *getScreen() { return mScreen; }
        void update() const;

        void setFullscreen();
        void setWindowed();
        void toggleFullscreen();

        void hideCursor();
        void showCursor();
        void toggleCursor();

        static Uint32 mapRGB(Uint8 r, Uint8 g, Uint8 b) { return SDL_MapRGB(mScreen->getFormat(), r, g, b); }
        static Uint32 mapRGB(SDL_PixelFormat *fmt, Uint8 r, Uint8 g, Uint8 b) { return SDL_MapRGB(fmt, r, g, b); }

        static void getRGB(Uint32 pixel, Uint8 *r, Uint8 *g, Uint8 *b) { SDL_GetRGB(pixel, mScreen->getFormat(), r, g, b); }
        static void getRGB(Uint32 pixel, SDL_PixelFormat *fmt, Uint8 *r, Uint8 *g, Uint8 *b) { SDL_GetRGB(pixel, fmt, r, g, b); }
};

#endif // VIDEO_HH

