#ifndef LISTBOXITEM_H
#define LISTBOXITEM_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <qlistview.h>
#include <qpopmenu.h>
#include <vector.h>
#include <qpixmap.h>

#include "user.h"

#define COL_ALIAS 1
#define COL_UIN 2
#define COL_NAME 3
#define COL_EMAIL 4

class ColInfo
{
public:
   ColInfo(unsigned theInfo = 0, unsigned short theWidth = 0, unsigned short theAlign = 0)
      { info = theInfo; width = theWidth; align = (unsigned short)theAlign; };
   unsigned short info, width, align;
};


//=====UserViewItem================================================================================
class CUserViewItem : public QListViewItem
{
public:
   CUserViewItem (ICQUser *, unsigned short, QListView *);
   virtual const char *key (int column, bool ascending) const;

   void setGraphics(void);
   ICQUser *getUser(void)  { return m_cUser; };
protected:
   virtual void paintCell ( QPainter *, const QColorGroup &, int column, int width, int align);
   
   QColor *m_cFore, *m_cBack;
   QPixmap *m_pIcon;
   
   ICQUser *m_cUser;
   unsigned short m_nIndex;
   
   static bool    s_bGridLines;
   static QPixmap *s_pOnline, 
                  *s_pOffline,
                  *s_pAway,
                  *s_pNa,
                  *s_pOccupied,
                  *s_pDnd,
                  *s_pPrivate,
                  *s_pMessage;
   static QColor  *s_cOnline,
                  *s_cAway,
                  *s_cOffline,
                  *s_cNew,
                  *s_cBack,
                  *s_cGridLines;

friend class CUserView;
};


//=====UserView====================================================================================
class CUserView : public QListView
{
public:   
   CUserView (QPopupMenu *m, QPopupMenu *mg, vector <ColInfo> colInfo, 
              bool isHeader, bool _bGridLines, QWidget *parent = 0, const char *name = 0);
   void maxLastColumn(void);
   
   void setPixmaps(QPixmap *_pOnline, QPixmap *_pOffline, QPixmap *_pAway,
                   QPixmap *_pNa, QPixmap *_pOccupied, QPixmap *_pDnd,
                   QPixmap *_pPrivate, QPixmap *_pMessage);
   void setColors(char *_sOnline, char *_sAway, char *_sOffline,
                  char *_sNew, char *_sBack, char *_sGridLines);


   //void setUserGroup(CUserGroup *_c)  { m_cUserGroup = _c; };
   void setShowHeader(bool);
   ICQUser *getSelectedUser(void);
   //CUserGroup *getUserGroup(void)  { return m_cUserGroup; };
   
   bool getGridLines(void)  { return CUserViewItem::s_bGridLines; };
   void setGridLines(bool _b)  { CUserViewItem::s_bGridLines = _b; };

   vector <ColInfo> colInfo;
protected:
   
   //CUserGroup *m_cUserGroup;
   QPopupMenu *mnuUser, *mnuGroup;
   virtual void mouseReleaseEvent(QMouseEvent *e); 
   virtual void keyPressEvent(QKeyEvent *e);
};


#endif
