/* support.h -- supporting functions for systems missing things we need. */

#ifndef SUPPORT_H
#define SUPPORT_H

#ifdef __cplusplus
extern "C" {
#endif

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <dirent.h>

#ifndef HAVE_INET_ATON
int inet_aton(const char *cp, struct in_addr *addr);
#endif  /* HAVE_INET_ATON */

#ifndef HAVE_INET_ADDR
unsigned long inet_addr(const char *cp);
#endif  /* HAVE_INET_ADDR */

#ifndef HAVE_STRERROR
char *strerror(int errnum);
#endif

#ifndef HAVE_ALPHASORT
int alphasort(const struct dirent **a, const struct dirent **b);
#endif

#ifndef HAVE_SCANDIR
int scandir(const char *dir, struct dirent ***namelist,
            int (*select)(const struct dirent *),
            int (*compar)());
#endif

#ifdef __cplusplus
}
#endif

#endif	/* SUPPORT_H */
