#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "requestdlg.h"

RequestDlg::RequestDlg(QWidget *parent = NULL, char *name = NULL) : QDialog(parent, name, true)
{
   resize(300, 200);
   setCaption("Chat Request");
   boxReason = new QGroupBox("Reason", this);
   boxReason->setGeometry(10, 60, 280, 140);
   mleReason = new MLEditWrap(30, boxReason);
   mleReason->setGeometry(10, 10, 260, 120);
   grpReturn = new QButtonGroup(this);
   grpReturn->setGeometry(10, 10, 280, 40);
   rdbAccept = new QRadioButton("Accept", grpReturn);
   rdbAccept->setGeometry(10, 10, 100, 20);
   rdbRefuse = new QRadioButton("Refuse", grpReturn);
   rdbAccept->setGeometry(110, 10, 100, 20);
   btnOk = new QPushButton("OK", this);
   btnOk->setGeometry(130, 165, 40, 30);
   connect (btnOk, SIGNAL(clicked()), this, SLOT(done()));
}


const char *RequestDlg::reason(void)
{
   return ((const char *)mleReason->text());
}

void RequestDlg::done()
{
   if (rdbAccept->isChecked()) accept();
   else reject();
}
