#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <qmsgbox.h> 
#include <qfiledialog.h>

#include "icqfunctions.h"
#include "chatacceptdlg.h"
#include "fileacceptdlg.h"
#include "showawaymsgdlg.h"
#include "countrycodes.h"

#include "log.h"

#define MARGIN_LEFT 5
#define MARGIN_RIGHT 30

unsigned short ICQFunctions::s_nX = 100;
unsigned short ICQFunctions::s_nY = 100;

//-----ICQFunctions::constructor-------------------------------------------------------------------
ICQFunctions::ICQFunctions(ICQ *s, ICQUser *u, bool isAutoClose, 
                           QWidget *parent, const char *name) 
   : QTabDialog(parent, name)
{
   server = s;
   icqEvent = NULL;
   m_cUser = u;
   m_bIsOwner = (u == &(server->icqOwner));
   
   setApplyButton();
   setCancelButton("Close");
   
   // get rid of the stupid OK button
   QPushButton *okButton = CHILD(this,QPushButton,"ok");
   okButton->hide();
   btnApply = CHILD(this, QPushButton, "apply settings");
   
   strcpy(tabLabel[TAB_READ], "View Event");
   fcnTab[TAB_READ] = new QWidget(this, tabLabel[TAB_READ]);
   splRead = new QSplitter(QSplitter::Vertical, fcnTab[TAB_READ]);
   splRead->setStyle(MotifStyle);
   msgView = new MsgView(splRead);   
   msgView->setGeometry(MARGIN_LEFT, 5, width() - MARGIN_RIGHT, 80);
   msgView->setFrameStyle( QFrame::WinPanel | QFrame::Sunken);
   mleRead = new MLEditWrap(true, splRead);
   mleRead->setGeometry(MARGIN_LEFT, 110, width() - MARGIN_RIGHT, 180);
   mleRead->setFrameStyle(QFrame::WinPanel | QFrame::Sunken);
   mleRead->setReadOnly(true);   
   splRead->setResizeMode(msgView, QSplitter::KeepSize);
   splRead->setResizeMode(mleRead, QSplitter::Stretch);
   connect (msgView, SIGNAL(doubleClicked(QListViewItem *)), this, SLOT(printMessage(QListViewItem *)));

   strcpy(tabLabel[TAB_SEND], "Send Event");
   fcnTab[TAB_SEND] = new QWidget(this, tabLabel[TAB_SEND]);
   grpCmd = new QButtonGroup("Select Function", fcnTab[TAB_SEND]);
   grpCmd->setExclusive(true);
   rdbMsg = new QRadioButton("Message", grpCmd);
   rdbMsg->setChecked(true);
   rdbUrl = new QRadioButton("URL", grpCmd);
   rdbUrl->setChecked(true);
   rdbAway = new QRadioButton("Check Away Msg", grpCmd);
   rdbAway->setChecked(true);
   rdbChat = new QRadioButton("Chat Request", grpCmd);
   rdbFile = new QRadioButton("File Transfer", grpCmd);
   connect(grpCmd, SIGNAL(clicked(int)), this, SLOT(specialFcn(int)));
   lblDescription = new QLabel(fcnTab[TAB_SEND]);
   msgVal = new char[2];
   mleSend = new MLEditWrap(true, fcnTab[TAB_SEND]);
   mleSend->setFrameStyle( QFrame::WinPanel | QFrame::Sunken);      
   connect(mleSend, SIGNAL(signal_CtrlEnterPressed()), this, SIGNAL(applyButtonPressed()));
   lblItem = new QLabel(fcnTab[TAB_SEND]);
   edtItem = new QLineEdit(fcnTab[TAB_SEND]);
   chkSendServer = new QCheckBox("Send through server", fcnTab[TAB_SEND]);
   chkSpoof = new QCheckBox("Spoof UIN:", fcnTab[TAB_SEND]);
   edtSpoof = new QLineEdit(fcnTab[TAB_SEND]);
   edtSpoof->setEnabled(false);
   edtSpoof->setMaxLength(10);
   edtSpoof->setValidator(new QIntValidator(0, 2147483647, edtSpoof));
   connect(chkSpoof, SIGNAL(toggled(bool)), edtSpoof, SLOT(setEnabled(bool)));
   
   strcpy(tabLabel[TAB_BASICINFO], "User Info");
   fcnTab[TAB_BASICINFO] = new QWidget(this, tabLabel[TAB_BASICINFO]);
   nfoAlias = new CInfoField(5, 5, 45, 5, 110, "Alias:", false, fcnTab[TAB_BASICINFO]);
   nfoStatus = new CInfoField(180, 5, 35, 5, width() - MARGIN_RIGHT - 190, 
                              "Status:", true, fcnTab[TAB_BASICINFO]);
   nfoUin = new CInfoField(5, 35, 45, 5, 110, "UIN:", true, fcnTab[TAB_BASICINFO]);
   nfoFirstName = new CInfoField(5, 65, 45, 5, 110, "Name:", false, fcnTab[TAB_BASICINFO]);
   nfoLastName = new CInfoField(170, 65, 0, 0, width() - MARGIN_RIGHT - 185, 
                                NULL, false, fcnTab[TAB_BASICINFO]);
   nfoEMail = new CInfoField(5, 95, 45, 5, width() - MARGIN_RIGHT - 70, 
                             "EMail:", false, fcnTab[TAB_BASICINFO]);   
   nfoHistory = new CInfoField(5, 125, 45, 5, width() - MARGIN_RIGHT - 70, 
                               "History:", false, fcnTab[TAB_BASICINFO]);
   nfoIp = new CInfoField(180, 35, 35, 5, width() - MARGIN_RIGHT - 230, 
                          "IP:", true, fcnTab[TAB_BASICINFO]); 
   chkAuthorization = new QCheckBox("Authorization Needed", fcnTab[TAB_BASICINFO]);
   chkAuthorization->setEnabled(m_bIsOwner);
   
   strcpy(tabLabel[TAB_DETAILINFO], "Details");
   fcnTab[TAB_DETAILINFO] = new QWidget(this, tabLabel[TAB_DETAILINFO]);
   nfoAge = new CInfoField(5, 5, 45, 5, 100, "Age:", !m_bIsOwner, fcnTab[TAB_DETAILINFO]);
   nfoState = new CInfoField(5, 35, 45, 5, 100, "State:", !m_bIsOwner, fcnTab[TAB_DETAILINFO]);
   nfoCity = new CInfoField(5, 65, 45, 5, width() - MARGIN_RIGHT - 70, "City:", !m_bIsOwner, fcnTab[TAB_DETAILINFO]);
   lblCountry = new QLabel("Country:", fcnTab[TAB_DETAILINFO]);
   cmbCountry = new CEComboBox(true, fcnTab[TAB_DETAILINFO]);
   cmbCountry->insertItem("Unspecified");
   cmbCountry->insertItem("Unknown (unspecified)");
   m_nUnknownCountryCode = 0xFFFF; // set the unknown value to default to unspecified
   cmbCountry->insertStrList(GetCountryList());
   cmbCountry->setEnabled(m_bIsOwner);
   nfoHomepage = new CInfoField(5, 125, 65, 5, width() - MARGIN_RIGHT - 90, 
                                "Homepage:", !m_bIsOwner, fcnTab[TAB_DETAILINFO]);
   lblSex = new QLabel("Sex:", fcnTab[TAB_DETAILINFO]);
   cmbSex = new CEComboBox(true, fcnTab[TAB_DETAILINFO]);
   cmbSex->insertItem("Unspecified");
   cmbSex->insertItem("Female");
   cmbSex->insertItem("Male");
   cmbSex->setEnabled(m_bIsOwner);
   nfoPhone = new CInfoField(180, 35, 45, 5, width() - MARGIN_RIGHT - 245, 
                             "Phone:", !m_bIsOwner, fcnTab[TAB_DETAILINFO]);
   boxAboutMsg = new QGroupBox (fcnTab[TAB_DETAILINFO]);
   boxAboutMsg->setFrameStyle(QFrame::Box | QFrame::Sunken);
   boxAboutMsg->setAlignment(AlignLeft);                               
   boxAboutMsg->setTitle("About");   
   mleAboutMsg = new MLEditWrap(true, boxAboutMsg);
   
   strcpy(tabLabel[TAB_HISTORY], "History");
   fcnTab[TAB_HISTORY] = new QWidget(this, tabLabel[TAB_HISTORY]);
   mleHistory = new MLEditWrap(true, fcnTab[TAB_HISTORY]);
   chkEditHistory = new QCheckBox("History read only", fcnTab[TAB_HISTORY]);
   connect(chkEditHistory, SIGNAL(toggled(bool)), mleHistory, SLOT(setReadOnly(bool)));
   
   addTab(fcnTab[TAB_READ], tabLabel[TAB_READ]);
   addTab(fcnTab[TAB_SEND], tabLabel[TAB_SEND]);
   addTab(fcnTab[TAB_BASICINFO], tabLabel[TAB_BASICINFO]);
   addTab(fcnTab[TAB_DETAILINFO], tabLabel[TAB_DETAILINFO]);
   addTab(fcnTab[TAB_HISTORY], tabLabel[TAB_HISTORY]);
  
   chkAutoClose = new QCheckBox("Auto Close", this);
   chkAutoClose->setChecked(isAutoClose);
   btnSave = new QPushButton("Save", this);
   connect(btnSave, SIGNAL(clicked()), this, SLOT(save()));
      
   connect (chkSpoof, SIGNAL(clicked()), this, SLOT(setSpoofed()));
   connect (this, SIGNAL(selected(const char *)), this, SLOT(tabSelected(const char *)));
   connect (server, SIGNAL(signal_doneUserFcn(bool, ICQEvent *)), this, SLOT(doneFcn(bool, ICQEvent *)));
   connect (this, SIGNAL(cancelButtonPressed()), this, SLOT(hide()));
   connect (this, SIGNAL(applyButtonPressed()), this, SLOT(callFcn()));

   setGeometry(s_nX, s_nY, 400, 360);
   setMinimumSize(400, 360);
}


void ICQFunctions::resizeEvent(QResizeEvent *)
{
  splRead->setGeometry(MARGIN_LEFT, 5, width() - MARGIN_RIGHT, height() - 90);
  
  grpCmd->setGeometry(MARGIN_LEFT, 5, width() - MARGIN_RIGHT, 60);
  rdbMsg->setGeometry(10, 15, 90, 20);
  rdbUrl->setGeometry(115, 15, 90, 20);
  rdbAway->setGeometry(205, 15, 120, 20);
  rdbChat->setGeometry(10, 35, 100, 20);
  rdbFile->setGeometry(115, 35, 100, 20);
  lblDescription->setGeometry(5, 70, 120, 20);   
  lblItem->setGeometry(5, height() - 140, 80, 20);
  edtItem->setGeometry(70, height() - 140, width() - MARGIN_RIGHT - 70, 20);
  chkSendServer->setGeometry(5, height() - 110, 150, 20);
  chkSpoof->setGeometry(170, height() - 110, 180, 20);
  edtSpoof->setGeometry(270, height() - 110, width() - MARGIN_RIGHT - 265, 20);
  mleSend->setGeometry(MARGIN_LEFT, 90, width() - MARGIN_RIGHT, height() - 240);
  
  nfoAlias->setGeometry(5, 5, 45, 5, 110);
  nfoStatus->setGeometry(180, 5, 35, 5, width() - MARGIN_RIGHT - 215);
  nfoUin->setGeometry(5, 35, 45, 5, 110);
  nfoFirstName->setGeometry(5, 65, 45, 5, 110);
  nfoLastName->setGeometry(170, 65, 0, 0, width() - MARGIN_RIGHT - 165);
  nfoEMail->setGeometry(5, 95, 45, 5, width() - MARGIN_RIGHT - 50);
  nfoHistory->setGeometry(5, 125, 45, 5, width() - MARGIN_RIGHT - 50);
  nfoIp->setGeometry(180, 35, 35, 5, width() - MARGIN_RIGHT - 215); 
  chkAuthorization->setGeometry(5, 150, 200, 20);
  
  nfoAge->setGeometry(5, 5, 45, 5, 100);
  nfoState->setGeometry(5, 35, 45, 5, 100);
  nfoCity->setGeometry(5, 65, 45, 5, width() - MARGIN_RIGHT - 50);
  lblCountry->setGeometry(5, 95, 48, 20);
  cmbCountry->setGeometry(55, 95, width() - MARGIN_RIGHT - 50, 20);
  nfoHomepage->setGeometry(5, 125, 65, 5, width() - MARGIN_RIGHT - 70);
  lblSex->setGeometry(180, 5, 45, 20);
  cmbSex->setGeometry(230, 5, width() - MARGIN_RIGHT - 225, 20);
  nfoPhone->setGeometry(180, 35, 45, 5, width() - MARGIN_RIGHT - 225);
  boxAboutMsg->setGeometry(5, 160, width() - MARGIN_RIGHT, height() - 250);
  mleAboutMsg->setGeometry(10, 15, boxAboutMsg->width() - 20, boxAboutMsg->height() - 25);

  mleHistory->setGeometry(MARGIN_LEFT, 5, width() - MARGIN_RIGHT, height() - 120);
  chkEditHistory->setGeometry(5, height() - 110, 150, 20);  
  
  chkAutoClose->setGeometry(10, height() - 30, 180, 20);
  btnSave->setGeometry(width() - 260, btnApply->y(), btnApply->width(), btnApply->height());
}


//-----ICQFunctions::keyPressEvent----------------------------------------------
void ICQFunctions::keyPressEvent(QKeyEvent *e)
{
  if (e->key() == Key_Enter || e->key() == Key_Return)
  {
    emit applyButtonPressed();
    return;
  }
  QTabDialog::keyPressEvent(e);
}

//-----ICQFunctions::setupTabs--------------------------------------------------
void ICQFunctions::setupTabs(int index)
{
   // read tab
   for (short i = m_cUser->getNumMessages() - 1; i >= 0; i--) 
      (void) new MsgViewItem(m_cUser->GetEvent(i), i, msgView);
   
   // print the first event if it's a message
   MsgViewItem *e = (MsgViewItem *)msgView->firstChild();
   if (e != NULL && e->msg->SubCommand() == ICQ_CMDxSUB_MSG)
   {
      msgView->setSelected(e, true);
      printMessage(e);
   }

   // Send tab
   rdbAway->setEnabled(m_cUser->isAway());
   if (chkSendServer->isEnabled()) 
      chkSendServer->setChecked(m_cUser->getSendServer());
   if (m_cUser->getStatusOffline()) 
   {
      chkSendServer->setChecked(true);
      chkSendServer->setEnabled(false);
   }
   chkSpoof->setChecked(false);
   rdbMsg->setChecked(true);
   specialFcn(0);
   setTabEnabled(tabLabel[TAB_SEND], !m_bIsOwner);
   
   // Info tabs
   setBasicInfo();
   setExtInfo();

   // History tab
   mleHistory->setReadOnly(true);
   chkEditHistory->setChecked(true);
   
   // mark the user as no longer new if they are new
   if (m_cUser->getIsNew()) 
   {
      m_cUser->setIsNew(false);
      emit signal_updatedUser();
   }
   
   show();
   
   switch (index) 
   {
   case 0: tabBar()->setCurrentTab(0); break;
   case 1: tabBar()->setCurrentTab(1); rdbMsg->setChecked(true); specialFcn(0); break;
   case 2: tabBar()->setCurrentTab(1); rdbUrl->setChecked(true); specialFcn(1); break;
   case 3: tabBar()->setCurrentTab(1); rdbChat->setChecked(true); specialFcn(3); break;
   case 4: tabBar()->setCurrentTab(1); rdbFile->setChecked(true); specialFcn(4); break;
   case 5: 
      tabBar()->setCurrentTab(1); 
      if (rdbAway->isEnabled())
      {
         rdbAway->setChecked(true); 
         specialFcn(2);
         callFcn();
      }
      break;
   case 6: tabBar()->setCurrentTab(2); break;
   case 7: tabBar()->setCurrentTab(3); break;
   case 8: tabBar()->setCurrentTab(4); break;
   }
   
}


//-----ICQFunctions::setBasicInfo-----------------------------------------------
void ICQFunctions::setBasicInfo(void)
{
   // info tab
   struct UserBasicInfo us;   
   m_cUser->getBasicInfo(us);
   nfoAlias->setData(us.alias);
   nfoStatus->setData(us.status);
   nfoFirstName->setData(us.firstname);
   nfoLastName->setData(us.lastname);
   nfoEMail->setData(us.email);
   nfoHistory->setData(us.history);
   nfoUin->setData(us.uin);
   nfoIp->setData(us.ip_port);
   chkAuthorization->setChecked(m_cUser->getAuthorization());

   sprintf(m_sBaseTitle, "%s (%s)", us.alias, us.name);
   setCaption(m_sBaseTitle);
   setIconText(us.alias);
}


//-----ICQFunctions::setExtInfo----------------------------------------------
void ICQFunctions::setExtInfo(void)
{
   struct UserExtInfo ud;   
   m_cUser->getExtInfo(ud);
   nfoCity->setData(ud.city);
   nfoState->setData(ud.state);
   unsigned short i = GetIndexByCountryCode(m_cUser->getCountryCode());
   if (i == COUNTRY_UNSPECIFIED)
      cmbCountry->setCurrentItem(0);
   else if (i == COUNTRY_UNKNOWN)
   {
      char c[64];
      m_nUnknownCountryCode = m_cUser->getCountryCode();
      sprintf(c, "Unknown (%d)", m_nUnknownCountryCode);
      cmbCountry->changeItem(c, 1);
      cmbCountry->setCurrentItem(1);
   }
   else  // known
      cmbCountry->setCurrentItem(i + 2);
   nfoPhone->setData(ud.phone);
   nfoAge->setData(ud.age);
   cmbSex->setCurrentItem(m_cUser->getSexNum());
   nfoHomepage->setData(ud.homepage);
   mleAboutMsg->setText(ud.about);
}


//-----ICQFunctions::tabSelected-------------------------------------------------------------------
void ICQFunctions::tabSelected(const char *tab)
{
   if (strcmp(tab, tabLabel[TAB_SEND]) == 0) 
   { 
      mleSend->setFocus();
      setApplyButton("Send");
      btnSave->hide();
      currentTab = TAB_SEND; 
   }
   else if (strcmp(tab, tabLabel[TAB_BASICINFO]) == 0) 
   { 
      setApplyButton("Update"); 
      btnSave->show();
      currentTab = TAB_BASICINFO; 
   }
   else if (strcmp(tab, tabLabel[TAB_READ]) == 0) 
   { 
      setApplyButton("Ok"); 
      btnSave->hide();
      currentTab = TAB_READ;
   }
   else if (strcmp(tab, tabLabel[TAB_DETAILINFO]) == 0) 
   { 
      setApplyButton("Update"); 
      btnSave->show();
      currentTab = TAB_DETAILINFO; 
   }
   else if (strcmp(tab, tabLabel[TAB_HISTORY]) == 0) 
   { 
      if (mleHistory->numLines() == 1) showHistory();  // if no history, then get it
      setApplyButton("Ok"); 
      btnSave->show();
      currentTab = TAB_HISTORY;
   }
   else 
   {
      setApplyButton("Ok");
   }
}


//-----ICQFunctions::user_addEvent----------------------------------------------
void ICQFunctions::user_addEvent(void)
{
   // if so then add the message to the read tab
   unsigned short i = m_cUser->getNumMessages() - 1;
   (void) new MsgViewItem(m_cUser->GetEvent(i), i, msgView);
}


//-----ICQFunctions::user_updateStats--------------------------------------------
void ICQFunctions::user_updateStatus(void)
{
   struct UserBasicInfo us;
   m_cUser->getBasicInfo(us);   
   nfoStatus->setData(us.status);
}


//-----ICQFunctions::printMessage-----------------------------------------------
void ICQFunctions::printMessage(QListViewItem *e)
{
  CUserEvent *m = ((MsgViewItem *)e)->msg;
  mleRead->clear();
  mleRead->append(m->Text());
  if (m->Command() == ICQ_CMDxTCP_START || m->Command() == ICQ_CMDxRCV_SYSxMSGxONLINE)
  {
    switch (m->SubCommand())
    {
    case ICQ_CMDxSUB_CHAT:  // accept or refuse a chat request
      (void) new CChatAcceptDlg(server, m_cUser, m->Sequence());
      break;
    case ICQ_CMDxSUB_FILE:  // accept or refuse a file transfer
      (void) new CFileAcceptDlg(server, m_cUser, (CEventFile *)m);
      break;
    case ICQ_CMDxSUB_URL:   // view a url
      if (server->getUrlViewer() != NULL && QueryUser(this, "View URL?", "Yes", "No") )
      {
        char szCmd[strlen(server->getUrlViewer()) + strlen(((CEventUrl *)m)->Url()) + 8];
        sprintf(szCmd, "%s %s &", server->getUrlViewer(), ((CEventUrl *)m)->Url());
        if (system(szCmd) == 0)
          gLog.Info("%sSpawning of external viewer (%s)\n%sfor URL \"%s\" successful.\n", 
                    L_TCPxSTR, server->getUrlViewer(), L_BLANKxSTR, ((CEventUrl *)m)->Url());
        else
          gLog.Error("%sView URL failed.\n", L_ERRORxSTR);
      }
      else 
        gLog.Warn("%sNot viewing URL \"%s\" (%s).\n", L_WARNxSTR, 
                  ((CEventUrl *)m)->Url(), 
                  server->getUrlViewer() == NULL ? "no viewer defined" : "rejected");
      break;
    case ICQ_CMDxSUB_REQxAUTH:
      if (QueryUser(this, "Authorize?", "Yes", "No")) 
        server->icqAuthorize( ((CEventAuth *)m)->Uin() );
      if (QueryUser(this, "Add?", "Yes", "No")) 
        server->usrAdd( ((CEventAuth *)m)->Uin(), NULL );
      break;
    } // switch
  }  // if
 
  short index = ((MsgViewItem *)e)->index;
  if (index >= 0)   // the message had not been seen yet
  {
     m_cUser->ClearEvent(index);
     msgView->markRead(index);
     emit signal_updatedUser();
  }
}


//-----ICQFunctions::save-------------------------------------------------------
void ICQFunctions::save()
{
  switch (currentTab)
  {
  case TAB_BASICINFO:
    saveBasicInfo();
    break;
  case TAB_DETAILINFO:
    saveExtInfo();
    break;
  case TAB_HISTORY:
    saveHistory();
    break;
  default:
    gLog.Warn("%sInternal error: ICQFunctions::save(): invalid tab - %s.\n", 
              L_WARNxSTR, currentTab);
    break;
  }
}


//-----ICQFunctions::saveBasicInfo----------------------------------------------
void ICQFunctions::saveBasicInfo()
{
   m_cUser->setEnableSave(false);
   m_cUser->setAlias(nfoAlias->text());
   m_cUser->setFirstName(nfoFirstName->text());
   m_cUser->setLastName(nfoLastName->text());
   m_cUser->setEmail(nfoEMail->text());
   m_cUser->setHistoryFile(nfoHistory->text());
   m_cUser->setAuthorization(chkAuthorization->isChecked());
   m_cUser->setEnableSave(true);
   m_cUser->saveBasicInfo();
}


//-----ICQFunctions::saveExtInfo---------------------------------------------
void ICQFunctions::saveExtInfo()
{
   m_cUser->setEnableSave(false);
   m_cUser->setCity(nfoCity->text());
   m_cUser->setState(nfoState->text());
   unsigned short i = cmbCountry->currentItem();
   if (i == 0) 
      m_cUser->setCountry(COUNTRY_UNSPECIFIED);
   else if (i == 1) 
      m_cUser->setCountry(m_nUnknownCountryCode);
   else
      m_cUser->setCountry(GetCountryCodeByIndex(i - 2));
   m_cUser->setAge(atol(nfoAge->text()));
   m_cUser->setSex(cmbSex->currentItem());
   m_cUser->setPhoneNumber(nfoPhone->text());
   m_cUser->setHomepage(nfoHomepage->text());
   m_cUser->setAbout((const char *)mleAboutMsg->text());
   m_cUser->setEnableSave(true);
   m_cUser->saveExtInfo();
}


//-----ICQFunctions::showHistory-------------------------------------------------------------------
void ICQFunctions::showHistory()
{
   if (m_cUser->history != NULL) 
   {
      m_cUser->history->close();
      if (!m_cUser->history->open(IO_ReadOnly))  // a serious error occured
      {
         mleHistory->setText("History is having problems: ");
         mleHistory->append(m_cUser->history->name());
         m_cUser->history->open(IO_Append | IO_WriteOnly);
         return;
      }
      int historyLen = m_cUser->history->size();
      char buf[historyLen + 1];
      m_cUser->history->readBlock(buf, historyLen);
      buf[historyLen] = '\0';
      mleHistory->setText(buf);
      mleHistory->goToEnd();
      m_cUser->history->close();
      m_cUser->history->open(IO_Append | IO_WriteOnly);
   }
}


//-----ICQFunctions::saveHistory-------------------------------------------------------------------
void ICQFunctions::saveHistory()
{
   if (m_cUser->history != NULL) 
   {
      m_cUser->history->close();
      m_cUser->history->open(IO_WriteOnly);
      m_cUser->history->writeBlock((const char *)mleHistory->text(), strlen((const char *)mleHistory->text()) );
      m_cUser->history->close();
      m_cUser->history->open(IO_Append | IO_WriteOnly);      
   }
}



//-----ICQFunctions::setSpoofed--------------------------------------------------------------------
void ICQFunctions::setSpoofed()
{
   if (chkSpoof->isChecked()) 
   {
      if (!QueryUser(this, "Spoofing messages is immoral and possibly illegal.\nIn clicking OK you absolve the author from any \nresponsibility for your actions.\nDo you want to continue?", 
                    "Ok", "Cancel")) 
      {
         chkSpoof->setChecked(false);
      }
   }
}


//-----ICQFunctions::specialFcn--------------------------------------------------------------------
void ICQFunctions::specialFcn(int theFcn)
{
   switch (theFcn) 
   {
   case 0:
      lblItem->hide();
      edtItem->hide();
      lblDescription->setText("Message:");
      mleSend->setEnabled(true);
      chkSendServer->setEnabled(true);
      break;   
   case 1:
      lblItem->setText("URL:");
      lblItem->show();
      edtItem->show();
      lblDescription->setText("Description:");
      mleSend->setEnabled(true);      
      chkSendServer->setEnabled(true);
      break;
   case 2:
      lblItem->hide();
      edtItem->hide();
      lblDescription->setText("Check Away Message");
      chkSendServer->setChecked(false);
      chkSendServer->setEnabled(false);
      mleSend->setEnabled(false);
      break;
   case 3:
      lblItem->hide();
      edtItem->hide();
      lblDescription->setText("Reason:");
      mleSend->setEnabled(true);
      chkSendServer->setChecked(false);
      chkSendServer->setEnabled(false);
      break;
   case 4:
      lblItem->setText("Filename:");
      lblItem->show();
      edtItem->show();
      lblDescription->setText("Description:");
      chkSendServer->setChecked(false);
      chkSendServer->setEnabled(false);
      mleSend->setEnabled(true);
      QString f = QFileDialog::getOpenFileName(NULL, NULL, this);
      if (!f.isNull()) edtItem->setText(f);
      break;
   }
}


//-----ICQFunctions::msg---------------------------------------------------------------------------
const char *ICQFunctions::msg(void)
{ 
   delete[] msgVal;
   msgVal = new char[strlen((const char *)mleSend->text()) + 1];
   strcpy(msgVal, (const char *)mleSend->text());
   return (msgVal);
}


//-----ICQFunctions::callFcn-----------------------------------------------------------------------
void ICQFunctions::callFcn()
{
   unsigned long uin;
   
   // disable user input
   btnApply->setEnabled(false);

   // do nothing if a command is already being processed
   if (icqEvent != NULL) return;

   switch (currentTab) 
   {
   case TAB_READ: hide(); return;
   case TAB_SEND:
      if (strlen(msg()) > MAX_MESSAGE_SIZE) 
      {
         char theWarning[1024];
         sprintf (theWarning, "Message is %d characters, over the ICQ limit of %d.  \nLicq and other clones support longer messages \nhowever Mirabilis clients will not.  Continue?", strlen(msg()), MAX_MESSAGE_SIZE);
         if(!QueryUser(this, theWarning, "Ok", "Cancel"))
         {
            btnApply->setEnabled(true);
            break;
         }
      }      
      uin = (chkSpoof->isChecked() ? atoi(edtSpoof->text()) : server->icqOwner.getUin());
      
      if (rdbMsg->isChecked())  // send a message
      {
         m_cUser->setSendServer(chkSendServer->isChecked());
         sprintf(m_sProgressMsg, "Sending msg %s...", (chkSendServer->isChecked() ? "server" : "direct"));
         icqEvent = server->sendMessage(m_cUser, msg(), (chkSendServer->isChecked() ? false : true), uin);
      }      
      else if (rdbAway->isChecked()) // check away message
      {
         strcpy(m_sProgressMsg, "Fetching...");
         m_cUser->setShowAwayMsg(true);
         icqEvent = server->sendReadAwayMsg(m_cUser, (chkSendServer->isChecked() ? false : true), uin);
      }
      else if (rdbUrl->isChecked()) // send URL
      {
         sprintf(m_sProgressMsg, "Sending URL %s...", (chkSendServer->isChecked() ? "server" : "direct"));
         icqEvent = server->sendUrl(m_cUser, (char *)edtItem->text(), msg(), (chkSendServer->isChecked() ? false : true), uin);            
      }
      else if (rdbChat->isChecked())   // send chat request
      {
         sprintf(m_sProgressMsg, "Sending chat request %s...", (chkSendServer->isChecked() ? "server" : "direct"));
         icqEvent = server->sendChat(m_cUser, msg(), (chkSendServer->isChecked() ? false : true), uin);
      }
      else if (rdbFile->isChecked())   // send file transfer
      {
         sprintf(m_sProgressMsg, "Sending file transfer %s...", (chkSendServer->isChecked() ? "server" : "direct"));
         icqEvent = server->sendFile(m_cUser, (char *)edtItem->text(), msg(), (chkSendServer->isChecked() ? false : true), uin);
      }
      
      if (icqEvent == NULL)
         doneFcn(false, NULL);

      break;
   case TAB_BASICINFO: 
      if ( (m_cUser == &(server->icqOwner)) && (!QueryUser(this, "Update local or server information?", "Local", "Server")) )
      {
         strcpy(m_sProgressMsg, "Updating server...");
         connect (server, SIGNAL(signal_doneUpdatePersonalBasicInfo(bool)), 
                  this, SLOT(doneUpdatePersonalBasicInfo(bool)));
         server->icqUpdatePersonalBasicInfo(nfoAlias->text(), 
                                            nfoFirstName->text(),
                                            nfoLastName->text(),
                                            nfoEMail->text(), 
                                            chkAuthorization->isChecked());
      }
      else
      {
         strcpy(m_sProgressMsg, "Updating...");
         connect (server, SIGNAL(signal_doneUserBasicInfo(bool, unsigned long)), this, SLOT(doneUserBasicInfo(bool, unsigned long)));
         server->icqGetUserBasicInfo(m_cUser);
      }
      break;
   case TAB_DETAILINFO:
      if ( (m_cUser == &(server->icqOwner)) && (!QueryUser(this, "Update local or server information?", "Local", "Server")) )
      {
         strcpy(m_sProgressMsg, "Updating server...");
         connect (server, SIGNAL(signal_doneUpdatePersonalExtInfo(bool)), this, SLOT(doneUpdatePersonalExtInfo(bool)));
         unsigned short i = cmbCountry->currentItem();
         unsigned short cc = ( i == 0 ? COUNTRY_UNSPECIFIED : (i == 1 ? m_nUnknownCountryCode : GetCountryCodeByIndex(i - 2)) );
         server->icqUpdatePersonalExtInfo(nfoCity->text(), cc,
                                          nfoState->text(), atol(nfoAge->text()),
                                          cmbSex->currentItem(), nfoPhone->text(),
                                          nfoHomepage->text(), mleAboutMsg->text());
      }
      else
      {
         strcpy(m_sProgressMsg, "Updating...");
         connect (server, SIGNAL(signal_doneUserExtInfo(bool, unsigned long)), this, SLOT(doneUserExtInfo(bool, unsigned long)));
         server->icqGetUserExtInfo(m_cUser);
      }
      break;
   case TAB_HISTORY: hide(); return;
   }
   
   char title[256];
   sprintf(title, "%s  [%s]", m_sBaseTitle, m_sProgressMsg);
   setCaption(title);
}


//-----ICQFunctions::doneFcn----------------------------------------------------
void ICQFunctions::doneFcn(bool isOk, ICQEvent *e)
{
  if (e != icqEvent) return;
  
  char title[256];
  sprintf(title, "%s  [%s%s]", m_sBaseTitle, m_sProgressMsg, isOk ? "done" : "failed");
  setCaption(title);
  btnApply->setEnabled(true);
  unsigned short theCmd = 0;
  if (e != NULL) theCmd = e->getCommand();
  icqEvent = NULL;
  
  if (isOk) 
  {
    if (theCmd == ICQ_CMDxTCP_START)
    {
      mleSend->clear(); 
      if (m_cUser->isAway() && m_cUser->ShowAwayMsg())
        (void) new ShowAwayMsgDlg(m_cUser);
    }
    if (chkAutoClose->isChecked()) 
      hide();
  }
  
}


void ICQFunctions::doneUserBasicInfo(bool isOk, unsigned long uin)
{
   if (uin != m_cUser->getUin()) return;
   
   char title[256];
   sprintf(title, "%s  [%s%s]", m_sBaseTitle, m_sProgressMsg,
           (isOk ? "done" : "failed"));
   setCaption(title);
   
   btnApply->setEnabled(true);   
   
   if (isOk) setBasicInfo();
}

void ICQFunctions::doneUserExtInfo(bool isOk, unsigned long uin)
{
   if (uin != m_cUser->getUin()) return;
   
   char title[256];
   sprintf(title, "%s  [%s%s]", m_sBaseTitle, m_sProgressMsg,
           (isOk ? "done" : "failed"));
   setCaption(title);

   btnApply->setEnabled(true);   
   
   if (isOk) setExtInfo();
}  


void ICQFunctions::doneUpdatePersonalBasicInfo(bool _bIsOk)
{
   char title[256];
   sprintf(title, "%s  [%s%s]", m_sBaseTitle, m_sProgressMsg,
           (_bIsOk ? "done" : "failed"));
   setCaption(title);
   
   btnApply->setEnabled(true);   
   
   if (_bIsOk) saveBasicInfo();
}


void ICQFunctions::doneUpdatePersonalExtInfo(bool _bIsOk)
{
   char title[256];
   sprintf(title, "%s  [%s%s]", m_sBaseTitle, m_sProgressMsg,
           (_bIsOk ? "done" : "failed"));
   setCaption(title);
   
   btnApply->setEnabled(true);   
   
   if (_bIsOk) saveExtInfo();
}


void ICQFunctions::hide()
{
   QDialog::hide();
   s_nX = x();
   s_nY = y();
   if (icqEvent != NULL) server->eventCancel(icqEvent);
   disconnect (server, SIGNAL(signal_doneUserFcn(bool, ICQEvent *)), this, SLOT(doneFcn(bool, ICQEvent *)));
   emit signal_finished(m_cUser);
   //delete this;
}


ICQFunctions::~ICQFunctions(void)
{
   delete[] msgVal;
} 
