#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <qpushbt.h>

#include "fileacceptdlg.h"
#include "filedlg.h"


CFileAcceptDlg::CFileAcceptDlg(ICQ *_xServer, ICQUser *_xUser,  
                               CEventFile *e,
                               QWidget *parent = 0, const char *name = 0) 
   : QWidget(parent, name)
{
   m_xServer = _xServer;
   m_xUser = _xUser;
   m_xEventFile = e->Copy();

   setGeometry(100, 100, 300, 130);
   QLabel *lblRefuse = new QLabel("Refusal Reason (if applicable):", this);
   lblRefuse->setGeometry(5, 5, 200, 20);
   mleRefuseMsg = new MLEditWrap(true, this);
   mleRefuseMsg->setGeometry(5, 30, 290, 50);
   
   QPushButton *btnAccept, *btnRefuse, *btnIgnore;
   btnAccept = new QPushButton( "Accept", this );
   btnAccept->setGeometry(10, 85, 80, 30 );
   connect( btnAccept, SIGNAL(clicked()), SLOT(accept()) );
   btnRefuse = new QPushButton( "Refuse", this );
   btnRefuse->setGeometry( 100, 85, 80, 30 );
   connect( btnRefuse, SIGNAL(clicked()), SLOT(refuse()) );
   btnIgnore = new QPushButton( "Ignore", this );
   btnIgnore->setGeometry(190, 85, 80, 30 );
   connect( btnIgnore, SIGNAL(clicked()), SLOT(ignore()) );   

   char title[128];
   sprintf(title, "Accept file transfer from %s?", m_xUser->getAlias());
   setCaption(title);

   show();
}


CFileAcceptDlg::~CFileAcceptDlg(void)
{
   delete m_xEventFile;
}


void CFileAcceptDlg::accept()
{
   unsigned short port;
   if (m_xServer->getTcpServerPort() != 0)   // assign the file port
   {
      unsigned short i = 0;
      while (i < 10 && m_xServer->getTcpPort(i)) i++;
      port = m_xServer->getTcpServerPort() + i + 1;
      m_xServer->setTcpPort(i, true);
   }
   else port = 0;
   CFileDlg *fileDlg = new CFileDlg(m_xUser, m_xServer->icqOwner.getAlias(),
                                    m_xEventFile->Filename(), 
                                    m_xEventFile->FileSize(), 
                                    true, port);
   if (fileDlg->getPort() != 0)
   {
      m_xServer->fileAccept(m_xUser, fileDlg->getPort(), m_xEventFile->Sequence());
      fileDlg->show();
   }
   else
      fileDlg->hide();

   hide();
   delete this;
}

void CFileAcceptDlg::refuse()
{
   m_xServer->fileRefuse(m_xUser, (const char *)mleRefuseMsg->text(), 
                         m_xEventFile->Sequence());
   hide();
   delete this;
}


void CFileAcceptDlg::ignore()
{
   // do nothing
   hide();
   delete this;
}

