#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <qpushbt.h>
#include "awaymsgdlg.h"


int AwayMsgDlg::s_nX = 100;
int AwayMsgDlg::s_nY = 100;


AwayMsgDlg::AwayMsgDlg(ICQOwner *theOwner, QWidget *parent = 0, const char *name = 0) : QDialog(parent, name)
{
   owner = theOwner;
   resize(300, 100);
   mleAwayMsg = new MLEditWrap(true, this);
   mleAwayMsg->setGeometry(5, 5, 290, 50);
   QPushButton *btnOk, *cancel;
   btnOk = new QPushButton( "Ok", this );
   btnOk->setGeometry(10, 60, 100, 30 );
   connect( btnOk, SIGNAL(clicked()), SLOT(ok()) );
   cancel = new QPushButton( "Cancel", this );
   cancel->setGeometry( 120, 60, 100, 30 );
   connect( cancel, SIGNAL(clicked()), SLOT(reject()) );
}


void AwayMsgDlg::show()
{
   char title[128];
   sprintf(title, "Set Away Message for %s:", owner->getAlias());
   setCaption(title);
   mleAwayMsg->setText(owner->getAwayMessage());
   setGeometry(s_nX, s_nY, width(), height());
   QDialog::show();
}

void AwayMsgDlg::hide()
{
  s_nX = x();
  s_nY = y();
  QDialog::hide();
}


void AwayMsgDlg::ok()
{
   char msg[4096];
   sprintf(msg, "%s", (const char *)mleAwayMsg->text()); 
   owner->setAwayMessage(msg);
   accept();
}
