/* libwmf (ipa/x.c): library for wmf conversion
   Copyright (C) 2000 - various; see CREDITS, ChangeLog, and sources

   The libwmf Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The libwmf Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the libwmf Library; see the file COPYING.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */


#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

/* If compiling as module, rename global functions to a standard
 */
#ifdef WMF_IPA_MODULE
#define wmf_x_device_open    wmf_device_open
#define wmf_x_device_close   wmf_device_close
#define wmf_x_device_begin   wmf_device_begin
#define wmf_x_device_end     wmf_device_end
#define wmf_x_flood_interior wmf_flood_interior
#define wmf_x_flood_exterior wmf_flood_exterior
#define wmf_x_draw_pixel     wmf_draw_pixel
#define wmf_x_draw_pie       wmf_draw_pie
#define wmf_x_draw_chord     wmf_draw_chord
#define wmf_x_draw_arc       wmf_draw_arc
#define wmf_x_draw_ellipse   wmf_draw_ellipse
#define wmf_x_draw_line      wmf_draw_line
#define wmf_x_poly_line      wmf_poly_line
#define wmf_x_draw_polygon   wmf_draw_polygon
#define wmf_x_draw_rectangle wmf_draw_rectangle
#define wmf_x_rop_draw       wmf_rop_draw
#define wmf_x_bmp_draw       wmf_bmp_draw
#define wmf_x_bmp_read       wmf_bmp_read
#define wmf_x_bmp_free       wmf_bmp_free
#define wmf_x_draw_text      wmf_draw_text
#define wmf_x_udata_init     wmf_udata_init
#define wmf_x_udata_copy     wmf_udata_copy
#define wmf_x_udata_set      wmf_udata_set
#define wmf_x_udata_free     wmf_udata_free
#define wmf_x_region_frame   wmf_region_frame
#define wmf_x_region_paint   wmf_region_paint
#define wmf_x_region_clip    wmf_region_clip
#endif /* WMF_IPA_MODULE */

#include "wmfdefs.h"

#ifdef X_DISPLAY_MISSING

void wmf_x_function (wmfAPI* API)
{	API->err = wmf_E_DeviceError;

	WMF_DEBUG (API,"No support for X");
}

#else /* X_DISPLAY_MISSING */ /* i.e., not */

#include <math.h>

#include "libwmf/x.h"

#include <X11/Xutil.h>
#include <X11/Xatom.h>

#include "ipa/x.h"
#include "ipa/x/bmp.h"
#include "ipa/x/color.h"
#include "ipa/x/device.h"
#include "ipa/x/draw.h"
#include "ipa/x/font.h"
#include "ipa/x/region.h"

void wmf_x_function (wmfAPI* API)
{	wmf_x_t* ddata = 0;

	wmfFunctionReference* FR = (wmfFunctionReference*) API->function_reference;

/* IPA function reference links
 */
	FR->device_open    = wmf_x_device_open;
	FR->device_close   = wmf_x_device_close;
	FR->device_begin   = wmf_x_device_begin;
	FR->device_end     = wmf_x_device_end;
	FR->flood_interior = wmf_x_flood_interior;
	FR->flood_exterior = wmf_x_flood_exterior;
	FR->draw_pixel     = wmf_x_draw_pixel;
	FR->draw_pie       = wmf_x_draw_pie;
	FR->draw_chord     = wmf_x_draw_chord;
	FR->draw_arc       = wmf_x_draw_arc;
	FR->draw_ellipse   = wmf_x_draw_ellipse;
	FR->draw_line      = wmf_x_draw_line;
	FR->poly_line      = wmf_x_poly_line;
	FR->draw_polygon   = wmf_x_draw_polygon;
	FR->draw_rectangle = wmf_x_draw_rectangle;
	FR->rop_draw       = wmf_x_rop_draw;
	FR->bmp_draw       = wmf_x_bmp_draw;
	FR->bmp_read       = wmf_x_bmp_read;
	FR->bmp_free       = wmf_x_bmp_free;
	FR->draw_text      = wmf_x_draw_text;
	FR->udata_init     = wmf_x_udata_init;
	FR->udata_copy     = wmf_x_udata_copy;
	FR->udata_set      = wmf_x_udata_set;
	FR->udata_free     = wmf_x_udata_free;
	FR->region_frame   = wmf_x_region_frame;
	FR->region_paint   = wmf_x_region_paint;
	FR->region_clip    = wmf_x_region_clip;

/* Allocate device data structure
 */
	ddata = (wmf_x_t*) wmf_malloc (API,sizeof (wmf_x_t));

	if (ERR (API))
	{	WMF_DEBUG (API,"bailing...");
		return;
	}

	API->device_data = (void*) ddata;

/* Device data defaults
 */
	ddata->display_name = 0;
	ddata->window_name = 0;
	ddata->icon_name = 0;

	ddata->display = 0;

	ddata->root = None;
	ddata->window = None;
	ddata->pixmap = None;
	ddata->hatch = None;
	ddata->brush = None;

	ddata->gc = 0;

	ddata->color = 0;

	ddata->bbox.TL.x = 0;
	ddata->bbox.TL.y = 0;
	ddata->bbox.BR.x = 0;
	ddata->bbox.BR.y = 0;

	ddata->flags = 0;
}

void wmf_x_udata_init (wmfAPI* API,wmfUserData_t* userdata)
{	/* wmf_x_t* ddata = WMF_X_GetData (API); */

	WMF_DEBUG (API,"wmf_[x_]udata_init");

}

void wmf_x_udata_copy (wmfAPI* API,wmfUserData_t* userdata)
{	/* wmf_x_t* ddata = WMF_X_GetData (API); */

	WMF_DEBUG (API,"wmf_[x_]udata_copy");

}

void wmf_x_udata_set (wmfAPI* API,wmfUserData_t* userdata)
{	/* wmf_x_t* ddata = WMF_X_GetData (API); */

	WMF_DEBUG (API,"wmf_[x_]udata_set");

}

void wmf_x_udata_free (wmfAPI* API,wmfUserData_t* userdata)
{	/* wmf_x_t* ddata = WMF_X_GetData (API); */

	WMF_DEBUG (API,"wmf_[x_]udata_free");

}

static void setbrushstyle (wmfAPI* API,wmfDC* dc)
{	wmf_x_t* ddata = WMF_X_GetData (API);

	wmfRGB pixel;

	wmfBrush* brush;

	int opacity;
	int fill_style;

	U16 i;
	U16 j;

	XGCValues values;

	brush = dc->brush;

	values.function = Our_XROPfunction[dc->ROPmode-1];

	if (values.function == GXinvert)
	{	values.function = GXxor;
		values.foreground = ddata->black;
	}
	else
	{	values.foreground = get_color (API,&(dc->brush->lbColor));
	}

	values.background = get_color (API,&(dc->bgcolor));

	switch (brush->lbStyle) /* TODO: these arrays are convenient but how SEG-safe are they? */
	{
	case BS_HATCHED:
		if (ddata->hatch != None) XFreePixmap (ddata->display,ddata->hatch);
		ddata->hatch = XCreateBitmapFromData (ddata->display,ddata->root,
		                                      HatchBrushes[brush->lbHatch],8,8);
		fill_style = ((dc->bgmode == TRANSPARENT) ? FillStippled : FillOpaqueStippled);
		XSetStipple (ddata->display,ddata->gc,ddata->hatch);
	break;

	case BS_DIBPATTERN:
		setdefaultstyle (API);

		if (ddata->brush != None)
		{	XFreePixmap (ddata->display,ddata->brush);
			ddata->brush = None;
		}
		if (dc->brush->bmp.data == 0)
		{	fill_style = FillSolid;
			break;
		}
		ddata->brush = XCreatePixmap (ddata->display,ddata->root,
		                              dc->brush->bmp.width,dc->brush->bmp.height,ddata->depth);
		if (ddata->brush == None)
		{	fill_style = FillSolid;
			break;
		}

		for (j = 0; j < dc->brush->bmp.height; j++)
		{	for (i = 0; i < dc->brush->bmp.width; i++)
			{	opacity = wmf_ipa_bmp_color (API,&(dc->brush->bmp),&pixel,i,j);

				XSetForeground (ddata->display,ddata->gc,get_color (API,&pixel));

				XDrawPoint (ddata->display,ddata->brush,ddata->gc,i,j);
			}
		}

		XSetTile (ddata->display,ddata->gc,ddata->brush);
		fill_style = FillTiled;
	break;

	case BS_NULL:
	case BS_SOLID:
	case BS_PATTERN:
	default:
		fill_style = FillSolid;
	break;
	}

	XSetFillStyle (ddata->display,ddata->gc,fill_style);

	switch (dc->polyfillmode)
	{
	case ALTERNATE:
		values.fill_rule = EvenOddRule;
	break;

	case WINDING:
		values.fill_rule = WindingRule;
	break;

	default:
		values.fill_rule = EvenOddRule;
	break;
	}

	XChangeGC (ddata->display,ddata->gc,GCFunction|GCForeground|GCBackground|GCFillRule,&values);
}

static void setlinestyle (wmfAPI* API,wmfDC* dc)
{	wmf_x_t* ddata = WMF_X_GetData (API);

	wmfPen* pen;

	unsigned long color;

	char* dashes;

	int dash_len;

	XGCValues values;

	pen = dc->pen;

	color = get_color (API,&(dc->pen->lopnColor));

	switch (dc->ROPmode)
	{
	case R2_BLACK:
		values.foreground = ddata->black;
		values.function = GXcopy;
	break;

	case R2_WHITE:
		values.foreground = ddata->white;
		values.function = GXcopy;
	break;

	case R2_XORPEN:
		values.foreground = color; /* It is very unlikely someone wants to XOR with 0 */
		                           /* This fixes the rubber-drawings in paintbrush    */
		if (values.foreground == 0) values.foreground = ((ddata->white) ? ddata->white : ddata->black);
		values.function = GXxor;
	break;

	default:
		values.foreground = color;
		values.function = Our_XROPfunction[dc->ROPmode-1];
	break;
	}

	switch (dc->pen->lopnStyle & PS_STYLE_MASK)
	{
	case PS_DASH:
		dashes = (char*) PEN_dash;
		dash_len = 2;
		values.line_style = ((dc->bgmode == TRANSPARENT) ? LineOnOffDash : LineDoubleDash);
	break;

	case PS_DOT:
		dashes = (char*) PEN_dot;
		dash_len = 2;
		values.line_style = ((dc->bgmode == TRANSPARENT) ? LineOnOffDash : LineDoubleDash);
	break;

	case PS_DASHDOT:
		dashes = (char*) PEN_dashdot;
		dash_len = 4;
		values.line_style = ((dc->bgmode == TRANSPARENT) ? LineOnOffDash : LineDoubleDash);
	break;

	case PS_DASHDOTDOT:
		dashes = (char*) PEN_dashdotdot;
		dash_len = 6;
		values.line_style = ((dc->bgmode == TRANSPARENT) ? LineOnOffDash : LineDoubleDash);
	break;

	case PS_ALTERNATE: /* FIXME: should be alternating _pixels_ that are set */
		dashes = (char*) PEN_alternate;
		dash_len = 2;
		values.line_style = ((dc->bgmode == TRANSPARENT) ? LineOnOffDash : LineDoubleDash);
	break;

	case PS_USERSTYLE: /* FIXME */
	default:
		dashes = 0;
		dash_len = 2;
		values.line_style = LineSolid;
	break;
	}

	values.fill_style = FillSolid;

	values.line_width = (int) ceil ( (double) x_width  (API,dc->pen->width )
	                               + (double) x_height (API,dc->pen->height));

	if (values.line_width < 1) values.line_width = 1;

	switch (pen->lopnStyle & PS_ENDCAP_MASK)
	{
	case PS_ENDCAP_SQUARE:
		values.cap_style = CapProjecting;
	break;

	case PS_ENDCAP_FLAT:
		values.cap_style = CapButt;
	break;

	case PS_ENDCAP_ROUND:
	default:
		values.cap_style = CapRound;
	break;
	}

	switch (pen->lopnStyle & PS_JOIN_MASK)
	{
	case PS_JOIN_BEVEL:
		values.join_style = JoinBevel;
	break;

	case PS_JOIN_MITER:
		values.join_style = JoinMiter;
	break;

	case PS_JOIN_ROUND:
	default:
		values.join_style = JoinRound;
	break;
	}

	if (dashes) XSetDashes (ddata->display,ddata->gc,0,dashes,dash_len);

	values.background = get_color (API,&(dc->bgcolor));

	XChangeGC (ddata->display,ddata->gc,
	           GCFunction | GCForeground | GCLineStyle | GCLineWidth |
	           GCCapStyle | GCBackground | GCJoinStyle | GCFillStyle,
	           &values);
}

static void setdefaultstyle (wmfAPI* API)
{	wmf_x_t* ddata = WMF_X_GetData (API);

	XGCValues values;

	values.function = GXcopy;

	values.foreground = ddata->black;
	values.background = ddata->white;

	values.fill_style = FillSolid;
	values.fill_rule = EvenOddRule;

	values.cap_style = CapRound;
	values.join_style = JoinRound;
	values.line_style = LineSolid;
	values.line_width = 1;

	XChangeGC (ddata->display,ddata->gc,
	           GCFunction | GCForeground | GCLineStyle | GCJoinStyle |
	           GCCapStyle | GCBackground | GCLineWidth | GCFillStyle | GCFillRule,
	           &values);
}

#endif /* X_DISPLAY_MISSING */
