/* libwmf ("ipa/fig/draw.h"): library for wmf conversion
   Copyright (C) 2000 - various; see CREDITS, ChangeLog, and sources

   The libwmf Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The libwmf Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the libwmf Library; see the file COPYING.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */


void wmf_fig_flood_interior (wmfAPI* API,wmfFlood_t* flood)
{	/* wmf_fig_t* ddata = WMF_FIG_GetData (API); */

	WMF_DEBUG (API,"~~~~~~~~wmf_[fig_]flood_interior");

	if (API->flags & WMF_OPT_IGNORE_NONFATAL)
	{	WMF_DEBUG (API,"flood_interior unsupported.");
	}
	else
	{	WMF_ERROR (API,"flood_interior unsupported.");
		API->err = wmf_E_Glitch;
	}
}

void wmf_fig_flood_exterior (wmfAPI* API,wmfFlood_t* flood)
{	/* wmf_fig_t* ddata = WMF_FIG_GetData (API); */

	WMF_DEBUG (API,"~~~~~~~~wmf_[fig_]flood_exterior");

	if (API->flags & WMF_OPT_IGNORE_NONFATAL)
	{	WMF_DEBUG (API,"flood_exterior unsupported.");
	}
	else
	{	WMF_ERROR (API,"flood_exterior unsupported.");
		API->err = wmf_E_Glitch;
	}
}

void wmf_fig_draw_pixel (wmfAPI* API,wmfDrawPixel_t* draw_pixel)
{	wmf_fig_t* ddata = WMF_FIG_GetData (API);

	float red;
	float green;
	float blue;

	FILE* out = ddata->out;

	WMF_DEBUG (API,"~~~~~~~~wmf_[fig_]draw_pixel");

	if (out == 0) return;

	red   = (float) ((int) draw_pixel->color.r) / 255;
	green = (float) ((int) draw_pixel->color.g) / 255;
	blue  = (float) ((int) draw_pixel->color.b) / 255;

	fprintf (out,"newpath %f %f moveto ",draw_pixel->pt.x,draw_pixel->pt.y);
	fprintf (out,"%f dup neg exch 0 rlineto 0 %f rlineto 0 rlineto ",
	         (float) draw_pixel->pixel_width,
	         (float) draw_pixel->pixel_height);

	fprintf (out,"closepath %f %f %f setrgbcolor fill\n",red,green,blue);
}

void wmf_fig_draw_pie (wmfAPI* API,wmfDrawArc_t* draw_arc)
{	wmf_fig_t* ddata = WMF_FIG_GetData (API);

	FILE* out = ddata->out;
	
	WMF_DEBUG (API,"~~~~~~~~wmf_[fig_]draw_pie");

	fprintf(out, "# wmf_[fig_]draw_pie\n");
	
	wmf_draw_arc(API, draw_arc, 0);
	
	fprintf(out, "# draw_pie not impl\n");

	
}

void wmf_fig_draw_chord (wmfAPI* API,wmfDrawArc_t* draw_arc)
{	wmf_fig_t* ddata = WMF_FIG_GetData (API);

	FILE* out = ddata->out;
	
	WMF_DEBUG (API,"~~~~~~~~wmf_[fig_]draw_chord");

	fprintf(out, "# draw_chord not impl\n");
	
	
}

void wmf_fig_draw_arc (wmfAPI* API,wmfDrawArc_t* draw_arc)
{	wmf_fig_t* ddata = WMF_FIG_GetData (API);

	FILE* out = ddata->out;
	
	WMF_DEBUG (API,"~~~~~~~~wmf_[fig_]draw_arc");

	fprintf(out, "# wmf_[fig_]draw_arc\n");
	
	wmf_draw_arc(API, draw_arc, 1);
	
	fprintf(out, "# end draw_arc\n");
	
}

void wmf_draw_arc (wmfAPI* API,wmfDrawArc_t* draw_arc, int sub_type)
{	wmf_fig_t* ddata = WMF_FIG_GetData (API);

	float style_val;
	int line_style,thickness,pen_color, fill_color,
		pen_style,area_fill,direction, forward_arrow, backward_arrow;
	int Ox,Oy;
	int cap_style;
	float start_x, start_y;
	float end_x, end_y;
	float mid_x, mid_y;

	float rad, start, end, mid;
	
	FILE* out = ddata->out;

	fprintf(out, "# wmf_draw_arc\n");

	start_x = (float) draw_arc->start.x;
	start_y = (float) draw_arc->start.y;
	end_x   = (float) draw_arc->end.x;
	end_y   = (float) draw_arc->end.y;

	pen_style = 0;
	thickness  = 1 + (draw_arc->dc->pen->height * 80) / atoi(ddata->figunit);
	ddata->depth -= ddata->ddec;
	
	line_style = setlinestyle(draw_arc->dc->pen);
	area_fill = setbrushstyle(API,draw_arc->dc->brush);

	style_val = 5.0;
	direction = 0;

	cap_style  = setcapstyle(draw_arc->dc->pen);
	forward_arrow  = 0;
	backward_arrow = 0;

	/* origin: */
	Ox = ((draw_arc->BR.x + draw_arc->TL.x) / 2); 
	Oy = ((draw_arc->BR.y + draw_arc->TL.y) / 2);

	/* long axis */
	rad = (float) ((draw_arc->BR.x - draw_arc->TL.x) / 2);
	/*
	start_y = sqrt(rad * rad - start_x * start_x);
	if (draw_arc->start.y < 0) start_y = - start_y;
	end_y   = sqrt(rad * rad - end_x * end_x);
	if (draw_arc->end.y < 0) end_y = - end_y;
	*/
	start = atan2(start_y, start_x);
	end = atan2(end_y, end_x);
	/* rad = sqrt(start_x*start_x + start_y*start_y); */

	/* Construct middle point: */
	if (end < start) end += M_2PI;
	mid = 0.5 * (start + end);

	mid_x = Ox + (rad * cos(mid));
	mid_y = Oy + (rad * sin(mid));

	/* Shift to origin: */
	start_x = Ox + start_x;
	start_y = Oy + start_y;
	end_x = Ox + end_x;
	end_y = Oy + end_y;
	
	pen_color = fig_find_color(draw_arc->dc->pen->lopnColor);
	fill_color = fig_find_color(draw_arc->dc->brush->lbColor);
	fig_handle_patterns(area_fill, &pen_color, &fill_color, &thickness);

	fprintf(out, 
	  "%d %d %d %d %d %d %d %d %d %f %d %d %d %d %f %f %d %d %d %d %d %d\n", 
	  O_ARC, sub_type, line_style, thickness, pen_color,
	  fill_color, ddata->depth, pen_style, area_fill, style_val, cap_style,
	  direction, forward_arrow, backward_arrow, (float) Ox, (float) Oy, 
	  (int)start_x, (int)start_y, (int)mid_x,(int)mid_y, (int)end_x, (int)end_y);
	
	WMF_DEBUG (API,"~~~~~~~~wmf_draw_arc");

}

void wmf_fig_draw_ellipse (wmfAPI* API,wmfDrawArc_t* draw_arc)
{	wmf_fig_t* ddata = WMF_FIG_GetData (API);

	float style_val, angle;
	int sub_type,line_style,thickness,pen_color, fill_color,
		pen_style,area_fill,direction;
	int Ox,Oy;
	int a,b;
	int start_x, start_y;
	int end_x, end_y;
	
	FILE* out = ddata->out;
	
	WMF_DEBUG (API,"~~~~~~~~wmf_[fig_]draw_ellipse");

	fprintf(out, "# wmf_[fig_]draw_ellipse\n");

	pen_style = 0;
	sub_type = 1;
	thickness  = 1 + (draw_arc->dc->pen->height * 80) / atoi(ddata->figunit);
	ddata->depth -= ddata->ddec;

	
	line_style = setlinestyle(draw_arc->dc->pen);
	area_fill = setbrushstyle(API,draw_arc->dc->brush);

	style_val = 5.0;
	direction = 1;
	angle = 0.0;

	/* origin of ellipse */
	Ox = (int) ((draw_arc->BR.x + draw_arc->TL.x) / 2); 
	Oy = (int) ((draw_arc->BR.y + draw_arc->TL.y) / 2);

      	/* axes of ellipse */
	a = (int) ((draw_arc->BR.x - draw_arc->TL.x) / 2);
	b = (int) ((draw_arc->BR.y - draw_arc->TL.y) / 2);

	pen_color = fig_find_color(draw_arc->dc->pen->lopnColor);
	fill_color = fig_find_color(draw_arc->dc->brush->lbColor);
	fig_handle_patterns(area_fill, &pen_color, &fill_color, &thickness);

	fprintf(out, 
	  "%d %d %d %d %d %d %d %d %d %f %d %f %d %d %d %d %d %d %d %d\n", 
	  O_ELLIPSE, sub_type, line_style, thickness, pen_color,
	  fill_color, ddata->depth, pen_style, area_fill, style_val,
	  direction, angle, Ox, Oy, a, b, Ox, Oy, (Ox + a), (Oy + b));
	
	fprintf(out, "# end draw_ellipse\n");

}

void wmf_fig_draw_line (wmfAPI* API,wmfDrawLine_t* draw_line)
{	wmf_fig_t* ddata = WMF_FIG_GetData (API);

	float linewidth;

	double stretch;

	int line_style, thickness, pen_color, fill_color, pen_style, area_fill;
	float style_val;
	int join_style, cap_style, radius, forward_arrow, backward_arrow, npoints;
	
	FILE* out = ddata->out;

	WMF_DEBUG (API,"~~~~~~~~wmf_[fig_]draw_line");

	if (out == 0) return;

	if (TO_DRAW (draw_line))
	{	linewidth = (float) draw_line->dc->pen->height;
		stretch = draw_line->dc->pen->width / draw_line->dc->pen->height;

		fputs ("# wmf_[fig_]draw_line\n",out);

		pen_style = 0;
		thickness  = 1 + (draw_line->dc->pen->height * 80) / atoi(ddata->figunit);
		ddata->depth -= ddata->ddec;

		line_style = setlinestyle(draw_line->dc->pen);
		area_fill = setbrushstyle(API,draw_line->dc->brush);

		style_val = 5.0;

		join_style = setjoinstyle(draw_line->dc->pen);
		cap_style  = setcapstyle(draw_line->dc->pen);

		radius = 5;
		forward_arrow = 0;
		backward_arrow = 0;
		npoints = 2;

		pen_color = fig_find_color(draw_line->dc->pen->lopnColor);
		fill_color = fig_find_color(draw_line->dc->brush->lbColor);

		/* fprintf (out,"%f 1 scale ",stretch); */
		fprintf(out, "%d %d %d %d %d %d %d %d %d %f %d %d %d %d %d %d\n",\
			O_POLYLINE, T_POLYLINE, line_style, thickness, pen_color, fill_color,\
			ddata->depth, pen_style, area_fill, style_val, join_style, cap_style, radius,\
			forward_arrow, backward_arrow, npoints);

		fprintf (out,"%d %d\n%d %d\n",
		         (int) draw_line->from.x, (int) draw_line->from.y,
		         (int) draw_line->to.x,   (int) draw_line->to.y  );

		fputs ("# end draw_line\n",out);
	}
}

void wmf_fig_poly_line (wmfAPI* API,wmfPolyLine_t* poly_line)
{	wmf_fig_t* ddata = WMF_FIG_GetData (API);

	U16 i;
	U16 sub_length;
	U16 sub_count;

	float linewidth;

	int line_style, thickness, pen_color, fill_color, pen_style, area_fill;
	float style_val;
	int join_style, cap_style, radius, forward_arrow, backward_arrow, npoints;
	double stretch;

	wmfPolyLine_t sub_line;

	FILE* out = ddata->out;

	WMF_DEBUG (API,"~~~~~~~~wmf_[fig_]poly_line");

	if (out == 0) return;

	if (poly_line->count > 500)
	{	sub_length = poly_line->count / (1 + poly_line->count / 500);
		sub_count = 0;

		sub_line.dc = poly_line->dc;
		sub_line.pt = poly_line->pt;

		while (poly_line->count > sub_count + 1)
		{	sub_line.count = MIN (sub_length,poly_line->count - sub_count);

			wmf_fig_poly_line (API,&sub_line);
			sub_line.pt += sub_line.count - 1;
			sub_count += sub_line.count - 1;
		}
	}
	else if ((poly_line->count > 1) && TO_DRAW (poly_line))
	{	linewidth = (float) poly_line->dc->pen->height;
		stretch = poly_line->dc->pen->width / poly_line->dc->pen->height;

		pen_style = 0;
		thickness  = 1 + (poly_line->dc->pen->height * 80) / atoi(ddata->figunit);
		ddata->depth -= ddata->ddec;

		line_style = setlinestyle(poly_line->dc->pen);
		/* area_fill = setbrushstyle(API,poly_line->dc->brush); */
		area_fill = -1;

		join_style = setjoinstyle(poly_line->dc->pen);
		cap_style  = setcapstyle(poly_line->dc->pen);

		radius = 5;
		forward_arrow = 0;
		backward_arrow = 0;
		pen_color = fig_find_color(poly_line->dc->pen->lopnColor);
		fill_color = fig_find_color(poly_line->dc->brush->lbColor);
					
		fputs ("# wmf_[fig_]poly_line\n",out);
		
		fprintf(out, "%d %d %d %d %d %d %d %d %d %f %d %d %d %d %d %d\n",\
			O_POLYLINE, T_POLYLINE, line_style, thickness, pen_color, fill_color,\
			ddata->depth, pen_style, area_fill, style_val, join_style, cap_style, radius,\
			forward_arrow, backward_arrow, poly_line->count);


		/* fprintf (out,"%f 1 scale\n",stretch); */

		/* Output co-ordinate pairs: */
		for (i = 0; i < poly_line->count; i++)
		{	
			fprintf (out,"%d %d\n",
			         (int) poly_line->pt[poly_line->count-1-i].x,
			         (int) poly_line->pt[poly_line->count-1-i].y);
		}

		fputs ("# end poly_line\n",out);
	}
}

void wmf_fig_draw_polygon (wmfAPI* API,wmfPolyLine_t* poly_line)
{	wmf_fig_t* ddata = WMF_FIG_GetData (API);

	U16 i;

	int line_style, thickness, pen_color, fill_color, pen_style, area_fill;
	float style_val;
	int join_style, cap_style, radius, forward_arrow, backward_arrow, npoints;
	
	FILE* out = ddata->out;

	wmfD_Rect bbox;

	WMF_DEBUG (API,"~~~~~~~~wmf_[fig_]draw_polygon");

	if (out == 0) return;

	if (poly_line->count > 500)
	{	if (API->flags & WMF_OPT_IGNORE_NONFATAL)
		{	WMF_DEBUG (API,"Too many points on polygon!");
		}
		else
		{	WMF_ERROR (API,"Too many points on polygon!");
			API->err = wmf_E_Glitch;
		}
	}
	else if (poly_line->count > 2)
	{	
		pen_style = 0;
		ddata->depth -= ddata->ddec;
		
		line_style = setlinestyle(poly_line->dc->pen);
		area_fill = setbrushstyle(API,poly_line->dc->brush);
		
		join_style = setjoinstyle(poly_line->dc->pen);
		cap_style = setcapstyle(poly_line->dc->pen);

		radius = 5;
		forward_arrow = 0;
		backward_arrow = 0;

		pen_color = fig_find_color(poly_line->dc->pen->lopnColor);
		fill_color = fig_find_color(poly_line->dc->brush->lbColor);
		thickness  = (poly_line->dc->pen->height * 80) / atoi(ddata->figunit);

		if (TO_FILL (poly_line))
		{	

			fig_handle_patterns(area_fill, &pen_color, &fill_color, &thickness);
			
			bbox.TL.x = poly_line->pt[0].x;
			bbox.TL.y = poly_line->pt[0].y;
			bbox.BR.x = poly_line->pt[0].x;
			bbox.BR.y = poly_line->pt[0].y;

			fputs ("# wmf_[fig_]draw_polygon\n",out);

			fprintf(out, "%d %d %d %d %d %d %d %d %d %f %d %d %d %d %d %d\n",\
			  O_POLYLINE, T_POLYGON, line_style, thickness, pen_color, fill_color,\
			  ddata->depth, pen_style, area_fill, style_val, join_style, cap_style, radius,\
			  forward_arrow, backward_arrow, poly_line->count + 1);


			for (i = 0; i < poly_line->count; i++)
			{	
				fprintf (out,"%d %d\n",
					(int) poly_line->pt[i].x,
					(int) poly_line->pt[i].y); 

				if (bbox.TL.x > poly_line->pt[i].x) bbox.TL.x = poly_line->pt[i].x;
				if (bbox.TL.y > poly_line->pt[i].y) bbox.TL.y = poly_line->pt[i].y;
				if (bbox.BR.x < poly_line->pt[i].x) bbox.BR.x = poly_line->pt[i].x;
				if (bbox.BR.y < poly_line->pt[i].y) bbox.BR.y = poly_line->pt[i].y;
			}

			fprintf (out,"%d %d\n",
				(int) poly_line->pt[0].x,
				(int) poly_line->pt[0].y); 
			
			fputs ("# end draw_polygon\n",out);
		}
		if (TO_DRAW (poly_line))
		{	
			area_fill = -1;
			thickness += 1;
			
			fputs ("# wmf_[fig_]draw_polygon\n",out);

			/* fprintf (out,"%f 1 scale\n",stretch); */

			fprintf(out, "%d %d %d %d %d %d %d %d %d %f %d %d %d %d %d %d\n",\
				O_POLYLINE, T_POLYGON, line_style, thickness, pen_color, fill_color,\
				ddata->depth, pen_style, area_fill, style_val, join_style, cap_style, radius,\
				forward_arrow, backward_arrow, poly_line->count + 1);

			for (i = 0; i < poly_line->count; i++)
			{	fprintf (out,"%d %d\n",
					(int) poly_line->pt[poly_line->count-1-i].x,
					(int) poly_line->pt[poly_line->count-1-i].y);
			}
			fprintf (out,"%d %d\n",
			 	(int) poly_line->pt[poly_line->count-1].x,
			 	(int) poly_line->pt[poly_line->count-1].y);
			
			fputs ("# end draw_polygon\n",out);
		}
	}
}

void wmf_fig_draw_rectangle (wmfAPI* API,wmfDrawRectangle_t* draw_rect)
{	wmf_fig_t* ddata = WMF_FIG_GetData (API);

	int line_style, thickness, pen_color, fill_color, pen_style, area_fill;
	float style_val;
	int join_style, cap_style, radius, forward_arrow, backward_arrow, npoints;
	
	FILE* out = ddata->out;

	wmfD_Rect bbox;

	WMF_DEBUG (API,"~~~~~~~~wmf_[fig_]draw_rectangle");

	if (out == 0) return;

	thickness  = (draw_rect->dc->pen->height * 80) / atoi(ddata->figunit);
	pen_style = 0;

	ddata->depth -= ddata->ddec;

	line_style = setlinestyle(draw_rect->dc->pen);
	area_fill = setbrushstyle(API,draw_rect->dc->brush);

	style_val = 5.0;

	join_style = setjoinstyle(draw_rect->dc->pen);
	cap_style = setcapstyle(draw_rect->dc->pen);

	radius = 5;
	forward_arrow = 0;
	backward_arrow = 0;

	pen_color = fig_find_color(draw_rect->dc->pen->lopnColor);
	fill_color = fig_find_color(draw_rect->dc->brush->lbColor);
	
	if (TO_FILL (draw_rect))
	{	bbox.TL = draw_rect->TL;
		bbox.BR = draw_rect->BR;
	
		fputs ("# wmf_[fig_]draw_rectangle\n",out);

		fig_handle_patterns(area_fill, &pen_color, &fill_color, &thickness);	

		fprintf(out, "%d %d %d %d %d %d %d %d %d %f %d %d %d %d %d %d\n",\
			O_POLYLINE, T_BOX, line_style, thickness, pen_color, fill_color,\
			ddata->depth, pen_style, area_fill, style_val, join_style, cap_style, radius,\
			forward_arrow, backward_arrow, 5);

		fprintf (out,"%d %d\n%d %d\n%d %d\n%d %d\n%d %d\n",
		         (int) draw_rect->TL.x, (int) draw_rect->TL.y,
		         (int) draw_rect->TL.x, (int) draw_rect->BR.y,
		         (int) draw_rect->BR.x, (int) draw_rect->BR.y,
		         (int) draw_rect->BR.x, (int) draw_rect->TL.y,
		         (int) draw_rect->TL.x, (int) draw_rect->TL.y);

		fputs ("# end draw_rectangle\n",out);
	}
	if (TO_DRAW (draw_rect))
	{	
		area_fill = -1;
		thickness += 1;
		
		fputs ("# wmf_[fig_]draw_rectangle\n",out);

		/* fprintf (out,"%f 1 scale ",stretch); */
		fprintf(out, "%d %d %d %d %d %d %d %d %d %f %d %d %d %d %d %d\n",\
			O_POLYLINE, T_BOX, line_style, thickness, pen_color, fill_color,\
			ddata->depth, pen_style, area_fill, style_val, join_style, cap_style, radius,\
			forward_arrow, backward_arrow, 5);


		fprintf (out,"%d %d\n%d %d\n%d %d\n%d %d\n %d %d\n",
		         (int) draw_rect->TL.x, (int) draw_rect->TL.y,
		         (int) draw_rect->TL.x, (int) draw_rect->BR.y,
		         (int) draw_rect->BR.x, (int) draw_rect->BR.y,
		         (int) draw_rect->BR.x, (int) draw_rect->TL.y,
		         (int) draw_rect->TL.x, (int) draw_rect->TL.y);

		fputs ("# end draw_rectangle\n",out);
	}
}
