/* libwmf ("ipa/fig/device.h"): library for wmf conversion
   Copyright (C) 2000 - various; see CREDITS, ChangeLog, and sources

   The libwmf Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The libwmf Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the libwmf Library; see the file COPYING.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */


/* This is called by wmf_play() the *first* time the meta file is played
 */
void wmf_fig_device_open (wmfAPI* API)
{	wmf_fig_t* ddata = WMF_FIG_GetData (API);

	WMF_DEBUG (API,"~~~~~~~~wmf_[fig_]device_open");

	if (ddata->out) ddata->offset = ftell (ddata->out);
}

/* This is called by wmf_api_destroy()
 */
void wmf_fig_device_close (wmfAPI* API)
{	wmf_fig_t* ddata = WMF_FIG_GetData (API);

	WMF_DEBUG (API,"~~~~~~~~wmf_[fig_]device_close");

	if (ddata->out) fflush (ddata->out);
}

/* This is called from the beginning of each play for initial page setup
 */
void wmf_fig_device_begin (wmfAPI* API)
{	wmf_fig_t* ddata = WMF_FIG_GetData (API);

	FILE* out = ddata->out;

	float Ox;
	float Oy;

	float xScale;
	float yScale;
	
	int i;
	
	int zero;
	int colno;
	char clr[10];
	char c;

	time_t t;

	float fu;
	
    wmfColorData* color = (wmfColorData*) API->color_data;
	
	WMF_DEBUG (API,"~~~~~~~~wmf_[fig_]device_begin");

	if (out == 0) return;

	if ((ddata->bbox.BR.x <= ddata->bbox.TL.x) || (ddata->bbox.BR.y <= ddata->bbox.TL.y))
	{	WMF_ERROR (API,"~~~~~~~~wmf_[fig_]device_begin: bounding box has null or negative size!");
		API->err = wmf_E_Glitch;
		return;
	}

	if ((ddata->fig_width == 0) || (ddata->fig_height == 0))
	{	ddata->fig_width  = 
			(unsigned int) ceil (ddata->bbox.BR.x - ddata->bbox.TL.x);
		ddata->fig_height = 
			(unsigned int) ceil (ddata->bbox.BR.y - ddata->bbox.TL.y);
	}

	/* Scale figure to screen size */
	
	if (strcmp(ddata->figunit,"1200") == 0)
		{
		if (ddata->fig_width < ddata->fig_height) 
			fu = (float) ddata->fig_height / 8.0;
		else
			fu = (float) ddata->fig_width / 8.0;
		ddata->figunit = (char*) malloc(5);
		snprintf(ddata->figunit, 5, "%4u", (unsigned int) fu); 
		};

	if (out && (ddata->offset >= 0)) fseek (out,ddata->offset,SEEK_SET);

	fig_std_colors();

	ddata->depth = 999;
	
	fputs ("#FIG 3.2\n",out);
	if (ddata->flags & WMF_FIG_LANDSCAPE) fputs ("Landscape\n",out);
	else                                  fputs ("Portrait\n" ,out);
	fputs ("Center\n",out);
	fputs ("Metric\n",out);
	fprintf (out,"%s\n",ddata->page_format);
	fputs ("100.0\n",out);
	fputs ("Single\n",out);
	fputs ("-2\n", out);
	fprintf (out, "%s 2\n", ddata->figunit);

	if (ddata->Title)
	{	fputs ("# Title: ",out);
		fprintf (out,"%s\n",ddata->Title);
	}
	if (ddata->Creator)
	{	fputs ("# Creator: ",out);
		fprintf (out,"%s\n",ddata->Creator);
	}
	if (ddata->Date)
	{	fputs ("# Date: ",out);
		fprintf (out,"%s\n",ddata->Date);
	}
	else 
	{	t = time();
		fprintf (out, "# Date: %s", ctime(&t));
	}
	if (ddata->For)
	{	fputs ("# For: ",out);
		fprintf (out,"%s\n",ddata->For);
	}

	for (i = 0; i< color->count; i++) 
	{
		fig_find_color(color->rgb [i]);
	}
	/* Write colour pseudo-objects to file */
	fig_color_to_file (out);
	
}

/* This is called from the end of each play for page termination
 */
void wmf_fig_device_end (wmfAPI* API)
{	wmf_fig_t* ddata = WMF_FIG_GetData (API);

	FILE* out = ddata->out;

	WMF_DEBUG (API,"~~~~~~~~wmf_[fig_]device_end");

	if (out == 0) return;
	
	fputs ("# end device_end\n",out);

}
