/* libwmf (<libwmf/macro.h>): library for wmf conversion
   Copyright (C) 2000 - various; see CREDITS, ChangeLog, and sources

   The libwmf Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The libwmf Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the libwmf Library; see the file COPYING.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */


#ifndef LIBWMF_MACRO_H
#define LIBWMF_MACRO_H

#include <math.h>

#include <libwmf/defs.h>
#include <libwmf/types.h>
#include <libwmf/ipa.h>

/* WMF_PEN_STYLE(wmfPen* P)  -> (U16) pen style
 * WMF_PEN_ENDCAP(wmfPen* P) -> (U16) endcap style
 * WMF_PEN_JOIN(wmfPen* P)   -> (U16) join style
 * WMF_PEN_TYPE(wmfPen* P)   -> (U16) `type' of pen (??)
 * 
 * WMF_PEN_WIDTH(wmfPen* P)  -> (double) pen `width'  (thickness w.r.t. x-axis)
 * WMF_PEN_HEIGHT(wmfPen* P) -> (double) pen `height' (thickness w.r.t. y-axis)
 * 
 * WMF_PEN_COLOR(wmfPen* P) -> (wmfRGB*) pen color
 */
#define WMF_PEN_STYLE(P)  ((P)->lopnStyle & PS_STYLE_MASK)
#define WMF_PEN_ENDCAP(P) ((P)->lopnStyle & PS_ENDCAP_MASK)
#define WMF_PEN_JOIN(P)   ((P)->lopnStyle & PS_JOIN_MASK)
#define WMF_PEN_TYPE(P)   ((P)->lopnStyle & PS_TYPE_MASK)

#define WMF_PEN_WIDTH(P)  ((P)->width)
#define WMF_PEN_HEIGHT(P) ((P)->height)

#define WMF_PEN_COLOR(P)  (&((P)->lopnColor))

/* WMF_BRUSH_STYLE(wmfBrush* B) -> (U16) brush style
 * WMF_BRUSH_HATCH(wmfBrush* B) -> (U16) brush hatch style
 * 
 * WMF_BRUSH_COLOR(wmfBrush* B) -> (wmfRGB*) brush color
 * 
 * WMF_BRUSH_BITMAP(wmfBrush* B) -> (wmfBMP*) brush bitmap
 */
#define WMF_BRUSH_STYLE(B)  ((B)->lbStyle)
#define WMF_BRUSH_HATCH(B)  ((B)->lbHatch)

#define WMF_BRUSH_COLOR(B)  (&((B)->lbColor))

#define WMF_BRUSH_BITMAP(B) (&((B)->bmp))

/* WMF_TEXT_ANGLE(wmfFont* F) -> (double) text angle in radians
 * 
 * WMF_TEXT_UNDERLINE(wmfFont* F) -> (U8) ?? whether to underline (?? how thick)
 * WMF_TEXT_STRIKEOUT(wmfFont* F) -> (U8) ?? whether to strikeout (?? how thick)
 * 
 * WMF_FONT_NAME(wmfFont* F)   -> (char*) font name supplied by metafile
 * WMF_FONT_PSNAME(wmfFont* F) -> (char*) font name to use in postscript output
 * WMF_FONT_FTFACE(wmfFont* F) -> (FT_Face) freetype(2) font face
 */
#define WMF_TEXT_ANGLE(F)     ((((double) (F)->lfEscapement) / 10) * M_PI / 180)

#define WMF_TEXT_UNDERLINE(F) ((F)->lfUnderline)
#define WMF_TEXT_STRIKEOUT(F) ((F)->lfStrikeOut)

#define WMF_FONT_NAME(F)   ((F)->lfFaceName)
#define WMF_FONT_PSNAME(F) ((F)->ps_name)
#define WMF_FONT_FTFACE(F) ((F)->ft_face)

/* WMF_DC_BRUSH(wmfDC* C) -> (wmfBrush*) current brush
 * WMF_DC_PEN(wmfDC* C)   -> (wmfPen*)   current pen
 * WMF_DC_FONT(wmfDC* C)  -> (wmfFont*)  current font
 * 
 * WMF_DC_TEXTCOLOR(wmfDC* C)  -> (wmfRGB*) text color
 * WMF_DC_BACKGROUND(wmfDC* C) -> (wmfRGB*) background color
 * 
 * WMF_DC_OPAQUE(wmfDC* C) -> (U16) whether to fill opaque (non-zero if true)
 * 
 * WMF_DC_POLYFILL(wmfDC* C) -> (U16) how to fill polygons
 * 
 * WMF_DC_ROP(wmfDC* C) -> (U16) ROP mode
 */
#define WMF_DC_BRUSH(C)      ((C)->brush)
#define WMF_DC_PEN(C)        ((C)->pen)
#define WMF_DC_FONT(C)       ((C)->font)

#define WMF_DC_TEXTCOLOR(C)  (&((C)->textcolor))
#define WMF_DC_BACKGROUND(C) (&((C)->bgcolor))

#define WMF_DC_OPAQUE(C)     ((C)->bgmode - 1)

#define WMF_DC_POLYFILL(C)   ((C)->polyfillmode)

#define WMF_DC_ROP(C)        ((C)->ROPmode)

#endif /* ! LIBWMF_MACRO_H */
