/* libwmf (<libwmf/api.h>): library for wmf conversion
   Copyright (C) 2000 - various; see CREDITS, ChangeLog, and sources

   The libwmf Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The libwmf Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the libwmf Library; see the file COPYING.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */


#ifndef LIBWMF_API_H
#define LIBWMF_API_H

#include <libwmf/types.h>

#ifdef __cplusplus
extern "C" {
#endif

/* Basic API
 */
extern wmf_error_t wmf_api_create (wmfAPI**,unsigned long,wmfAPI_Options*);
extern wmf_error_t wmf_api_destroy (wmfAPI*);

extern wmf_error_t wmf_header_read (wmfAPI*);

extern wmf_error_t wmf_scan (wmfAPI*,unsigned long,wmfD_Rect*);
extern wmf_error_t wmf_play (wmfAPI*,unsigned long,wmfD_Rect*);

extern wmf_error_t wmf_bbuf_input (wmfAPI*,wmfRead,wmfSeek,wmfTell,void*);

extern wmf_error_t wmf_file_open (wmfAPI*,char*);
extern wmf_error_t wmf_file_close (wmfAPI*);

extern wmf_error_t wmf_mem_open (wmfAPI*,unsigned char*,long);
extern wmf_error_t wmf_mem_close (wmfAPI*);

/* Other externally available functions (see also ipa-specific headers)
 */
/* (1) Memory management
 */
extern void* wmf_malloc (wmfAPI*,size_t);
extern void* wmf_calloc (wmfAPI*,size_t,size_t);
extern void* wmf_realloc (wmfAPI*,void*,size_t);
extern void  wmf_free (wmfAPI*,void*);

extern char* wmf_strdup (wmfAPI*,char*);

extern char* wmf_strstr (const char*,const char*);

/* (2) Initialization
 */
extern wmf_error_t wmf_player_init (wmfAPI*);

/* (3) File/Stream stuff
 */
extern U16 wmf_aldus_checksum (wmfAPI*);

extern U16 wmf_read_16 (wmfAPI*);
extern U32 wmf_read_32 (wmfAPI*,U16*,U16*);

extern int  wmf_file_read (void*);
extern int  wmf_file_seek (void*,long);
extern long wmf_file_tell (void*);

extern int  wmf_mem_read (void*);
extern int  wmf_mem_seek (void*,long);
extern long wmf_mem_tell (void*);

/* (4) Debug/Error reporting
 */
extern void wmf_error (wmfAPI*,char*,int,char*);
extern void wmf_debug (wmfAPI*,char*,int,char*);
extern void wmf_assert (wmfAPI*,char*,int);

extern char* wmf_help (void);

/* (5) Miscellaneous
 */
extern void wmf_set_viewport_origin (wmfAPI*,wmfD_Coord);

extern void wmf_status_function (wmfAPI*,void*,wmfStatus);

#ifdef __cplusplus
}
#endif

/* Useful defs & macros
 */

#define WMF_ERROR(Z,M) wmf_error (Z,__FILE__,__LINE__,M)

#ifdef DEBUG
#define WMF_DEBUG(Z,M) wmf_debug (Z,__FILE__,__LINE__,M)
#define WMF_ASSERT(Z,M) if (!(M)) wmf_assert (Z,__FILE__,__LINE__)
#else
#define WMF_DEBUG(Z,M)
#define WMF_ASSERT(Z,M)
#endif

/* Flags to be passed in wmf_api_create: flags to lie in range (1<<0) to (1<<19)
 */
#define WMF_OPT_ALLOC           (1<<0)  /* use provided [*]alloc/free functions */
#define WMF_OPT_ARGS            (1<<1)  /* check provided command line for --wmf-<option> */

#define WMF_OPT_FONTDIRS        (1<<2)  /* font directories specified */
#define WMF_OPT_FONTMAP         (1<<3)  /* font mappings specified */
#define WMF_OPT_SYS_FONTS       (1<<4)  /* use system fonts, if found */
#define WMF_OPT_SYS_FONTMAP     (1<<5)  /* use specified XML system fontmap file */
#define WMF_OPT_XTRA_FONTS      (1<<6)  /* use non-system fonts, if found */
#define WMF_OPT_XTRA_FONTMAP    (1<<7)  /* use specified XML non-system fontmap file */

#define WMF_OPT_FUNCTION        (1<<8)  /* initialize device-layer with supplied function */
#define WMF_OPT_MODULE          (1<<9)  /* initialize device-layer with specified module  */
#define WMF_OPT_MODULE_DIRS     (1<<10) /* check for module also in specified directories */

#define WMF_OPT_IGNORE_NONFATAL (1<<14) /* ignore (some) non-fatal errors --wmf-ignore-nonfatal */

#define WMF_OPT_NO_ERROR        (1<<15) /* suppress all error reports --wmf-error */
#define WMF_OPT_NO_DEBUG        (1<<16) /* suppress all debug reports --wmf-debug */
#define WMF_OPT_LOG_ERROR       (1<<17) /* divert error reports to specified stream */
#define WMF_OPT_LOG_DEBUG       (1<<18) /* divert debug reports to specified stream */

#define WMF_OPT_DIAGNOSTICS     (1<<19) /* emit diagnostic information --wmf-diagnostics */

#endif /* ! LIBWMF_API_H */
