/*
  libuta - a C++ widget library based on SDL (Simple Direct Layer)
  Copyright (C) 1999-2002  Karsten Laux

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/

#include "questionbox.h"
#include "multilineedit.h"
#include "pushbutton.h"
#include "resources.h"

namespace uta {


QuestionBox::QuestionBox(const std::string& title, const std::string& question) : 
  uDialogBox(title)
{

  if(RES_AVAILABLE("questionbox_color"))
    Widget::setColor(COLOR_RES("questionbox_color"));
  if(RES_AVAILABLE("questionbox_surface"))
    Widget::setBackground(SURFACE_RES("questionbox_surface"));

  MultiLineEdit* text = new MultiLineEdit(this, 
					  20,30,
					  width()-40, height()-50-40);
  text->setTransparency(true);
  text->addText(question.c_str());
	  
  PushButton* no = new PushButton(this, 
				  20, height()-40-13,
				  70,25);
  no->setText("No");
			
  PushButton* yes = new PushButton(this, 
				   width()-70-20, height()-40-13,
				   70,25);  
  
  yes->setText("Yes");

   
  no->clicked.connect(slot(this, &QuestionBox::reject));
  yes->clicked.connect(slot(this, &QuestionBox::accept));

}

QuestionBox::QuestionBox(const std::string& question)
{
  QuestionBox("", question);
}


QuestionBox::~QuestionBox()
{

}



}

