dnl aclocal.m4 generated automatically by aclocal 1.4

dnl Copyright (C) 1994, 1995-8, 1999 Free Software Foundation, Inc.
dnl This file is free software; the Free Software Foundation
dnl gives unlimited permission to copy and/or distribute it,
dnl with or without modifications, as long as this notice is preserved.

dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY, to the extent permitted by law; without
dnl even the implied warranty of MERCHANTABILITY or FITNESS FOR A
dnl PARTICULAR PURPOSE.

dnl This file is distributed under the terms of the GNU General Public license.
dnl Copyright (C) 1999 Michael Day (See the file COPYING for details).
dnl
dnl --------------------------------------------------------------------------
dnl Documentation:
dnl
dnl Available macros for checking languages and language features:
dnl
dnl LANGUAGES(
dnl	C(
dnl	    STDLIB
dnl	)
dnl	CXX(
dnl	    STDLIB,
dnl	    BOOL,
dnl	    NAMESPACE,
dnl	    CONST_CAST,
dnl	    MEMBER_FUNCTION_TEMPLATES,
dnl	    MEMBER_CLASS_TEMPLATES,
dnl	    MUTABLE,
dnl	    PARTIAL_SPECIALIZATION,
dnl	    FRIEND_TEMPLATES,
dnl	    INTRINSIC_CONSTRUCTORS
dnl	)
dnl )
dnl
dnl Available macros for checking packages:
dnl
dnl PACKAGES(
dnl
dnl )
dnl
dnl --------------------------------------------------------------------------
dnl Linux distribution mirror location database:

dnl TODO: add more distributions

define([linux_mirror],
[
    Your local $1 mirror site -- ifelse(
	$1, Redhat, ftp://ftp.redhat.com/MIRRORS.html,
	$1, SuSE, http://www.suse.com/ftp_new.html,
	$1, Debian, http://ftp.debian.org/,
	$1, Slackware, ftp://ftp.cdrom.com/pub/linux/slackware/,
	somewhere on the net.)
])

dnl --------------------------------------------------------------------------
dnl Friendly user messages:

dnl TODO: internationalization? :)

define([sorry_message], "Sorry things didn't work out.")
define([again_message], "Please install this package and run configure again.")
define([thank_message], "Thank you for your patience.")

dnl --------------------------------------------------------------------------
dnl Uncommented remainder of file:

define([CATEGORY],
[
    define([$1], [$3] $1_RECURSE($[]*) [$4])

    define([$1_RECURSE], [ifelse](dnl
$[]#, 0,,
$[]#, 1,
[[$2]]$[]1,
[[$2]]$[]1 [[$1_RECURSE]]([builtin]([[shift]], $[]@))))
])


CATEGORY([PACKAGES], [PACKAGES_],
[
],
[
    if test x"$test_failed" = xtrue ; then

	echo "configure: error: $test_msg1

Available from:"

	if test -z "$test_msg2" ; then

	    echo "$mirror" 1>&2

	else

	    echo "
    $test_msg2
" 1>&2

	    if test ! -z "$BROWSER" ; then
    
		echo "Would you like to download this now with $BROWSER? (y/N)"
		read input
	
		changequote(,)dnl
		if echo "$input" | grep "^[Yy]" > /dev/null ; then
		changequote([,])dnl
    
		    $BROWSER $test_msg2
		    echo thank_message 1>&2

		else

		    echo
		    echo sorry_message 1>&2

		fi

	    else

		echo
		echo sorry_message 1>&2
	    fi
	fi

	echo again_message 1>&2
	echo 1>&2
	exit 1

    fi
])


CATEGORY([PACKAGES_REQUIRED], [PACKAGES_],
[
    test_optional=false
])


CATEGORY([PACKAGES_OPTIONAL], [PACKAGES_],
[
    test_optional=true
],
[
    test_optional=false
])


CATEGORY([LANGUAGES], [LANGUAGES_])


CATEGORY([LANGUAGES_C], [C_],
[
    AC_LANG_SAVE
    AC_LANG_C

    AC_PROG_CC
    AC_PROG_CPP
],
[
    AC_LANG_RESTORE
])


CATEGORY([C_REQUIRED], [C_],
[
    test_optional=false
])


CATEGORY([C_OPTIONAL], [C_],
[
    test_optional=true
],
[
    test_optional=false
])


CATEGORY([LANGUAGES_CXX], [CXX_],
[
    AC_LANG_SAVE
    AC_LANG_CPLUSPLUS

    AC_PROG_CXX
],
[
    if test x"$test_failed" = xtrue ; then

	echo "configure: error: $test_msg1

        Please install an ansi compliant C++ compiler and libraries,
	such as a recent version of gcc (the GNU Compiler Collection).
"	

	exit 1

    fi

    AC_LANG_RESTORE
])


CATEGORY([CXX_REQUIRED], [CXX_],
[
    test_optional=false
])


CATEGORY([CXX_OPTIONAL], [CXX_],
[
    test_optional=true
],
[
    test_optional=false
])


CATEGORY([SUMMARY], [SUMMARY_])


AC_DEFUN([SUMMARY_MESSAGE],
[
echo
echo "Great, now try:"
echo

echo "make              -- to compile this package"
echo "make install      -- to install this package (in $prefix)"
echo "make dist         -- to create a distribution from this package"
echo "make doc          -- to generate the documentation (requires Doc++)"
dnl echo "make check        -- to run the test suite (requires DejaGnu)"


echo
])


AC_DEFUN([SETUP_EVERYTHING],
[
    AC_CANONICAL_HOST

    AC_PROG_INSTALL
    AC_PROG_LN_S
    AC_PROG_MAKE_SET

    dnl Check for whether tar should be gtar, to ensure that "make dist"
    dnl works correctly. Check for useful downloaders such as wget or lynx.

    AC_CHECK_PROGS(TAR, gtar, tar)
    AC_CHECK_PROGS(WGET, wget)
    AC_CHECK_PROGS(LYNX, lynx)

    dnl Choose an appropriate downloader if one exists, giving preference
    dnl to wget, then lynx.

    if test ! -z "$WGET" ; then

	BROWSER="$WGET"

    elif test ! -z "$LYNX" ; then

	BROWSER="$LYNX"

    fi

    dnl Check if host is running linux, and if so attempt to determine
    dnl which distribution (for selecting appropriate mirror sites).

    dnl TODO: add tests for more distributions

    if test "$host_os" = "linux-gnu" ; then

	if test -f /etc/redhat-release ; then

	    mirror="linux_mirror(Redhat)"

	elif test -f /etc/SuSE-release ; then

	    mirror="linux_mirror(SuSE)"

	elif test -f /etc/debian_version ; then

	    mirror="linux_mirror(Debian)"

	elif test -f /usr/lib/setup/slack-version ; then

	    mirror="linux_mirror(Slackware)"

	else

	    mirror="linux_mirror(Linux)"

	fi
    
    else

	case "$host_vendor" in
	    acorn) vendor="Acorn" ;;
	    apple) vendor="Apple" ;;
	    be) vendor="Be" ;;
	    bull) vendor="Bull" ;;
	    cbm) vendor="Commodore" ;;
	    cray) vendor="Cray" ;;
	    crds) vendor="CRDS" ;;
	    dec) vendor="Digital" ;;
	    dg) vendor="DG" ;;
	    fujitsu) vendor="Fujitsu" ;;
	    hitachi) vendor="Hitachi" ;;
	    hp) vendor="HP" ;;
	    ibm) vendor="IBM" ;;
	    next) vendor="NeXT" ;;
	    ns) vendor="NS" ;;
	    omron) vendor="Omron" ;;
	    sequent) vendor="Sequent" ;;
	    siemens) vendor="Siemens" ;;
	    sgi) vendor="SGI" ;;
	    sony) vendor="Sony" ;;
	    sun) vendor="Sun" ;;
	    wrs) vendor="WRS" ;;
	    *) vendor="$host_vendor" ;;
	esac

	mirror="
    Your local $vendor operating system vendor
"

    fi
])


AC_DEFUN([TEST_SKIP],
[
    if test ! x"$test_failed" = xtrue ; then

	$1

    fi
])


AC_DEFUN([TEST_FAILED],
[
    if test ! x"$test_optional" = xtrue ; then
	
	test_failed=true
	test_msg1="$1"
	test_msg2="$2"

    fi
])


dnl CHECK_LIB(foo.h, foo, foo_func, http://foo.com, -lfoo-help)
AC_DEFUN([CHECK_LIB],
[
    AC_CHECK_HEADER($1,
    [
	AC_CHECK_LIB($2, $3,, TEST_FAILED(lib$2 not found, [$4]), [$5])
    ],
    [
	TEST_FAILED($1 from lib$2 not found, [$4])
    ])
])


dnl CHECK_LIB_HEADER_VERSION(foo, func, foo.h, version.h, VERSION, 1.2.3, url)
AC_DEFUN([CHECK_LIB_HEADER_VERSION],
[
    AC_CHECK_HEADER($3,
    [
	AC_CHECK_LIB($1, $2,
	[
changequote(, )dnl
ac_tr_lib=HAVE_LIB`echo $1 | sed -e 's/[^a-zA-Z0-9_]/_/g' \
 -e 'y/abcdefghijklmnopqrstuvwxyz/ABCDEFGHIJKLMNOPQRSTUVWXYZ/'`
changequote([, ])dnl
AC_DEFINE_UNQUOTED($ac_tr_lib)
LIBS="-l$1 $LIBS"
	
	    AC_MSG_CHECKING(for lib$1 v$6)

	    ac_ver_var=`echo $1['_']$6 | sed 'y%./+-%__p_%'`    

	    AC_CACHE_VAL(ac_cv_ver_$ac_ver_var,
[

    MJ=`expr $6 : '\(.*\)\..*\..*'`
    MI=`expr $6 : '.*\.\(.*\)\..*'`
    MC=`expr $6 : '.*\..*\.\(.*\)'`

cat > conftest.$ac_ext <<EOF
[#]line __oline__ "configure"
#include "confdefs.h"
#include <$3>
snort $5 snort
EOF

    major_bad=1
    minor_bad=1
    micro_bad=1

    if version=`(eval "$ac_cpp conftest.$ac_ext") 2>/dev/null` ; then

	version=`echo $version | sed "s/.*snort\(.*\)snort.*/\1/g"`
	version=`echo $version | sed "s/ \|\"//g"`

	rm -rf conftest*
	    
	major=`expr $version : '\(.*\)\..*\..*'`
	minor=`expr $version : '.*\.\(.*\)\..*'`
	micro=`expr $version : '.*\..*\.\(.*\)'`

	major_bad=`expr $major \< $MJ`
	minor_bad=`expr $major \= $MJ \& $minor \< $MI`
	micro_bad=`expr $major \= $MJ \& $minor \= $MI \& $micro \< $MC`

    fi

    if expr $major_bad \| $minor_bad \| $micro_bad > /dev/null ; then

	eval "ac_cv_ver_$ac_ver_var=no"

    else

	eval "ac_cv_ver_$ac_ver_var=yes"

    fi

])

	    if eval "test \"`echo '$ac_cv_ver_'$ac_ver_var`\" = yes" ; then

		AC_MSG_RESULT(yes)

	    else
	
		AC_MSG_RESULT(no)
		TEST_FAILED([a newer version of lib$1 is required], [$7])
	
	    fi
	],
	[
	    TEST_FAILED(lib$1 not found, [$7])
	])
    ],
    [
	TEST_FAILED($2 from lib$1 not found, [$7])
    ])
])


dnl CHECK_LIB_SCRIPT_VERSION(foo, foo-script, 1.2.3, url)
AC_DEFUN([CHECK_LIB_SCRIPT_VERSION],
[
    AC_MSG_CHECKING(for lib$1 v$3)

    ac_ver_var=`echo $1['_']$3 | sed 'y%./+-%__p_%'`

    msg="lib$1 not found"

    AC_CACHE_VAL(ac_cv_ver_$ac_ver_var,
[   
    MJ=`expr $3 : '\(.*\)\..*\..*'`
    MI=`expr $3 : '.*\.\(.*\)\..*'`
    MC=`expr $3 : '.*\..*\.\(.*\)'`

    if type "$2" > /dev/null 2>&1 ; then

	version=`$2 --version | sed "s/[[^0-9.]]//g"`
	major=`expr $version : '\(.*\)\..*\..*'`
	minor=`expr $version : '.*\.\(.*\)\..*'`
	micro=`expr $version : '.*\..*\.\(.*\)'`

	major_ok=`expr $major \> $MJ`
	minor_ok=`expr $major \= $MJ \& $minor \> $MI`
	micro_ok=`expr $major \= $MJ \& $minor \= $MI \& $micro \>= $MC`

	if expr $major_ok \| $minor_ok \| $micro_ok > /dev/null ; then

	    eval "ac_cv_ver_$ac_ver_var=yes"

	else

	    eval "ac_cv_ver_$ac_ver_var=no"
	    msg="a newer version of lib$1 is required"

	fi
    
    else

	eval "ac_cv_ver_$ac_ver_var=no"
	msg="lib$1 not found"

    fi

])

    if eval "test \"`echo '$ac_cv_ver_'$ac_ver_var`\" = yes"
    then

	AC_MSG_RESULT(yes)

	LIBS="-l$1 $LIBS"
	CPPFLAGS="`$2 --cflags` $CPPFLAGS"

	changequote(,)dnl

	ac_tr_lib=HAVE_LIB`echo $1 | sed -e 's/[^a-zA-Z0-9_]/_/g' \
	    -e 'y/abcdefghijklmnopqrstuvwxyz/ABCDEFGHIJKLMNOPQRSTUVWXYZ/'`

	changequote([,])dnl

	AC_DEFINE_UNQUOTED($ac_tr_lib)

	dnl The following ghastly hack is necessary for autoheader
	dnl to recognize that this is a library, given that we are
	dnl not actually *using* AC_CHECK_LIB(). Ouch.

	if false ; then

	    AC_CHECK_LIB($1, foo)

	fi

    else

	AC_MSG_RESULT(no)
	TEST_FAILED($msg, [$4])

    fi
])


AC_DEFUN([PACKAGES_LIBM],
[
    TEST_SKIP(
    [
	dnl This test is courtesy of sponge's investigative work on BeOS. It
	dnl checks to see if the maths functions are available in the default
	dnl libraries first and only if that fails does it check libm.

	AC_CHECK_FUNC(pow,,
	[
	    CHECK_LIB(
		math.h,
		m,
		pow)
	])
    ])
])


AC_DEFUN([PACKAGES_LIBDL],
[
    TEST_SKIP(
    [
	CHECK_LIB(
	    dlfcn.h,
	    dl,
	    dlopen)
    ])
])


AC_DEFUN([PACKAGES_PTHREADS],
[
    TEST_SKIP(
    [
	CHECK_LIB(
	    pthread.h,
	    pthread,
	    pthread_create)

	dnl Needs to detect appropriate flags for Solaris, such as
	dnl those which set POSIX threads semantics.

	CPPFLAGS="$CPPFLAGS -D_REENTRANT"
    ])
])

AC_DEFUN([PACKAGES_LIBC_R],
[
    TEST_SKIP(
    [
	CHECK_LIB(
	    pthread.h,
	    c_r,
	    pthread_create)

	dnl Needs to detect appropriate flags for Solaris, such as
	dnl those which set POSIX threads semantics.

	CPPFLAGS="$CPPFLAGS -D_THREAD_SAFE"
    ])
])


dnl AC_DEFUN([PACKAGES_LIBSIGCPP],
dnl [
dnl    TEST_SKIP(
dnl    [
dnl	CHECK_LIB(
dnl	    sigc++/bind.h,
dnl	    sigc,
dnl	    main)
dnl    ])
dnl])

AC_DEFUN([PACKAGES_SDL],
[
    TEST_SKIP(
    [
	CHECK_LIB_HEADER_VERSION(
	    SDL,
	    SDL_Init,
	    SDL/SDL.h,
	    SDL/SDL_version.h,
	    SDL_MAJOR_VERSION.SDL_MINOR_VERSION.SDL_PATCHLEVEL,
	    $1,
	http://www.devolution.com/~slouken/SDL/SDL-0.10/src/SDL-$1.tar.gz)
    ])
])

AC_DEFUN([PACKAGES_LIBSDL_MIXER],
[
    TEST_SKIP(
    [
      AC_CHECK_HEADER(SDL/SDL_mixer.h,
	[
		AC_DEFINE(HAVE_MIXER))
		AC_CHECK_LIB([
			SDL_mixer, 
			MixSetPostMix,
			[$LIBS="-lSDL_mixer $LIBS" AC_DEFINE(HAVE_MIXER)], 
			TEST_FAILED(libSDL_mixer not found, Mix_SetPostMix)])
    	]
    ]

])

AC_DEFUN([PACKAGES_LIBZ],
[
    TEST_SKIP(
    [
	CHECK_LIB(
	    zlib.h,
	    z,
	    inflateInit_)
    ])
])


AC_DEFUN([PACKAGES_LIBXML],
[
    TEST_SKIP(
    [
	CHECK_LIB_SCRIPT_VERSION(
	    xml,
	    xml-config,
	    $1)
    ])
])


AC_DEFUN([PACKAGES_LIBPNG],
[
    TEST_SKIP(
    [
dnl	CHECK_LIB(
dnl	    png.h,
dnl	    png,
dnl	    png_create_read_struct)
	AC_CHECK_LIB(png, png_create_read_struct, LIBS="-lpng $LIBS")
    ])
])


AC_DEFUN([PACKAGES_FREETYPE],
[
    TEST_SKIP(
    [
	CHECK_LIB_HEADER_VERSION(
	    ttf,
	    TT_Open_Face,
	    freetype.h,
	    freetype.h,
	    TT_FREETYPE_MAJOR.TT_FREETYPE_MINOR.0,
	    $1.0,
	ftp://ftp.freetype.org/pub/freetype/freetype-$1.tar.gz)
    ])
])



AC_DEFUN([PACKAGES_CURSES],
[
    TEST_SKIP(
    [
	CHECK_LIB(
	    curses.h,
	    curses,
	    initscr)
    ])
])


AC_DEFUN([PACKAGES_NCURSES],
[
    TEST_SKIP(
    [
	CHECK_LIB_HEADER_VERSION(
	    ncurses,
	    initscr,
	    ncurses.h,
	    ncurses.h,
	    NCURSES_VERSION_MAJOR.NCURSES_VERSION_MINOR.NCURSES_VERSION_PATCH,
	    ifelse($2,, $1.0, $1.$2),
	ftp://ftp.gnu.org/gnu/ncurses/ncurses-$1.tar.gz)
    ])
])


AC_DEFUN([PACKAGES_X11],
[
    TEST_SKIP(
    [
	AC_PATH_X

	if test "$no_x" = yes ; then

	    TEST_FAILED([could not locate X-Windows client libraries])

	fi

	LIBS="-L$x_libraries -lX11 -lXext $LIBS"
    ])
])


AC_DEFUN([PACKAGES_MESA],
[
    TEST_SKIP(
    [
	CHECK_LIB_HEADER_VERSION(
	    MesaGL,
	    glBegin,
	    GL/gl.h,
	    GL/gl.h,
	    MESA_MAJOR_VERSION.MESA_MINOR_VERSION.0,
	    $1.0,
	ftp://ftp.mesa3d.org/mesa/MesaLib-$1.tar.gz)
    ])
])


dnl CHECK_FEATURE(name, declarations, function-body)
AC_DEFUN([CHECK_FEATURE],
[
    AC_MSG_CHECKING([for $1])

    ac_feature_var=`echo $1 | sed 'y%./+- %__p__%'`

    AC_CACHE_VAL(ac_cv_feature_$ac_feature_var,
[
    AC_TRY_COMPILE([$2], [$3],
    [
	eval "ac_cv_feature_$ac_feature_var=yes"
    ],
    [
	eval "ac_cv_feature_$ac_feature_var=no"
    ])
])

    if eval "test \"`echo '$ac_cv_feature_'$ac_feature_var`\" = yes"
    then

	AC_MSG_RESULT(yes)

    else

	AC_MSG_RESULT(no)
	TEST_FAILED(obsolete C++ compiler)
    fi
])
    
])


AC_DEFUN([C_STDLIB],
[
    TEST_SKIP(
    [
	AC_HEADER_STDC
    ])
])


AC_DEFUN([CXX_STDLIB],
[
    TEST_SKIP(
    [
	AC_CHECK_HEADERS(vector map algorithm string,,
	[
	    TEST_FAILED(obsolete C++ libraries)
	])
    ])
])


AC_DEFUN([CXX_BOOL],
[
    TEST_SKIP(
    [
	CHECK_FEATURE([bool],,[ bool t = true, f = false; ])
    ])
])


AC_DEFUN([CXX_NAMESPACE],
[
    TEST_SKIP(
    [
	CHECK_FEATURE([namespace],
	[
	    namespace foo { int i; } 
	],
	[
	    foo::i = 1; 
	])
    ])
])


AC_DEFUN([CXX_CONST_CAST],
[
    TEST_SKIP(
    [
	CHECK_FEATURE([const_cast],
	[
	    class foo;
	],
	[
	    const foo *c = 0; 
	    foo *c1 = const_cast<foo *>(c);
	])
    ])
])


AC_DEFUN([CXX_MEMBER_FUNCTION_TEMPLATES],
[
    TEST_SKIP(
    [
	CHECK_FEATURE([member function templates],
	[
	    class foo
	    {
		public:

		template <class T> void method(T t);
	    };

	    template <class T>
	    void foo::method(T t) { t = 0; }
	])
    ])
])


AC_DEFUN([CXX_MEMBER_CLASS_TEMPLATES],
[
    TEST_SKIP(
    [
	CHECK_FEATURE([member class templates],
	[
	    struct S
	    {
		template <class T> struct A { };
		template <class T> struct B { };
	    };
	])
    ])
])


AC_DEFUN([CXX_MUTABLE],
[
    TEST_SKIP(
    [
	CHECK_FEATURE([mutable],
	[
	    class foo
	    {
		mutable char *s;

		public:

		void bar() const { s = 0; }
	    };
	])
    ])
])


AC_DEFUN([CXX_PARTIAL_SPECIALIZATION],
[
    TEST_SKIP(
    [
	CHECK_FEATURE([partial specialization],
	[
	    template <class A, class B>
	    class Foo { };

	    template <class B>
	    class Foo<void, B> { };
	],
	[
	    Foo<float, float> a;
	    Foo<void, void> b;
	])
    ])
])


AC_DEFUN([CXX_FRIEND_TEMPLATES],
[
    TEST_SKIP(
    [
	CHECK_FEATURE([friend templates],
	[
	    struct A
	    {
		template <class T>
		friend T *gen();
	    };
	])
    ])
])


AC_DEFUN([CXX_INTRINSIC_CONSTRUCTORS],
[
    TEST_SKIP(
    [
	CHECK_FEATURE([intrinsic constructors],
	[
	    template <class T>
	    struct A
	    {
		T t;
		A() : t() { }
	    };

	    A<int> i;
	])
    ])
])


AC_DEFUN([CHECK_TYPE],
[AC_REQUIRE([AC_HEADER_STDC])dnl
AC_MSG_CHECKING(for $2)
AC_CACHE_VAL(ac_cv_type_$2,
[AC_EGREP_CPP(dnl
changequote(<<,>>)
<<(^|[^a-zA-Z_0-9])$2[^a-zA-Z_0-9]>>
changequote([,]), [#include <$1>
#if STDC_HEADERS
#include <stdlib.h>
#include <stddef.h>
#endif], ac_cv_type_$2=yes, ac_cv_type_$2=no)])dnl
AC_MSG_RESULT($ac_cv_type_$2)
if test $ac_cv_type_$2 = no; then
  AC_DEFINE($2, $3)
fi
])


AC_DEFUN([PACKAGES_NETWORKING],
[
    TEST_SKIP(
    [
	dnl Needs to check for BeOS networking header files.
	dnl Needs to check for Win32 networking header files.
    
	AC_CHECK_LIB(socket, socket, LIBS="-lsocket $LIBS")
	AC_CHECK_LIB(nsl, gethostbyname, LIBS="-lnsl $LIBS")
	AC_CHECK_LIB(resolv, hstrerror, LIBS="-lresolv $LIBS")
	CHECK_TYPE(sys/socket.h, socklen_t, int)
    ])
])


dnl FUDGE_CONFIG_HEADER(path to config.h.in)
AC_DEFUN([FUDGE_CONFIG_HEADER],
[
    if test -f "$1"
    then

	dnl Massively munge config.h.in
	dnl Basically changes certain /* ... */ to /// for Doc++

	changequote(,)dnl
	arg=`echo "$1" | sed -e 's/[\/]/\\\\\\//g' -e 's/[.]/\\\\./g'`
	sed "\/\/\* $arg/!s/\/\*\(.*\)\*\//\/\/\/\1/" < "$1" > config.h.$$
	changequote([,])dnl
	
	mv config.h.$$ "$1"

    fi
])

# Configure paths for SDL
# Sam Lantinga 9/21/99
# stolen from Manish Singh
# stolen back from Frank Belew
# stolen from Manish Singh
# Shamelessly stolen from Owen Taylor

dnl AM_PATH_SDL([MINIMUM-VERSION, [ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]]])
dnl Test for SDL, and define SDL_CFLAGS and SDL_LIBS
dnl
AC_DEFUN(AM_PATH_SDL,
[dnl 
dnl Get the cflags and libraries from the sdl-config script
dnl
AC_ARG_WITH(sdl-prefix,[  --with-sdl-prefix=PFX   Prefix where SDL is installed (optional)],
            sdl_prefix="$withval", sdl_prefix="")
AC_ARG_WITH(sdl-exec-prefix,[  --with-sdl-exec-prefix=PFX Exec prefix where SDL is installed (optional)],
            sdl_exec_prefix="$withval", sdl_exec_prefix="")
AC_ARG_ENABLE(sdltest, [  --disable-sdltest       Do not try to compile and run a test SDL program],
		    , enable_sdltest=yes)

  if test x$sdl_exec_prefix != x ; then
     sdl_args="$sdl_args --exec-prefix=$sdl_exec_prefix"
     if test x${SDL_CONFIG+set} != xset ; then
        SDL_CONFIG=$sdl_exec_prefix/bin/sdl-config
     fi
  fi
  if test x$sdl_prefix != x ; then
     sdl_args="$sdl_args --prefix=$sdl_prefix"
     if test x${SDL_CONFIG+set} != xset ; then
        SDL_CONFIG=$sdl_prefix/bin/sdl-config
     fi
  fi

  AC_PATH_PROG(SDL_CONFIG, sdl-config, no)
  min_sdl_version=ifelse([$1], ,0.11.0,$1)
  AC_MSG_CHECKING(for SDL - version >= $min_sdl_version)
  no_sdl=""
  if test "$SDL_CONFIG" = "no" ; then
    no_sdl=yes
  else
    SDL_CFLAGS=`$SDL_CONFIG $sdl_args --cflags`
    SDL_LIBS=`$SDL_CONFIG $sdl_args --libs`

    dnl This token is for any flags not -l* or -L*, e.g. 
    dnl -Wl,-rpath,/usr/local/lib, to grab from SDL
    SDL_CONFIG_EXTRA_FLAGS=`$SDL_CONFIG $sdl_args --libs | \
	       sed -e 's/-[[Ll]][[^[:space:]]]*//g'`

    sdl_major_version=`$SDL_CONFIG $sdl_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
    sdl_minor_version=`$SDL_CONFIG $sdl_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
    sdl_micro_version=`$SDL_CONFIG $sdl_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`
    if test "x$enable_sdltest" = "xyes" ; then
      ac_save_CFLAGS="$CFLAGS"
      ac_save_LIBS="$LIBS"
      CFLAGS="$CFLAGS $SDL_CFLAGS"
      LIBS="$LIBS $SDL_LIBS"
dnl
dnl Now check if the installed SDL is sufficiently new. (Also sanity
dnl checks the results of sdl-config to some extent
dnl
      rm -f conf.sdltest
      AC_TRY_RUN([
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <SDL/SDL.h>

char*
my_strdup (char *str)
{
  char *new_str;
  
  if (str)
    {
      new_str = malloc ((strlen (str) + 1) * sizeof(char));
      strcpy (new_str, str);
    }
  else
    new_str = NULL;
  
  return new_str;
}

int main ()
{
  int major, minor, micro;
  char *tmp_version;

  system ("touch conf.sdltest");

  /* HP/UX 9 (%@#!) writes to sscanf strings */
  tmp_version = my_strdup("$min_sdl_version");
  if (sscanf(tmp_version, "%d.%d.%d", &major, &minor, &micro) != 3) {
     printf("%s, bad version string\n", "$min_sdl_version");
     exit(1);
   }

   if (($sdl_major_version > major) ||
      (($sdl_major_version == major) && ($sdl_minor_version > minor)) ||
      (($sdl_major_version == major) && ($sdl_minor_version == minor) && ($sdl_micro_version >= micro)))
    {
      return 0;
    }
  else
    {
      printf("\n*** 'sdl-config --version' returned %d.%d.%d, but the minimum version\n", $sdl_major_version, $sdl_minor_version, $sdl_micro_version);
      printf("*** of SDL required is %d.%d.%d. If sdl-config is correct, then it is\n", major, minor, micro);
      printf("*** best to upgrade to the required version.\n");
      printf("*** If sdl-config was wrong, set the environment variable SDL_CONFIG\n");
      printf("*** to point to the correct copy of sdl-config, and remove the file\n");
      printf("*** config.cache before re-running configure\n");
      return 1;
    }
}

],, no_sdl=yes,[echo $ac_n "cross compiling; assumed OK... $ac_c"])
       CFLAGS="$ac_save_CFLAGS"
       LIBS="$ac_save_LIBS"
     fi
  fi
  if test "x$no_sdl" = x ; then
     AC_MSG_RESULT(yes)
     ifelse([$2], , :, [$2])     
  else
     AC_MSG_RESULT(no)
     if test "$SDL_CONFIG" = "no" ; then
       echo "*** The sdl-config script installed by SDL could not be found"
       echo "*** If SDL was installed in PREFIX, make sure PREFIX/bin is in"
       echo "*** your path, or set the SDL_CONFIG environment variable to the"
       echo "*** full path to sdl-config."
     else
       if test -f conf.sdltest ; then
        :
       else
          echo "*** Could not run SDL test program, checking why..."
          CFLAGS="$CFLAGS $SDL_CFLAGS"
          LIBS="$LIBS $SDL_LIBS"
          AC_TRY_LINK([
#include <stdio.h>
#include <SDL/SDL.h>
],      [ return 0; ],
        [ echo "*** The test program compiled, but did not run. This usually means"
          echo "*** that the run-time linker is not finding SDL or finding the wrong"
          echo "*** version of SDL. If it is not finding SDL, you'll need to set your"
          echo "*** LD_LIBRARY_PATH environment variable, or edit /etc/ld.so.conf to point"
          echo "*** to the installed location  Also, make sure you have run ldconfig if that"
          echo "*** is required on your system"
	  echo "***"
          echo "*** If you have an old version installed, it is best to remove it, although"
          echo "*** you may also be able to get things to work by modifying LD_LIBRARY_PATH"],
        [ echo "*** The test program failed to compile or link. See the file config.log for the"
          echo "*** exact error that occured. This usually means SDL was incorrectly installed"
          echo "*** or that you have moved SDL since it was installed. In the latter case, you"
          echo "*** may want to edit the sdl-config script: $SDL_CONFIG" ])
          CFLAGS="$ac_save_CFLAGS"
          LIBS="$ac_save_LIBS"
       fi
     fi
     SDL_CFLAGS=""
     SDL_LIBS=""
     ifelse([$3], , :, [$3])
  fi
  AC_SUBST(SDL_CFLAGS)
  AC_SUBST(SDL_LIBS)
  rm -f conf.sdltest
])

# Configure paths for SDL
# Sam Lantinga 9/21/99
# stolen from Manish Singh
# stolen back from Frank Belew
# stolen from Manish Singh
# Shamelessly stolen from Owen Taylor


dnl AM_PATH_SIGC([MINIMUM-VERSION, [ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]]])
dnl Test for SIGC, and define SIGC_CFLAGS and SIGC_LIBS
dnl
AC_DEFUN(AM_PATH_SIGC,
[dnl 
dnl Get the cflags and libraries from the sigc-config script
dnl
AC_ARG_WITH(sigc-prefix,[  --with-sigc-prefix=PFX   Prefix where libsigc++ is installed (optional)],
            sigc_prefix="$withval", sigc_prefix="")
AC_ARG_WITH(sigc-exec-prefix,[  --with-sigc-exec-prefix=PFX Exec prefix where libsigc++ is installed (optional)],
            sigc_exec_prefix="$withval", sigc_exec_prefix="")

  if test x$sigc_exec_prefix != x ; then
     sigc_args="$sigc_args --exec-prefix=$sigc_exec_prefix"
     if test x${SIGC_CONFIG+set} != xset ; then
        SIGC_CONFIG=$sigc_exec_prefix/bin/sigc-config
     fi
  fi
  if test x$sigc_prefix != x ; then
     sigc_args="$sigc_args --prefix=$sigc_prefix"
     if test x${SIGC_CONFIG+set} != xset ; then
        SIGC_CONFIG=$sigc_prefix/bin/sigc-config
     fi
  fi

  AC_PATH_PROG(SIGC_CONFIG, sigc-config, no)
  min_sigc_version=ifelse([$1], ,0.8.5,$1)
  AC_MSG_CHECKING(for libsigc++ - version >= $min_sigc_version)
  no_sigc=""
  if test "$SIGC_CONFIG" = "no" ; then
    no_sigc=yes
    AC_MSG_RESULT(no)	
  else
    SIGC_CFLAGS=`$SIGC_CONFIG $sigcconf_args --cflags`
    SIGC_LIBS=`$SIGC_CONFIG $sigcconf_args --libs`

    sigc_major_version=`$SIGC_CONFIG $sigc_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
    sigc_minor_version=`$SIGC_CONFIG $sigc_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
    sigc_micro_version=`$SIGC_CONFIG $sigc_config_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`
    ac_save_CFLAGS="$CFLAGS"
    ac_save_LIBS="$LIBS"
    CFLAGS="$CFLAGS $SIGC_CFLAGS"
    LIBS="$LIBS $SIGC_LIBS"

    rm -f conf.sigctest
    AC_TRY_RUN([
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

char*
my_strdup (char *str)
{
  char *new_str;
  
  if (str)
    {
      new_str = malloc ((strlen (str) + 1) * sizeof(char));
      strcpy (new_str, str);
    }
  else
    new_str = NULL;
  
  return new_str;
}

int main ()
{
  int major, minor, micro;
  char *tmp_version;

  system ("touch conf.sigctest");

  /* HP/UX 9 (%@#!) writes to sscanf strings */
  tmp_version = my_strdup("$min_sigc_version");
  if (sscanf(tmp_version, "%d.%d.%d", &major, &minor, &micro) != 3) {
     printf("%s, bad version string\n", "$min_sigc_version");
     exit(1);
   }

   if (($sigc_major_version > major) ||
      (($sigc_major_version == major) && ($sigc_minor_version > minor)) ||
      (($sigc_major_version == major) && ($sigc_minor_version == minor) && ($sigc_micro_version >= micro)))
    {
      return 0;
    }
  else
    {
      printf("\n*** 'sigc-config --version' returned %d.%d.%d, but the minimum version\n", $sigc_major_version, $sigc_minor_version, $sigc_micro_version);
      printf("*** of libsigc required is %d.%d.%d.\n", major, minor, micro);
      printf("*** If sigc-config was wrong, set the environment variable SIGC_CONFIG\n");
      printf("*** to point to the correct copy of sigc-config, and remove the file\n");
      printf("*** config.cache before re-running configure\n");
      return 1;
    }
}

],,no_sigc=yes,[echo $ac_n "cross compiling; assumed OK... $ac_c"])
       
    CFLAGS="$ac_save_CFLAGS"
    LIBS="$ac_save_LIBS"
    if test "x$no_sigc" = x ; then
      AC_MSG_RESULT(yes)	
      ifelse([$2], , :, [$2])
    else
      AC_MSG_RESULT(no)
      ifelse([$3], , :, [$3])	
    fi
   fi
  AC_SUBST(SIGC_CFLAGS)
  AC_SUBST(SIGC_LIBS)
 
]) 

# Define a conditional.

AC_DEFUN(AM_CONDITIONAL,
[AC_SUBST($1_TRUE)
AC_SUBST($1_FALSE)
if $2; then
  $1_TRUE=
  $1_FALSE='#'
else
  $1_TRUE='#'
  $1_FALSE=
fi])

# Do all the work for Automake.  This macro actually does too much --
# some checks are only needed if your package does certain things.
# But this isn't really a big deal.

# serial 1

dnl Usage:
dnl AM_INIT_AUTOMAKE(package,version, [no-define])

AC_DEFUN(AM_INIT_AUTOMAKE,
[AC_REQUIRE([AC_PROG_INSTALL])
PACKAGE=[$1]
AC_SUBST(PACKAGE)
VERSION=[$2]
AC_SUBST(VERSION)
dnl test to see if srcdir already configured
if test "`cd $srcdir && pwd`" != "`pwd`" && test -f $srcdir/config.status; then
  AC_MSG_ERROR([source directory already configured; run "make distclean" there first])
fi
ifelse([$3],,
AC_DEFINE_UNQUOTED(PACKAGE, "$PACKAGE", [Name of package])
AC_DEFINE_UNQUOTED(VERSION, "$VERSION", [Version number of package]))
AC_REQUIRE([AM_SANITY_CHECK])
AC_REQUIRE([AC_ARG_PROGRAM])
dnl FIXME This is truly gross.
missing_dir=`cd $ac_aux_dir && pwd`
AM_MISSING_PROG(ACLOCAL, aclocal, $missing_dir)
AM_MISSING_PROG(AUTOCONF, autoconf, $missing_dir)
AM_MISSING_PROG(AUTOMAKE, automake, $missing_dir)
AM_MISSING_PROG(AUTOHEADER, autoheader, $missing_dir)
AM_MISSING_PROG(MAKEINFO, makeinfo, $missing_dir)
AC_REQUIRE([AC_PROG_MAKE_SET])])

#
# Check to make sure that the build environment is sane.
#

AC_DEFUN(AM_SANITY_CHECK,
[AC_MSG_CHECKING([whether build environment is sane])
# Just in case
sleep 1
echo timestamp > conftestfile
# Do `set' in a subshell so we don't clobber the current shell's
# arguments.  Must try -L first in case configure is actually a
# symlink; some systems play weird games with the mod time of symlinks
# (eg FreeBSD returns the mod time of the symlink's containing
# directory).
if (
   set X `ls -Lt $srcdir/configure conftestfile 2> /dev/null`
   if test "[$]*" = "X"; then
      # -L didn't work.
      set X `ls -t $srcdir/configure conftestfile`
   fi
   if test "[$]*" != "X $srcdir/configure conftestfile" \
      && test "[$]*" != "X conftestfile $srcdir/configure"; then

      # If neither matched, then we have a broken ls.  This can happen
      # if, for instance, CONFIG_SHELL is bash and it inherits a
      # broken ls alias from the environment.  This has actually
      # happened.  Such a system could not be considered "sane".
      AC_MSG_ERROR([ls -t appears to fail.  Make sure there is not a broken
alias in your environment])
   fi

   test "[$]2" = conftestfile
   )
then
   # Ok.
   :
else
   AC_MSG_ERROR([newly created file is older than distributed files!
Check your system clock])
fi
rm -f conftest*
AC_MSG_RESULT(yes)])

dnl AM_MISSING_PROG(NAME, PROGRAM, DIRECTORY)
dnl The program must properly implement --version.
AC_DEFUN(AM_MISSING_PROG,
[AC_MSG_CHECKING(for working $2)
# Run test in a subshell; some versions of sh will print an error if
# an executable is not found, even if stderr is redirected.
# Redirect stdin to placate older versions of autoconf.  Sigh.
if ($2 --version) < /dev/null > /dev/null 2>&1; then
   $1=$2
   AC_MSG_RESULT(found)
else
   $1="$3/missing $2"
   AC_MSG_RESULT(missing)
fi
AC_SUBST($1)])

# Add --enable-maintainer-mode option to configure.
# From Jim Meyering

# serial 1

AC_DEFUN(AM_MAINTAINER_MODE,
[AC_MSG_CHECKING([whether to enable maintainer-specific portions of Makefiles])
  dnl maintainer-mode is disabled by default
  AC_ARG_ENABLE(maintainer-mode,
[  --enable-maintainer-mode enable make rules and dependencies not useful
                          (and sometimes confusing) to the casual installer],
      USE_MAINTAINER_MODE=$enableval,
      USE_MAINTAINER_MODE=no)
  AC_MSG_RESULT($USE_MAINTAINER_MODE)
  AM_CONDITIONAL(MAINTAINER_MODE, test $USE_MAINTAINER_MODE = yes)
  MAINT=$MAINTAINER_MODE_TRUE
  AC_SUBST(MAINT)dnl
]
)

# Like AC_CONFIG_HEADER, but automatically create stamp file.

AC_DEFUN(AM_CONFIG_HEADER,
[AC_PREREQ([2.12])
AC_CONFIG_HEADER([$1])
dnl When config.status generates a header, we must update the stamp-h file.
dnl This file resides in the same directory as the config header
dnl that is generated.  We must strip everything past the first ":",
dnl and everything past the last "/".
AC_OUTPUT_COMMANDS(changequote(<<,>>)dnl
ifelse(patsubst(<<$1>>, <<[^ ]>>, <<>>), <<>>,
<<test -z "<<$>>CONFIG_HEADERS" || echo timestamp > patsubst(<<$1>>, <<^\([^:]*/\)?.*>>, <<\1>>)stamp-h<<>>dnl>>,
<<am_indx=1
for am_file in <<$1>>; do
  case " <<$>>CONFIG_HEADERS " in
  *" <<$>>am_file "*<<)>>
    echo timestamp > `echo <<$>>am_file | sed -e 's%:.*%%' -e 's%[^/]*$%%'`stamp-h$am_indx
    ;;
  esac
  am_indx=`expr "<<$>>am_indx" + 1`
done<<>>dnl>>)
changequote([,]))])


# serial 40 AC_PROG_LIBTOOL
AC_DEFUN(AC_PROG_LIBTOOL,
[AC_REQUIRE([AC_LIBTOOL_SETUP])dnl

# Save cache, so that ltconfig can load it
AC_CACHE_SAVE

# Actually configure libtool.  ac_aux_dir is where install-sh is found.
CC="$CC" CFLAGS="$CFLAGS" CPPFLAGS="$CPPFLAGS" \
LD="$LD" LDFLAGS="$LDFLAGS" LIBS="$LIBS" \
LN_S="$LN_S" NM="$NM" RANLIB="$RANLIB" \
DLLTOOL="$DLLTOOL" AS="$AS" OBJDUMP="$OBJDUMP" \
${CONFIG_SHELL-/bin/sh} $ac_aux_dir/ltconfig --no-reexec \
$libtool_flags --no-verify $ac_aux_dir/ltmain.sh $lt_target \
|| AC_MSG_ERROR([libtool configure failed])

# Reload cache, that may have been modified by ltconfig
AC_CACHE_LOAD

# This can be used to rebuild libtool when needed
LIBTOOL_DEPS="$ac_aux_dir/ltconfig $ac_aux_dir/ltmain.sh"

# Always use our own libtool.
LIBTOOL='$(SHELL) $(top_builddir)/libtool'
AC_SUBST(LIBTOOL)dnl

# Redirect the config.log output again, so that the ltconfig log is not
# clobbered by the next message.
exec 5>>./config.log
])

AC_DEFUN(AC_LIBTOOL_SETUP,
[AC_PREREQ(2.13)dnl
AC_REQUIRE([AC_ENABLE_SHARED])dnl
AC_REQUIRE([AC_ENABLE_STATIC])dnl
AC_REQUIRE([AC_ENABLE_FAST_INSTALL])dnl
AC_REQUIRE([AC_CANONICAL_HOST])dnl
AC_REQUIRE([AC_CANONICAL_BUILD])dnl
AC_REQUIRE([AC_PROG_RANLIB])dnl
AC_REQUIRE([AC_PROG_CC])dnl
AC_REQUIRE([AC_PROG_LD])dnl
AC_REQUIRE([AC_PROG_NM])dnl
AC_REQUIRE([AC_PROG_LN_S])dnl
dnl

case "$target" in
NONE) lt_target="$host" ;;
*) lt_target="$target" ;;
esac

# Check for any special flags to pass to ltconfig.
#
# the following will cause an existing older ltconfig to fail, so
# we ignore this at the expense of the cache file... Checking this 
# will just take longer ... bummer!
#libtool_flags="--cache-file=$cache_file"
#
test "$enable_shared" = no && libtool_flags="$libtool_flags --disable-shared"
test "$enable_static" = no && libtool_flags="$libtool_flags --disable-static"
test "$enable_fast_install" = no && libtool_flags="$libtool_flags --disable-fast-install"
test "$ac_cv_prog_gcc" = yes && libtool_flags="$libtool_flags --with-gcc"
test "$ac_cv_prog_gnu_ld" = yes && libtool_flags="$libtool_flags --with-gnu-ld"
ifdef([AC_PROVIDE_AC_LIBTOOL_DLOPEN],
[libtool_flags="$libtool_flags --enable-dlopen"])
ifdef([AC_PROVIDE_AC_LIBTOOL_WIN32_DLL],
[libtool_flags="$libtool_flags --enable-win32-dll"])
AC_ARG_ENABLE(libtool-lock,
  [  --disable-libtool-lock  avoid locking (might break parallel builds)])
test "x$enable_libtool_lock" = xno && libtool_flags="$libtool_flags --disable-lock"
test x"$silent" = xyes && libtool_flags="$libtool_flags --silent"

# Some flags need to be propagated to the compiler or linker for good
# libtool support.
case "$lt_target" in
*-*-irix6*)
  # Find out which ABI we are using.
  echo '[#]line __oline__ "configure"' > conftest.$ac_ext
  if AC_TRY_EVAL(ac_compile); then
    case "`/usr/bin/file conftest.o`" in
    *32-bit*)
      LD="${LD-ld} -32"
      ;;
    *N32*)
      LD="${LD-ld} -n32"
      ;;
    *64-bit*)
      LD="${LD-ld} -64"
      ;;
    esac
  fi
  rm -rf conftest*
  ;;

*-*-sco3.2v5*)
  # On SCO OpenServer 5, we need -belf to get full-featured binaries.
  SAVE_CFLAGS="$CFLAGS"
  CFLAGS="$CFLAGS -belf"
  AC_CACHE_CHECK([whether the C compiler needs -belf], lt_cv_cc_needs_belf,
    [AC_TRY_LINK([],[],[lt_cv_cc_needs_belf=yes],[lt_cv_cc_needs_belf=no])])
  if test x"$lt_cv_cc_needs_belf" != x"yes"; then
    # this is probably gcc 2.8.0, egcs 1.0 or newer; no need for -belf
    CFLAGS="$SAVE_CFLAGS"
  fi
  ;;

ifdef([AC_PROVIDE_AC_LIBTOOL_WIN32_DLL],
[*-*-cygwin* | *-*-mingw*)
  AC_CHECK_TOOL(DLLTOOL, dlltool, false)
  AC_CHECK_TOOL(AS, as, false)
  AC_CHECK_TOOL(OBJDUMP, objdump, false)
  ;;
])
esac
])

# AC_LIBTOOL_DLOPEN - enable checks for dlopen support
AC_DEFUN(AC_LIBTOOL_DLOPEN, [AC_BEFORE([$0],[AC_LIBTOOL_SETUP])])

# AC_LIBTOOL_WIN32_DLL - declare package support for building win32 dll's
AC_DEFUN(AC_LIBTOOL_WIN32_DLL, [AC_BEFORE([$0], [AC_LIBTOOL_SETUP])])

# AC_ENABLE_SHARED - implement the --enable-shared flag
# Usage: AC_ENABLE_SHARED[(DEFAULT)]
#   Where DEFAULT is either `yes' or `no'.  If omitted, it defaults to
#   `yes'.
AC_DEFUN(AC_ENABLE_SHARED, [dnl
define([AC_ENABLE_SHARED_DEFAULT], ifelse($1, no, no, yes))dnl
AC_ARG_ENABLE(shared,
changequote(<<, >>)dnl
<<  --enable-shared[=PKGS]  build shared libraries [default=>>AC_ENABLE_SHARED_DEFAULT],
changequote([, ])dnl
[p=${PACKAGE-default}
case "$enableval" in
yes) enable_shared=yes ;;
no) enable_shared=no ;;
*)
  enable_shared=no
  # Look at the argument we got.  We use all the common list separators.
  IFS="${IFS= 	}"; ac_save_ifs="$IFS"; IFS="${IFS}:,"
  for pkg in $enableval; do
    if test "X$pkg" = "X$p"; then
      enable_shared=yes
    fi
  done
  IFS="$ac_save_ifs"
  ;;
esac],
enable_shared=AC_ENABLE_SHARED_DEFAULT)dnl
])

# AC_DISABLE_SHARED - set the default shared flag to --disable-shared
AC_DEFUN(AC_DISABLE_SHARED, [AC_BEFORE([$0],[AC_LIBTOOL_SETUP])dnl
AC_ENABLE_SHARED(no)])

# AC_ENABLE_STATIC - implement the --enable-static flag
# Usage: AC_ENABLE_STATIC[(DEFAULT)]
#   Where DEFAULT is either `yes' or `no'.  If omitted, it defaults to
#   `yes'.
AC_DEFUN(AC_ENABLE_STATIC, [dnl
define([AC_ENABLE_STATIC_DEFAULT], ifelse($1, no, no, yes))dnl
AC_ARG_ENABLE(static,
changequote(<<, >>)dnl
<<  --enable-static[=PKGS]  build static libraries [default=>>AC_ENABLE_STATIC_DEFAULT],
changequote([, ])dnl
[p=${PACKAGE-default}
case "$enableval" in
yes) enable_static=yes ;;
no) enable_static=no ;;
*)
  enable_static=no
  # Look at the argument we got.  We use all the common list separators.
  IFS="${IFS= 	}"; ac_save_ifs="$IFS"; IFS="${IFS}:,"
  for pkg in $enableval; do
    if test "X$pkg" = "X$p"; then
      enable_static=yes
    fi
  done
  IFS="$ac_save_ifs"
  ;;
esac],
enable_static=AC_ENABLE_STATIC_DEFAULT)dnl
])

# AC_DISABLE_STATIC - set the default static flag to --disable-static
AC_DEFUN(AC_DISABLE_STATIC, [AC_BEFORE([$0],[AC_LIBTOOL_SETUP])dnl
AC_ENABLE_STATIC(no)])


# AC_ENABLE_FAST_INSTALL - implement the --enable-fast-install flag
# Usage: AC_ENABLE_FAST_INSTALL[(DEFAULT)]
#   Where DEFAULT is either `yes' or `no'.  If omitted, it defaults to
#   `yes'.
AC_DEFUN(AC_ENABLE_FAST_INSTALL, [dnl
define([AC_ENABLE_FAST_INSTALL_DEFAULT], ifelse($1, no, no, yes))dnl
AC_ARG_ENABLE(fast-install,
changequote(<<, >>)dnl
<<  --enable-fast-install[=PKGS]  optimize for fast installation [default=>>AC_ENABLE_FAST_INSTALL_DEFAULT],
changequote([, ])dnl
[p=${PACKAGE-default}
case "$enableval" in
yes) enable_fast_install=yes ;;
no) enable_fast_install=no ;;
*)
  enable_fast_install=no
  # Look at the argument we got.  We use all the common list separators.
  IFS="${IFS= 	}"; ac_save_ifs="$IFS"; IFS="${IFS}:,"
  for pkg in $enableval; do
    if test "X$pkg" = "X$p"; then
      enable_fast_install=yes
    fi
  done
  IFS="$ac_save_ifs"
  ;;
esac],
enable_fast_install=AC_ENABLE_FAST_INSTALL_DEFAULT)dnl
])

# AC_ENABLE_FAST_INSTALL - set the default to --disable-fast-install
AC_DEFUN(AC_DISABLE_FAST_INSTALL, [AC_BEFORE([$0],[AC_LIBTOOL_SETUP])dnl
AC_ENABLE_FAST_INSTALL(no)])

# AC_PROG_LD - find the path to the GNU or non-GNU linker
AC_DEFUN(AC_PROG_LD,
[AC_ARG_WITH(gnu-ld,
[  --with-gnu-ld           assume the C compiler uses GNU ld [default=no]],
test "$withval" = no || with_gnu_ld=yes, with_gnu_ld=no)
AC_REQUIRE([AC_PROG_CC])dnl
AC_REQUIRE([AC_CANONICAL_HOST])dnl
AC_REQUIRE([AC_CANONICAL_BUILD])dnl
ac_prog=ld
if test "$ac_cv_prog_gcc" = yes; then
  # Check if gcc -print-prog-name=ld gives a path.
  AC_MSG_CHECKING([for ld used by GCC])
  ac_prog=`($CC -print-prog-name=ld) 2>&5`
  case "$ac_prog" in
    # Accept absolute paths.
changequote(,)dnl
    [\\/]* | [A-Za-z]:[\\/]*)
      re_direlt='/[^/][^/]*/\.\./'
changequote([,])dnl
      # Canonicalize the path of ld
      ac_prog=`echo $ac_prog| sed 's%\\\\%/%g'`
      while echo $ac_prog | grep "$re_direlt" > /dev/null 2>&1; do
	ac_prog=`echo $ac_prog| sed "s%$re_direlt%/%"`
      done
      test -z "$LD" && LD="$ac_prog"
      ;;
  "")
    # If it fails, then pretend we aren't using GCC.
    ac_prog=ld
    ;;
  *)
    # If it is relative, then search for the first ld in PATH.
    with_gnu_ld=unknown
    ;;
  esac
elif test "$with_gnu_ld" = yes; then
  AC_MSG_CHECKING([for GNU ld])
else
  AC_MSG_CHECKING([for non-GNU ld])
fi
AC_CACHE_VAL(ac_cv_path_LD,
[if test -z "$LD"; then
  IFS="${IFS= 	}"; ac_save_ifs="$IFS"; IFS="${IFS}${PATH_SEPARATOR-:}"
  for ac_dir in $PATH; do
    test -z "$ac_dir" && ac_dir=.
    if test -f "$ac_dir/$ac_prog" || test -f "$ac_dir/$ac_prog$ac_exeext"; then
      ac_cv_path_LD="$ac_dir/$ac_prog"
      # Check to see if the program is GNU ld.  I'd rather use --version,
      # but apparently some GNU ld's only accept -v.
      # Break only if it was the GNU/non-GNU ld that we prefer.
      if "$ac_cv_path_LD" -v 2>&1 < /dev/null | egrep '(GNU|with BFD)' > /dev/null; then
	test "$with_gnu_ld" != no && break
      else
	test "$with_gnu_ld" != yes && break
      fi
    fi
  done
  IFS="$ac_save_ifs"
else
  ac_cv_path_LD="$LD" # Let the user override the test with a path.
fi])
LD="$ac_cv_path_LD"
if test -n "$LD"; then
  AC_MSG_RESULT($LD)
else
  AC_MSG_RESULT(no)
fi
test -z "$LD" && AC_MSG_ERROR([no acceptable ld found in \$PATH])
AC_PROG_LD_GNU
])

AC_DEFUN(AC_PROG_LD_GNU,
[AC_CACHE_CHECK([if the linker ($LD) is GNU ld], ac_cv_prog_gnu_ld,
[# I'd rather use --version here, but apparently some GNU ld's only accept -v.
if $LD -v 2>&1 </dev/null | egrep '(GNU|with BFD)' 1>&5; then
  ac_cv_prog_gnu_ld=yes
else
  ac_cv_prog_gnu_ld=no
fi])
])

# AC_PROG_NM - find the path to a BSD-compatible name lister
AC_DEFUN(AC_PROG_NM,
[AC_MSG_CHECKING([for BSD-compatible nm])
AC_CACHE_VAL(ac_cv_path_NM,
[if test -n "$NM"; then
  # Let the user override the test.
  ac_cv_path_NM="$NM"
else
  IFS="${IFS= 	}"; ac_save_ifs="$IFS"; IFS="${IFS}${PATH_SEPARATOR-:}"
  for ac_dir in $PATH /usr/ccs/bin /usr/ucb /bin; do
    test -z "$ac_dir" && ac_dir=.
    if test -f $ac_dir/nm || test -f $ac_dir/nm$ac_exeext ; then
      # Check to see if the nm accepts a BSD-compat flag.
      # Adding the `sed 1q' prevents false positives on HP-UX, which says:
      #   nm: unknown option "B" ignored
      if ($ac_dir/nm -B /dev/null 2>&1 | sed '1q'; exit 0) | egrep /dev/null >/dev/null; then
	ac_cv_path_NM="$ac_dir/nm -B"
	break
      elif ($ac_dir/nm -p /dev/null 2>&1 | sed '1q'; exit 0) | egrep /dev/null >/dev/null; then
	ac_cv_path_NM="$ac_dir/nm -p"
	break
      else
	ac_cv_path_NM=${ac_cv_path_NM="$ac_dir/nm"} # keep the first match, but
	continue # so that we can try to find one that supports BSD flags
      fi
    fi
  done
  IFS="$ac_save_ifs"
  test -z "$ac_cv_path_NM" && ac_cv_path_NM=nm
fi])
NM="$ac_cv_path_NM"
AC_MSG_RESULT([$NM])
])

# AC_CHECK_LIBM - check for math library
AC_DEFUN(AC_CHECK_LIBM,
[AC_REQUIRE([AC_CANONICAL_HOST])dnl
LIBM=
case "$lt_target" in
*-*-beos* | *-*-cygwin*)
  # These system don't have libm
  ;;
*-ncr-sysv4.3*)
  AC_CHECK_LIB(mw, _mwvalidcheckl, LIBM="-lmw")
  AC_CHECK_LIB(m, main, LIBM="$LIBM -lm")
  ;;
*)
  AC_CHECK_LIB(m, main, LIBM="-lm")
  ;;
esac
])

# AC_LIBLTDL_CONVENIENCE[(dir)] - sets LIBLTDL to the link flags for
# the libltdl convenience library and INCLTDL to the include flags for
# the libltdl header and adds --enable-ltdl-convenience to the
# configure arguments.  Note that LIBLTDL and INCLTDL are not
# AC_SUBSTed, nor is AC_CONFIG_SUBDIRS called.  If DIR is not
# provided, it is assumed to be `libltdl'.  LIBLTDL will be prefixed
# with '${top_builddir}/' and INCLTDL will be prefixed with
# '${top_srcdir}/' (note the single quotes!).  If your package is not
# flat and you're not using automake, define top_builddir and
# top_srcdir appropriately in the Makefiles.
AC_DEFUN(AC_LIBLTDL_CONVENIENCE, [AC_BEFORE([$0],[AC_LIBTOOL_SETUP])dnl
  case "$enable_ltdl_convenience" in
  no) AC_MSG_ERROR([this package needs a convenience libltdl]) ;;
  "") enable_ltdl_convenience=yes
      ac_configure_args="$ac_configure_args --enable-ltdl-convenience" ;;
  esac
  LIBLTDL='${top_builddir}/'ifelse($#,1,[$1],['libltdl'])/libltdlc.la
  INCLTDL='-I${top_srcdir}/'ifelse($#,1,[$1],['libltdl'])
])

# AC_LIBLTDL_INSTALLABLE[(dir)] - sets LIBLTDL to the link flags for
# the libltdl installable library and INCLTDL to the include flags for
# the libltdl header and adds --enable-ltdl-install to the configure
# arguments.  Note that LIBLTDL and INCLTDL are not AC_SUBSTed, nor is
# AC_CONFIG_SUBDIRS called.  If DIR is not provided and an installed
# libltdl is not found, it is assumed to be `libltdl'.  LIBLTDL will
# be prefixed with '${top_builddir}/' and INCLTDL will be prefixed
# with '${top_srcdir}/' (note the single quotes!).  If your package is
# not flat and you're not using automake, define top_builddir and
# top_srcdir appropriately in the Makefiles.
# In the future, this macro may have to be called after AC_PROG_LIBTOOL.
AC_DEFUN(AC_LIBLTDL_INSTALLABLE, [AC_BEFORE([$0],[AC_LIBTOOL_SETUP])dnl
  AC_CHECK_LIB(ltdl, main,
  [test x"$enable_ltdl_install" != xyes && enable_ltdl_install=no],
  [if test x"$enable_ltdl_install" = xno; then
     AC_MSG_WARN([libltdl not installed, but installation disabled])
   else
     enable_ltdl_install=yes
   fi
  ])
  if test x"$enable_ltdl_install" = x"yes"; then
    ac_configure_args="$ac_configure_args --enable-ltdl-install"
    LIBLTDL='${top_builddir}/'ifelse($#,1,[$1],['libltdl'])/libltdl.la
    INCLTDL='-I${top_srcdir}/'ifelse($#,1,[$1],['libltdl'])
  else
    ac_configure_args="$ac_configure_args --enable-ltdl-install=no"
    LIBLTDL="-lltdl"
    INCLTDL=
  fi
])

dnl old names
AC_DEFUN(AM_PROG_LIBTOOL, [indir([AC_PROG_LIBTOOL])])dnl
AC_DEFUN(AM_ENABLE_SHARED, [indir([AC_ENABLE_SHARED], $@)])dnl
AC_DEFUN(AM_ENABLE_STATIC, [indir([AC_ENABLE_STATIC], $@)])dnl
AC_DEFUN(AM_DISABLE_SHARED, [indir([AC_DISABLE_SHARED], $@)])dnl
AC_DEFUN(AM_DISABLE_STATIC, [indir([AC_DISABLE_STATIC], $@)])dnl
AC_DEFUN(AM_PROG_LD, [indir([AC_PROG_LD])])dnl
AC_DEFUN(AM_PROG_NM, [indir([AC_PROG_NM])])dnl

dnl This is just to silence aclocal about the macro not being used
ifelse([AC_DISABLE_FAST_INSTALL])dnl

